/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class AddAuthsCommand
extends Shell.Command {
    private Option userOpt;
    private Option scanOptAuths;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getConnector().whoami());
        String scanOpts = cl.getOptionValue(this.scanOptAuths.getOpt());
        Authorizations auths = shellState.getConnector().securityOperations().getUserAuthorizations(user);
        StringBuilder userAuths = new StringBuilder();
        if (!auths.isEmpty()) {
            userAuths.append(auths.toString());
            userAuths.append(",");
        }
        userAuths.append(scanOpts);
        shellState.getConnector().securityOperations().changeUserAuthorizations(user, ScanCommand.parseAuthorizations(userAuths.toString()));
        Shell.log.debug((Object)("Changed record-level authorizations for user " + user));
        return 0;
    }

    @Override
    public String description() {
        return "adds authorizations to the maximum scan authorizations for a user";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForUsers(root, completionSet);
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup setOrClear = new OptionGroup();
        this.scanOptAuths = new Option("s", "scan-authorizations", true, "scan authorizations to set");
        this.scanOptAuths.setArgName("comma-separated-authorizations");
        setOrClear.addOption(this.scanOptAuths);
        setOrClear.setRequired(true);
        o.addOptionGroup(setOrClear);
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

