/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellOptionsJC {
    private static final Logger log = LoggerFactory.getLogger(ShellOptionsJC.class);
    @Parameter(names={"-u", "--user"}, description="username (defaults to your OS user)")
    private String username = null;
    @Parameter(names={"-p", "--password"}, description="password (can be specified as 'pass:<password>', 'file:<local file containing the password>', 'env:<variable containing the pass>', or stdin)", converter=PasswordConverter.class)
    private String password;
    @Parameter(names={"-tc", "--tokenClass"}, description="token type to create, use the -l to pass options", converter=TokenConverter.class)
    private AuthenticationToken authenticationToken;
    @DynamicParameter(names={"-l", "--tokenProperty"}, description="login properties in the format key=value. Reuse -l for each property")
    private Map<String, String> tokenProperties = new TreeMap<String, String>();
    @Parameter(names={"--disable-tab-completion"}, description="disables tab completion (for less overhead when scripting)")
    private boolean tabCompletionDisabled;
    @Parameter(names={"--debug"}, description="enables client debugging")
    private boolean debugEnabled;
    @Parameter(names={"--fake"}, description="fake a connection to accumulo")
    private boolean fake;
    @Parameter(names={"-?", "--help"}, help=true, description="display this help")
    private boolean helpEnabled;
    @Parameter(names={"-e", "--execute-command"}, description="executes a command, and then exits")
    private String execCommand;
    @Parameter(names={"-f", "--execute-file"}, description="executes commands from a file at startup", converter=FileConverter.class)
    private File execFile;
    @Parameter(names={"-fv", "--execute-file-verbose"}, description="executes commands from a file at startup, with commands shown", converter=FileConverter.class)
    private File execFileVerbose;
    @Parameter(names={"-h", "--hdfsZooInstance"}, description="use hdfs zoo instance")
    private boolean hdfsZooInstance;
    @Parameter(names={"-z", "--zooKeeperInstance"}, description="use a zookeeper instance with the given instance name and list of zoo hosts. Syntax: -z <zoo-instance-name> <zoo-hosts>. Where <zoo-hosts> is a comma separated list of zookeeper servers.", arity=2)
    private List<String> zooKeeperInstance = new ArrayList<String>();
    @Parameter(names={"--ssl"}, description="use ssl to connect to accumulo")
    private boolean useSsl = false;
    @Parameter(names={"--sasl"}, description="use SASL to connect to Accumulo (Kerberos)")
    private boolean useSasl = false;
    @Parameter(names={"--config-file"}, description="read the given client config file. If omitted, the path searched can be specified with $ACCUMULO_CLIENT_CONF_PATH, which defaults to ~/.accumulo/config:$ACCUMULO_CONF_DIR/client.conf:/etc/accumulo/client.conf")
    private String clientConfigFile = null;
    @Parameter(names={"-zi", "--zooKeeperInstanceName"}, description="use a zookeeper instance with the given instance name. This parameter is used in conjunction with -zh.")
    private String zooKeeperInstanceName;
    @Parameter(names={"-zh", "--zooKeeperHosts"}, description="use a zookeeper instance with the given comma separated list of zookeeper servers. This parameter is used in conjunction with -zi.")
    private String zooKeeperHosts;
    @Parameter(names={"--auth-timeout"}, description="minutes the shell can be idle without re-entering a password")
    private int authTimeout = 60;
    @Parameter(names={"--disable-auth-timeout"}, description="disables requiring the user to re-type a password after being idle")
    private boolean authTimeoutDisabled;
    @Parameter(hidden=true)
    private List<String> unrecognizedOptions;

    public String getUsername() throws Exception {
        if (null == this.username) {
            ClientConfiguration clientConf = this.getClientConfiguration();
            if (Boolean.parseBoolean(clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED))) {
                if (!UserGroupInformation.isSecurityEnabled()) {
                    throw new RuntimeException("Kerberos security is not enabled");
                }
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                this.username = ugi.getUserName();
            } else {
                this.username = System.getProperty("user.name", "root");
            }
        }
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationToken getAuthenticationToken() throws Exception {
        ClientConfiguration clientConf;
        boolean saslEnabled;
        if (null == this.authenticationToken && (saslEnabled = Boolean.parseBoolean((clientConf = this.getClientConfiguration()).get(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED)))) {
            this.authenticationToken = new KerberosToken();
        }
        return this.authenticationToken;
    }

    public Map<String, String> getTokenProperties() {
        return this.tokenProperties;
    }

    public boolean isTabCompletionDisabled() {
        return this.tabCompletionDisabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isFake() {
        return this.fake;
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public File getExecFile() {
        return this.execFile;
    }

    public File getExecFileVerbose() {
        return this.execFileVerbose;
    }

    public boolean isHdfsZooInstance() {
        return this.hdfsZooInstance;
    }

    public List<String> getZooKeeperInstance() {
        return this.zooKeeperInstance;
    }

    public String getZooKeeperInstanceName() {
        return this.zooKeeperInstanceName;
    }

    public String getZooKeeperHosts() {
        return this.zooKeeperHosts;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public boolean isAuthTimeoutDisabled() {
        if (this.useSasl()) {
            return true;
        }
        return this.authTimeoutDisabled;
    }

    public List<String> getUnrecognizedOptions() {
        return this.unrecognizedOptions;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String getClientConfigFile() {
        return this.clientConfigFile;
    }

    public ClientConfiguration getClientConfiguration() throws ConfigurationException, FileNotFoundException {
        ClientConfiguration clientConfig;
        ClientConfiguration clientConfiguration = clientConfig = this.clientConfigFile == null ? ClientConfiguration.loadDefault() : ClientConfiguration.fromFile((File)new File(this.getClientConfigFile()));
        if (this.useSsl()) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
        }
        if (this.useSasl()) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED, "true");
        }
        if (!this.getZooKeeperInstance().isEmpty()) {
            List<String> zkOpts = this.getZooKeeperInstance();
            String instanceName = zkOpts.get(0);
            String hosts = zkOpts.get(1);
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST, hosts);
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_NAME, instanceName);
        }
        if (null != this.zooKeeperHosts && !this.zooKeeperHosts.isEmpty()) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST, this.zooKeeperHosts);
        }
        if (null != this.zooKeeperInstanceName && !this.zooKeeperInstanceName.isEmpty()) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_NAME, this.zooKeeperInstanceName);
        }
        if (!clientConfig.containsKey(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST.getKey())) {
            SiteConfiguration siteConf = SiteConfiguration.getInstance();
            clientConfig.withZkHosts(siteConf.get(Property.INSTANCE_ZK_HOST));
        }
        return clientConfig;
    }

    public boolean useSasl() {
        return this.useSasl;
    }

    public static class TokenConverter
    implements IStringConverter<AuthenticationToken> {
        public AuthenticationToken convert(String value) {
            try {
                return Class.forName(value).asSubclass(AuthenticationToken.class).newInstance();
            }
            catch (Exception e) {
                log.error("Could not instantiate AuthenticationToken {}", (Object)value, (Object)e);
                throw new ParameterException((Throwable)e);
            }
        }
    }

    public static class PasswordConverter
    implements IStringConverter<String> {
        public static final String STDIN = "stdin";

        public String convert(String value) {
            for (KeyType keyType : KeyType.values()) {
                if (!keyType.matches(value)) continue;
                return keyType.convert(value);
            }
            return value;
        }

        private static enum KeyType {
            PASS("pass:"),
            ENV("env:"){

                @Override
                String process(String value) {
                    return System.getenv(value);
                }
            }
            ,
            FILE("file:"){

                @Override
                String process(String value) {
                    try (Scanner scanner = null;){
                        scanner = new Scanner(new File(value));
                        String string = scanner.nextLine();
                        return string;
                    }
                }
            }
            ,
            STDIN("stdin"){

                @Override
                public boolean matches(String value) {
                    return this.prefix.equals(value);
                }

                @Override
                public String convert(String value) {
                    return this.prefix;
                }
            };

            String prefix;

            private KeyType(String prefix) {
                this.prefix = prefix;
            }

            public boolean matches(String value) {
                return value.startsWith(this.prefix);
            }

            public String convert(String value) {
                return this.process(value.substring(this.prefix.length()));
            }

            String process(String value) {
                return value;
            }
        }
    }
}

