/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsFactory;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedProcessor
implements TProcessor {
    private static final Logger log = LoggerFactory.getLogger(TimedProcessor.class);
    private final TProcessor other;
    private final Metrics metrics;
    private long idleStart = 0L;

    public TimedProcessor(AccumuloConfiguration conf, TProcessor next, String serverName, String threadName) {
        this(new MetricsFactory(conf), next, serverName, threadName);
    }

    public TimedProcessor(MetricsFactory factory, TProcessor next, String serverName, String threadName) {
        this.other = next;
        this.metrics = factory.createThriftMetrics(serverName, threadName);
        try {
            this.metrics.register();
        }
        catch (Exception e) {
            log.error("Exception registering MBean with MBean Server", (Throwable)e);
        }
        this.idleStart = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(TProtocol in, TProtocol out) throws TException {
        long now = 0L;
        boolean metricsEnabled = this.metrics.isEnabled();
        if (metricsEnabled) {
            now = System.currentTimeMillis();
            this.metrics.add("idle", now - this.idleStart);
        }
        try {
            boolean bl = this.other.process(in, out);
            return bl;
        }
        finally {
            if (metricsEnabled) {
                this.idleStart = System.currentTimeMillis();
                this.metrics.add("execute", this.idleStart - now);
            }
        }
    }
}

