/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import com.beust.jcommander.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchScannerOpts;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.examples.simple.client.CountingVerifyingReceiver;
import org.apache.accumulo.examples.simple.client.RandomBatchWriter;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomBatchScanner {
    private static final Logger log = LoggerFactory.getLogger(RandomBatchScanner.class);

    static void generateRandomQueries(int num, long min, long max, Random r, HashSet<Range> ranges, HashMap<Text, Boolean> expectedRows) {
        log.info(String.format("Generating %,d random queries...", num));
        while (ranges.size() < num) {
            long rowid = RandomBatchWriter.abs(r.nextLong()) % (max - min) + min;
            Text row1 = new Text(String.format("row_%010d", rowid));
            Range range = new Range(new Text(row1));
            ranges.add(range);
            expectedRows.put(row1, false);
        }
        log.info("finished");
    }

    private static boolean checkAllRowsFound(HashMap<Text, Boolean> expectedRows) {
        int count = 0;
        boolean allFound = true;
        for (Map.Entry<Text, Boolean> entry : expectedRows.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            ++count;
        }
        if (count > 0) {
            log.warn("Did not find " + count + " rows");
            allFound = false;
        }
        return allFound;
    }

    static boolean doRandomQueries(int num, long min, long max, int evs, Random r, BatchScanner tsbr) {
        HashSet<Range> ranges = new HashSet<Range>(num);
        HashMap<Text, Boolean> expectedRows = new HashMap<Text, Boolean>();
        RandomBatchScanner.generateRandomQueries(num, min, max, r, ranges, expectedRows);
        tsbr.setRanges(ranges);
        CountingVerifyingReceiver receiver = new CountingVerifyingReceiver(expectedRows, evs);
        long t1 = System.currentTimeMillis();
        for (Map.Entry entry : tsbr) {
            receiver.receive((Key)entry.getKey(), (Value)entry.getValue());
        }
        long t2 = System.currentTimeMillis();
        log.info(String.format("%6.2f lookups/sec %6.2f secs%n", (double)num / ((double)(t2 - t1) / 1000.0), (double)(t2 - t1) / 1000.0));
        log.info(String.format("num results : %,d%n", receiver.count));
        return RandomBatchScanner.checkAllRowsFound(expectedRows);
    }

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Opts opts = new Opts();
        BatchScannerOpts bsOpts = new BatchScannerOpts();
        opts.parseArgs(RandomBatchScanner.class.getName(), args, new Object[]{bsOpts});
        Connector connector = opts.getConnector();
        BatchScanner batchReader = connector.createBatchScanner(opts.getTableName(), opts.auths, bsOpts.scanThreads.intValue());
        batchReader.setTimeout(bsOpts.scanTimeout.longValue(), TimeUnit.MILLISECONDS);
        Random r = opts.seed == null ? new Random() : new Random(opts.seed);
        boolean status = RandomBatchScanner.doRandomQueries(opts.num, opts.min, opts.max, opts.size, r, batchReader);
        System.gc();
        System.gc();
        System.gc();
        r = opts.seed == null ? new Random() : new Random(opts.seed);
        status = status && RandomBatchScanner.doRandomQueries(opts.num, opts.min, opts.max, opts.size, r, batchReader);
        batchReader.close();
        if (!status) {
            System.exit(1);
        }
    }

    public static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--min"}, description="miniumum row that will be generated")
        long min = 0L;
        @Parameter(names={"--max"}, description="maximum ow that will be generated")
        long max = 0L;
        @Parameter(names={"--num"}, required=true, description="number of ranges to generate")
        int num = 0;
        @Parameter(names={"--size"}, required=true, description="size of the value to write")
        int size = 0;
        @Parameter(names={"--seed"}, description="seed for pseudo-random number generator")
        Long seed = null;
    }
}

