/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.DurabilityImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TimeoutTabletLocator;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.impl.TabletIdImpl;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.data.thrift.UpdateErrors;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchWriter {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchWriter.class);
    private final ClientContext context;
    private final long maxMem;
    private final long maxLatency;
    private final long timeout;
    private final Durability durability;
    private boolean flushing;
    private boolean closed;
    private MutationSet mutations;
    private final MutationWriter writer;
    private final Timer jtimer = new Timer("BatchWriterLatencyTimer", true);
    private final Map<String, TimeoutTracker> timeoutTrackers = Collections.synchronizedMap(new HashMap());
    private long totalMemUsed = 0L;
    private long lastProcessingStartTime;
    private long totalAdded = 0L;
    private final AtomicLong totalSent = new AtomicLong(0L);
    private final AtomicLong totalBinned = new AtomicLong(0L);
    private final AtomicLong totalBinTime = new AtomicLong(0L);
    private final AtomicLong totalSendTime = new AtomicLong(0L);
    private long startTime = 0L;
    private long initialGCTimes;
    private long initialCompileTimes;
    private double initialSystemLoad;
    private AtomicInteger tabletServersBatchSum = new AtomicInteger(0);
    private AtomicInteger tabletBatchSum = new AtomicInteger(0);
    private AtomicInteger numBatches = new AtomicInteger(0);
    private AtomicInteger maxTabletBatch = new AtomicInteger(Integer.MIN_VALUE);
    private AtomicInteger minTabletBatch = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger minTabletServersBatch = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger maxTabletServersBatch = new AtomicInteger(Integer.MIN_VALUE);
    private final Violations violations = new Violations();
    private final Map<KeyExtent, Set<SecurityErrorCode>> authorizationFailures = new HashMap<KeyExtent, Set<SecurityErrorCode>>();
    private final HashSet<String> serverSideErrors = new HashSet();
    private final FailedMutations failedMutations = new FailedMutations();
    private int unknownErrors = 0;
    private boolean somethingFailed = false;
    private Throwable lastUnknownError = null;

    public TabletServerBatchWriter(ClientContext context, BatchWriterConfig config) {
        this.context = context;
        this.maxMem = config.getMaxMemory();
        this.maxLatency = config.getMaxLatency(TimeUnit.MILLISECONDS) <= 0L ? Long.MAX_VALUE : config.getMaxLatency(TimeUnit.MILLISECONDS);
        this.timeout = config.getTimeout(TimeUnit.MILLISECONDS);
        this.mutations = new MutationSet();
        this.lastProcessingStartTime = System.currentTimeMillis();
        this.durability = config.getDurability();
        this.writer = new MutationWriter(config.getMaxWriteThreads());
        if (this.maxLatency != Long.MAX_VALUE) {
            this.jtimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TabletServerBatchWriter tabletServerBatchWriter = TabletServerBatchWriter.this;
                        synchronized (tabletServerBatchWriter) {
                            if (System.currentTimeMillis() - TabletServerBatchWriter.this.lastProcessingStartTime > TabletServerBatchWriter.this.maxLatency) {
                                TabletServerBatchWriter.this.startProcessing();
                            }
                        }
                    }
                    catch (Throwable t) {
                        TabletServerBatchWriter.this.updateUnknownErrors("Max latency task failed " + t.getMessage(), t);
                    }
                }
            }, 0L, this.maxLatency / 4L);
        }
    }

    private synchronized void startProcessing() {
        if (this.mutations.getMemoryUsed() == 0) {
            return;
        }
        this.lastProcessingStartTime = System.currentTimeMillis();
        try {
            this.writer.queueMutations(this.mutations);
        }
        catch (InterruptedException e) {
            log.warn("Mutations rejected from binning thread, retrying...");
            this.failedMutations.add(this.mutations);
        }
        this.mutations = new MutationSet();
    }

    private synchronized void decrementMemUsed(long amount) {
        this.totalMemUsed -= amount;
        this.notifyAll();
    }

    public synchronized void addMutation(String table, Mutation m) throws MutationsRejectedException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        this.checkForFailures();
        this.waitRTE(new WaitCondition(){

            @Override
            public boolean shouldWait() {
                return (TabletServerBatchWriter.this.totalMemUsed > TabletServerBatchWriter.this.maxMem || TabletServerBatchWriter.this.flushing) && !TabletServerBatchWriter.this.somethingFailed;
            }
        });
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        this.checkForFailures();
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : gcmBeans) {
                this.initialGCTimes += garbageCollectorMXBean.getCollectionTime();
            }
            CompilationMXBean compMxBean = ManagementFactory.getCompilationMXBean();
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                this.initialCompileTimes = compMxBean.getTotalCompilationTime();
            }
            this.initialSystemLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }
        m = new Mutation(m);
        this.totalMemUsed += m.estimatedMemoryUsed();
        this.mutations.addMutation(table, m);
        ++this.totalAdded;
        if ((long)this.mutations.getMemoryUsed() >= this.maxMem / 2L) {
            this.startProcessing();
            this.checkForFailures();
        }
    }

    public void addMutation(String table, Iterator<Mutation> iterator) throws MutationsRejectedException {
        while (iterator.hasNext()) {
            this.addMutation(table, iterator.next());
        }
    }

    public synchronized void flush() throws MutationsRejectedException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        Span span = Trace.start("flush");
        try {
            this.checkForFailures();
            if (this.flushing) {
                this.waitRTE(new WaitCondition(){

                    @Override
                    public boolean shouldWait() {
                        return TabletServerBatchWriter.this.flushing && !TabletServerBatchWriter.this.somethingFailed;
                    }
                });
                this.checkForFailures();
                return;
            }
            this.flushing = true;
            this.startProcessing();
            this.checkForFailures();
            this.waitRTE(new WaitCondition(){

                @Override
                public boolean shouldWait() {
                    return TabletServerBatchWriter.this.totalMemUsed > 0L && !TabletServerBatchWriter.this.somethingFailed;
                }
            });
            this.flushing = false;
            this.notifyAll();
            this.checkForFailures();
        }
        finally {
            span.stop();
        }
    }

    public synchronized void close() throws MutationsRejectedException {
        if (this.closed) {
            return;
        }
        Span span = Trace.start("close");
        try {
            this.closed = true;
            this.startProcessing();
            this.waitRTE(new WaitCondition(){

                @Override
                public boolean shouldWait() {
                    return TabletServerBatchWriter.this.totalMemUsed > 0L && !TabletServerBatchWriter.this.somethingFailed;
                }
            });
            this.logStats();
            this.checkForFailures();
        }
        finally {
            this.writer.binningThreadPool.shutdownNow();
            this.writer.sendThreadPool.shutdownNow();
            this.jtimer.cancel();
            span.stop();
        }
    }

    private void logStats() {
        if (log.isTraceEnabled()) {
            long finishTime = System.currentTimeMillis();
            long finalGCTimes = 0L;
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : gcmBeans) {
                finalGCTimes += garbageCollectorMXBean.getCollectionTime();
            }
            CompilationMXBean compMxBean = ManagementFactory.getCompilationMXBean();
            long finalCompileTimes = 0L;
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                finalCompileTimes = compMxBean.getTotalCompilationTime();
            }
            double averageRate = (double)this.totalSent.get() / ((double)this.totalSendTime.get() / 1000.0);
            double overallRate = (double)this.totalAdded / ((double)(finishTime - this.startTime) / 1000.0);
            double finalSystemLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            log.trace("");
            log.trace("TABLET SERVER BATCH WRITER STATISTICS");
            log.trace(String.format("Added                : %,10d mutations", this.totalAdded));
            log.trace(String.format("Sent                 : %,10d mutations", this.totalSent.get()));
            log.trace(String.format("Resent percentage   : %10.2f%s", (double)(this.totalSent.get() - this.totalAdded) / (double)this.totalAdded * 100.0, "%"));
            log.trace(String.format("Overall time         : %,10.2f secs", (double)(finishTime - this.startTime) / 1000.0));
            log.trace(String.format("Overall send rate    : %,10.2f mutations/sec", overallRate));
            log.trace(String.format("Send efficiency      : %10.2f%s", overallRate / averageRate * 100.0, "%"));
            log.trace("");
            log.trace("BACKGROUND WRITER PROCESS STATISTICS");
            log.trace(String.format("Total send time      : %,10.2f secs %6.2f%s", (double)this.totalSendTime.get() / 1000.0, 100.0 * (double)this.totalSendTime.get() / (double)(finishTime - this.startTime), "%"));
            log.trace(String.format("Average send rate    : %,10.2f mutations/sec", averageRate));
            log.trace(String.format("Total bin time       : %,10.2f secs %6.2f%s", (double)this.totalBinTime.get() / 1000.0, 100.0 * (double)this.totalBinTime.get() / (double)(finishTime - this.startTime), "%"));
            log.trace(String.format("Average bin rate     : %,10.2f mutations/sec", (double)this.totalBinned.get() / ((double)this.totalBinTime.get() / 1000.0)));
            log.trace(String.format("tservers per batch   : %,8.2f avg  %,6d min %,6d max", Float.valueOf(this.numBatches.get() != 0 ? this.tabletServersBatchSum.get() / this.numBatches.get() : 0), this.minTabletServersBatch.get(), this.maxTabletServersBatch.get()));
            log.trace(String.format("tablets per batch    : %,8.2f avg  %,6d min %,6d max", Float.valueOf(this.numBatches.get() != 0 ? this.tabletBatchSum.get() / this.numBatches.get() : 0), this.minTabletBatch.get(), this.maxTabletBatch.get()));
            log.trace("");
            log.trace("SYSTEM STATISTICS");
            log.trace(String.format("JVM GC Time          : %,10.2f secs", (double)(finalGCTimes - this.initialGCTimes) / 1000.0));
            if (compMxBean.isCompilationTimeMonitoringSupported()) {
                log.trace(String.format("JVM Compile Time     : %,10.2f secs", (double)(finalCompileTimes - this.initialCompileTimes) / 1000.0));
            }
            log.trace(String.format("System load average : initial=%6.2f final=%6.2f", this.initialSystemLoad, finalSystemLoad));
        }
    }

    private void updateSendStats(long count, long time) {
        this.totalSent.addAndGet(count);
        this.totalSendTime.addAndGet(time);
    }

    public void updateBinningStats(int count, long time, Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
        if (log.isTraceEnabled()) {
            this.totalBinTime.addAndGet(time);
            this.totalBinned.addAndGet(count);
            this.updateBatchStats(binnedMutations);
        }
    }

    private static void computeMin(AtomicInteger stat, int update2) {
        int old = stat.get();
        while (!stat.compareAndSet(old, Math.min(old, update2))) {
            old = stat.get();
        }
    }

    private static void computeMax(AtomicInteger stat, int update2) {
        int old = stat.get();
        while (!stat.compareAndSet(old, Math.max(old, update2))) {
            old = stat.get();
        }
    }

    private void updateBatchStats(Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
        this.tabletServersBatchSum.addAndGet(binnedMutations.size());
        TabletServerBatchWriter.computeMin(this.minTabletServersBatch, binnedMutations.size());
        TabletServerBatchWriter.computeMax(this.maxTabletServersBatch, binnedMutations.size());
        int numTablets = 0;
        for (Map.Entry<String, TabletLocator.TabletServerMutations<Mutation>> entry : binnedMutations.entrySet()) {
            TabletLocator.TabletServerMutations<Mutation> tsm = entry.getValue();
            numTablets += tsm.getMutations().size();
        }
        this.tabletBatchSum.addAndGet(numTablets);
        TabletServerBatchWriter.computeMin(this.minTabletBatch, numTablets);
        TabletServerBatchWriter.computeMax(this.maxTabletBatch, numTablets);
        this.numBatches.incrementAndGet();
    }

    private void waitRTE(WaitCondition condition) {
        try {
            while (condition.shouldWait()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatedConstraintViolations(List<ConstraintViolationSummary> cvsList) {
        if (cvsList.size() > 0) {
            TabletServerBatchWriter tabletServerBatchWriter = this;
            synchronized (tabletServerBatchWriter) {
                this.somethingFailed = true;
                this.violations.add(cvsList);
                this.notifyAll();
            }
        }
    }

    private void updateAuthorizationFailures(Set<KeyExtent> keySet, SecurityErrorCode code) {
        HashMap<KeyExtent, SecurityErrorCode> map = new HashMap<KeyExtent, SecurityErrorCode>();
        for (KeyExtent ke : keySet) {
            map.put(ke, code);
        }
        this.updateAuthorizationFailures(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthorizationFailures(Map<KeyExtent, SecurityErrorCode> authorizationFailures) {
        if (authorizationFailures.size() > 0) {
            HashSet<String> tableIds = new HashSet<String>();
            for (KeyExtent ke : authorizationFailures.keySet()) {
                tableIds.add(ke.getTableId());
            }
            Tables.clearCache(this.context.getInstance());
            for (String tableId : tableIds) {
                if (Tables.exists(this.context.getInstance(), tableId)) continue;
                throw new TableDeletedException(tableId);
            }
            TabletServerBatchWriter tabletServerBatchWriter = this;
            synchronized (tabletServerBatchWriter) {
                this.somethingFailed = true;
                this.mergeAuthorizationFailures(this.authorizationFailures, authorizationFailures);
                this.notifyAll();
            }
        }
    }

    private void mergeAuthorizationFailures(Map<KeyExtent, Set<SecurityErrorCode>> source, Map<KeyExtent, SecurityErrorCode> addition) {
        for (Map.Entry<KeyExtent, SecurityErrorCode> entry : addition.entrySet()) {
            Set<SecurityErrorCode> secs = source.get(entry.getKey());
            if (secs == null) {
                secs = new HashSet<SecurityErrorCode>();
                source.put(entry.getKey(), secs);
            }
            secs.add(entry.getValue());
        }
    }

    private synchronized void updateServerErrors(String server, Exception e) {
        this.somethingFailed = true;
        this.serverSideErrors.add(server);
        this.notifyAll();
        log.error("Server side error on " + server + ": " + e);
    }

    private synchronized void updateUnknownErrors(String msg, Throwable t) {
        this.somethingFailed = true;
        ++this.unknownErrors;
        this.lastUnknownError = t;
        this.notifyAll();
        if (t instanceof TableDeletedException || t instanceof TableOfflineException || t instanceof TimedOutException) {
            log.debug("{}", (Object)msg, (Object)t);
        } else {
            log.error("{}", (Object)msg, (Object)t);
        }
    }

    private void checkForFailures() throws MutationsRejectedException {
        if (this.somethingFailed) {
            List<ConstraintViolationSummary> cvsList = this.violations.asList();
            HashMap<TabletId, Set<org.apache.accumulo.core.client.security.SecurityErrorCode>> af = new HashMap<TabletId, Set<org.apache.accumulo.core.client.security.SecurityErrorCode>>();
            for (Map.Entry<KeyExtent, Set<SecurityErrorCode>> entry : this.authorizationFailures.entrySet()) {
                HashSet<org.apache.accumulo.core.client.security.SecurityErrorCode> codes = new HashSet<org.apache.accumulo.core.client.security.SecurityErrorCode>();
                for (SecurityErrorCode sce : entry.getValue()) {
                    codes.add(org.apache.accumulo.core.client.security.SecurityErrorCode.valueOf(sce.name()));
                }
                af.put(new TabletIdImpl(entry.getKey()), codes);
            }
            throw new MutationsRejectedException(this.context.getInstance(), cvsList, (Map<TabletId, Set<org.apache.accumulo.core.client.security.SecurityErrorCode>>)af, (Collection<String>)this.serverSideErrors, this.unknownErrors, this.lastUnknownError);
        }
    }

    private synchronized void addFailedMutations(MutationSet failedMutations) throws Exception {
        this.mutations.addAll(failedMutations);
        if ((long)this.mutations.getMemoryUsed() >= this.maxMem / 2L || this.closed || this.flushing) {
            this.startProcessing();
        }
    }

    private static class MutationSet {
        private final HashMap<String, List<Mutation>> mutations = new HashMap();
        private int memoryUsed = 0;

        MutationSet() {
        }

        void addMutation(String table, Mutation mutation) {
            List<Mutation> tabMutList = this.mutations.get(table);
            if (tabMutList == null) {
                tabMutList = new ArrayList<Mutation>();
                this.mutations.put(table, tabMutList);
            }
            tabMutList.add(mutation);
            this.memoryUsed = (int)((long)this.memoryUsed + mutation.estimatedMemoryUsed());
        }

        Map<String, List<Mutation>> getMutations() {
            return this.mutations;
        }

        int size() {
            int result = 0;
            for (List<Mutation> perTable : this.mutations.values()) {
                result += perTable.size();
            }
            return result;
        }

        public void addAll(MutationSet failures) {
            Set<Map.Entry<String, List<Mutation>>> es = failures.getMutations().entrySet();
            for (Map.Entry<String, List<Mutation>> entry : es) {
                String table = entry.getKey();
                for (Mutation mutation : entry.getValue()) {
                    this.addMutation(table, mutation);
                }
            }
        }

        public void addAll(String table, List<Mutation> mutations) {
            for (Mutation mutation : mutations) {
                this.addMutation(table, mutation);
            }
        }

        public int getMemoryUsed() {
            return this.memoryUsed;
        }
    }

    private class MutationWriter {
        private static final int MUTATION_BATCH_SIZE = 131072;
        private final ExecutorService sendThreadPool;
        private final SimpleThreadPool binningThreadPool;
        private final Map<String, TabletLocator.TabletServerMutations<Mutation>> serversMutations = new HashMap<String, TabletLocator.TabletServerMutations<Mutation>>();
        private final Set<String> queued = new HashSet<String>();
        private final Map<String, TabletLocator> locators;

        public MutationWriter(int numSendThreads) {
            this.sendThreadPool = new SimpleThreadPool(numSendThreads, this.getClass().getName());
            this.locators = new HashMap<String, TabletLocator>();
            this.binningThreadPool = new SimpleThreadPool(1, "BinMutations", new SynchronousQueue<Runnable>());
            this.binningThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }

        private synchronized TabletLocator getLocator(String tableId) {
            TabletLocator ret = this.locators.get(tableId);
            if (ret == null) {
                ret = new TimeoutTabletLocator(TabletServerBatchWriter.this.timeout, TabletServerBatchWriter.this.context, tableId);
                this.locators.put(tableId, ret);
            }
            return ret;
        }

        private void binMutations(MutationSet mutationsToProcess, Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
            String tableId = null;
            try {
                Set<Map.Entry<String, List<Mutation>>> es = mutationsToProcess.getMutations().entrySet();
                for (Map.Entry<String, List<Mutation>> entry : es) {
                    tableId = entry.getKey();
                    TabletLocator locator = this.getLocator(tableId);
                    String table = entry.getKey();
                    List<Mutation> tableMutations = entry.getValue();
                    if (tableMutations == null) continue;
                    ArrayList<Mutation> tableFailures = new ArrayList<Mutation>();
                    locator.binMutations(TabletServerBatchWriter.this.context, tableMutations, binnedMutations, tableFailures);
                    if (tableFailures.size() <= 0) continue;
                    TabletServerBatchWriter.this.failedMutations.add(table, tableFailures);
                    if (tableFailures.size() != tableMutations.size()) continue;
                    if (!Tables.exists(TabletServerBatchWriter.this.context.getInstance(), entry.getKey())) {
                        throw new TableDeletedException(entry.getKey());
                    }
                    if (Tables.getTableState(TabletServerBatchWriter.this.context.getInstance(), table) != TableState.OFFLINE) continue;
                    throw new TableOfflineException(TabletServerBatchWriter.this.context.getInstance(), entry.getKey());
                }
                return;
            }
            catch (AccumuloServerException ase) {
                TabletServerBatchWriter.this.updateServerErrors(ase.getServer(), ase);
            }
            catch (AccumuloException ae) {
                TabletServerBatchWriter.this.failedMutations.add(mutationsToProcess);
            }
            catch (AccumuloSecurityException e) {
                TabletServerBatchWriter.this.updateAuthorizationFailures(Collections.singletonMap(new KeyExtent(tableId, null, null), SecurityErrorCode.valueOf(e.getSecurityErrorCode().name())));
            }
            catch (TableDeletedException e) {
                TabletServerBatchWriter.this.updateUnknownErrors(e.getMessage(), e);
            }
            catch (TableOfflineException e) {
                TabletServerBatchWriter.this.updateUnknownErrors(e.getMessage(), e);
            }
            catch (TableNotFoundException e) {
                TabletServerBatchWriter.this.updateUnknownErrors(e.getMessage(), e);
            }
            binnedMutations.clear();
        }

        void queueMutations(final MutationSet mutationsToSend) throws InterruptedException {
            if (null == mutationsToSend) {
                return;
            }
            this.binningThreadPool.execute(Trace.wrap(new Runnable(){

                @Override
                public void run() {
                    if (null != mutationsToSend) {
                        try {
                            log.trace("{} - binning {} mutations", (Object)Thread.currentThread().getName(), (Object)mutationsToSend.size());
                            MutationWriter.this.addMutations(mutationsToSend);
                        }
                        catch (Exception e) {
                            TabletServerBatchWriter.this.updateUnknownErrors("Error processing mutation set", e);
                        }
                    }
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMutations(MutationSet mutationsToSend) {
            HashMap<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations = new HashMap<String, TabletLocator.TabletServerMutations<Mutation>>();
            Span span = Trace.start("binMutations");
            try {
                long t1 = System.currentTimeMillis();
                this.binMutations(mutationsToSend, binnedMutations);
                long t2 = System.currentTimeMillis();
                TabletServerBatchWriter.this.updateBinningStats(mutationsToSend.size(), t2 - t1, binnedMutations);
            }
            finally {
                span.stop();
            }
            this.addMutations(binnedMutations);
        }

        private synchronized void addMutations(Map<String, TabletLocator.TabletServerMutations<Mutation>> binnedMutations) {
            int count = 0;
            for (Map.Entry<String, TabletLocator.TabletServerMutations<Mutation>> entry : binnedMutations.entrySet()) {
                String server = entry.getKey();
                TabletLocator.TabletServerMutations<Mutation> currentMutations = this.serversMutations.get(server);
                if (currentMutations == null) {
                    this.serversMutations.put(server, entry.getValue());
                } else {
                    for (Map.Entry<KeyExtent, List<Mutation>> entry2 : entry.getValue().getMutations().entrySet()) {
                        for (Mutation m : entry2.getValue()) {
                            currentMutations.addMutation(entry2.getKey(), m);
                        }
                    }
                }
                if (!log.isTraceEnabled()) continue;
                for (Map.Entry<KeyExtent, List<Mutation>> entry2 : entry.getValue().getMutations().entrySet()) {
                    count += entry2.getValue().size();
                }
            }
            if (count > 0 && log.isTraceEnabled()) {
                log.trace(String.format("Started sending %,d mutations to %,d tablet servers", count, binnedMutations.keySet().size()));
            }
            ArrayList<String> servers = new ArrayList<String>(binnedMutations.keySet());
            Collections.shuffle(servers);
            for (String server : servers) {
                if (this.queued.contains(server)) continue;
                this.sendThreadPool.submit(Trace.wrap(new SendTask(server)));
                this.queued.add(server);
            }
        }

        private synchronized TabletLocator.TabletServerMutations<Mutation> getMutationsToSend(String server) {
            TabletLocator.TabletServerMutations<Mutation> tsmuts = this.serversMutations.remove(server);
            if (tsmuts == null) {
                this.queued.remove(server);
            }
            return tsmuts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MutationSet sendMutationsToTabletServer(String location, Map<KeyExtent, List<Mutation>> tabMuts, TimeoutTracker timeoutTracker) throws IOException, AccumuloSecurityException, AccumuloServerException {
            MutationSet mutationSet;
            if (tabMuts.size() == 0) {
                return new MutationSet();
            }
            TInfo tinfo = Tracer.traceInfo();
            timeoutTracker.startingWrite();
            HostAndPort parsedServer = HostAndPort.fromString(location);
            TabletClientService.Client client = timeoutTracker.getTimeOut() < TabletServerBatchWriter.this.context.getClientTimeoutInMillis() ? ThriftUtil.getTServerClient(parsedServer, TabletServerBatchWriter.this.context, timeoutTracker.getTimeOut()) : ThriftUtil.getTServerClient(parsedServer, TabletServerBatchWriter.this.context);
            try {
                MutationSet allFailures = new MutationSet();
                if (tabMuts.size() == 1 && tabMuts.values().iterator().next().size() == 1) {
                    Map.Entry<KeyExtent, List<Mutation>> entry = tabMuts.entrySet().iterator().next();
                    try {
                        client.update(tinfo, TabletServerBatchWriter.this.context.rpcCreds(), entry.getKey().toThrift(), entry.getValue().get(0).toThrift(), DurabilityImpl.toThrift(TabletServerBatchWriter.this.durability));
                    }
                    catch (NotServingTabletException e) {
                        allFailures.addAll(entry.getKey().getTableId(), entry.getValue());
                        this.getLocator(entry.getKey().getTableId()).invalidateCache(entry.getKey());
                    }
                    catch (ConstraintViolationException e) {
                        TabletServerBatchWriter.this.updatedConstraintViolations(Translator.translate(e.violationSummaries, Translators.TCVST));
                    }
                    timeoutTracker.madeProgress();
                } else {
                    long usid = client.startUpdate(tinfo, TabletServerBatchWriter.this.context.rpcCreds(), DurabilityImpl.toThrift(TabletServerBatchWriter.this.durability));
                    ArrayList<TMutation> updates = new ArrayList<TMutation>();
                    for (Map.Entry<KeyExtent, List<Mutation>> entry : tabMuts.entrySet()) {
                        long size = 0L;
                        Iterator<Mutation> iter = entry.getValue().iterator();
                        while (iter.hasNext()) {
                            while (size < 131072L && iter.hasNext()) {
                                Mutation mutation = iter.next();
                                updates.add(mutation.toThrift());
                                size += mutation.numBytes();
                            }
                            client.applyUpdates(tinfo, usid, entry.getKey().toThrift(), updates);
                            updates.clear();
                            size = 0L;
                        }
                    }
                    UpdateErrors updateErrors = client.closeUpdate(tinfo, usid);
                    Map<KeyExtent, Long> failures = Translator.translate(updateErrors.failedExtents, Translators.TKET);
                    TabletServerBatchWriter.this.updatedConstraintViolations(Translator.translate(updateErrors.violationSummaries, Translators.TCVST));
                    TabletServerBatchWriter.this.updateAuthorizationFailures(Translator.translate(updateErrors.authorizationFailures, Translators.TKET));
                    long totalCommitted = 0L;
                    for (Map.Entry<KeyExtent, Long> entry : failures.entrySet()) {
                        KeyExtent failedExtent = entry.getKey();
                        int numCommitted = (int)entry.getValue().longValue();
                        totalCommitted += (long)numCommitted;
                        String tableId = failedExtent.getTableId();
                        this.getLocator(tableId).invalidateCache(failedExtent);
                        ArrayList mutations = (ArrayList)tabMuts.get(failedExtent);
                        allFailures.addAll(tableId, mutations.subList(numCommitted, mutations.size()));
                    }
                    if (failures.keySet().containsAll(tabMuts.keySet()) && totalCommitted == 0L) {
                        timeoutTracker.wroteNothing();
                    } else {
                        timeoutTracker.madeProgress();
                    }
                }
                mutationSet = allFailures;
            }
            catch (Throwable throwable) {
                try {
                    ThriftUtil.returnClient(client);
                    throw throwable;
                }
                catch (TTransportException e) {
                    timeoutTracker.errorOccured((Exception)((Object)e));
                    throw new IOException(e);
                }
                catch (TApplicationException tae) {
                    TabletServerBatchWriter.this.updateServerErrors(location, (Exception)((Object)tae));
                    throw new AccumuloServerException(location, tae);
                }
                catch (ThriftSecurityException e) {
                    TabletServerBatchWriter.this.updateAuthorizationFailures(tabMuts.keySet(), e.code);
                    throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                }
                catch (NoSuchScanIDException e) {
                    throw new IOException((Throwable)((Object)e));
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            ThriftUtil.returnClient(client);
            return mutationSet;
        }

        class SendTask
        implements Runnable {
            private final String location;

            SendTask(String server) {
                this.location = server;
            }

            @Override
            public void run() {
                try {
                    TabletLocator.TabletServerMutations tsmuts = MutationWriter.this.getMutationsToSend(this.location);
                    while (tsmuts != null) {
                        this.send(tsmuts);
                        tsmuts = MutationWriter.this.getMutationsToSend(this.location);
                    }
                    return;
                }
                catch (Throwable t) {
                    TabletServerBatchWriter.this.updateUnknownErrors("Failed to send tablet server " + this.location + " its batch : " + t.getMessage(), t);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void send(TabletLocator.TabletServerMutations<Mutation> tsm) throws AccumuloServerException, AccumuloSecurityException {
                MutationSet failures = null;
                String oldName = Thread.currentThread().getName();
                Map<KeyExtent, List<Mutation>> mutationBatch = tsm.getMutations();
                try {
                    long count = 0L;
                    TreeSet<String> tableIds = new TreeSet<String>();
                    for (Map.Entry<KeyExtent, List<Mutation>> entry : mutationBatch.entrySet()) {
                        count += (long)entry.getValue().size();
                        tableIds.add(entry.getKey().getTableId());
                    }
                    String msg = "sending " + String.format("%,d", count) + " mutations to " + String.format("%,d", mutationBatch.size()) + " tablets at " + this.location + " tids: [" + Joiner.on((char)',').join(tableIds) + ']';
                    Thread.currentThread().setName(msg);
                    Span span = Trace.start("sendMutations");
                    try {
                        TimeoutTracker timeoutTracker = (TimeoutTracker)TabletServerBatchWriter.this.timeoutTrackers.get(this.location);
                        if (timeoutTracker == null) {
                            timeoutTracker = new TimeoutTracker(this.location, TabletServerBatchWriter.this.timeout);
                            TabletServerBatchWriter.this.timeoutTrackers.put(this.location, timeoutTracker);
                        }
                        long st1 = System.currentTimeMillis();
                        failures = MutationWriter.this.sendMutationsToTabletServer(this.location, mutationBatch, timeoutTracker);
                        long st2 = System.currentTimeMillis();
                        if (log.isTraceEnabled()) {
                            log.trace("sent " + String.format("%,d", count) + " mutations to " + this.location + " in " + String.format("%.2f secs (%,.2f mutations/sec) with %,d failures", (double)(st2 - st1) / 1000.0, (double)count / ((double)(st2 - st1) / 1000.0), failures.size()));
                        }
                        long successBytes = 0L;
                        for (Map.Entry<KeyExtent, List<Mutation>> entry : mutationBatch.entrySet()) {
                            for (Mutation mutation : entry.getValue()) {
                                successBytes += mutation.estimatedMemoryUsed();
                            }
                        }
                        if (failures.size() > 0) {
                            TabletServerBatchWriter.this.failedMutations.add(failures);
                            successBytes -= (long)failures.getMemoryUsed();
                        }
                        TabletServerBatchWriter.this.updateSendStats(count, st2 - st1);
                        TabletServerBatchWriter.this.decrementMemUsed(successBytes);
                    }
                    finally {
                        span.stop();
                    }
                }
                catch (IOException e) {
                    if (log.isTraceEnabled()) {
                        log.trace("failed to send mutations to {} : {}", (Object)this.location, (Object)e.getMessage());
                    }
                    HashSet<String> tables = new HashSet<String>();
                    for (KeyExtent ke : mutationBatch.keySet()) {
                        tables.add(ke.getTableId());
                    }
                    for (String table : tables) {
                        MutationWriter.this.getLocator(table).invalidateCache(TabletServerBatchWriter.this.context.getInstance(), this.location);
                    }
                    TabletServerBatchWriter.this.failedMutations.add(this.location, tsm);
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        }
    }

    private class FailedMutations
    extends TimerTask {
        private MutationSet recentFailures = null;
        private long initTime;

        FailedMutations() {
            TabletServerBatchWriter.this.jtimer.schedule((TimerTask)this, 0L, 500L);
        }

        private MutationSet init() {
            if (this.recentFailures == null) {
                this.recentFailures = new MutationSet();
                this.initTime = System.currentTimeMillis();
            }
            return this.recentFailures;
        }

        synchronized void add(String table, ArrayList<Mutation> tableFailures) {
            this.init().addAll(table, tableFailures);
        }

        synchronized void add(MutationSet failures) {
            this.init().addAll(failures);
        }

        synchronized void add(String location, TabletLocator.TabletServerMutations<Mutation> tsm) {
            this.init();
            for (Map.Entry<KeyExtent, List<Mutation>> entry : tsm.getMutations().entrySet()) {
                this.recentFailures.addAll(entry.getKey().getTableId(), entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MutationSet rf = null;
                FailedMutations failedMutations = this;
                synchronized (failedMutations) {
                    if (this.recentFailures != null && System.currentTimeMillis() - this.initTime > 1000L) {
                        rf = this.recentFailures;
                        this.recentFailures = null;
                    }
                }
                if (rf != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("tid=" + Thread.currentThread().getId() + "  Requeuing " + rf.size() + " failed mutations");
                    }
                    TabletServerBatchWriter.this.addFailedMutations(rf);
                }
            }
            catch (Throwable t) {
                TabletServerBatchWriter.this.updateUnknownErrors("tid=" + Thread.currentThread().getId() + "  Failed to requeue failed mutations " + t.getMessage(), t);
                this.cancel();
            }
        }
    }

    private static interface WaitCondition {
        public boolean shouldWait();
    }

    private static class TimeoutTracker {
        final String server;
        final long timeOut;
        long activityTime;
        Long firstErrorTime = null;

        TimeoutTracker(String server, long timeOut) {
            this.timeOut = timeOut;
            this.server = server;
        }

        void startingWrite() {
            this.activityTime = System.currentTimeMillis();
        }

        void madeProgress() {
            this.activityTime = System.currentTimeMillis();
            this.firstErrorTime = null;
        }

        void wroteNothing() {
            if (this.firstErrorTime == null) {
                this.firstErrorTime = this.activityTime;
            } else if (System.currentTimeMillis() - this.firstErrorTime > this.timeOut) {
                throw new TimedOutException(Collections.singleton(this.server));
            }
        }

        void errorOccured(Exception e) {
            this.wroteNothing();
        }

        public long getTimeOut() {
            return this.timeOut;
        }
    }
}

