/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;

public class MultiTableFixture
extends Fixture {
    @Override
    public void setUp(State state, Environment env) throws Exception {
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        state.set("tableNamePrefix", String.format("multi_%s_%s_%d", hostname, env.getPid(), System.currentTimeMillis()));
        state.set("nextId", 0);
        state.set("numWrites", 0L);
        state.set("totalWrites", 0L);
        state.set("tableList", new CopyOnWriteArrayList());
    }

    @Override
    public void tearDown(State state, Environment env) throws Exception {
        if (env.isMultiTableBatchWriterInitialized()) {
            MultiTableBatchWriter mtbw = env.getMultiTableBatchWriter();
            try {
                mtbw.close();
            }
            catch (MutationsRejectedException e) {
                this.log.error((Object)"Ignoring mutations that weren't flushed", (Throwable)e);
            }
            env.resetMultiTableBatchWriter();
        }
        Connector conn = env.getConnector();
        List tables = (List)state.get("tableList");
        for (String tableName : tables) {
            try {
                conn.tableOperations().delete(tableName);
                this.log.debug((Object)("Dropping table " + tableName));
            }
            catch (TableNotFoundException e) {
                this.log.warn((Object)("Tried to drop table " + tableName + " but could not be found!"));
            }
        }
    }
}

