/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TabletStateChangeIteratorIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @Test
    public void test() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        String[] tables = this.getUniqueNames(6);
        String t1 = tables[0];
        String t2 = tables[1];
        final String t3 = tables[2];
        String metaCopy1 = tables[3];
        String metaCopy2 = tables[4];
        String metaCopy3 = tables[5];
        this.createTable(t1, true);
        this.createTable(t2, false);
        this.createTable(t3, true);
        this.copyTable("accumulo.metadata", metaCopy1);
        State state = new State();
        while (this.findTabletsNeedingAttention(metaCopy1, state) > 0) {
            UtilWaitThread.sleep((long)500L);
            this.copyTable("accumulo.metadata", metaCopy1);
        }
        Assert.assertEquals((String)"No tables should need attention", (long)0L, (long)this.findTabletsNeedingAttention(metaCopy1, state));
        this.copyTable(metaCopy1, metaCopy2);
        this.copyTable(metaCopy1, metaCopy3);
        this.removeLocation(metaCopy1, t3);
        Assert.assertEquals((String)"Should have two tablets without a loc", (long)2L, (long)this.findTabletsNeedingAttention(metaCopy1, state));
        this.reassignLocation(metaCopy2, t3);
        Assert.assertEquals((String)"Should have one tablet that needs to be unassigned", (long)1L, (long)this.findTabletsNeedingAttention(metaCopy2, state));
        state = new State(){

            @Override
            public Collection<MergeInfo> merges() {
                String tableIdToModify = (String)TabletStateChangeIteratorIT.this.getConnector().tableOperations().tableIdMap().get(t3);
                return Collections.singletonList(new MergeInfo(new KeyExtent(tableIdToModify, null, null), MergeInfo.Operation.MERGE));
            }
        };
        Assert.assertEquals((String)"Should have 2 tablets that need to be chopped or unassigned", (long)1L, (long)this.findTabletsNeedingAttention(metaCopy2, state));
        state = new State();
        this.addDuplicateLocation(metaCopy3, t3);
        Assert.assertEquals((String)"Should have 1 tablet that needs a metadata repair", (long)1L, (long)this.findTabletsNeedingAttention(metaCopy3, state));
        this.dropTables(t1, t2, t3, metaCopy1, metaCopy2, metaCopy3);
    }

    private void addDuplicateLocation(String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        String tableIdToModify = (String)this.getConnector().tableOperations().tableIdMap().get(tableNameToModify);
        Mutation m = new Mutation(new KeyExtent(tableIdToModify, null, null).getMetadataEntry());
        m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, new Text("1234567"), new Value("fake:9005".getBytes(StandardCharsets.UTF_8)));
        BatchWriter bw = this.getConnector().createBatchWriter(table, null);
        bw.addMutation(m);
        bw.close();
    }

    private void reassignLocation(String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        String tableIdToModify = (String)this.getConnector().tableOperations().tableIdMap().get(tableNameToModify);
        Scanner scanner = this.getConnector().createScanner(table, Authorizations.EMPTY);
        scanner.setRange(new KeyExtent(tableIdToModify, null, null).toMetadataRange());
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        Map.Entry entry = (Map.Entry)scanner.iterator().next();
        Mutation m = new Mutation(((Key)entry.getKey()).getRow());
        m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier(), ((Key)entry.getKey()).getTimestamp());
        m.put(((Key)entry.getKey()).getColumnFamily(), new Text("1234567"), ((Key)entry.getKey()).getTimestamp() + 1L, new Value("fake:9005".getBytes(StandardCharsets.UTF_8)));
        scanner.close();
        BatchWriter bw = this.getConnector().createBatchWriter(table, null);
        bw.addMutation(m);
        bw.close();
    }

    private void removeLocation(String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        String tableIdToModify = (String)this.getConnector().tableOperations().tableIdMap().get(tableNameToModify);
        BatchDeleter deleter = this.getConnector().createBatchDeleter(table, Authorizations.EMPTY, 1, new BatchWriterConfig());
        deleter.setRanges(Collections.singleton(new KeyExtent(tableIdToModify, null, null).toMetadataRange()));
        deleter.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        deleter.delete();
        deleter.close();
    }

    private int findTabletsNeedingAttention(String table, State state) throws TableNotFoundException {
        int results = 0;
        Scanner scanner = this.getConnector().createScanner(table, Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)state);
        scanner.updateScanIteratorOption("tabletChange", "debug", "1");
        for (Map.Entry e : scanner) {
            if (e == null) continue;
            ++results;
        }
        return results;
    }

    private void createTable(String t, boolean online) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, TableExistsException {
        Connector conn = this.getConnector();
        conn.tableOperations().create(t);
        conn.tableOperations().online(t, true);
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        partitionKeys.add(new Text("some split"));
        conn.tableOperations().addSplits(t, partitionKeys);
        if (!online) {
            conn.tableOperations().offline(t, true);
        }
    }

    private void copyTable(String source, String copy) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        try {
            this.dropTables(copy);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        this.getConnector().tableOperations().create(copy);
        try (Scanner scanner = this.getConnector().createScanner(source, Authorizations.EMPTY);
             BatchWriter writer = this.getConnector().createBatchWriter(copy, new BatchWriterConfig());){
            RowIterator rows = new RowIterator((Iterable)new IsolatedScanner(scanner));
            while (rows.hasNext()) {
                Iterator row = rows.next();
                Mutation m = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key k = (Key)entry.getKey();
                    if (m == null) {
                        m = new Mutation(k.getRow());
                    }
                    m.put(k.getColumnFamily(), k.getColumnQualifier(), k.getColumnVisibilityParsed(), k.getTimestamp(), (Value)entry.getValue());
                }
                writer.addMutation(m);
            }
        }
    }

    private void dropTables(String ... tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        for (String t : tables) {
            this.getConnector().tableOperations().delete(t);
        }
    }

    private class State
    implements CurrentState {
        private State() {
        }

        public Set<TServerInstance> onlineTabletServers() {
            HashSet<TServerInstance> tservers = new HashSet<TServerInstance>();
            for (String tserver : TabletStateChangeIteratorIT.this.getConnector().instanceOperations().getTabletServers()) {
                try {
                    String zPath = ZooUtil.getRoot((Instance)TabletStateChangeIteratorIT.this.getConnector().getInstance()) + "/tservers" + "/" + tserver;
                    long sessionId = ZooLock.getSessionId((ZooCache)new ZooCache(AccumuloClusterHarness.getCluster().getZooKeepers(), TabletStateChangeIteratorIT.this.getConnector().getInstance().getZooKeepersSessionTimeOut()), (String)zPath);
                    tservers.add(new TServerInstance(tserver, sessionId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return tservers;
        }

        public Set<String> onlineTables() {
            HashSet onlineTables = new HashSet(TabletStateChangeIteratorIT.this.getConnector().tableOperations().tableIdMap().values());
            return Sets.filter(onlineTables, tableId -> Tables.getTableState((Instance)TabletStateChangeIteratorIT.this.getConnector().getInstance(), (String)tableId) == TableState.ONLINE);
        }

        public Collection<MergeInfo> merges() {
            return Collections.emptySet();
        }

        public Set<KeyExtent> migrationsSnapshot() {
            return Collections.emptySet();
        }

        public Set<TServerInstance> shutdownServers() {
            return Collections.emptySet();
        }

        public MasterState getMasterState() {
            return MasterState.NORMAL;
        }
    }
}

