/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.UGIAssumingTransport;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.AccumuloProxy;
import org.apache.accumulo.proxy.thrift.AccumuloSecurityException;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.Key;
import org.apache.accumulo.proxy.thrift.KeyValue;
import org.apache.accumulo.proxy.thrift.ScanOptions;
import org.apache.accumulo.proxy.thrift.ScanResult;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.proxy.thrift.WriterOptions;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public class KerberosProxyIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosProxyIT.class);
    private static final String PROXIED_USER1 = "proxied_user1";
    private static final String PROXIED_USER2 = "proxied_user2";
    private static final String PROXIED_USER3 = "proxied_user3";
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static File proxyKeytab;
    private static String hostname;
    private static String proxyPrimary;
    private static String proxyPrincipal;
    private MiniAccumuloClusterImpl mac;
    private Process proxyProcess;
    private int proxyPort;

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    @BeforeClass
    public static void startKdc() throws Exception {
        kdc = new TestingKdc();
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (null == krbEnabledForITs || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        proxyKeytab = new File(kdc.getKeytabDir(), "proxy.keytab");
        hostname = InetAddress.getLocalHost().getCanonicalHostName();
        proxyPrimary = "proxy";
        proxyPrincipal = proxyPrimary + "/" + hostname;
        kdc.createPrincipal(proxyKeytab, proxyPrincipal);
        proxyPrincipal = kdc.qualifyUser(proxyPrincipal);
    }

    @AfterClass
    public static void stopKdc() throws Exception {
        if (null != kdc) {
            kdc.stop();
        }
        if (null != krbEnabledForITs) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void startMac() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.mac = harness.create(this.getClass().getName(), this.testName.getMethodName(), (AuthenticationToken)new PasswordToken((CharSequence)"unused"), new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                cfg.setNumTservers(1);
                Map siteCfg = cfg.getSiteConfig();
                siteCfg.put(Property.INSTANCE_RPC_SASL_ALLOWED_USER_IMPERSONATION.getKey(), proxyPrincipal + ":" + kdc.getRootUser().getPrincipal() + "," + kdc.qualifyUser(KerberosProxyIT.PROXIED_USER1) + "," + kdc.qualifyUser(KerberosProxyIT.PROXIED_USER2));
                siteCfg.put(Property.INSTANCE_RPC_SASL_ALLOWED_HOST_IMPERSONATION.getKey(), "*");
                cfg.setSiteConfig(siteCfg);
            }
        }, kdc);
        this.mac.start();
        MiniAccumuloConfigImpl cfg = this.mac.getConfig();
        this.proxyProcess = this.startProxy(cfg);
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        boolean success = false;
        ClusterUser rootUser = kdc.getRootUser();
        while (!success) {
            UserGroupInformation ugi;
            try {
                ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            }
            catch (IOException ex) {
                log.info("Login as root is failing", (Throwable)ex);
                Thread.sleep(3000L);
                continue;
            }
            TSocket socket = new TSocket(hostname, this.proxyPort);
            log.info("Connecting to proxy with server primary '" + proxyPrimary + "' running on " + hostname);
            TSaslClientTransport transport = new TSaslClientTransport("GSSAPI", null, proxyPrimary, hostname, Collections.singletonMap("javax.security.sasl.qop", "auth"), null, (TTransport)socket);
            UGIAssumingTransport ugiTransport = new UGIAssumingTransport((TTransport)transport, ugi);
            try {
                ugiTransport.open();
                success = true;
            }
            catch (TTransportException e) {
                Throwable cause = e.getCause();
                if (null == cause || !(cause instanceof ConnectException)) continue;
                log.info("Proxy not yet up, waiting");
                Thread.sleep(3000L);
                this.proxyProcess = this.checkProxyAndRestart(this.proxyProcess, cfg);
            }
            finally {
                if (null == ugiTransport) continue;
                ugiTransport.close();
            }
        }
        Assert.assertTrue((String)"Failed to connect to the proxy repeatedly", (boolean)success);
    }

    private Process startProxy(MiniAccumuloConfigImpl cfg) throws IOException {
        File proxyPropertiesFile = this.generateNewProxyConfiguration(cfg);
        return this.mac.exec(Proxy.class, new String[]{"-p", proxyPropertiesFile.getCanonicalPath()});
    }

    private File generateNewProxyConfiguration(MiniAccumuloConfigImpl cfg) throws IOException {
        this.proxyPort = PortUtils.getRandomFreePort();
        File proxyPropertiesFile = new File(cfg.getConfDir(), "proxy.properties");
        if (proxyPropertiesFile.exists()) {
            Assert.assertTrue((String)"Failed to delete proxy.properties file", (boolean)proxyPropertiesFile.delete());
        }
        Properties proxyProperties = new Properties();
        proxyProperties.setProperty("useMockInstance", "false");
        proxyProperties.setProperty("useMiniAccumulo", "false");
        proxyProperties.setProperty("protocolFactory", TCompactProtocol.Factory.class.getName());
        proxyProperties.setProperty("tokenClass", KerberosToken.class.getName());
        proxyProperties.setProperty("port", Integer.toString(this.proxyPort));
        proxyProperties.setProperty("maxFrameSize", "16M");
        proxyProperties.setProperty("instance", this.mac.getInstanceName());
        proxyProperties.setProperty("zookeepers", this.mac.getZooKeepers());
        proxyProperties.setProperty("thriftServerType", "sasl");
        proxyProperties.setProperty("kerberosPrincipal", proxyPrincipal);
        proxyProperties.setProperty("kerberosKeytab", proxyKeytab.getCanonicalPath());
        FileWriter writer = new FileWriter(proxyPropertiesFile);
        proxyProperties.store(writer, "Configuration for Accumulo proxy");
        writer.close();
        log.info("Created configuration for proxy listening on {}", (Object)this.proxyPort);
        return proxyPropertiesFile;
    }

    private Process checkProxyAndRestart(Process proxy, MiniAccumuloConfigImpl cfg) throws IOException {
        try {
            proxy.exitValue();
        }
        catch (IllegalThreadStateException e) {
            log.info("Proxy is still running");
            return proxy;
        }
        log.info("Restarting proxy because it is no longer alive");
        return this.startProxy(cfg);
    }

    @After
    public void stopMac() throws Exception {
        if (null != this.proxyProcess) {
            log.info("Destroying proxy process");
            this.proxyProcess.destroy();
            log.info("Waiting for proxy termination");
            this.proxyProcess.waitFor();
            log.info("Proxy terminated");
        }
        if (null != this.mac) {
            this.mac.stop();
        }
    }

    @Test
    public void testProxyClient() throws Exception {
        ClusterUser rootUser = kdc.getRootUser();
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        TSocket socket = new TSocket(hostname, this.proxyPort);
        log.info("Connecting to proxy with server primary '" + proxyPrimary + "' running on " + hostname);
        TSaslClientTransport transport = new TSaslClientTransport("GSSAPI", null, proxyPrimary, hostname, Collections.singletonMap("javax.security.sasl.qop", "auth"), null, (TTransport)socket);
        UGIAssumingTransport ugiTransport = new UGIAssumingTransport((TTransport)transport, ugi);
        ugiTransport.open();
        AccumuloProxy.Client.Factory factory = new AccumuloProxy.Client.Factory();
        AccumuloProxy.Client client = factory.getClient((TProtocol)new TCompactProtocol((TTransport)ugiTransport), (TProtocol)new TCompactProtocol((TTransport)ugiTransport));
        ByteBuffer login = client.login(rootUser.getPrincipal(), Collections.emptyMap());
        String table = "table";
        if (!client.tableExists(login, table)) {
            client.createTable(login, table, true, TimeType.MILLIS);
        }
        String writer = client.createWriter(login, table, new WriterOptions());
        HashMap<ByteBuffer, List<ColumnUpdate>> updates = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        ColumnUpdate update = new ColumnUpdate(ByteBuffer.wrap("cf1".getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap("cq1".getBytes(StandardCharsets.UTF_8)));
        update.setValue(ByteBuffer.wrap("value1".getBytes(StandardCharsets.UTF_8)));
        updates.put(ByteBuffer.wrap("row1".getBytes(StandardCharsets.UTF_8)), Collections.singletonList(update));
        update = new ColumnUpdate(ByteBuffer.wrap("cf2".getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap("cq2".getBytes(StandardCharsets.UTF_8)));
        update.setValue(ByteBuffer.wrap("value2".getBytes(StandardCharsets.UTF_8)));
        updates.put(ByteBuffer.wrap("row2".getBytes(StandardCharsets.UTF_8)), Collections.singletonList(update));
        client.update(writer, updates);
        client.flush(writer);
        client.closeWriter(writer);
        String scanner = client.createScanner(login, table, new ScanOptions());
        ScanResult results = client.nextK(scanner, 10);
        Assert.assertEquals((long)2L, (long)results.getResults().size());
        KeyValue kv = (KeyValue)results.getResults().get(0);
        Key k = kv.key;
        ByteBuffer v = kv.value;
        Assert.assertEquals((Object)ByteBuffer.wrap("row1".getBytes(StandardCharsets.UTF_8)), (Object)k.row);
        Assert.assertEquals((Object)ByteBuffer.wrap("cf1".getBytes(StandardCharsets.UTF_8)), (Object)k.colFamily);
        Assert.assertEquals((Object)ByteBuffer.wrap("cq1".getBytes(StandardCharsets.UTF_8)), (Object)k.colQualifier);
        Assert.assertEquals((Object)ByteBuffer.wrap(new byte[0]), (Object)k.colVisibility);
        Assert.assertEquals((Object)ByteBuffer.wrap("value1".getBytes(StandardCharsets.UTF_8)), (Object)v);
        kv = (KeyValue)results.getResults().get(1);
        k = kv.key;
        v = kv.value;
        Assert.assertEquals((Object)ByteBuffer.wrap("row2".getBytes(StandardCharsets.UTF_8)), (Object)k.row);
        Assert.assertEquals((Object)ByteBuffer.wrap("cf2".getBytes(StandardCharsets.UTF_8)), (Object)k.colFamily);
        Assert.assertEquals((Object)ByteBuffer.wrap("cq2".getBytes(StandardCharsets.UTF_8)), (Object)k.colQualifier);
        Assert.assertEquals((Object)ByteBuffer.wrap(new byte[0]), (Object)k.colVisibility);
        Assert.assertEquals((Object)ByteBuffer.wrap("value2".getBytes(StandardCharsets.UTF_8)), (Object)v);
        client.closeScanner(scanner);
        ugiTransport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowedClientForImpersonation() throws Exception {
        String user = this.testName.getMethodName();
        File keytab = new File(kdc.getKeytabDir(), user + ".keytab");
        kdc.createPrincipal(keytab, user);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)keytab.getAbsolutePath());
        log.info("Logged in as " + ugi);
        TSocket socket = new TSocket(hostname, this.proxyPort);
        log.info("Connecting to proxy with server primary '" + proxyPrimary + "' running on " + hostname);
        TSaslClientTransport transport = new TSaslClientTransport("GSSAPI", null, proxyPrimary, hostname, Collections.singletonMap("javax.security.sasl.qop", "auth"), null, (TTransport)socket);
        UGIAssumingTransport ugiTransport = new UGIAssumingTransport((TTransport)transport, ugi);
        ugiTransport.open();
        AccumuloProxy.Client.Factory factory = new AccumuloProxy.Client.Factory();
        AccumuloProxy.Client client = factory.getClient((TProtocol)new TCompactProtocol((TTransport)ugiTransport), (TProtocol)new TCompactProtocol((TTransport)ugiTransport));
        try {
            AccumuloSecurityException e = (AccumuloSecurityException)Assert.assertThrows(AccumuloSecurityException.class, () -> client.login(kdc.qualifyUser(user), Collections.emptyMap()));
            Assert.assertTrue((boolean)this.thriftExceptionMatchesPattern(e, ".*Error BAD_CREDENTIALS.*"));
            Assert.assertTrue((boolean)this.thriftExceptionMatchesPattern(e, ".*Expected '" + proxyPrincipal + "' but was '" + kdc.qualifyUser(user) + "'.*"));
        }
        finally {
            if (null != ugiTransport) {
                ugiTransport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMismatchPrincipals() throws Exception {
        ClusterUser rootUser = kdc.getRootUser();
        String user = this.testName.getMethodName();
        File keytab = new File(kdc.getKeytabDir(), user + ".keytab");
        kdc.createPrincipal(keytab, user);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)keytab.getAbsolutePath());
        log.info("Logged in as " + ugi);
        TSocket socket = new TSocket(hostname, this.proxyPort);
        log.info("Connecting to proxy with server primary '" + proxyPrimary + "' running on " + hostname);
        TSaslClientTransport transport = new TSaslClientTransport("GSSAPI", null, proxyPrimary, hostname, Collections.singletonMap("javax.security.sasl.qop", "auth"), null, (TTransport)socket);
        UGIAssumingTransport ugiTransport = new UGIAssumingTransport((TTransport)transport, ugi);
        ugiTransport.open();
        AccumuloProxy.Client.Factory factory = new AccumuloProxy.Client.Factory();
        AccumuloProxy.Client client = factory.getClient((TProtocol)new TCompactProtocol((TTransport)ugiTransport), (TProtocol)new TCompactProtocol((TTransport)ugiTransport));
        try {
            AccumuloSecurityException e = (AccumuloSecurityException)Assert.assertThrows(AccumuloSecurityException.class, () -> client.login(rootUser.getPrincipal(), Collections.emptyMap()));
            Assert.assertTrue((boolean)this.thriftExceptionMatchesPattern(e, "RPC principal did not match requested Accumulo principal"));
        }
        finally {
            if (null != ugiTransport) {
                ugiTransport.close();
            }
        }
    }

    @Test
    public void proxiedUserAccessWithoutAccumuloProxy() throws Exception {
        final String tableName = this.getUniqueNames(1)[0];
        ClusterUser rootUser = kdc.getRootUser();
        final UserGroupInformation rootUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        UserGroupInformation realUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)proxyPrincipal, (String)proxyKeytab.getAbsolutePath());
        final String userWithoutCredentials1 = kdc.qualifyUser(PROXIED_USER1);
        final String userWithoutCredentials2 = kdc.qualifyUser(PROXIED_USER2);
        final String userWithoutCredentials3 = kdc.qualifyUser(PROXIED_USER3);
        UserGroupInformation proxyUser1 = UserGroupInformation.createProxyUser((String)userWithoutCredentials1, (UserGroupInformation)realUgi);
        UserGroupInformation proxyUser2 = UserGroupInformation.createProxyUser((String)userWithoutCredentials2, (UserGroupInformation)realUgi);
        UserGroupInformation proxyUser3 = UserGroupInformation.createProxyUser((String)userWithoutCredentials3, (UserGroupInformation)realUgi);
        rootUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ZooKeeperInstance inst = new ZooKeeperInstance(KerberosProxyIT.this.mac.getClientConfig());
                Connector conn = inst.getConnector(rootUgi.getUserName(), (AuthenticationToken)new KerberosToken());
                conn.tableOperations().create(tableName);
                conn.securityOperations().createLocalUser(userWithoutCredentials1, new PasswordToken((CharSequence)"ignored"));
                conn.securityOperations().grantTablePermission(userWithoutCredentials1, tableName, TablePermission.READ);
                conn.securityOperations().createLocalUser(userWithoutCredentials3, new PasswordToken((CharSequence)"ignored"));
                conn.securityOperations().grantTablePermission(userWithoutCredentials3, tableName, TablePermission.READ);
                return null;
            }
        });
        realUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ZooKeeperInstance inst = new ZooKeeperInstance(KerberosProxyIT.this.mac.getClientConfig());
                Connector conn = inst.getConnector(proxyPrincipal, (AuthenticationToken)new KerberosToken());
                try {
                    Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
                    s.iterator().hasNext();
                    Assert.fail((String)"Expected to see an exception");
                }
                catch (RuntimeException e) {
                    int numSecurityExceptionsSeen = Iterables.size((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), org.apache.accumulo.core.client.AccumuloSecurityException.class));
                    Assert.assertTrue((String)("Expected to see at least one AccumuloSecurityException, but saw: " + Throwables.getStackTraceAsString((Throwable)e)), (numSecurityExceptionsSeen > 0 ? 1 : 0) != 0);
                }
                return null;
            }
        });
        proxyUser1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ZooKeeperInstance inst = new ZooKeeperInstance(KerberosProxyIT.this.mac.getClientConfig());
                Connector conn = inst.getConnector(userWithoutCredentials1, (AuthenticationToken)new KerberosToken(userWithoutCredentials1));
                Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
                Assert.assertFalse((boolean)s.iterator().hasNext());
                return null;
            }
        });
        proxyUser2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ZooKeeperInstance inst = new ZooKeeperInstance(KerberosProxyIT.this.mac.getClientConfig());
                Connector conn = inst.getConnector(userWithoutCredentials2, (AuthenticationToken)new KerberosToken(userWithoutCredentials3));
                try {
                    Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
                    s.iterator().hasNext();
                    Assert.fail((String)"Expected to see an exception");
                }
                catch (RuntimeException e) {
                    int numSecurityExceptionsSeen = Iterables.size((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), org.apache.accumulo.core.client.AccumuloSecurityException.class));
                    Assert.assertTrue((String)("Expected to see at least one AccumuloSecurityException, but saw: " + Throwables.getStackTraceAsString((Throwable)e)), (numSecurityExceptionsSeen > 0 ? 1 : 0) != 0);
                }
                return null;
            }
        });
        proxyUser3.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ZooKeeperInstance inst = new ZooKeeperInstance(KerberosProxyIT.this.mac.getClientConfig());
                try {
                    inst.getConnector(userWithoutCredentials3, (AuthenticationToken)new KerberosToken(userWithoutCredentials3));
                    Assert.fail((String)"Should not be able to create a Connector as this user cannot be proxied");
                }
                catch (org.apache.accumulo.core.client.AccumuloSecurityException accumuloSecurityException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private boolean thriftExceptionMatchesPattern(AccumuloSecurityException e, String pattern) {
        return e.isSetMsg() && e.msg.matches(pattern);
    }

    static {
        krbEnabledForITs = null;
    }
}

