/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigurationUpdateIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TableConfigurationUpdateIT.class);

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector conn = this.getConnector();
        Instance inst = conn.getInstance();
        String table = this.getUniqueNames(1)[0];
        conn.tableOperations().create(table);
        NamespaceConfiguration defaultConf = new NamespaceConfiguration("+default", inst, (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
        int randomMax = 4;
        int numThreads = 2;
        int iterations = 100000;
        TableConfiguration tableConf = new TableConfiguration(inst, table, defaultConf);
        long start = System.currentTimeMillis();
        ExecutorService svc = Executors.newFixedThreadPool(numThreads);
        CountDownLatch countDown = new CountDownLatch(numThreads);
        ArrayList<Future<Exception>> futures = new ArrayList<Future<Exception>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            futures.add(svc.submit(new TableConfRunner(randomMax, iterations, (AccumuloConfiguration)tableConf, countDown)));
        }
        svc.shutdown();
        Assert.assertTrue((boolean)svc.awaitTermination(60L, TimeUnit.MINUTES));
        for (Future future : futures) {
            Exception e = (Exception)future.get();
            if (null == e) continue;
            Assert.fail((String)("Thread failed with exception " + e));
        }
        long end = System.currentTimeMillis();
        log.debug(tableConf + " with " + iterations + " iterations and " + numThreads + " threads and cache invalidates " + 1.0 / (double)randomMax * 100.0 + "% took " + (end - start) / 1000L + " second(s)");
    }

    public static class TableConfRunner
    implements Callable<Exception> {
        private static final Property prop = Property.TABLE_SPLIT_THRESHOLD;
        private AccumuloConfiguration tableConf;
        private CountDownLatch countDown;
        private int iterations;
        private int randMax;

        public TableConfRunner(int randMax, int iterations, AccumuloConfiguration tableConf, CountDownLatch countDown) {
            this.randMax = randMax;
            this.iterations = iterations;
            this.tableConf = tableConf;
            this.countDown = countDown;
        }

        @Override
        public Exception call() {
            Random r = new Random();
            this.countDown.countDown();
            try {
                this.countDown.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return e;
            }
            String t = Thread.currentThread().getName() + " ";
            try {
                for (int i = 0; i < this.iterations; ++i) {
                    int choice = r.nextInt(this.randMax);
                    if (choice < 1) {
                        this.tableConf.invalidateCache();
                        continue;
                    }
                    this.tableConf.get(prop);
                }
            }
            catch (Exception e) {
                log.error(t, (Throwable)e);
                return e;
            }
            return null;
        }
    }
}

