/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.KerberosAuthorizor;
import org.apache.accumulo.server.security.handler.KerberosPermissionHandler;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.accumulo.test.util.CertUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(MiniClusterHarness.class);
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final String PROP_PREFIX = "org.apache.accumulo.test.functional.";
    public static final String USE_SSL_FOR_IT_OPTION = "org.apache.accumulo.test.functional.useSslForIT";
    public static final String USE_CRED_PROVIDER_FOR_IT_OPTION = "org.apache.accumulo.test.functional.useCredProviderForIT";
    public static final String USE_KERBEROS_FOR_IT_OPTION = "org.apache.accumulo.test.functional.useKrbForIT";
    public static final String TRUE = Boolean.toString(true);
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";

    public MiniAccumuloClusterImpl create(AuthenticationToken token) throws Exception {
        return this.create(MiniClusterHarness.class.getName(), Long.toString(COUNTER.incrementAndGet()), token);
    }

    public MiniAccumuloClusterImpl create(AuthenticationToken token, TestingKdc kdc) throws Exception {
        return this.create(MiniClusterHarness.class.getName(), Long.toString(COUNTER.incrementAndGet()), token, kdc);
    }

    public MiniAccumuloClusterImpl create(AccumuloITBase testBase, AuthenticationToken token) throws Exception {
        return this.create(testBase.getClass().getName(), testBase.testName.getMethodName(), token);
    }

    public MiniAccumuloClusterImpl create(AccumuloITBase testBase, AuthenticationToken token, TestingKdc kdc) throws Exception {
        return this.create(testBase, token, kdc, MiniClusterConfigurationCallback.NO_CALLBACK);
    }

    public MiniAccumuloClusterImpl create(AccumuloITBase testBase, AuthenticationToken token, TestingKdc kdc, MiniClusterConfigurationCallback configCallback) throws Exception {
        return this.create(testBase.getClass().getName(), testBase.testName.getMethodName(), token, configCallback, kdc);
    }

    public MiniAccumuloClusterImpl create(AccumuloClusterHarness testBase, AuthenticationToken token, TestingKdc kdc) throws Exception {
        return this.create(testBase.getClass().getName(), testBase.testName.getMethodName(), token, testBase, kdc);
    }

    public MiniAccumuloClusterImpl create(AccumuloClusterHarness testBase, AuthenticationToken token, MiniClusterConfigurationCallback callback) throws Exception {
        return this.create(testBase.getClass().getName(), testBase.testName.getMethodName(), token, callback);
    }

    public MiniAccumuloClusterImpl create(String testClassName, String testMethodName, AuthenticationToken token) throws Exception {
        return this.create(testClassName, testMethodName, token, MiniClusterConfigurationCallback.NO_CALLBACK);
    }

    public MiniAccumuloClusterImpl create(String testClassName, String testMethodName, AuthenticationToken token, TestingKdc kdc) throws Exception {
        return this.create(testClassName, testMethodName, token, MiniClusterConfigurationCallback.NO_CALLBACK, kdc);
    }

    public MiniAccumuloClusterImpl create(String testClassName, String testMethodName, AuthenticationToken token, MiniClusterConfigurationCallback configCallback) throws Exception {
        return this.create(testClassName, testMethodName, token, configCallback, null);
    }

    public MiniAccumuloClusterImpl create(String testClassName, String testMethodName, AuthenticationToken token, MiniClusterConfigurationCallback configCallback, TestingKdc kdc) throws Exception {
        Objects.requireNonNull(token);
        Preconditions.checkArgument((token instanceof PasswordToken || token instanceof KerberosToken ? 1 : 0) != 0, (Object)"A PasswordToken or KerberosToken is required");
        String rootPasswd = token instanceof PasswordToken ? new String(((PasswordToken)token).getPassword(), StandardCharsets.UTF_8) : UUID.randomUUID().toString();
        File baseDir = AccumuloClusterHarness.createTestDir(testClassName + "_" + testMethodName);
        MiniAccumuloConfigImpl cfg = new MiniAccumuloConfigImpl(baseDir, rootPasswd);
        cfg.setNativeLibPaths(new String[]{NativeMapIT.nativeMapLocation().getAbsolutePath()});
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.TRUE.toString());
        Configuration coreSite = new Configuration(false);
        this.configureForEnvironment(cfg, this.getClass(), AccumuloClusterHarness.getSslDir(baseDir), coreSite, kdc);
        configCallback.configureMiniCluster(cfg, coreSite);
        MiniAccumuloClusterImpl miniCluster = new MiniAccumuloClusterImpl(cfg);
        if (coreSite.size() > 0) {
            File csFile = new File(miniCluster.getConfig().getConfDir(), "core-site.xml");
            if (csFile.exists()) {
                throw new RuntimeException(csFile + " already exist");
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(miniCluster.getConfig().getConfDir(), "core-site.xml")));
            coreSite.writeXml((OutputStream)out);
            ((OutputStream)out).close();
        }
        return miniCluster;
    }

    protected void configureForEnvironment(MiniAccumuloConfigImpl cfg, Class<?> testClass, File folder, Configuration coreSite, TestingKdc kdc) {
        if (TRUE.equals(System.getProperty(USE_SSL_FOR_IT_OPTION))) {
            this.configureForSsl(cfg, folder);
        }
        if (TRUE.equals(System.getProperty(USE_CRED_PROVIDER_FOR_IT_OPTION))) {
            cfg.setUseCredentialProvider(true);
        }
        if (TRUE.equals(System.getProperty(USE_KERBEROS_FOR_IT_OPTION))) {
            if (TRUE.equals(System.getProperty(USE_SSL_FOR_IT_OPTION))) {
                throw new RuntimeException("Cannot use both SSL and Kerberos");
            }
            try {
                this.configureForKerberos(cfg, folder, coreSite, kdc);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize KDC", e);
            }
        }
    }

    protected void configureForSsl(MiniAccumuloConfigImpl cfg, File folder) {
        Map siteConfig = cfg.getSiteConfig();
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            return;
        }
        File sslDir = new File(folder, "ssl");
        Assert.assertTrue((sslDir.mkdirs() || sslDir.isDirectory() ? 1 : 0) != 0);
        File rootKeystoreFile = new File(sslDir, "root-" + cfg.getInstanceName() + ".jks");
        File localKeystoreFile = new File(sslDir, "local-" + cfg.getInstanceName() + ".jks");
        File publicTruststoreFile = new File(sslDir, "public-" + cfg.getInstanceName() + ".jks");
        String rootKeystorePassword = "root_keystore_password";
        String truststorePassword = "truststore_password";
        try {
            new CertUtils(Property.RPC_SSL_KEYSTORE_TYPE.getDefaultValue(), "o=Apache Accumulo,cn=MiniAccumuloCluster", "RSA", 2048, "sha1WithRSAEncryption").createAll(rootKeystoreFile, localKeystoreFile, publicTruststoreFile, cfg.getInstanceName(), "root_keystore_password", cfg.getRootPassword(), "truststore_password");
        }
        catch (Exception e) {
            throw new RuntimeException("error creating MAC keystore", e);
        }
        siteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), localKeystoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), cfg.getRootPassword());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), publicTruststoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), "truststore_password");
        cfg.setSiteConfig(siteConfig);
    }

    protected void configureForKerberos(MiniAccumuloConfigImpl cfg, File folder, Configuration coreSite, TestingKdc kdc) throws Exception {
        Map siteConfig = cfg.getSiteConfig();
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            throw new RuntimeException("Cannot use both SSL and SASL/Kerberos");
        }
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SASL_ENABLED.getKey()))) {
            return;
        }
        if (null == kdc) {
            throw new IllegalStateException("MiniClusterKdc was null");
        }
        log.info("Enabling Kerberos/SASL for minicluster");
        cfg.setProperty(Property.INSTANCE_RPC_SASL_ENABLED, "true");
        ClusterUser serverUser = kdc.getAccumuloServerUser();
        cfg.setProperty(Property.GENERAL_KERBEROS_KEYTAB, serverUser.getKeytab().getAbsolutePath());
        cfg.setProperty(Property.GENERAL_KERBEROS_PRINCIPAL, serverUser.getPrincipal());
        cfg.setProperty(Property.INSTANCE_SECURITY_AUTHENTICATOR, KerberosAuthenticator.class.getName());
        cfg.setProperty(Property.INSTANCE_SECURITY_AUTHORIZOR, KerberosAuthorizor.class.getName());
        cfg.setProperty(Property.INSTANCE_SECURITY_PERMISSION_HANDLER, KerberosPermissionHandler.class.getName());
        cfg.setProperty(Property.TRACE_USER, serverUser.getPrincipal());
        cfg.setProperty(Property.TRACE_TOKEN_TYPE, KerberosToken.CLASS_NAME);
        Map systemProperties = cfg.getSystemProperties();
        systemProperties.put(JAVA_SECURITY_KRB5_CONF, System.getProperty(JAVA_SECURITY_KRB5_CONF, ""));
        systemProperties.put(SUN_SECURITY_KRB5_DEBUG, System.getProperty(SUN_SECURITY_KRB5_DEBUG, "false"));
        cfg.setSystemProperties(systemProperties);
        coreSite.set("hadoop.security.authentication", "kerberos");
        cfg.setRootUserName(kdc.getRootUser().getPrincipal());
    }
}

