/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.celltypes.NumberType;
import org.apache.accumulo.server.replication.DistributedWorkQueueWorkAssignerHelper;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationServlet
extends BasicServlet {
    private static final Logger log = LoggerFactory.getLogger(ReplicationServlet.class);
    private static final long serialVersionUID = 1L;
    private volatile transient ReplicationUtil replicationUtil = null;

    private synchronized ReplicationUtil getReplicationUtil() {
        if (this.replicationUtil == null) {
            this.replicationUtil = new ReplicationUtil(Monitor.getContext());
        }
        return this.replicationUtil;
    }

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Replication Overview";
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse response, StringBuilder sb) throws Exception {
        Connector conn = Monitor.getContext().getConnector();
        MasterMonitorInfo mmi = Monitor.getMmi();
        int totalWorkQueueSize = this.getReplicationUtil().getMaxReplicationThreads(mmi);
        TableOperations tops = conn.tableOperations();
        if (!ReplicationTable.isOnline((Connector)conn)) {
            ReplicationServlet.banner(sb, "", "Replication table is offline");
            return;
        }
        Table replicationStats = new Table("replicationStats", "Replication Status");
        replicationStats.addSortableColumn("Table");
        replicationStats.addSortableColumn("Peer");
        replicationStats.addSortableColumn("Remote Identifier");
        replicationStats.addSortableColumn("ReplicaSystem Type");
        replicationStats.addSortableColumn("Files needing replication", new NumberType(), null);
        Map peers = this.getReplicationUtil().getPeers();
        Set allConfiguredTargets = this.getReplicationUtil().getReplicationTargets();
        Map targetCounts = this.getReplicationUtil().getPendingReplications();
        Map tableNameToId = tops.tableIdMap();
        Map tableIdToName = this.getReplicationUtil().invert(tableNameToId);
        long filesPendingOverAllTargets = 0L;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            String tableName = (String)tableIdToName.get(configuredTarget.getSourceTableId());
            if (null == tableName) {
                log.trace("Could not determine table name from id {}", (Object)configuredTarget.getSourceTableId());
                continue;
            }
            String replicaSystemClass = (String)peers.get(configuredTarget.getPeerName());
            if (null == replicaSystemClass) {
                log.trace("Could not determine configured ReplicaSystem for {}", (Object)configuredTarget.getPeerName());
                continue;
            }
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (null == numFiles) {
                replicationStats.addRow(tableName, configuredTarget.getPeerName(), configuredTarget.getRemoteIdentifier(), replicaSystemClass, 0);
                continue;
            }
            replicationStats.addRow(tableName, configuredTarget.getPeerName(), configuredTarget.getRemoteIdentifier(), replicaSystemClass, numFiles);
            filesPendingOverAllTargets += numFiles.longValue();
        }
        NumberType<Long> filesPendingFormat = new NumberType<Long>(0L, Long.valueOf(2 * totalWorkQueueSize), 0L, Long.valueOf(4 * totalWorkQueueSize));
        String utilization = filesPendingFormat.format(filesPendingOverAllTargets);
        sb.append("<div><center><br /><span class=\"table-caption\">Total files pending replication: ").append(utilization).append("</span></center></div>");
        replicationStats.generate(req, sb);
        Table replicationInProgress = new Table("replicationInProgress", "In-Progress Replication");
        replicationInProgress.addSortableColumn("File");
        replicationInProgress.addSortableColumn("Peer");
        replicationInProgress.addSortableColumn("Source Table ID");
        replicationInProgress.addSortableColumn("Peer Identifier");
        replicationInProgress.addUnsortableColumn("Status");
        String zkRoot = ZooUtil.getRoot((Instance)Monitor.getContext().getInstance());
        String workQueuePath = zkRoot + "/replication/workqueue";
        DistributedWorkQueue workQueue = new DistributedWorkQueue(workQueuePath, Monitor.getContext().getConfiguration());
        try {
            for (String queueKey : workQueue.getWorkQueued()) {
                Map.Entry queueKeyPair = DistributedWorkQueueWorkAssignerHelper.fromQueueKey((String)queueKey);
                String filename = (String)queueKeyPair.getKey();
                ReplicationTarget target = (ReplicationTarget)queueKeyPair.getValue();
                String path = this.getReplicationUtil().getAbsolutePath(conn, workQueuePath, queueKey);
                String progress = this.getReplicationUtil().getProgress(conn, path, target);
                replicationInProgress.addRow(null == path ? ".../" + filename : path, target.getPeerName(), target.getSourceTableId(), target.getRemoteIdentifier(), progress);
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Could not calculate replication in progress", e);
        }
        replicationInProgress.generate(req, sb);
    }
}

