/* $OpenLDAP: pkg/ldap/libraries/liblutil/memcmp.c,v 1.4 2003/05/25 01:31:21 kurt Exp $ */
/*
 * Copyright 1998-2003 The OpenLDAP Foundation, All Rights Reserved.
 * COPYING RESTRICTIONS APPLY, see COPYRIGHT file
 */
#include "portable.h"

#include <ac/string.h>

/* 
 * Memory Compare
 */
int
(memcmp)(const void *v1, const void *v2, int n) 
{
    if (n != 0) {
		const unsigned char *s1=v1, *s2=v2;
        do {
            if (*s1++ != *s2++)
                return (*--s1 - *--s2);
        } while (--n != 0);
    }
    return (0);
} 
