---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, colonnes, mise en forme des tableaux,
              mise en forme d'une colonne, changer le style d'une colonne, 
              fonte dans un tableau
---

# Comment changer la fonte d'une colonne ?

L'extension <ctanpkg:array> permet d'insérer systématiquement des commandes 
entre le contenu d'une colonne et son séparateur. Cela se fait au moyen 
des "descripteurs" de colonnes `>` et `<`.

Voici comment tout cela fonctionne :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{array}

\begin{document}
\begin{tabular}{|>{\scshape}l|>{\(}c<{\)}|>{\itshape}r|}
  \hline
  Hugo       & 1831 & Les feuilles d'automne \\
  Balzac     & 1832 & Le colonel Chabert     \\
  Maupassant & 1887 & Le Horla               \\
  \hline
\end{tabular}
\end{document}
```