/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion", "markdown"})
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        Intrinsics.checkNotNullParameter(stateInfo, "stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list = Companion.matchLinkDefinition(pos.getOriginalText(), pos.getOffset());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list;
        Iterator iterator2 = ((Iterable)matchResult).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            IElementType iElementType;
            int i = n++;
            IntRange range = (IntRange)iterator2.next();
            IntRange intRange = Companion.addToRangeAndWiden(range, 0);
            switch (i) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.LINK_TITLE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"There are no more than three groups in this regex");
                }
            }
            productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = CollectionsKt.last(matchResult).getLast() - pos.getOffset() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf(new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        return false;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\fJ\u0011\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\bJ\u0011\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\bJ\u001e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "addToRangeAndWiden", "Lkotlin/ranges/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "isSpace", "c", "", "isSpaceOrNewline", "matchLinkDefinition", "", "text", "", "startOffset", "matchLinkDestination", "start", "matchLinkLabel", "matchLinkTitle", "passOneNewline", "markdown"})
    @SourceDebugExtension(value={"SMAP\nLinkReferenceDefinitionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkReferenceDefinitionProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion\n*L\n1#1,223:1\n218#1:224\n220#1:225\n218#1:226\n220#1:227\n218#1:228\n220#1:229\n218#1:230\n220#1:231\n218#1:232\n218#1:233\n220#1:234\n218#1:235\n218#1:236\n218#1:237\n218#1:238\n*S KotlinDebug\n*F\n+ 1 LinkReferenceDefinitionProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion\n*L\n78#1:224\n99#1:225\n99#1:226\n101#1:227\n101#1:228\n112#1:229\n112#1:230\n126#1:231\n126#1:232\n162#1:233\n166#1:234\n166#1:235\n208#1:236\n212#1:237\n220#1:238\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkNotNullParameter(range, "range");
            return new IntRange(range.getFirst() + t, range.getLast() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkNotNullParameter(pos, "pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text2, int startOffset) {
            Intrinsics.checkNotNullParameter(text2, "text");
            int offset = MarkerBlockProvider.Companion.passSmallIndent(text2, startOffset);
            IntRange intRange = this.matchLinkLabel(text2, offset);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset = linkLabel.getLast() + 1;
            if (offset >= text2.length() || text2.charAt(offset) != ':') {
                return null;
            }
            ++offset;
            offset = this.passOneNewline(text2, offset);
            IntRange intRange2 = this.matchLinkDestination(text2, offset);
            if (intRange2 == null) {
                return null;
            }
            IntRange destination = intRange2;
            offset = destination.getLast() + 1;
            offset = this.passOneNewline(text2, offset);
            IntRange title = this.matchLinkTitle(text2, offset);
            ArrayList<IntRange> result2 = new ArrayList<IntRange>();
            result2.add(linkLabel);
            result2.add(destination);
            if (title != null) {
                for (offset = title.getLast() + 1; offset < text2.length(); ++offset) {
                    Companion companion = this;
                    char c$iv = text2.charAt(offset);
                    boolean $i$f$isSpace = false;
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                }
                if (offset >= text2.length() || text2.charAt(offset) == '\n') {
                    result2.add(title);
                }
            }
            return result2;
        }

        @Nullable
        public final IntRange matchLinkDestination(@NotNull CharSequence text2, int start) {
            int offset;
            block16: {
                Intrinsics.checkNotNullParameter(text2, "text");
                if (start >= text2.length()) {
                    return null;
                }
                offset = start;
                if (text2.charAt(offset) != '<') break block16;
                ++offset;
                while (offset < text2.length()) {
                    Companion this_$iv;
                    char c;
                    block18: {
                        block17: {
                            c = text2.charAt(offset);
                            if (c == '>') {
                                return new IntRange(start, offset);
                            }
                            if (c == '<' || c == '>') break block17;
                            this_$iv = this;
                            boolean $i$f$isSpaceOrNewline = false;
                            Companion this_$iv$iv = this_$iv;
                            boolean $i$f$isSpace = false;
                            if (!(c == ' ' || c == '\t' || c == '\n')) break block18;
                        }
                        return null;
                    }
                    if (c == '\\' && offset + 1 < text2.length()) {
                        this_$iv = this;
                        char c$iv = text2.charAt(offset + 1);
                        boolean $i$f$isSpaceOrNewline = false;
                        Companion this_$iv$iv = this_$iv;
                        boolean $i$f$isSpace = false;
                        if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                            ++offset;
                        }
                    }
                    ++offset;
                }
                return null;
            }
            boolean hasParens = false;
            while (offset < text2.length()) {
                char c = text2.charAt(offset);
                Companion this_$iv = this;
                boolean $i$f$isSpaceOrNewline = false;
                Companion this_$iv$iv = this_$iv;
                boolean $i$f$isSpace = false;
                if (c == ' ' || c == '\t' || c == '\n' || c <= '\u001b') break;
                if (c == '(') {
                    if (hasParens) break;
                    hasParens = true;
                } else if (c == ')') {
                    if (!hasParens) break;
                    hasParens = false;
                } else if (c == '\\' && offset + 1 < text2.length()) {
                    this_$iv = this;
                    char c$iv = text2.charAt(offset + 1);
                    boolean $i$f$isSpaceOrNewline2 = false;
                    Companion this_$iv$iv2 = this_$iv;
                    boolean $i$f$isSpace2 = false;
                    if (!(c$iv == ' ' || c$iv == '\t' || c$iv == '\n')) {
                        ++offset;
                    }
                }
                ++offset;
            }
            if (start == offset) {
                return null;
            }
            return new IntRange(start, offset - 1);
        }

        @Nullable
        public final IntRange matchLinkTitle(@NotNull CharSequence text2, int start) {
            char c;
            Intrinsics.checkNotNullParameter(text2, "text");
            if (start >= text2.length()) {
                return null;
            }
            char c2 = text2.charAt(start);
            if (c2 == '\'') {
                c = '\'';
            } else if (c2 == '\"') {
                c = '\"';
            } else if (c2 == '(') {
                c = ')';
            } else {
                return null;
            }
            char endDelim = c;
            boolean isBlank = false;
            for (int offset = start + 1; offset < text2.length(); ++offset) {
                Companion this_$iv;
                char c3 = text2.charAt(offset);
                if (c3 == endDelim) {
                    return new IntRange(start, offset);
                }
                if (c3 == '\n') {
                    if (isBlank) {
                        return null;
                    }
                    isBlank = true;
                } else {
                    this_$iv = this;
                    boolean $i$f$isSpace = false;
                    if (!(c3 == ' ' || c3 == '\t')) {
                        isBlank = false;
                    }
                }
                if (c3 != '\\' || offset + 1 >= text2.length()) continue;
                this_$iv = this;
                char c$iv = text2.charAt(offset + 1);
                boolean $i$f$isSpaceOrNewline = false;
                Companion this_$iv$iv = this_$iv;
                boolean $i$f$isSpace = false;
                if (c$iv == ' ' || c$iv == '\t' || c$iv == '\n') continue;
                ++offset;
            }
            return null;
        }

        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text2, int start) {
            Intrinsics.checkNotNullParameter(text2, "text");
            int offset = start;
            if (offset >= text2.length() || text2.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            for (int i = 1; i < 1000; ++i) {
                if (offset >= text2.length()) {
                    return null;
                }
                char c = text2.charAt(offset);
                if (c == '[' || c == ']') break;
                if (c == '\\') {
                    if (++offset >= text2.length()) {
                        return null;
                    }
                    c = text2.charAt(offset);
                }
                if (!CharsKt.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                ++offset;
            }
            if (!seenNonWhitespace || offset >= text2.length() || text2.charAt(offset) != ']') {
                return null;
            }
            return new IntRange(start, offset);
        }

        private final int passOneNewline(CharSequence text2, int start) {
            boolean $i$f$isSpace;
            char c$iv;
            int offset;
            for (offset = start; offset < text2.length(); ++offset) {
                Companion companion = this;
                c$iv = text2.charAt(offset);
                $i$f$isSpace = false;
                if (!(c$iv == ' ' || c$iv == '\t')) break;
            }
            if (offset < text2.length() && text2.charAt(offset) == '\n') {
                ++offset;
                while (offset < text2.length()) {
                    Companion this_$iv = this;
                    c$iv = text2.charAt(offset);
                    $i$f$isSpace = false;
                    if (!(c$iv == ' ' || c$iv == '\t')) break;
                    ++offset;
                }
            }
            return offset;
        }

        private final boolean isSpace(char c) {
            boolean $i$f$isSpace = false;
            return c == ' ' || c == '\t';
        }

        private final boolean isSpaceOrNewline(char c) {
            boolean $i$f$isSpaceOrNewline = false;
            Companion this_$iv = this;
            boolean $i$f$isSpace = false;
            return c == ' ' || c == '\t' || c == '\n';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

