/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.util.Vector;
import nts.base.Dimen;
import nts.node.BreakingCntx;
import nts.node.NetDimen;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;

public class VertSplit
extends NodeList {
    protected static final int INF_BAD = 10000;
    protected static final int DEPLORABLE = 100000;
    protected static final int AWFUL_BAD = 0x3FFFFFFF;
    public Dimen goal;
    protected Dimen maxDepth;
    public NetDimen soFar;
    public Dimen depth;
    private int currIndex;
    private int bestIndex;
    private int leastCost;

    public void setNullSpecs() {
        this.goal = Dimen.MAX_VALUE;
        this.maxDepth = Dimen.ZERO;
        this.soFar = new NetDimen();
        this.depth = Dimen.ZERO;
    }

    private void restart() {
        this.currIndex = 0;
        this.bestIndex = 0;
        this.leastCost = 0x3FFFFFFF;
    }

    public boolean allConsumed() {
        return this.currIndex >= this.length();
    }

    protected NodeEnum currPageList() {
        return this.nodes(0, this.currIndex);
    }

    protected NodeEnum contribList() {
        return this.nodes(this.currIndex);
    }

    protected boolean findBreak() {
        BreakingContext brkContext = new BreakingContext();
        while (this.currIndex < this.length()) {
            Node node = this.nodeAt(this.currIndex);
            this.passWhileBreaking(node);
            boolean tryThisBreak = true;
            if (node.isKernBreak()) {
                if (this.currIndex + 1 < this.length()) {
                    tryThisBreak = this.nodeAt(this.currIndex + 1).canFollowKernBreak();
                } else {
                    if (this.waitingForMore()) {
                        return false;
                    }
                    tryThisBreak = false;
                }
            }
            if (tryThisBreak) {
                brkContext.atSkip = this.currIndex > 0 && this.nodeAt(this.currIndex - 1).canPrecedeSkipBreak();
                int pen = node.breakPenalty(brkContext);
                if (this.tryBreak(pen)) {
                    return true;
                }
            }
            if (!node.sizeIgnored()) {
                this.soFar.add(this.depth);
                this.soFar.add(node.getHeight());
                this.soFar.addShrink(node.getHshr());
                this.soFar.addStretch(node.getHstrOrd(), node.getHstr());
                this.depth = node.getDepth();
            }
            this.adjustDepth();
            ++this.currIndex;
        }
        return false;
    }

    protected void passWhileBreaking(Node node) {
    }

    protected boolean waitingForMore() {
        return false;
    }

    protected void adjustDepth() {
        if (this.depth.moreThan(this.maxDepth)) {
            this.soFar.add(this.depth);
            this.depth = this.maxDepth;
            this.soFar.sub(this.depth);
        }
    }

    protected boolean tryBreak(int pen) {
        if (pen < 10000) {
            int cost;
            int badness;
            Dimen diff = this.goal.minus(this.soFar.getNatural());
            if (diff.moreThan(0)) {
                int n = this.soFar.getMaxStrOrder() > 0 ? 0 : diff.badness(this.soFar.getStretch((byte)0));
            } else {
                badness = (diff = diff.negative()).moreThan(this.soFar.getShrink()) ? 0x3FFFFFFF : diff.badness(this.soFar.getShrink());
            }
            int extra = this.extraPenalty();
            int n = badness < 0x3FFFFFFF ? (pen <= -10000 ? pen : (badness < 10000 ? badness + pen + extra : 100000)) : (cost = badness);
            if (extra >= 10000) {
                cost = 0x3FFFFFFF;
            }
            if (cost <= this.leastCost) {
                this.bestIndex = this.currIndex;
                this.leastCost = cost;
                this.markBestPlace();
                this.traceCost(pen, badness, cost, true);
            } else {
                this.traceCost(pen, badness, cost, false);
            }
            return cost == 0x3FFFFFFF || pen <= -10000;
        }
        return false;
    }

    protected int extraPenalty() {
        return 0;
    }

    protected void markBestPlace() {
    }

    protected void traceCost(int pen, int bad, int cost, boolean best) {
    }

    public Node breakNode() {
        return this.bestIndex < this.length() ? this.nodeAt(this.bestIndex) : null;
    }

    public NodeList makeSplitting(Dimen height, Dimen depth) {
        this.goal = height;
        this.maxDepth = depth;
        if (!this.findBreak()) {
            this.tryBreak(-10000);
        }
        return this.split();
    }

    protected NodeList split() {
        NodeList list = new NodeList(new Vector(this.data.subList(0, this.bestIndex)));
        this.data = new Vector(this.data.subList(this.bestIndex, this.length()));
        this.restart();
        return list;
    }

    public boolean pruneTop() {
        while (this.currIndex < this.length()) {
            Node node = this.nodeAt(this.currIndex);
            this.passWhilePrunning(node);
            if (node.discardable()) {
                this.data.remove(this.currIndex);
                continue;
            }
            if (node.sizeIgnored()) {
                ++this.currIndex;
                continue;
            }
            Node adj = this.topAdjustment(this.nodeAt(this.currIndex).getHeight());
            if (adj != null) {
                this.data.add(this.currIndex, adj);
            }
            return true;
        }
        return false;
    }

    protected void passWhilePrunning(Node node) {
    }

    protected Node topAdjustment(Dimen height) {
        return null;
    }

    private final void block$() {
        this.setNullSpecs();
        this.restart();
    }

    public VertSplit() {
        this.block$();
    }

    public VertSplit(int initCap) {
        super(initCap);
        this.block$();
    }

    public VertSplit(int initCap, int capIncrement) {
        super(initCap, capIncrement);
        this.block$();
    }

    public VertSplit(NodeEnum nodes) {
        super(nodes);
        this.block$();
    }

    public VertSplit(Node[] nodes) {
        super(nodes);
        this.block$();
    }

    public VertSplit(Node[] nodes, int offset, int count) {
        super(nodes, offset, count);
        this.block$();
    }

    protected static class BreakingContext
    implements BreakingCntx {
        public boolean atSkip = true;

        public boolean spaceBreaking() {
            return true;
        }

        public boolean allowedAtSkip() {
            return this.atSkip;
        }

        public int hyphenPenalty() {
            return 0;
        }

        public int exHyphenPenalty() {
            return 0;
        }

        BreakingContext() {
        }
    }
}

