unit VFString;
{$I option.pas}
interface
uses Dos, VFDcl;

Function  ConvByte      (bb  : byte)    : string;
Function  ConvInt       (bb  : longint) : string;
Function  ConvReal      (flo : float)   : string;

Function  ConvDecByte   (bb  : byte)    : string;
Function  ConvBitByte   (bb  : byte)    : string;
Function  ConvOctByte   (bb  : byte)    : string;
Function  ConvHexByte   (bb  : byte)    : string;
Function  ConvChar      (ich : byte)    : string;
Function  ConvDecLongInt(int : longint) : string;
Function  ConvBitLongInt(int : longint) : string;
Function  ConvOctLongInt(int : longint) : string;
Function  ConvHexLongInt(int : longint) : string;
Function  ConvRealTrue  (x   : float)   : string;

Function  UpCaseString(s : string) : string;
Function  DelSpaces(s : string) : string;
Procedure FileSplit(Path  : String;
                  var Dir : DirStr;
                  var Nam : NameStr;
                  var Ext : ExtStr);
Function  PathConcat(spath : string; sfile : string) : string;

Procedure ErrorLog(s : string);

Procedure CloseLogFile;

Function  GetFragmString(var s : string) : string;

implementation


Function  DelSpaces(s : string) : string;
var i1, i2, ii : integer;
begin
     ii:=ord(s[0]);
     if ii = 0 then DelSpaces:=''
     else begin
          i1:=1;  while (i1 <= ii) and (s[i1] = ' ') do i1:=i1+1;
          i2:=ii; while (i2 >= 1 ) and (s[i2] = ' ') do i2:=i2-1;
          if (i1 > i2) then DelSpaces:=''
          else begin
               ii:=i2-i1+1;
               DelSpaces:=copy(s,i1,i2-i1+1);
          end;
     end;
end; {DelSpaces}


Function  UpCaseString(s : string) : string;
var i, ii : integer;
    ss : string;
begin
     ss:=s;
     ii:=ord(ss[0]);
     for i:=1 to ii do ss[i]:=UpCase(ss[i]);
     UpCaseString:=ss;
end; {UpCaseString}

function GetFragmString(var s : string) : string;
var i1, i2, ii : integer;
    sh : string;
begin

    ii:=ord(s[0]);

    i1:=1;
    while (i1 <= ii) and (s[i1] = ' ') do i1:=i1+1;
    if i1 > ii then
    begin
         GetFragmString:=''; s:=''; exit;
    end;

    i2:=i1;
    while (i2 <= ii) and (s[i2] <> ' ') do i2:=i2+1;

    sh:=copy(s,i1,i2-i1);

    while (i2 <= ii) and (s[i2] = ' ') do i2:=i2+1;
    if i2 <= ii then delete(s,1,i2-1)
                else s:='';

    GetFragmString:=sh;

end; {GetFragmString}




Procedure FileSplit(Path  : String;
                  var Dir : DirStr;
                  var Nam : NameStr;
                  var Ext : ExtStr);
var sDir, sFil, sNam, sExt : string;
    ii, jj, kk : integer;
begin
     if Path = '' then
     begin
          Dir:=''; Nam:=''; Ext:='';
          exit;
     end;

     kk:=ord(Path[0]);

     ii:=kk;
     while (ii > 0) and (not (Path[ii] in [':','\'])) do ii:=ii-1;

     if ii = 0 then
     begin
          sDir:=''; sFil:=Path;
     end
     else
     if ii = kk then
     begin
          sDir:=Path; sFil:='';
     end
     else begin
          sDir:=copy(Path,1,ii); sFil:=copy(Path,ii+1,kk-ii);
     end;

     sFil:=DelSpaces(SFil);
     if (sFil = '.') or (sFil = '..') then
     begin
          sDir:=sDir+sFil; sFil:='';
     end;

     kk:=ord(sFil[0]); jj:=kk;
     while (jj > 0) and (sFil[jj] <> '.') do jj:=jj-1;
     if jj = 0 then
     begin
          sNam:=sFil; sExt:='';
     end
     else begin
          sNam:=copy(sFil,1,jj-1);
          sExt:=copy(sFil,jj,kk-jj+1);
     end;

     Dir:=sDir; Nam:=sNam; Ext:=sExt;

end; {FileSplit}

Function PathConcat(spath : string; sfile : string) : string;
var Dir  : DirStr;
    Nam  : NameStr;
    Ext  : ExtStr;
    sres : string;
var kk   : integer;
begin
     if spath = '' then sres := sfile
     else begin
          FileSplit(sfile,Dir,Nam,Ext);
          if Dir = '' then
          begin
               FileSplit(spath,Dir,Nam,Ext);
               if (Nam <> '') or (Ext <> '')
                   then sres := spath+'\'+sfile
                   else sres := spath+sfile;
          end
          else sres := sfile;
     end;
     PathConcat:=sres;
end; {PathConcat}

function ConvByte(bb : byte) : string;
var s : string;
begin
     str(bb,s);
     ConvByte:=s;
end; {ConvByte}

function ConvInt(bb : longint) : string;
var s : string;
begin
     str(bb,s);
     ConvInt:=s;
end; {ConvInt}

function ConvDecByte(bb : byte) : string;
var s : string;
begin
     s:='';
     s:=Digit[bb mod 10]+s; bb:=bb div 10;
     s:=Digit[bb mod 10]+s; bb:=bb div 10;
     s:=Digit[bb mod 10]+s; bb:=bb div 10;
     ConvDecByte:=s;
end; {ConvDecByte}

function ConvBitByte(bb : byte) : string;
var s : string;
begin
     s:='';
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     s:=Digit[bb mod 2]+s; bb:=bb div 2;
     ConvBitByte:=s;
end; {ConvBitByte}

function ConvOctByte(bb : byte) : string;
var s : string;
begin
     s:='';
     s:=Digit[bb mod 8]+s; bb:=bb div 8;
     s:=Digit[bb mod 8]+s; bb:=bb div 8;
     s:=Digit[bb mod 8]+s; bb:=bb div 8;
     ConvOctByte:=s;
end; {ConvOctByte}

function ConvHexByte(bb : byte) : string;
var s : string;
begin
     s:=Digit[bb div 16]+Digit[bb mod 16];
     ConvHexByte:=s;
end; {ConvHexByte}

function ConvCharByte(ich : byte) : string;
var s : string;
begin
     case FlOutByte of
     0 : s:='D '+ConvDecByte(ich);
     1 : s:='O '+ConvOctByte(ich);
     2 : s:='H '+ConvHexByte(ich);
     else s:='D '+ConvByte(ich);
     end; {case}
     ConvCharByte:=s;
end; {ConvCharByte}

function ConvChar(ich : byte) : string;
var s : string;
begin
     case FlOutChar of
     0 : if ich in [33..39,42..126] then s:='C '+char(ich)
                                    else s:=ConvCharByte(ich);
     1 : if ich in [65..90,97..122] then s:='C '+char(ich)
                                    else s:=ConvCharByte(ich);
     2 : if ich in [48..57,65..90,97..122] then s:='C '+char(ich)
                                    else s:=ConvCharByte(ich);
     else s:=ConvCharByte(ich);
     end; {case}
     ConvChar:=s;
end; {ConvChar}

function ConvDecLongInt(int : longint) : string;
var s : string;
    iw : lword;
    i  : longword;
begin
     s:=''; iw.iint:=int;
     i.jwordlo:=iw.iwordlo;
     i.jwordhi:=iw.iwordhi;

     while (i.jwordlo <> 0) or (i.jwordhi <> 0) do
     begin
        i.jwordlo:=MaxWord*(i.jwordhi mod 10) + i.jwordlo;
        i.jwordhi:=i.jwordhi div 10;
        s:=Digit[i.jwordlo mod 10]+s; i.jwordlo:=i.jwordlo div 10;
     end;
     if s = '' then s:='0';
     ConvDecLongInt:=s;
end; {ConvDecLongInt}

function ConvOctLongInt(int : longint) : string;
var s : string;
    iw : lword;
    i  : longword;
begin
     s:=''; iw.iint:=int;
     i.jwordlo:=iw.iwordlo;
     i.jwordhi:=iw.iwordhi;

     while (i.jwordlo <> 0) or (i.jwordhi <> 0) do
     begin
        i.jwordlo:=MaxWord*(i.jwordhi mod 8) + i.jwordlo;
        i.jwordhi:=i.jwordhi div 8;
        s:=Digit[i.jwordlo mod 8]+s; i.jwordlo:=i.jwordlo div 8;
     end;
     if s = '' then s:='0';
     ConvOctLongInt:=s;
end; {ConvOctLongInt}

function ConvBitLongInt(int : longint) : string;
var s : string;
    iw : lword;
    i  : longword;
begin
     s:=''; iw.iint:=int;
     i.jwordlo:=iw.iwordlo;
     i.jwordhi:=iw.iwordhi;

     while (i.jwordlo <> 0) or (i.jwordhi <> 0) do
     begin
        i.jwordlo:=MaxWord*(i.jwordhi mod 2) + i.jwordlo;
        i.jwordhi:=i.jwordhi div 2;
        s:=Digit[i.jwordlo mod 2]+s; i.jwordlo:=i.jwordlo div 2;
     end;
     if s = '' then s:='0';
     ConvBitLongInt:=s;
end; {ConvBitLongInt}

function ConvHexLongInt(int : longint) : string;
var s : string;
    iw : lword;
    i  : longword;
begin
     s:=''; iw.iint:=int;
     i.jwordlo:=iw.iwordlo;
     i.jwordhi:=iw.iwordhi;

     while (i.jwordlo <> 0) or (i.jwordhi <> 0) do
     begin
        i.jwordlo:=MaxWord*(i.jwordhi mod 16) + i.jwordlo;
        i.jwordhi:=i.jwordhi div 16;
        s:=Digit[i.jwordlo mod 16]+s; i.jwordlo:=i.jwordlo div 16;
     end;
     if s = '' then s:='0';
     ConvHexLongInt:=s;
end; {ConvHexLongInt}


function ConvReal(flo : float) : string;
var s : string;
begin
     str(flo,s);
     ConvReal:=s;
end; {ConvReal}

Function ConvRealTrue(x : float) : string;
var lgt, lgt2 : integer;
    flag : boolean;
var flneg : boolean;
    kk, k, KE, KL, N : integer;
    s, ss, sk : string;
begin
     lgt:=20; lgt2:=8; flag:=false;

     if lgt2 < 2 then lgt2:=2;
     if lgt < lgt2+2 then lgt:=lgt2+2;

     if x < 0.0 then begin x:=-x; flneg:=true; end else flneg:=false;

     str(x:lgt2+8,s);
     KE:=pos('E',S); KL:=ord(s[0]);
     val(copy(s,KE+1,KL-KE),N,k);

     ss:=s[2]+copy(s,4,KE-4);
     KL:=ord(ss[0]); if KL > lgt2+1 then KL:=lgt2+1;
     for k:=KL+1 to lgt do ss[k]:='0'; ss[0]:=chr(lgt);
     kk:=KL; while (kk > 0) and (ss[kk]='0') do kk:=kk-1;

     KL:=ord(ss[0]);

     if N >= 0 then
     begin
          if N < lgt-3 then
          begin
              if flag then s:=' '+copy(ss,1,N+1)+'.'+copy(ss,N+2,lgt-N-3)
                      else if kk <= N+1 then s:=' '+copy(ss,1,N+1)
                           else s:=' '+copy(ss,1,N+1)+'.'+copy(ss,N+2,kk-N-1);
          end
          else
          if N <= lgt-2  then s:=' '+copy(ss,1,N+1)
          else
          begin
               str(N,sk); k:=lgt-ord(sk[0])-4; if k < lgt2 then k:=lgt2;
               if flag then s:=' '+ss[1]+'.'+copy(ss,2,k-1)+'E+'+sk
                       else s:=' '+ss[1]+'.'+copy(ss,2,kk-1)+'E+'+sk;
          end;
     end
     else begin
          N:=-N;
          if 2+lgt2+N <= lgt then
          begin
               for k:=1 to N-1 do sk[k]:='0'; sk[0]:=chr(N-1);
               KE:=lgt-2-N; if KE < lgt2 then KE:=lgt2;
               if flag then s:=' 0.'+sk+copy(ss,1,KE)
                       else s:=' 0.'+sk+copy(ss,1,kk);
          end
          else
          begin
               str(N,sk); k:=lgt-ord(sk[0])-4; if k < lgt2 then k:=lgt2;
               if flag then s:=' '+ss[1]+'.'+copy(ss,2,k-1)+'E-'+sk
                       else s:=' '+ss[1]+'.'+copy(ss,2,kk-1)+'E-'+sk;
          end;
     end;

     if flneg then s[1]:='-';
     if pos('.',s) = 0 then s:=s+'.0';
     ConvRealTrue:=DelSpaces(s);

end; {ConvRealTrue}


procedure ErrorLog(s : string);
var SDir : DirStr;
    SNam : NameStr;
    SExt : ExtStr;
    ss : string;
begin
  if FlagLogScr then writeln(s);
  if FlagLogOut then
  begin
     if not FlagLog then
     begin
          FileSplit(TableNameGlb,sDir,sNam,sExt);
          if (sDir = '') or (sDir = ' ') then sDir:=OutputDirFile;
          if (sNam = '') or (sNam = ' ') then sNam:='NONAME';
          ss:=PathConcat(sDir,sNam+'.LOG');
          writeln('LOG file is '+ss);
          assign(fnLog,ss);
          rewrite(fnLog);
          FlagLog:=true;
     end;
     writeln(fnLog,s);
  end;
end; {ErrorLog}

procedure CloseLogFile;
begin
  if FlagLog then close(fnlog);
end; {CloseLog}


end.