/*
WMHANDLR.H
Event (WM_ message) handlers - interface
Dave Maxey and Andrew Schulman - 1991

wmhandler_init MUST be called before a window is opened.

wmhandler_get returns current handler for an event.

wmhandler_set also returns current handler, and then makes
supplied handler current for the message type.
*/

#ifdef __cplusplus
extern "C" {
#endif
typedef long (*WMHANDLER)(HWND, UINT, WPARAM, LPARAM);

long FAR PASCAL _export WndProc(HWND, UINT, WPARAM, LPARAM);
void wmhandler_init(void);
WMHANDLER wmhandler_get(UINT);
WMHANDLER wmhandler_set(UINT, WMHANDLER);
#ifdef __cplusplus
}
#endif

