/* vputs.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/video.h>
#include "video2.h"

static void _v_puts1 (const char *p, int len)
{
  int max, cnt;

  while (len > 0)
    {
      max = _v_width - _v_x;
      if (len < max)
        cnt = len;
      else
        cnt = max;
      if (cnt > 0)
        {
          v_putm (p, cnt);
          if (cnt == max)
            {
              _v_x = 0;
              ++_v_y;
              if (_v_y >= _v_height)
                {
                  --_v_y;
                  v_scrollup ();
                }
            }
          else
            _v_x += cnt;
          v_gotoxy (_v_x, _v_y);
        }
      len -= cnt;
      p += cnt;
    }
}


void _v_puts_len (const char *p, int len)
{
  const char *q;
  int n;

  do
    {
      q = memchr (p, '\n', (size_t)len);
      if (q == NULL)
        _v_puts1 (p, len);
      else
        {
          n = q - p;
          _v_puts1 (p, n);
          v_putc ('\n');
          p = q + 1;
          len -= n + 1;
        }
    } while (q != NULL);
}


void v_puts (const char *p)
{
  _v_puts_len (p, (int)strlen (p));
}
