/* echo.c
 * v0.91
 * 
 * Holger Danielsson
 * (dani@lara.prima.ruhr.de)
 * 6.9.1996
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "execute.h"


/* Status fr den Echomodus */
int echomode = 0;

/* ECHO ausfhren:
 * Die Variable 'onoff' bestimmt, ob auf das Einschalten/Ausschalten 
 * des Echomodus geachtet werden soll ('ECHO'- und '@ECHO'-Befehl). 
 * Wird einer der Parameter ON/OFF erkannt, wird der Echomodus
 * entsprechend eingestellt und alle weiteren Parameter ignoriert.
 * Beim 'ECHO.'-Befehl werden die Parameter ON bzw. OFF ignoriert
 * und alle Parameter als Text ausgegeben. 
 *
 * Syntax: echo on
 *         echo off
 *         echo text text ...
 * argv[]:       0     1   2
 *
 */
int execute_echo(char *argv[], int onoff)
{
   if ( argv[0] && onoff ) {
      if ( !stricmp(argv[0],"off") ) {
         echomode = 0;
         return 0;
      }
      if ( !stricmp(argv[0],"on") ) {
         echomode = 1;
         return 0;
      }
   }
   
   write_command(&argv[0]);
   return 0;
}




