/* sbrk.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

void * __sbrk(int bytes)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    void * retv;

    if (bytes == 0)
        retv = p->heap_brk;
    else {
        EnterCriticalSection(&(p->CritSectHeap));

        if (bytes > 0)
            retv = _rsxnt_grow_heap(p, bytes);
        else
            retv = _rsxnt_shrink_heap(p, -bytes);

        LeaveCriticalSection(&(p->CritSectHeap));
    }
    return retv;
}
