#ifndef _service_h
#define _service_h

#define SERVICE_USER_CONTROL      128
#define SERVICE_USER_CONTROL_LAST 255

class CService
{
  private:
    BOOL                  bDebug;
    LPTSTR                lpServiceName;
    LPTSTR                lpServiceDisplayName;
    DWORD                 dwControlsAccepted;
    SERVICE_STATUS        ssStatus;
    SERVICE_STATUS_HANDLE sshStatusHandle;
    
    static VOID WINAPI    service_ctrl   (DWORD);
    static VOID WINAPI    service_main   (DWORD, LPTSTR *);
    void                  ServiceControl (DWORD);
    void                  ServiceMain    (DWORD, LPTSTR *);

  public:
    CService ();

    // interface to application
    virtual BOOL  ServiceStart (DWORD, LPTSTR *) = 0;
    virtual DWORD ServiceStop () = 0;
    virtual BOOL  ServicePause ();
    virtual BOOL  ServiceContinue ();
    virtual BOOL  ServiceKill ();
    virtual DWORD ServiceUserControl (DWORD);

    void  Init (LPTSTR, LPTSTR, DWORD);
    void  Run (int, char **);
    void  SetStatusPending (DWORD);
    DWORD ReportServiceEvent  (WORD, DWORD, DWORD, PVOID, DWORD, ...);

    void  LogError(int id)   { ReportServiceEvent (EVENTLOG_ERROR_TYPE, (id), 0, NULL, 0);};
    void  LogInfo(int id)    { ReportServiceEvent (EVENTLOG_INFORMATION_TYPE, (id), 0, NULL, 0);};
    void  LogWarning(int id) { ReportServiceEvent (EVENTLOG_WARNING_TYPE, (id), 0, NULL, 0);};

    void  CmdInstallService (void);
    void  CmdRemoveService (void);
};
#endif

