/***************************************************************************\
*                                                                           *
*   WINGDI.H                                                                *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINGDI_H)
#define _WINGDI_H

#ifdef __cplusplus
extern "C" {
#endif

#define DRIVERVERSION	0
#define TECHNOLOGY		2
#define HORZSIZE		4
#define VERTSIZE		6
#define HORZRES       8
#define VERTRES       10
#define BITSPIXEL     12
#define PLANES        14
#define NUMBRUSHES		16
#define NUMPENS		18
#define NUMMARKERS    20
#define NUMFONTS      22
#define NUMCOLORS     24
#define PDEVICESIZE   26
#define CURVECAPS     28
#define LINECAPS      30
#define POLYGONALCAPS 32
#define TEXTCAPS      34
#define CLIPCAPS      36
#define RASTERCAPS    38
#define ASPECTX       40
#define ASPECTY       42
#define ASPECTXY      44
#define LOGPIXELSX    88
#define LOGPIXELSY    90
#define SIZEPALETTE  104
#define NUMRESERVED  106
#define COLORRES     108
#define PHYSICALWIDTH   110
#define PHYSICALHEIGHT  111
#define PHYSICALOFFSETX 112
#define PHYSICALOFFSETY 113
#define SCALINGFACTORX  114
#define SCALINGFACTORY  115
#define VREFRESH        116
#define DESKTOPVERTRES  117
#define DESKTOPHORZRES  118
#define BLTALIGNMENT    119

int WINAPI GetDeviceCaps(HDC, int);

#define HORZRES       8     
#define VERTRES       10    

#define CLIP_DEFAULT_PRECIS     0
#define CLIP_CHARACTER_PRECIS   1
#define CLIP_STROKE_PRECIS      2
#define CLIP_MASK               0xf
#define CLIP_LH_ANGLES          (1<<4)
#define CLIP_TT_ALWAYS          (2<<4)
#define CLIP_EMBEDDED           (8<<4)

#define DEFAULT_QUALITY         0
#define DRAFT_QUALITY           1
#define PROOF_QUALITY           2

#define DEFAULT_PITCH 0
#define FIXED_PITCH 1
#define VARIABLE_PITCH 2
#define ANSI_CHARSET            0
#define DEFAULT_CHARSET         1
#define SYMBOL_CHARSET          2
#define SHIFTJIS_CHARSET        128
#define HANGEUL_CHARSET         129
#define CHINESEBIG5_CHARSET     136

#define OEM_CHARSET             255
#define OUT_DEFAULT_PRECIS      0
#define OUT_STRING_PRECIS       1
#define OUT_CHARACTER_PRECIS    2
#define OUT_STROKE_PRECIS       3
#define OUT_TT_PRECIS           4
#define OUT_DEVICE_PRECIS       5
#define OUT_RASTER_PRECIS       6
#define OUT_TT_ONLY_PRECIS      7
#define OUT_OUTLINE_PRECIS      8

#define TMPF_FIXED_PITCH    0x01
#define TMPF_VECTOR             0x02
#define TMPF_DEVICE             0x08
#define TMPF_TRUETYPE       0x04

typedef struct 
{
    LONG        tmHeight;
    LONG        tmAscent;
    LONG        tmDescent;
    LONG        tmInternalLeading;
    LONG        tmExternalLeading;
    LONG        tmAveCharWidth;
    LONG        tmMaxCharWidth;
    LONG        tmWeight;
    LONG        tmOverhang;
    LONG        tmDigitizedAspectX;
    LONG        tmDigitizedAspectY;
    TCHAR      tmFirstChar;
    TCHAR      tmLastChar;
    TCHAR      tmDefaultChar;
    TCHAR      tmBreakChar;
    BYTE         tmItalic;
    BYTE         tmUnderlined;
    BYTE         tmStruckOut;
    BYTE         tmPitchAndFamily;
    BYTE         tmCharSet;
} TEXTMETRIC, *PTEXTMETRIC, *LPTEXTMETRIC;

#define GetTextMetrics TFUNCT(GetTextMetrics)
BOOL WINAPI GetTextMetrics(HDC, LPTEXTMETRIC);

typedef struct
{
    LONG        tmHeight;
    LONG        tmAscent;
    LONG        tmDescent;
    LONG        tmInternalLeading;
    LONG        tmExternalLeading;
    LONG        tmAveCharWidth;
    LONG        tmMaxCharWidth;
    LONG        tmWeight;
    LONG        tmOverhang;
    LONG        tmDigitizedAspectX;
    LONG        tmDigitizedAspectY;
    TCHAR        tmFirstChar;
    TCHAR     tmLastChar;
    TCHAR     tmDefaultChar;
    TCHAR     tmBreakChar;
    BYTE        tmItalic;
    BYTE        tmUnderlined;
    BYTE        tmStruckOut;
    BYTE        tmPitchAndFamily;
    BYTE        tmCharSet;
    DWORD   ntmFlags;
    UINT    ntmSizeEM;
    UINT    ntmCellHeight;
    UINT    ntmAvgWidth;
} NEWTEXTMETRIC, *PNEWTEXTMETRIC, *LPNEWTEXTMETRIC;

#define FF_DONTCARE    0
#define FF_ROMAN           (1<<4)
#define FF_SWISS              (2<<4)
#define FF_MODERN        (3<<4)
#define FF_SCRIPT            (4<<4)
#define FF_DECORATIVE (5<<4)

#define FW_DONTCARE         0
#define FW_THIN             100
#define FW_EXTRALIGHT       200
#define FW_LIGHT            300
#define FW_NORMAL           400
#define FW_MEDIUM           500
#define FW_SEMIBOLD         600
#define FW_BOLD             700
#define FW_EXTRABOLD        800
#define FW_HEAVY            900
#define FW_ULTRALIGHT       FW_EXTRALIGHT
#define FW_REGULAR          FW_NORMAL
#define FW_DEMIBOLD         FW_SEMIBOLD
#define FW_ULTRABOLD        FW_EXTRABOLD
#define FW_BLACK            FW_HEAVY

#define CreateFont TFUNCT(CreateFont)
 HFONT WINAPI CreateFont(int, int, int, int, int, long, long, long, long, long, long,
  long, long, LPCTSTR lpName);

#define RASTER_FONTTYPE     0x0001
#define DEVICE_FONTTYPE     0x002
#define TRUETYPE_FONTTYPE   0x004

#define LF_FULLFACESIZE     64
#define LF_FACESIZE         32

#define LOGFONT TSTRUCT(LOGFONT)
#define PLOGFONT TSTRUCT(PLOGFONT)
#define LPLOGFONT TSTRUCT(LPLOGFONT)
typedef struct 
{
    LONG      lfHeight;
    LONG      lfWidth;
    LONG      lfEscapement;
    LONG      lfOrientation;
    LONG      lfWeight;
    BYTE      lfItalic;
    BYTE      lfUnderline;
    BYTE      lfStrikeOut;
    BYTE      lfCharSet;
    BYTE      lfOutPrecision;
    BYTE      lfClipPrecision;
    BYTE      lfQuality;
    BYTE      lfPitchAndFamily;
    TCHAR      lfFaceName[LF_FACESIZE];
} LOGFONT, *PLOGFONT, *LPLOGFONT;

#define CreateFontIndirect TFUNCT(CreateFontIndirect)
HFONT  WINAPI CreateFontIndirect(CONST LOGFONT *);
#define CreateScalableFontResource TFUNCT(CreateScalableFontResource)
BOOL WINAPI CreateScalableFontResource(DWORD, LPCTSTR, LPCTSTR, LPCTSTR);
#define GetTextFace TFUNCT(GetTextFace)
int WINAPI GetTextFace(HDC, int, LPTSTR);
int   WINAPI GetTextCharacterExtra(HDC);
UINT  WINAPI GetTextAlign(HDC);
COLORREF WINAPI GetTextColor(HDC);
#define GetTextExtentPoint TFUNCT(GetTextExtentPoint)
BOOL WINAPI GetTextExtentPoint(HDC, LPCTSTR, int, LPSIZE);
int WINAPI SetTextCharacterExtra(HDC, int);
COLORREF WINAPI SetTextColor(HDC, COLORREF);
BOOL WINAPI SetTextJustification(HDC, int, int);

#define GetCharWidth TFUNCT(GetCharWidth)
BOOL WINAPI GetCharWidth(HDC, UINT, UINT, LPINT);

#define TA_NOUPDATECP                0
#define TA_UPDATECP                  1
#define TA_LEFT                      0
#define TA_RIGHT                     2
#define TA_CENTER                    6
#define TA_TOP                       0
#define TA_BOTTOM                    8
#define TA_BASELINE                  24
#define TA_RTLREADING                256
#define TA_MASK       (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING)

#define VTA_BASELINE TA_BASELINE
#define VTA_LEFT     TA_BOTTOM
#define VTA_RIGHT    TA_TOP
#define VTA_CENTER   TA_CENTER
#define VTA_BOTTOM   TA_RIGHT
#define VTA_TOP      TA_LEFT

#define ETO_OPAQUE                   0x0002
#define ETO_CLIPPED                  0x0004
#define ETO_GLYPH_INDEX              0x0010
#define ETO_RTLREADING               0x0080

#define ASPECT_FILTERING             0x0001

UINT WINAPI SetTextAlign(HDC, UINT);

#define ENUMLOGFONT TSTRUCT(ENUMLOGFONT)
#define LPENUMLOGFONT TSTRUCT(LPENUMLOGFONT)
typedef struct 
{
    LOGFONT elfLogFont;
    TCHAR elfFullName[LF_FULLFACESIZE];
    TCHAR elfStyle[LF_FACESIZE];
} ENUMLOGFONT, * LPENUMLOGFONT;

typedef int WINAPI (* OLDFONTENUMPROC)(CONST LOGFONT *, CONST TEXTMETRIC *, DWORD, LPARAM);
typedef OLDFONTENUMPROC FONTENUMPROC;

#define EnumFontFamilies TFUNCT(EnumFontFamilies)
int  WINAPI EnumFontFamilies(HDC, LPCTSTR, FONTENUMPROC, LPARAM);
#define EnumFonts TFUNCT(EnumFonts)
int  WINAPI EnumFonts(HDC, LPCTSTR,  FONTENUMPROC, LPARAM);

#define GetObject TFUNCT(GetObject)
int   WINAPI GetObject(HGDIOBJ, int, LPVOID);
BOOL WINAPI DeleteObject(HGDIOBJ hObject);
HGDIOBJ WINAPI GetStockObject(int);
HGDIOBJ WINAPI SelectObject(HDC hDc, HGDIOBJ hObject);

#define BS_SOLID		0
#define BS_NULL		1
#define BS_HOLLOW		BS_NULL
#define BS_HATCHED		2
#define BS_PATTERN      	3
#define BS_INDEXED		4
#define BS_DIBPATTERN	5
#define BS_DIBPATTERNPT	6
#define BS_PATTERN8X8	7
#define BS_DIBPATTERN8X8	8

#define HS_HORIZONTAL	0
#define HS_VERTICAL		1
#define HS_FDIAGONAL	2
#define HS_BDIAGONAL	3
#define HS_CROSS		4
#define HS_DIAGCROSS		5

typedef struct {
    UINT		lbStyle;
    COLORREF	lbColor;
    LONG	lbHatch;
  } LOGBRUSH, *PLOGBRUSH,  *LPLOGBRUSH;

typedef LOGBRUSH	PATTERN;
typedef PATTERN	*PPATTERN;
typedef PATTERN	*LPPATTERN;

#pragma pack(1)
typedef struct {
        BYTE    rgbtBlue;
        BYTE    rgbtGreen;
        BYTE    rgbtRed;
} RGBTRIPLE;
#pragma pack()

typedef struct {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
} RGBQUAD, * LPRGBQUAD;

#define RGB(r,g,b) ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))
#define GetRValue(rgb)      ((BYTE)(rgb))
#define GetGValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((BYTE)((rgb)>>16))

#define TRANSPARENT         1
#define OPAQUE              2
#define BKMODE_LAST         2

HBRUSH WINAPI CreateSolidBrush(COLORREF);
HBRUSH  WINAPI CreateBrushIndirect(CONST LOGBRUSH *);

typedef struct {
    LONG        bmType;
    LONG        bmWidth;
    LONG        bmHeight;
    LONG        bmWidthBytes;
    WORD        bmPlanes;
    WORD        bmBitsPixel;
    LPVOID      bmBits;
  } BITMAP, *PBITMAP, *LPBITMAP;

HBITMAP WINAPI CreateBitmap(int, int, UINT, UINT, CONST VOID *);
HBITMAP WINAPI CreateBitmapIndirect(CONST BITMAP *);
HBITMAP WINAPI CreateCompatibleBitmap(HDC, int, int);
HBITMAP WINAPI CreateDiscardableBitmap(HDC, int, int);

HDC WINAPI CreateCompatibleDC(HDC);
BOOL WINAPI CancelDC(HDC);
BOOL WINAPI DeleteDC(HDC);
BOOL WINAPI RestoreDC(HDC, int);
int  WINAPI SaveDC(HDC);

#define CCHDEVICENAME 32
#define CCHFORMNAME 32

typedef struct _devicemodeA {
    TCHAR   dmDeviceName[CCHDEVICENAME];
    WORD dmSpecVersion;
    WORD dmDriverVersion;
    WORD dmSize;
    WORD dmDriverExtra;
    DWORD dmFields;
    short dmOrientation;
    short dmPaperSize;
    short dmPaperLength;
    short dmPaperWidth;
    short dmScale;
    short dmCopies;
    short dmDefaultSource;
    short dmPrintQuality;
    short dmColor;
    short dmDuplex;
    short dmYResolution;
    short dmTTOption;
    short dmCollate;
    TCHAR   dmFormName[CCHFORMNAME];
    WORD   dmLogPixels;
    DWORD  dmBitsPerPel;
    DWORD  dmPelsWidth;
    DWORD  dmPelsHeight;
    DWORD  dmDisplayFlags;
    DWORD  dmDisplayFrequency;
    DWORD  dmICMMethod;
    DWORD  dmICMIntent;
    DWORD  dmMediaType;
    DWORD  dmDitherType;
    DWORD  dmReserved1;
    DWORD  dmReserved2;
} DEVMODE, *PDEVMODE, *LPDEVMODE;

#define ResetDC TFUNCT(ResetDC)
HDC WINAPI ResetDC(HDC, CONST DEVMODE *);

BOOL WINAPI Pie(HDC, int, int, int, int, int, int, int, int);
BOOL WINAPI Arc(HDC, int, int, int, int, int, int, int, int);
BOOL WINAPI Chord(HDC, int, int, int, int, int, int, int, int);
BOOL WINAPI Ellipse(HDC hDc, int a, int b, int c, int d);

#define SRCCOPY             (DWORD)0x00CC0020
#define SRCPAINT            (DWORD)0x00EE0086
#define SRCAND              (DWORD)0x008800C6
#define SRCINVERT           (DWORD)0x00660046
#define SRCERASE            (DWORD)0x00440328
#define NOTSRCCOPY          (DWORD)0x00330008
#define NOTSRCERASE         (DWORD)0x001100A6
#define MERGECOPY           (DWORD)0x00C000CA
#define MERGEPAINT          (DWORD)0x00BB0226
#define PATCOPY             (DWORD)0x00F00021
#define PATPAINT            (DWORD)0x00FB0A09
#define PATINVERT           (DWORD)0x005A0049
#define DSTINVERT           (DWORD)0x00550009
#define BLACKNESS           (DWORD)0x00000042
#define WHITENESS           (DWORD)0x00FF0062

BOOL WINAPI BitBlt(HDC, int, int, int, int, HDC, int, int, DWORD);
BOOL WINAPI MaskBlt(HDC, int, int, int, int,
              HDC, int, int, HBITMAP, int, int, DWORD);
BOOL WINAPI PlgBlt(HDC, CONST POINT *, HDC, int, int, int,
                     int, HBITMAP, int, int);
BOOL WINAPI PatBlt(HDC, int, int, int, int, DWORD);

typedef struct {
    BYTE        peRed;
    BYTE        peGreen;
    BYTE        peBlue;
    BYTE        peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;

typedef struct {
	WORD	palVersion;
	WORD	palNumEntries;
	PALETTEENTRY	palPalEntry[1];
} LOGPALETTE, *PLOGPALETTE,  *LPLOGPALETTE;

HPALETTE WINAPI CreatePalette(CONST LOGPALETTE *);
BOOL WINAPI AnimatePalette(HPALETTE, UINT, UINT, CONST PALETTEENTRY *);
UINT WINAPI GetSystemPaletteEntries(HDC, UINT, UINT, LPPALETTEENTRY);
UINT WINAPI GetSystemPaletteUse(HDC);
UINT WINAPI GetPaletteEntries(HPALETTE, UINT, UINT, LPPALETTEENTRY);
BOOL WINAPI ResizePalette(HPALETTE, UINT);
HPALETTE WINAPI SelectPalette(HDC, HPALETTE, BOOL);
UINT  WINAPI SetPaletteEntries(HPALETTE, UINT, UINT, CONST PALETTEENTRY *);
UINT  WINAPI SetSystemPaletteUse(HDC, UINT);

typedef struct {
    WORD  nSize;
    WORD  nVersion;
    DWORD dwFlags;
    BYTE  iPixelType;
    BYTE  cColorBits;
    BYTE  cRedBits;
    BYTE  cRedShift;
    BYTE  cGreenBits;
    BYTE  cGreenShift;
    BYTE  cBlueBits;
    BYTE  cBlueShift;
    BYTE  cAlphaBits;
    BYTE  cAlphaShift;
    BYTE  cAccumBits;
    BYTE  cAccumRedBits;
    BYTE  cAccumGreenBits;
    BYTE  cAccumBlueBits;
    BYTE  cAccumAlphaBits;
    BYTE  cDepthBits;
    BYTE  cStencilBits;
    BYTE  cAuxBuffers;
    BYTE  iLayerType;
    BYTE  bReserved;
    DWORD dwLayerMask;
    DWORD dwVisibleMask;
    DWORD dwDamageMask;
} PIXELFORMATDESCRIPTOR, *PPIXELFORMATDESCRIPTOR, *LPPIXELFORMATDESCRIPTOR;

#define PFD_TYPE_RGBA        0
#define PFD_TYPE_COLORINDEX  1
#define PFD_MAIN_PLANE       0
#define PFD_OVERLAY_PLANE    1
#define PFD_UNDERLAY_PLANE   (-1)
#define PFD_DOUBLEBUFFER            0x00000001
#define PFD_STEREO                  0x00000002
#define PFD_DRAW_TO_WINDOW          0x00000004
#define PFD_DRAW_TO_BITMAP          0x00000008
#define PFD_SUPPORT_GDI             0x00000010
#define PFD_SUPPORT_OPENGL          0x00000020
#define PFD_GENERIC_FORMAT          0x00000040
#define PFD_NEED_PALETTE            0x00000080
#define PFD_NEED_SYSTEM_PALETTE     0x00000100
#define PFD_SWAP_EXCHANGE           0x00000200
#define PFD_SWAP_COPY               0x00000400
#define PFD_DOUBLEBUFFER_DONTCARE   0x40000000
#define PFD_STEREO_DONTCARE         0x80000000

int WINAPI ChoosePixelFormat(HDC, CONST PIXELFORMATDESCRIPTOR *);
int WINAPI DescribePixelFormat(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
BOOL  WINAPI SetPixelFormat(HDC, int, CONST PIXELFORMATDESCRIPTOR *);

typedef int WINAPI (*GOBJENUMPROC)(LPVOID, LPARAM);
typedef VOID WINAPI (*LINEDDAPROC)(int, int, LPARAM);

BOOL WINAPI LineDDA(int, int, int, int, LINEDDAPROC, LPARAM);
BOOL WINAPI LineTo(HDC, int, int);
BOOL WINAPI MoveToEx(HDC, int, int, LPPOINT);
#define TextOut TFUNCT(TextOut)
BOOL WINAPI TextOut(HDC, int, int, LPCTSTR, int);
#define ExtTextOut TFUNCT(ExtTextOut)
BOOL WINAPI ExtTextOut(HDC, int, int, UINT, CONST RECT *,LPCTSTR, UINT, CONST INT *);

#define POLYTEXT TSTRUCT(POLYTEXT)
#define PPOLYTEXT TSTRUCT(PPOLYTEXT)
#define LPPOLYTEXT TSTRUCT(LPPOLYTEXT)
typedef struct 
{
    int       x;
    int       y;
    UINT      n;
    LPCTSTR    lpstr;
    UINT      uiFlags;
    RECT      rcl;
    int      *pdx;
} POLYTEXT, *PPOLYTEXT, *LPPOLYTEXT;

#define PolyTextOut TFUNCT(PolyTextOut)
BOOL  WINAPI PolyTextOut(HDC, CONST POLYTEXT *, int);

BOOL  WINAPI DPtoLP(HDC, LPPOINT, int);
BOOL  WINAPI LPtoDP(HDC, LPPOINT, int);

BOOL  WINAPI Polygon(HDC, CONST POINT *, int);
BOOL  WINAPI Polyline(HDC, CONST POINT *, int);
BOOL  WINAPI PolyBezier(HDC, CONST POINT *, DWORD);
BOOL  WINAPI PolyBezierTo(HDC, CONST POINT *, DWORD);
BOOL  WINAPI PolylineTo(HDC, CONST POINT *, DWORD);
BOOL WINAPI PolyPolygon(HDC, CONST POINT *, CONST INT *, int);
BOOL WINAPI PolyPolyline(HDC, CONST POINT *, CONST DWORD *, DWORD);

BOOL WINAPI AngleArc(HDC, int, int, DWORD, FLOAT, FLOAT);

HRGN WINAPI CreateRectRgn(int, int, int, int);
HRGN WINAPI CreateRectRgnIndirect(CONST RECT *);
HRGN WINAPI CreateRoundRectRgn(int, int, int, int, int, int);
HRGN WINAPI CreatePolyPolygonRgn(CONST POINT *, CONST INT *, int, int);
HRGN WINAPI CreatePolygonRgn(CONST POINT *, int, int);
int  WINAPI IntersectClipRect(HDC, int, int, int, int);
BOOL WINAPI InvertRgn(HDC, HRGN);
int WINAPI CombineRgn(HRGN, HRGN, HRGN, int);
int WINAPI OffsetClipRgn(HDC, int, int);
int WINAPI OffsetRgn(HRGN, int, int);
BOOL WINAPI PaintRgn(HDC, HRGN);
BOOL WINAPI PtInRegion(HRGN, int, int);
BOOL WINAPI PtVisible(HDC, int, int);
BOOL WINAPI RectInRegion(HRGN, CONST RECT *);
BOOL WINAPI SetRectRgn(HRGN, int, int, int, int);
int WINAPI SelectClipRgn(HDC, HRGN);
int WINAPI ExtSelectClipRgn(HDC, HRGN, int);
int WINAPI SetMetaRgn(HDC);
int WINAPI GetRgnBox(HRGN, LPRECT);
int WINAPI ExcludeClipRect(HDC, int, int, int, int);
BOOL WINAPI FillRgn(HDC, HRGN, HBRUSH);
BOOL WINAPI EqualRgn(HRGN, HRGN);

BOOL WINAPI RectVisible(HDC, CONST RECT *);
BOOL WINAPI Rectangle(HDC, int, int, int, int);
BOOL  WINAPI RoundRect(HDC, int, int, int, int, int, int);

HMETAFILE WINAPI CloseMetaFile(HDC);
#define CopyMetaFile TFUNCT(CopyMetaFile)
HMETAFILE WINAPI CopyMetaFile(HMETAFILE, LPCTSTR);
BOOL WINAPI DeleteMetaFile(HMETAFILE);
BOOL WINAPI PlayMetaFile(HDC, HMETAFILE);
HMETAFILE   WINAPI SetMetaFileBitsEx(UINT, CONST BYTE *);

typedef struct {
        DWORD   bcSize;
        WORD    bcWidth;
        WORD    bcHeight;
        WORD    bcPlanes;
        WORD    bcBitCount;
} BITMAPCOREHEADER, *PBITMAPCOREHEADER, *LPBITMAPCOREHEADER;

typedef struct {
        DWORD      biSize;
        LONG       biWidth;
        LONG       biHeight;
        WORD       biPlanes;
        WORD       biBitCount;
        DWORD      biCompression;
        DWORD      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        DWORD      biClrUsed;
        DWORD      biClrImportant;
} BITMAPINFOHEADER, *PBITMAPINFOHEADER, *LPBITMAPINFOHEADER;

#define GetCValue(cmyk) ((BYTE)(cmyk))
#define GetMValue(cmyk) ((BYTE)((cmyk)>> 8))
#define GetYValue(cmyk) ((BYTE)((cmyk)>>16))
#define GetKValue(cmyk) ((BYTE)((cmyk)>>24))

#define CMYK(c,m,y,k) ((COLORREF)((((BYTE)(c)|((WORD)((BYTE)(m))<<8))|(((DWORD)(BYTE)(y))<<16))|(((DWORD)(BYTE)(k))<<24)))

typedef long FXPT16DOT16, *LPFXPT16DOT16;
typedef long FXPT2DOT30, *LPFXPT2DOT30;

typedef struct {
	FXPT2DOT30 ciexyzX;
	FXPT2DOT30 ciexyzY;
	FXPT2DOT30 ciexyzZ;
} CIEXYZ, *LPCIEXYZ;

typedef struct {
	CIEXYZ  ciexyzRed;
	CIEXYZ  ciexyzGreen;
	CIEXYZ  ciexyzBlue;
} CIEXYZTRIPLE, *LPCIEXYZTRIPLE;

typedef struct {
        DWORD        bV4Size;
        LONG         bV4Width;
        LONG         bV4Height;
        WORD         bV4Planes;
        WORD         bV4BitCount;
        DWORD        bV4V4Compression;
        DWORD        bV4SizeImage;
        LONG         bV4XPelsPerMeter;
        LONG         bV4YPelsPerMeter;
        DWORD        bV4ClrUsed;
        DWORD        bV4ClrImportant;
        DWORD        bV4RedMask;
        DWORD        bV4GreenMask;
        DWORD        bV4BlueMask;
        DWORD        bV4AlphaMask;
        DWORD        bV4CSType;
        CIEXYZTRIPLE bV4Endpoints;
        DWORD        bV4GammaRed;
        DWORD        bV4GammaGreen;
        DWORD        bV4GammaBlue;
} BITMAPV4HEADER, *PBITMAPV4HEADER, *LPBITMAPV4HEADER;

#define BI_RGB        0L
#define BI_RLE8       1L
#define BI_RLE4       2L
#define BI_BITFIELDS  3L

typedef struct {
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[1];
} BITMAPINFO, *PBITMAPINFO, *LPBITMAPINFO;

typedef struct {
    BITMAPCOREHEADER    bmciHeader;
    RGBTRIPLE           bmciColors[1];
} BITMAPCOREINFO, *PBITMAPCOREINFO, *LPBITMAPCOREINFO;

#pragma pack(2)
typedef struct {
        WORD    bfType;
        DWORD   bfSize;
        WORD    bfReserved1;
        WORD    bfReserved2;
        DWORD   bfOffBits;
} BITMAPFILEHEADER, *PBITMAPFILEHEADER, *LPBITMAPFILEHEADER;
#pragma pack()

HBITMAP WINAPI CreateDIBSection(HDC, CONST BITMAPINFO *, UINT, VOID **, HANDLE, DWORD);
UINT WINAPI GetDIBColorTable(HDC, UINT, UINT, RGBQUAD *);
UINT WINAPI SetDIBColorTable(HDC, UINT, UINT, CONST RGBQUAD *);
int WINAPI SetDIBits(HDC, HBITMAP, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT);
int WINAPI SetDIBitsToDevice(HDC, int, int, DWORD, DWORD, int,
	int, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT);
int WINAPI StretchDIBits(HDC, int, int, int, int, int, int, int, int, CONST
	VOID *, CONST BITMAPINFO *, UINT, DWORD);

#define RDH_RECTANGLES  1

typedef struct {
    DWORD   dwSize;
    DWORD   iType;
    DWORD   nCount;
    DWORD   nRgnSize;
    RECT    rcBound;
} RGNDATAHEADER, *PRGNDATAHEADER;

typedef struct {
    RGNDATAHEADER   rdh;
    char            Buffer[1];
} RGNDATA, *PRGNDATA, *LPRGNDATA;

DWORD WINAPI GetRegionData(HRGN, DWORD, LPRGNDATA);

#define MWT_IDENTITY		1
#define MWT_LEFTMULTIPLY	2
#define MWT_RIGHTMULTIPLY	3
#define MWT_MIN		MWT_IDENTITY
#define MWT_MAX		MWT_RIGHTMULTIPLY

#define _XFORM_
typedef struct {
    FLOAT   eM11;
    FLOAT   eM12;
    FLOAT   eM21;
    FLOAT   eM22;
    FLOAT   eDx;
    FLOAT   eDy;
  } XFORM, *PXFORM, *LPXFORM;

HRGN WINAPI ExtCreateRegion(CONST XFORM *, DWORD, CONST RGNDATA *);
BOOL WINAPI GetWorldTransform(HDC, LPXFORM);
BOOL WINAPI SetWorldTransform(HDC, CONST XFORM *);
BOOL WINAPI ModifyWorldTransform(HDC, CONST XFORM *, DWORD);
BOOL WINAPI CombineTransform(LPXFORM, CONST XFORM *, CONST XFORM *);

BOOL  WINAPI GetViewportExtEx(HDC, LPSIZE);
BOOL  WINAPI GetViewportOrgEx(HDC, LPPOINT);
BOOL  WINAPI GetWindowExtEx(HDC, LPSIZE);
BOOL  WINAPI GetWindowOrgEx(HDC, LPPOINT);

BOOL WINAPI SetViewportExtEx(HDC, int, int, LPSIZE);
BOOL WINAPI SetViewportOrgEx(HDC, int, int, LPPOINT);
BOOL WINAPI SetWindowExtEx(HDC, int, int, LPSIZE);
BOOL WINAPI SetWindowOrgEx(HDC, int, int, LPPOINT);

typedef struct {
	UINT	lopnStyle;
	POINT	lopnWidth;
	COLORREF	lopnColor;
  } LOGPEN, *PLOGPEN, *LPLOGPEN;

typedef struct {
    DWORD       elpPenStyle;
    DWORD       elpWidth;
    UINT        elpBrushStyle;
    COLORREF    elpColor;
    LONG        elpHatch;
    DWORD       elpNumEntries;
    DWORD       elpStyleEntry[1];
} EXTLOGPEN, *PEXTLOGPEN, *LPEXTLOGPEN;

#define PS_SOLID	0
#define PS_DASH	1
#define PS_DOT		2
#define PS_DASHDOT	3
#define PS_DASHDOTDOT	4
#define PS_NULL	5
#define PS_INSIDEFRAME	6
#define PS_USERSTYLE		7
#define PS_ALTERNATE		8
#define PS_STYLE_MASK       0x0000000F
#define PS_ENDCAP_ROUND     0x00000000
#define PS_ENDCAP_SQUARE    0x00000100
#define PS_ENDCAP_FLAT      0x00000200
#define PS_ENDCAP_MASK      0x00000F00
#define PS_JOIN_ROUND       0x00000000
#define PS_JOIN_BEVEL       0x00001000
#define PS_JOIN_MITER       0x00002000
#define PS_JOIN_MASK        0x0000F000
#define PS_COSMETIC         0x00000000
#define PS_GEOMETRIC        0x00010000
#define PS_TYPE_MASK        0x000F0000

HPEN WINAPI CreatePen(int, int, COLORREF);
HPEN WINAPI CreatePenIndirect(CONST LOGPEN *);
HBRUSH WINAPI CreatePatternBrush(HBITMAP);

#define R2_BLACK		1
#define R2_NOTMERGEPEN	2
#define R2_MASKNOTPEN     	3
#define R2_NOTCOPYPEN       	4
#define R2_MASKPENNOT       	5
#define R2_NOT             		6
#define R2_XORPEN           	7
#define R2_NOTMASKPEN       	8 
#define R2_MASKPEN          	9 
#define R2_NOTXORPEN        	10
#define R2_NOP              		11
#define R2_MERGENOTPEN      	12
#define R2_COPYPEN          	13
#define R2_MERGEPENNOT      	14
#define R2_MERGEPEN         	15
#define R2_WHITE            	16
#define R2_LAST             		16

int WINAPI GetROP2(HDC);
int WINAPI SetROP2(HDC, int);

#define NEWFRAME                     1
#define ABORTDOC                     2
#define NEXTBAND                     3
#define SETCOLORTABLE                4
#define GETCOLORTABLE                5
#define FLUSHOUTPUT                  6
#define DRAFTMODE                    7
#define QUERYESCSUPPORT              8
#define SETABORTPROC                 9
#define STARTDOC                     10
#define ENDDOC                       11
#define GETPHYSPAGESIZE              12
#define GETPRINTINGOFFSET            13
#define GETSCALINGFACTOR             14
#define MFCOMMENT                    15
#define GETPENWIDTH                  16
#define SETCOPYCOUNT                 17
#define SELECTPAPERSOURCE            18
#define DEVICEDATA                   19
#define PASSTHROUGH                  19
#define GETTECHNOLGY                 20
#define GETTECHNOLOGY                20
#define SETLINECAP                   21
#define SETLINEJOIN                  22
#define SETMITERLIMIT                23
#define BANDINFO                     24
#define DRAWPATTERNRECT              25
#define GETVECTORPENSIZE             26
#define GETVECTORBRUSHSIZE           27
#define ENABLEDUPLEX                 28
#define GETSETPAPERBINS              29
#define GETSETPRINTORIENT            30
#define ENUMPAPERBINS                31
#define SETDIBSCALING                32
#define EPSPRINTING                  33
#define ENUMPAPERMETRICS             34
#define GETSETPAPERMETRICS           35
#define POSTSCRIPT_DATA              37
#define POSTSCRIPT_IGNORE            38
#define MOUSETRAILS                  39
#define GETDEVICEUNITS               42
#define GETEXTENDEDTEXTMETRICS       256
#define GETEXTENTTABLE               257
#define GETPAIRKERNTABLE             258
#define GETTRACKKERNTABLE            259
#define EXTTEXTOUT                   512
#define GETFACENAME                  513
#define DOWNLOADFACE                 514
#define ENABLERELATIVEWIDTHS         768
#define ENABLEPAIRKERNING            769
#define SETKERNTRACK                 770
#define SETALLJUSTVALUES             771
#define SETCHARSET                   772
#define STRETCHBLT                   2048
#define GETSETSCREENPARAMS           3072
#define QUERYDIBSUPPORT              3073
#define BEGIN_PATH                   4096
#define CLIP_TO_PATH                 4097
#define END_PATH                     4098
#define EXT_DEVICE_CAPS              4099
#define RESTORE_CTM                  4100
#define SAVE_CTM                     4101
#define SET_ARC_DIRECTION            4102
#define SET_BACKGROUND_COLOR         4103
#define SET_POLY_MODE                4104
#define SET_SCREEN_ANGLE             4105
#define SET_SPREAD                   4106
#define TRANSFORM_CTM                4107
#define SET_CLIP_BOX                 4108
#define SET_BOUNDS                   4109
#define SET_MIRROR_MODE              4110
#define OPENCHANNEL                  4110
#define DOWNLOADHEADER               4111
#define CLOSECHANNEL                 4112
#define POSTSCRIPT_PASSTHROUGH       4115
#define ENCAPSULATED_POSTSCRIPT      4116

INT  WINAPI DrawEscape(HDC, INT, INT, LPCSTR);
INT WINAPI Escape(HDC, INT, INT, LPCSTR, LPVOID);
INT WINAPI ExtEscape(HDC, INT, INT, LPCSTR, INT, LPSTR);

BOOL WINAPI FloodFill(HDC, int, int, COLORREF);
BOOL WINAPI ExtFloodFill(HDC, int, int, COLORREF, UINT);
BOOL WINAPI FrameRgn(HDC, HRGN, HBRUSH, int, int);
BOOL WINAPI GetAspectRatioFilterEx(HDC, LPSIZE);
COLORREF WINAPI GetBkColor(HDC);
int WINAPI GetBkMode(HDC);
LONG WINAPI GetBitmapBits(HBITMAP, LONG, LPVOID);
BOOL WINAPI GetBitmapDimensionEx(HBITMAP, LPSIZE);
UINT WINAPI GetBoundsRect(HDC, LPRECT, UINT);
BOOL WINAPI GetBrushOrgEx(HDC, LPPOINT);
COLORREF WINAPI GetPixel(HDC, int, int);
int WINAPI GetPixelFormat(HDC);
int WINAPI GetPolyFillMode(HDC);
int WINAPI GetStretchBltMode(HDC);
COLORREF WINAPI SetBkColor(HDC, COLORREF);
int WINAPI SetBkMode(HDC, int);
LONG WINAPI SetBitmapBits(HBITMAP, DWORD, CONST VOID *);
UINT WINAPI SetBoundsRect(HDC, CONST RECT *, UINT);
DWORD WINAPI SetMapperFlags(HDC, DWORD);
int WINAPI SetGraphicsMode(HDC hdc, int iMode);
int WINAPI SetMapMode(HDC, int);
COLORREF WINAPI SetPixel(HDC, int, int, COLORREF);
BOOL WINAPI SetPixelV(HDC, int, int, COLORREF);
int WINAPI SetPolyFillMode(HDC, int);
BOOL WINAPI StretchBlt(HDC, int, int, int, int, HDC, int, int, int, int, DWORD);
int WINAPI SetStretchBltMode(HDC, int);
BOOL WINAPI UpdateColors(HDC);

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINGDI_H) */
