#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <malloc.h>

int main (int argc, char ** argv, char ** env)
{
    int ph[2], org[2];
    int ret, c;

    if (argc <= 1) {
        printf("usage: pipe_rd <program that uses stdin>");
        return (1);
    }

    setbuf(stdin, NULL);
    setbuf(stdout, NULL);

    if (pipe (ph) != 0) {
	perror ("pipe");
	return (2);
    }

    /* redirect stdin */
    org[0] = dup( fileno( stdin ) );
    dup2( ph[0], fileno( stdin ) );

    fcntl (ph[0], F_SETFD, FD_CLOEXEC);  /* don't inherit pipe handles */
    fcntl (ph[1], F_SETFD, FD_CLOEXEC);

    ret = spawnvpe(P_SESSION, argv[1], argv + 1, env);

    dup2( org[0], fileno( stdin ) );
    close(org[0]);

    if (ret >= 0) {
	printf("spawn ret = %d\n", ret);

	printf("text for pipe:\n");
	/* write some text in pipe */
	while ((c = getchar()) != EOF) {
	    write(ph[1], &c, 1);
	}
    }
    close (ph[0]);
    close (ph[1]);
    return (0);
}
