/* copro struct */

#define i_orgeip    _info
#define i_retsys    _info+4
#define i_ebx	    _info+8
#define i_ecx	    _info+12
#define i_edx	    _info+16
#define i_esi	    _info+20
#define i_edi	    _info+24
#define i_ebp	    _info+28
#define i_eax	    _info+32
#define i_ds	    _info+36
#define i_es	    _info+40
#define i_fs	    _info+44
#define i_gs	    _info+48
#define i_orgeax    _info+52
#define i_eip	    _info+56
#define i_cs	    _info+60
#define i_eflags    _info+64
#define i_esp	    _info+68
#define i_ss	    _info+72


	.globl start
	.globl _back_to_prg
	.globl _debugged
	.globl _used_math
	.globl _raise

	.text

/* called from extender: 1. init exception ; 2. change mathe state */
/* gs = emu data seg */

start:
	cmpl	$0x98765432,%eax	/* exception call ? */
	jz	L11
	cmpl	$0x12345678,%eax	/* init call ? */
	jz	L10
	movl	%edx, %gs:_debugged	/* debugged>0 : don't lookahead */
	movl	%ecx, %gs:_used_math	/* used_math>0: don't init */
	lret
/* ! can't use movl %eax,gs:xx (bug ??) */


	.align 2,144
L10:
	movl	$_info , %eax	       /* return coprostruct */
	lret


	.align 2,144
/* entry : gs = emu sel , ds:esi = info stuct */
L11:
	movw	%gs, %dx

	movw	%dx, %ds
	movw	%dx, %es
	movw	%dx, %ss
	movl	emu_esp, %esp

	movw	i_fs,%fs

	pushl	$_info
	call	_math_emulate
_back_to_prg:
	movl	i_eax,%eax
	movl	i_ebx,%ebx
	movl	i_ecx,%ecx
	movl	i_edx,%edx
	movl	i_esi,%esi
	movl	i_edi,%edi
	movl	i_ebp,%ebp
	movw	i_es,%es
	movw	i_fs,%fs

	movw	i_ss,%ss	/* change stack to user */
	movl	i_esp,%esp

	pushl	i_eflags
	pushl	i_cs
	pushl	i_eip
	movw	i_ds,%ds
	iret


	.align 2,144
_abort_emu:
_raise:
	movw $0xFFFF,%eax
	lret


	.data

	rsxfpu_ver:
		.long 103

	dpmi_esp:
		.long 0
	dpmi_ss:
		.long 0
	emu_esp:
		.long 0xfff0
	_debugged:
		.long 0
	_used_math:
		.long 0

		.globl _process_npx
	_process_npx:
		.long _copro

	.comm _copro,172
	.comm _info,92

