////////////////////////////////////////////////////////////////////////////////
/// @file w2ltx.cpp
/// 
/// $Workfile:$
/// 
/// $Author:$
/// $Date:$
/// $Revision:$
/// 
///  Copyright: Ingo H. de Boer
/// 
////////////////////////////////////////////////////////////////////////////////

#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <tchar.h>

using namespace std;

#include "wsW2LTX.h"

void usage(char *name)
{
    cout << "Usage: " << name << " filename.doc" << endl;
    exit (-1);
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 2)
		usage (argv[0]);

	// create wsW2LTX object
	wsW2LTX _wsW2LTX;

	// set input name of file to convert
	_wsW2LTX.SetInputName(argv[1]);

	// show some information, like the file version
	cout << endl;
	std::string strFileVersion;
	std::string strProductVersion;
	_wsW2LTX.GetVersion(&strProductVersion[0], &strFileVersion[0]);
	cout << "wsW2LTX version: " << &strFileVersion[0] << endl;

	// convert the file
	cout << "converting file: " << argv[1] << endl;
	cout << endl;
	if (!_wsW2LTX.Convert())
	{
		cerr << endl << "Could not convert the document! Exiting to system!" << endl;
		exit(-1);
	}
	else
	{
		cout << endl << "finished converting..." << endl;
	}

	return 0;
}

