/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.wizards;

import java.util.HashMap;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.wizards.TexlipseProjectAttributes;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class TexlipseWizardPage
extends WizardPage {
    protected HashMap<Object, IStatus> statusMap;
    protected TexlipseProjectAttributes attributes;

    protected TexlipseWizardPage(int pageNumber, TexlipseProjectAttributes attributes) {
        super("page" + pageNumber);
        this.attributes = attributes;
        this.setTitle(TexlipsePlugin.getResourceString("projectWizardPageTitle"));
        this.setDescription(TexlipsePlugin.getResourceString("projectWizardPageDescription"));
        this.statusMap = new HashMap();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 2;
        composite.setLayout((Layout)gd);
        composite.setLayoutData((Object)new GridData(1808));
        this.createComponents(composite);
        this.statusMap.put(composite, this.createStatus(0, ""));
        this.setControl((Control)composite);
    }

    protected void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        separator.setLayoutData((Object)gridData);
    }

    protected void addSpacer(Composite parent, int span) {
        Label spacer = new Label(parent, 16384);
        GridData gd = null;
        if (span == 1) {
            gd = new GridData();
        } else {
            gd = new GridData(768);
            gd.horizontalSpan = span;
        }
        spacer.setLayoutData((Object)gd);
    }

    protected abstract void createComponents(Composite var1);

    protected IStatus createStatus(int severity, String message) {
        return new Status(severity, TexlipsePlugin.getPluginId(), severity, message, null);
    }

    protected void updateStatus(IStatus lastStatus, Object key) {
        IStatus status = null;
        boolean allOk = true;
        this.statusMap.put(key, lastStatus);
        if (lastStatus.matches(4)) {
            status = lastStatus;
            allOk = false;
        } else {
            for (IStatus i : this.statusMap.values()) {
                if (!i.matches(0)) {
                    status = i;
                }
                if (!i.matches(4)) continue;
                allOk = false;
                break;
            }
        }
        this.setPageComplete(allOk);
        Control ctrl = this.getControl();
        if (ctrl != null && ctrl.isVisible()) {
            if (status == null) {
                status = lastStatus;
            }
            TexlipseWizardPage.applyToStatusLine((DialogPage)this, status);
        }
    }

    protected static void applyToStatusLine(DialogPage page, IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        page.setErrorMessage(errorMessage);
        page.setMessage(warningMessage, status.getSeverity());
    }
}

