/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.TexlipseNature;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.templates.ProjectTemplateManager;
import net.sourceforge.texlipse.wizards.TexlipseProjectAttributes;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class TexlipseProjectCreationOperation
implements IRunnableWithProgress {
    private TexlipseProjectAttributes attributes;

    public TexlipseProjectCreationOperation(TexlipseProjectAttributes attr) {
        this.attributes = attr;
    }

    public void run(IProgressMonitor pMon) throws InvocationTargetException, InterruptedException {
        IProgressMonitor monitor = pMon;
        if (pMon == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(TexlipsePlugin.getResourceString("projectWizardProgressCreating"), 12);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                String name = this.attributes.getProjectName();
                IProject project = root.getProject(name);
                monitor.worked(1);
                this.createProject(project, monitor);
                monitor.worked(1);
                TexlipseProjectCreationOperation.addProjectNature(project, monitor);
                monitor.worked(1);
                this.createProjectDirs(project, monitor);
                monitor.worked(1);
                TexlipseProperties.setProjectProperty((IResource)project, "langSpell", String.valueOf(this.attributes.getLanguageCode()));
                TexlipseProperties.setProjectProperty((IResource)project, "markDer", "true");
                TexlipseProperties.setProjectProperty((IResource)project, "markTmpDer", "true");
                TexlipseProperties.setProjectProperty((IResource)project, "makeIndSty", "");
                TexlipseProperties.setProjectProperty((IResource)project, "bibrefDir", "");
                TexlipseProperties.setProjectProperty((IResource)project, "outputFile", this.attributes.getOutputFile());
                TexlipseProperties.setProjectProperty((IResource)project, "outputFormat", this.attributes.getOutputFormat());
                TexlipseProperties.setProjectProperty((IResource)project, "builderNum", String.valueOf(this.attributes.getBuilder()));
                TexlipsePlugin.getDefault().getPreferenceStore().setValue("outputFormat", this.attributes.getOutputFormat());
                TexlipsePlugin.getDefault().getPreferenceStore().setValue("builderNum", this.attributes.getBuilder());
                monitor.worked(1);
                this.createMainFile(project, monitor);
                monitor.worked(1);
                monitor.subTask(TexlipsePlugin.getResourceString("projectWizardProgressSettingsFile"));
                TexlipseProperties.saveProjectProperties(project);
                monitor.worked(1);
                IDE.openEditor((IWorkbenchPage)TexlipsePlugin.getCurrentWorkbenchPage(), (IFile)TexlipseProperties.getProjectSourceFile(project));
                monitor.worked(1);
            }
            catch (CoreException e) {
                TexlipsePlugin.log(TexlipsePlugin.getResourceString("projectWizardCreateError"), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createProject(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(TexlipsePlugin.getResourceString("projectWizardProgressDirectory"));
        if (!project.exists()) {
            if (this.attributes.getProjectLocation() != null) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                Path projectPath = new Path(this.attributes.getProjectLocation());
                IStatus stat = ResourcesPlugin.getWorkspace().validateProjectLocation(project, (IPath)projectPath);
                if (stat.getSeverity() != 0) {
                    throw new CoreException(stat);
                }
                desc.setLocation((IPath)projectPath);
                project.create(desc, monitor);
            } else {
                project.create(monitor);
            }
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
    }

    public static void addProjectNature(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(TexlipsePlugin.getResourceString("projectWizardProgressNature"));
        IProjectDescription desc = project.getDescription();
        String[] natures = desc.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (TexlipseNature.NATURE_ID.equals(natures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 1, natures.length);
        newNatures[0] = TexlipseNature.NATURE_ID;
        desc.setNatureIds(newNatures);
        project.setDescription(desc, monitor);
    }

    private void createProjectDirs(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(TexlipsePlugin.getResourceString("projectWizardProgressSubdirs"));
        String outputDir = this.attributes.getOutputDir();
        String sourceDir = this.attributes.getSourceDir();
        String tempDir = this.attributes.getTempDir();
        this.createDir(project, monitor, outputDir, true);
        this.createDir(project, monitor, sourceDir, false);
        this.createDir(project, monitor, tempDir, true);
        TexlipseProperties.setProjectProperty((IResource)project, "outputDir", outputDir);
        TexlipseProperties.setProjectProperty((IResource)project, "srcDir", sourceDir);
        TexlipseProperties.setProjectProperty((IResource)project, "tempDir", tempDir);
    }

    private void createDir(IProject project, IProgressMonitor monitor, String dir, boolean derivedAsDefault) throws CoreException {
        if (dir != null && dir.length() > 0) {
            IFolder folder = project.getFolder(dir);
            folder.create(true, true, monitor);
            if (derivedAsDefault) {
                folder.setDerived(true);
            }
        }
    }

    private void createMainFile(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(TexlipsePlugin.getResourceString("projectWizardProgressFile"));
        String name = this.attributes.getSourceFile();
        if (name == null || name.length() == 0) {
            throw new CoreException(TexlipsePlugin.stat("Null main file name"));
        }
        TexlipseProperties.setProjectProperty((IResource)project, "mainTexFile", name);
        byte[] template = this.getTemplate(this.attributes.getTemplate());
        if (template == null) {
            template = new byte[]{};
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(template);
        IFile mainFile = TexlipseProperties.getProjectSourceFile(project);
        mainFile.create((InputStream)stream, true, monitor);
    }

    private byte[] getTemplate(String name) {
        String[] userNames = ProjectTemplateManager.loadUserTemplateNames();
        int i = 0;
        while (i < userNames.length) {
            if (userNames[i].equals(name)) {
                byte[] content = null;
                try {
                    content = ProjectTemplateManager.readUserTemplate(name);
                }
                catch (IOException iOException) {}
                if (content != null) {
                    return content;
                }
            }
            ++i;
        }
        String[] systemNames = ProjectTemplateManager.loadTemplateNames();
        int i2 = 0;
        while (i2 < systemNames.length) {
            if (systemNames[i2].equals(name)) {
                byte[] content = null;
                try {
                    content = ProjectTemplateManager.readSystemTemplate(name);
                }
                catch (IOException iOException) {}
                if (content != null) {
                    return content;
                }
            }
            ++i2;
        }
        return null;
    }
}

