/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibparser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.texlipse.bibparser.AbbrevRetriever;
import net.sourceforge.texlipse.bibparser.BibLexer;
import net.sourceforge.texlipse.bibparser.EntryRetriever;
import net.sourceforge.texlipse.bibparser.lexer.LexerException;
import net.sourceforge.texlipse.bibparser.node.Start;
import net.sourceforge.texlipse.bibparser.parser.Parser;
import net.sourceforge.texlipse.bibparser.parser.ParserException;
import net.sourceforge.texlipse.model.ParseErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BibParser {
    private String filename;
    private Reader reader;
    private List<ParseErrorMessage> errors;
    private List warnings;
    private List tasks;
    private Start ast;

    public BibParser(String filename) {
        this.filename = filename;
        this.errors = new ArrayList<ParseErrorMessage>();
        this.warnings = new ArrayList();
    }

    public BibParser(Reader r) {
        this.reader = r;
        this.errors = new ArrayList<ParseErrorMessage>();
        this.warnings = new ArrayList();
    }

    public List getEntries() throws IOException, FileNotFoundException {
        try {
            BibLexer l = this.filename != null ? new BibLexer(new PushbackReader(new FileReader(this.filename), 1024)) : new BibLexer(new PushbackReader(this.reader, 1024));
            Parser p = new Parser(l);
            this.ast = p.parse();
            EntryRetriever er = new EntryRetriever();
            this.ast.apply(er);
            er.finishParse();
            this.warnings = er.getWarnings();
            this.tasks = er.getTasks();
            return er.getEntries();
        }
        catch (LexerException le) {
            String msg = le.getMessage();
            int first = msg.indexOf(91);
            int last = msg.indexOf(93);
            String numseq = msg.substring(first + 1, last);
            String[] numbers = numseq.split(",");
            this.errors.add(new ParseErrorMessage(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]) - 1, 2, msg.substring(last + 2), 2));
        }
        catch (ParserException pe) {
            String msg = pe.getMessage();
            int last = msg.indexOf(93);
            this.errors.add(new ParseErrorMessage(pe.getToken().getLine(), pe.getToken().getPos(), pe.getToken().getText().length(), msg.substring(last + 2), 2));
        }
        return null;
    }

    public List getAbbrevs() {
        if (this.ast != null) {
            AbbrevRetriever ar = new AbbrevRetriever();
            this.ast.apply(ar);
            return ar.getAbbrevs();
        }
        return null;
    }

    public List<ParseErrorMessage> getErrors() {
        return this.errors;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getTasks() {
        return this.tasks;
    }
}

