{$N-,V-,W-,G+}

Unit wbibshow;

Interface

uses
  wobjects, wbibdisp, wbibgui, WinTypes, WinProcs, bibpchec, strings, ole,
  bibstrg, streams, bibecond, bibvars, bibutil, bib8bit, rc_id,
  wbibstat, win31, wbibabv1, bibfile, wbibole, lfnunit, SMAPI;

type
  PPrinterStats = ^TPrinterStats;
  TPrinterStats = record
    FirstTime: boolean;
    Width,Height: integer;
    XPos,YPos: integer;
    XRes,YRes,XExtent,YExtent: integer;
    LeftMar,RightMar,TopMar,BottomMar: integer;
  end;

  PObjRect = ^TObjRect;
  TObjRect = Object(TObject)
    R: TRect;
    O: POleObj;
    constructor init(AR: TRect; AO: POleObj);
  end;

  PFieldRegion = ^TFieldRegion;
  TFieldRegion = object(TObject)
    R: HRgn;
    fld,Hyperlink,obj: integer;
{    Obj: POleObj;}
    constructor init(Afield: byte; ARegion: HRgn; AHyper: integer);
    destructor  done; virtual;
  end;

  PHyperLinkObj = ^THyperLinkObj;
  THyperLinkObj = object(TObject)
    Link: PString;
    PLink: PChar;
    Ltype: integer;
    StartInd,EndInd,Len: longint;
    constructor init(ALink: PChar; ALen: longint; ALtype: integer; Start: word);
    function    Active: boolean;
    destructor  done; virtual;
  end;

  POneLine = ^TOneLine;
  TOneLine = object(TObject)
    line: PString;
    Height,Ascent,Descent,PrevDesc,IndDepth,LineLen: integer;
    StartingFont: integer;
    constructor init(Aline: string; AHeight,Alen,AAscent,ADescent,
                     APrevDesc,AFont,Aindent: integer);
    destructor  done; virtual;
  end;

  PEntryName = ^TEntryName;
  TEntryName = object(TWindow)
    FirstTime,TagShow,ClickPass,UpdateEntry,ShowEmpty,NumShow: boolean;
    LastHeight: integer;
    CurrentHead: string;
    CurrentTag: boolean;
    HelpBar: PHelpBar;
    constructor Init(Aparent: PWindowsObject; ShowTags,PassClick,AShowEmpty,
                     ANumShow: boolean; AHelpBar: PHelpBar);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   wmMouseActivate(var Msg: TMessage);
                              virtual wm_First+wm_MouseActivate;
    procedure   Update;
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure   WmLButtonDown(var Msg: TMessage);
                              virtual wm_first+wm_LButtonDown;
    procedure   WmRButtonDown(var Msg: TMessage);
                              virtual wm_First+wm_RButtonDown;   
    procedure   WmMButtonDown(var Msg: TMessage);
                              virtual wm_first+wm_MButtonDown;
    procedure   WmMouseMove(var Msg: TMessage);
                              virtual wm_first+wm_MouseMove;
  end;

  PDisplayArea = ^TDisplayArea;
  TDisplayArea = object(TWindow)
    FirstTime,UpdateEntry,CursorIsFinger,ShowPattern: boolean;
    OldDimensions: TRect;
    ShownList,LineList,HyperLinks,Objects,ObjRects: TCollection;
    Indent:     integer;
    Pattern:    PatRecPtr;
    HelpBar:    PHelpBar;
    CaretHeight,DefCaretHeight: integer;
    CanUseCaret,CaretIsActive,SendDblClk: boolean;
    CaretPos:   TPoint;
    CaretInd,LastY,NewLines: integer;
    constructor Init(AParent: PWindowsObject; APattern: PatRecPtr;
                     AHelpBar: PHelpBar; ADblClks: boolean);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   wmMouseActivate(var Msg: TMessage);
                              virtual wm_First+wm_MouseActivate;
    procedure   Update;
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure   PaintIt(PaintDC: HDC; PrinterStats: PPrinterStats);
    procedure   ButtonDown(btn: word; var Msg: TMessage);
    procedure   WmLButtonDown(var Msg: TMessage);
                              virtual wm_first+wm_LButtonDown;
    procedure   WmRButtonDown(var Msg: TMessage);
                              virtual wm_first+wm_RButtonDown;
    procedure   WmLButtonDblClk(var Msg: TMessage);
                              virtual wm_first+wm_LButtonDblClk;
    procedure   WmMouseMove(var Msg: TMessage);
                              virtual wm_first+wm_MouseMove;
    procedure   CaretRestore;
    procedure   CaretDestroy;
    procedure   CaretMove(Ind: integer; visible: boolean);
    procedure   CaretVisible;
    procedure   BibObjectMsg(var Msg: TMessage);
                               virtual wm_First+Bib_ObjectMsg;
    destructor  Done; virtual;
  end;

var
  EntryNameHeight: integer;


Implementation

Const 
  XShiftDef = 5; YShiftDef = 0;
  FontChangeChar = #1;
  FieldStartChar = #2;
  FieldEndChar   = #3;
  HyperStartChar = #4;
  OleObjectChar  = #5;
  TildeChar      = #6;

{ TFieldRegion methods }

constructor TFieldRegion.init(Afield: byte; ARegion: HRgn; AHyper: integer);
begin
  TObject.init;
  fld:=Afield; R:=ARegion;
  Hyperlink:=AHyper; Obj:=-1;
end;

destructor TFieldRegion.done;
begin
  DeleteObject(R);
  TObject.Done;
end;

{ TObjRect methods }

constructor TObjRect.init(AR: TRect; AO: POleObj);
var
  i: integer;
begin
  TObject.init;
  R:=AR; O:=AO;
  if (R.Left>R.Right) then
  begin
    i:=R.Left; R.Left:=R.Right; R.Right:=i;
  end;
  if (R.Top>R.Bottom) then
  begin
    i:=R.Top; R.Top:=R.Bottom; R.Bottom:=i;
  end;
end;                { TObjRect.init }

{ TEntryName methods }

constructor TEntryName.Init(AParent: PWindowsObject;
                            ShowTags,PassClick,AShowEmpty,ANumShow: boolean;
                            AHelpBar: PHelpBar);
begin
  TWindow.Init(AParent,'<none>');
  Attr.Style:=ws_Child or ws_Visible;
  DisableAutoCreate;
  FirstTime:=true;
  LastHeight:=1;
  TagShow:=ShowTags;
  ClickPass:=PassClick;
  UpdateEntry:=true;
  CurrentHead:=''; CurrentTag:=false;
  ShowEmpty:=AShowEmpty; NumShow:=ANumShow;
  HelpBar:=AHelpBar;
end;                              { TEntryName.Init }

function TEntryName.GetClassName: PChar;
begin
  if ClickPass then GetClassName:=BibDBENameCPass
  else GetClassName:=BibDBENameNoCPass;
end;

procedure TEntryName.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  Class.hBrBackground:=0; {HBrush(Color_Menu+1);}
  Class.hCursor:=0; {FingerCursor;}
end;

procedure TEntryName.wmMouseActivate(var Msg: TMessage);
begin
  if GetActiveWindow=Parent^.HWindow then
    DefWndProc(Msg)
  else Msg.Result:=ma_ActivateAndEat;
end;

procedure TEntryName.Update;
begin
  UpdateEntry:=true;
  InvalidateRect(HWindow,Nil,true);
end;

procedure TEntryName.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  Metrics: TTextMetric;
  Rect: TRect;
  S: Pstring;
  Extent,Shft: Longint;
  x0,y0: integer;
  Pen: HPen;
  Tag: boolean;
begin
  New(S);
  Tag:=false;
  if UpdateEntry then
  begin
    if (Entry=Nil) or (entry^.entrytype='') or
      not (ShowEmpty or BibFileExists) then S^:='<none>'
    else begin
      S^:=entry^.EntryType; StrUpr(S^);
      if {(entry^.nentry=0) or} (entry^.name='') then S^:=S^+': <UnNamed>'
      else S^:=S^+': '+entry^.name;
      if NumShow and (Entry^.entrynum>0) then
      begin
        if (Pattern=Nil) or (not Pattern^.on) then
          S^:=S^+'  ['+num2str(entry^.entrynum)+']'
        else
          S^:=S^+'  ['+num2str(entry^.entrynum)+', '+num2str(entry^.realnum)+']';
      end;
      if TagShow then Tag:=IsTagged(Entry^.realnum,Tags);
    end;
    CurrentHead:=S^; CurrentTag:=Tag; UpdateEntry:=false;
  end else
  begin
    S^:=CurrentHead;
    if TagShow then Tag:=CurrentTag;
  end;

  with Fonts^[LabelFont] do
  begin
    if not Initialized then
    begin
      Font:=CreateFontIndirect(Logfont);
      SelectObject(PaintDC,Font);
      GetTextMetrics(PaintDC,Metrics);
      Height:=Metrics.tmHeight+Metrics.tmExternalLeading;
      Ascent:=Metrics.tmAscent;
      Descent:=Metrics.tmDescent;
      Initialized:=true;
    end else SelectObject(PaintDC,Font);
    SetTextColor(PaintDC,Color);
  end;
  SetBKMode(PaintDC,Transparent);

  GetClientRect(HWindow,Rect);
  if PaintInfo.fErase then
  begin
    if ENameBackBrush=0 then ENameBackBrush:=CreateSolidBrush(EnameBackColor);
    FillRect(PaintDC,Rect,ENameBackBrush);
  end;

  SetTextAlign(PaintDC,ta_Center+ta_NoUpdateCP+Ta_Top);
  TextOut(PaintDC,(Rect.right-Rect.Left) div 2, 0, @S^[1],length(S^));

               { Tag symbol }
  if Tag then
  begin
    Pen:=CreatePen(ps_Solid,2,TagColor);
    SelectObject(PaintDC,Pen);
    Extent:=GetTextExtent(PaintDC,@S^[1],length(S^));
    Shft:=GetTextExtent(PaintDC,'M',1);
    x0:=(Rect.right-Rect.left-LoWord(Shft)-LoWord(Extent)) div 2 - 1;
    y0:=HiWord(Extent) div 2+1;
    MoveTo(PaintDC,x0-(LoWord(Shft) div 4)+1,y0-(HiWord(Shft) div 4)-1);
    LineTo(PaintDC,x0+(LoWord(Shft) div 4)-1,y0+(HiWord(Shft) div 4)+1);
    MoveTo(PaintDC,x0-(LoWord(Shft) div 4),y0+(HiWord(Shft) div 4));
    LineTo(PaintDC,x0+(LoWord(Shft) div 4),y0-(HiWord(Shft) div 4));
    SelectObject(PaintDC,GetStockObject(Null_Pen));
    DeleteObject(Pen);
  end;
  SelectObject(PaintDC,GetStockObject(System_Font));
  Dispose(S);
end;                             { TEntryName.Paint }

procedure TEntryName.wmLButtonDown(var Msg: TMessage);
begin
  PostMessage(Parent^.HWindow,bib_ClickedOnField,$FFFF,
              MakeLong(mk_LButton,Msg.wParam));
  TWindow.wmLButtonDown(Msg);
end;

procedure TEntryName.wmRButtonDown(var Msg: TMessage);
begin
  PostMessage(Parent^.HWindow,bib_ClickedOnField,$FFFF,
              MakeLong(mk_RButton,Msg.wParam));
end;

procedure TEntryName.wmMButtonDown(var Msg: TMessage);
begin
  PostMessage(Parent^.HWindow,bib_ClickedOnField,$FFFF,
              MakeLong(mk_MButton,Msg.wParam));
end;

procedure TEntryName.wmMouseMove(var Msg: TMessage);
begin
  SetCursor(FingerCursor);
  if HelpBar<>Nil then HelpBar^.ClearHelpText;
end;

{ TOneLine methods }

constructor TOneLine.Init(Aline: string; AHeight,Alen,AAscent,ADescent,
            APrevDesc,AFont,Aindent: integer);
var
  i: integer;
begin
  TObject.init;
  Height:=AHeight; StartingFont:=AFont;
  Ascent:=AAscent; Descent:=ADescent;
  PrevDesc:=APrevDesc;
  LineLen:=ALen;
  IndDepth:=AIndent;
  i:=1;
  while i<=length(Aline) do    { Remove region info }
  begin
    if      Aline[i]=FontChangeChar then i:=i+2              { font change   }
    else if Aline[i]=OleObjectChar  then i:=i+3              { Object        }
    else if Aline[i]=FieldStartChar then Delete(Aline,i,2)   { Open region   }
    else if Aline[i]=FieldEndChar   then Delete(Aline,i,1)   { Close region  }
    else if ALine[i]=HyperStartChar then Delete(ALine,i,3)   { Open hypelink }
    else inc(i);
  end;
  line:=Nil; if ALine<>'' then line:=NewStr(ALine);
end;

destructor  TOneLine.Done;
begin
  if line<>Nil then DisposeStr(line);
  TObject.Done;
end;

{ THyperLinkObj methods }

constructor THyperLinkObj.init(ALink: PChar; ALen: longint;
                               ALtype: integer; Start: word);
begin
  TObject.init;
  Link:=Nil; PLink:=Nil; Len:=0; ALen:=abs(ALen);
  if (Alink<>Nil) and (ALen>0) then
  begin
    Len:=ALen;
    GetMem(Link,len+2); PLink:=PChar(Link)+1;
    Move(ALink^,PLink^,len); PLink[len]:=#0;
    if len>255 then Link^[0]:=#255 else Link^[0]:=Chr(len); 
  end;
  Ltype:=ALtype;
  StartInd:=Start; EndInd:=0;
end;                    { THyperLinkObj.init }

function THyperLinkObj.Active: boolean;
var
  IsActive: boolean;
  l,ind: integer;
begin
  IsActive:=(Link<>Nil) and
          ((HyperTypesArr^[LType].Flags and HClass_on)<>0);
  if IsActive then
  begin
    l:=Ltype; ind:=NHyperTypes;
    while (l>=Hyper_User) and (Ind>=0) do
    begin
      l:=HyperTypesArr^[l].Htype; dec(Ind);
    end;
    if Ind<=0 then IsActive:=false   { Recursion }
    else if l=Hyper_Mail then
      IsActive:=(UseMAPI and LoadMAPI) or WWWBrowser.Active
    else
      IsActive:=((l<>Hyper_Href) and (l<>Hyper_FTP)) or (WWWBrowser.Active);
  end;
  Active:=IsActive;
end;                   { THyperLinkObj.Active }

destructor THyperLinkObj.Done;
begin
  if (Link<>Nil) and (Len>0) then FreeMem(Link,len+2);
  TObject.Done;
end;

{ TDisplayArea methods }

constructor TDisplayArea.Init(AParent: PWindowsObject; APattern: PatRecPtr;
                              AHelpBar: PHelpBar; ADblClks: boolean);
begin
  TWindow.init(AParent,'<none>');
  SendDblClk:=ADblClks;
  HelpBar:=AHelpBar;
  Attr.Style:=ws_VScroll or ws_Hscroll or ws_border or ws_Child or ws_visible;
  DisableAutoCreate;
  FirstTime:=true;
  Scroller:=New(PScroller,init(@Self,10,10,0,100));
  Scroller^.AutoMode:=false;
  CursorIsFinger:=false;
  UpdateEntry:=true;
  Pattern:=APattern;
  ShowPattern:=Pattern<>Nil;
  Indent:=0;
  with OldDimensions do
  begin
    top:=0; left:=0; bottom:=0; right:=0;
  end;
  LineList.init(100,100);
  ShownList.Init(30,10);
  Hyperlinks.Init(0,100);
  Objects.init(0,100);
  ObjRects.init(0,100);
  CanUseCaret:=false; CaretIsActive:=false;
  CaretHeight:=2;
  CaretPos.X:=5; CaretPos.Y:=1;
  CaretInd:=-1;
  NewLines:=0;
end;                           { TDisplayArea.Init }

function TDisplayArea.GetClassName: PChar;
begin
  if SendDblClk then GetClassName:=BibDBDispAreaDblClk
  else GetClassName:=BibDBDispArea;
end;

procedure TDisplayArea.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  Class.hCursor:=0;
  if SendDblClk then Class.Style:=Class.Style or cs_DblClks;
end;

procedure TDisplayArea.wmMouseActivate(var Msg: TMessage);
begin
  if GetActiveWindow=Parent^.HWindow then DefWndProc(Msg)
  else Msg.Result:=ma_ActivateAndEat;
end;

procedure TDisplayArea.Update;
begin
  UpdateEntry:=true; InvalidateRect(HWindow,Nil,true);
end;

procedure TDisplayArea.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
begin
  PaintIt(PaintDC,Nil);
end;

procedure TDisplayArea.PaintIt(PaintDC: HDC; PrinterStats: PPrinterStats);
type
  OpenRegionType = record
    fld: byte;
    active: boolean;
    Baseline,lnum,Xpos: integer;
    R: HRgn;
    Hyperlink: integer;
  end; 
var
  CharWidth,FirstChar: Word;
  S,S2: Pchar;
  Ext: Longint;
  Line: Pstring;
  ty,Lheight,LCharAscent,LCharDescent,PrevDescent,llen,i,MaxLineLen: integer;
  CurrentFont,StartingFont,ScreenWidth,ScreenHeight: integer;
  XShift,XShift2,YShift,CurrentHyper,MyObjectCounter: integer;
  OpenRegion: OpenRegionType;
  EatSpace,print,LoadObjects,Verbatim: boolean;
  NormalFontInd,BoldFontInd,FontShift,InitialYShift: integer;
  CurrentFld: byte;

function OutputText(S: PChar; n: integer; xp: integer): integer;
begin
  if print or (xp<0) then ExtTextOut(PaintDC,0,0,0,Nil,S,n,Nil);
  if llen>MaxLineLen then MaxLineLen:=llen;
  if xp>=0 then OutputText:=xp+LoWord(GetTextExtent(PaintDC,S,n))
  else OutputText:=0;
end;

procedure SetFont(FontInd: integer);
var
  Metrics: TTextMetric;
  L: TLogFont;
begin
{  if (FontInd<FirstFontIndex) or (FontInd>LastFontIndex) then Messagebeep(0);  }
  if Fonts^[FontInd].Default then FontInd:=NormalFontInd;
  if FontInd=CurrentFont then Exit;
  if not Fonts^[FontInd].Initialized then
  with Fonts^[FontInd] do
  begin
    L:=LogFont;
{    if Print then L.lfHeight:=MulDiv(-PointSize,PrinterStats^.YRes,720);}
    if Print then L.lfHeight:=-PointSize;
    Font:=CreateFontIndirect(L);
    Initialized:=true; Height:=0;
  end;
  SelectObject(PaintDC,Fonts^[FontInd].Font);
  SetTextColor(PaintDC,Fonts^[FontInd].Color);
  CurrentFont:=FontInd;
  if Fonts^[FontInd].Height=0 then
  begin
    GetTextMetrics(PaintDC,Metrics);
    Fonts^[FontInd].Height:=Metrics.tmHeight+Metrics.tmExternalLeading;
    Fonts^[FontInd].Ascent:=Metrics.tmAscent;
    Fonts^[FontInd].Descent:=Metrics.tmDescent;
  end;
  if StartingFont=0 then StartingFont:=FontInd;
end;                                  { SetFont }

procedure GetObjRect(ObjInd: integer; var R: TRect; Absol: boolean);
var
  XMove,YMove,FactX,FactY: real;
  i: integer;

function MakeInt(r: real): integer;  { Guard against overflow }
begin
  if r>32767 then MakeInt:=32767
  else if r<-32768 then MakeInt:=-32768
  else MakeInt:=round(r);
end;

begin           { GetObjRect }
  XMove:=0; YMove:=0;
  if Absol then
  begin
    XMove:=POleObj(Objects.at(ObjInd))^.Left; YMove:=ty;
  end;
  FactX:=1.0*ScreenResX/2540.0; FactY:=1.0*ScreenResY/2540.0;
  if Print then
  begin
    FactX:=72.0/254.0; FactY:=FactX;
  end;
  POleObj(Objects.at(ObjInd))^.GetRect(R,XMove,YMove,FactX,FactY);
end;                      { GetObjRect }

function DrawObject(ObjInd: integer; ShowIt: boolean): integer;
var
  OleObj: POleObj;
  R: TRect;
  k: integer;
begin
  OleObj:=POleObj(Objects.at(ObjInd));
  if not OleObj^.ok then Exit;
  GetObjRect(ObjInd,R,true);
  if OleObj^.HAlign=ObjAlign_Center then
    k:=(ScreenWidth-XShift-XShift2) div 2 - (R.right-R.Left) div 2+XShift
  else if OleObj^.HAlign=ObjAlign_Left then k:=XShift
  else if OleObj^.HAlign=ObjAlign_Right then
    k:=(ScreenWidth-XShift2)-(R.Right-R.Left)
  else k:=R.Left;
  if k<XShift then k:=XShift;
  R.right:=R.right-R.Left+k; R.left:=k;
  ObjRects.Insert(New(PObjRect,init(R,OleObj)));
  k:=OleObj^.Display(HWindow,PaintDC,R,ShowIt);
  DrawObject:=k;
  if ShowIt then MoveTo(PaintDC,k,ty);
  if k>MaxLineLen then MaxLineLen:=k;
end;                { DrawObject }

procedure PrintLineList;
var
  LineInd,i,j: integer;
  S: string;
begin
  for LineInd:=1 to LineList.Count do
  with POneLine(LineList.at(LineInd-1))^ do
  begin
    S:=''; if line<>Nil then S:=line^;
    ty:=ty+PrevDesc+Ascent;
    LCharAscent:=Ascent; LCharDescent:=Descent; Llen:=LineLen;
    MoveTo(PaintDC,XShift+IndDepth,ty);
    i:=1; j:=1;
    SetFont(StartingFont); 
    while (i<=length(S)+1) do
    begin
      if (S[i]=OleObjectChar) and (i<length(S)-1) then   { Object }
      begin
        if i-j>0 then OutputText(@S[j],i-j,-1);
        DrawObject(Ord(S[i+1])+256*Ord(S[i+2]),true);
        j:=i+3; i:=j;
      end else if (S[i]=FontChangeChar) and (i<length(S)) then    { font change }
      begin
        if i-j>0 then OutputText(@S[j],i-j,-1);
        SetFont(Ord(S[i+1]));
        j:=i+2; i:=j;
      end else if i>length(S) then
      begin
        OutputText(@S[j],i-j,-1);
        inc(i);
      end else inc(i);
    end;
  end;
end;                         { PrintLineList }

procedure NewPage(jump: boolean);
var
  OldFontInd: integer;
  l: longint;
begin
  if not print then Exit;
  if jump then
  begin
    SelectObject(PaintDC,GetStockObject(System_Font));
    EndPage(PaintDC);
    StartPage(PaintDC);
    SetTextAlign(PaintDC,ta_Baseline+ta_UpdateCP);
    SetMapMode(PaintDC,MM_AnIsotropic);
    with PrinterStats^ do
    begin
      SetWindowExt(PaintDC,Width,Height);
      SetViewportExt(PaintDC,XExtent,YExtent);
    end;
    SetFont(CurrentFont);
  end;
  if PrintPageHeader then
  begin
    OldFontInd:=CurrentFont;
    SetFont(PageHeaderFont);
    l:=GetTextExtent(PaintDC,@bibname^[1],length(bibname^));
    MoveTo(PaintDC,ScreenWidth-LoWord(l)-PrinterStats^.RightMar,
           Fonts^[PageHeaderFont].Ascent);
    TextOut(PaintDC,0,0,@bibname^[1],length(bibname^));
    SetFont(OldFontInd);
  end;
  ty:=YShift; NewLines:=0;
end;                           { NewPage }

procedure PrintOut(txt: string; FontInd: integer; ForceEOL: boolean);
var
  Prefix: string[2];
  OrigTxt: string;
  l: Word;
  OldHeight,OldCAscent,OldCDescent,xp: integer;

procedure PrintLine(var S: string);
var
  i,j,nchars: integer;

procedure AddToRegion;
var
  R1,R2: HRgn;
  y1,x2,y2,xx: integer;
begin
  if Print then Exit;
  R1:=0; R2:=0;
  x2:=xp; y1:=ty-LHeight; y2:=ty+LCharDescent;
  with OpenRegion do
  begin
    if R=0 then
      R:=CreateRectRgn(Xpos,ty-LCharAscent,x2,y2)
    else begin
      R1:=R; xx:=XPos; if xx<Indent*PattIndLen then xx:=Indent*PattIndLen;
      R2:=CreateRectRgn(xx,y1,x2,y2);
      R:=CreateRectRgn(1,1,2,2);
      CombineRgn(R,R1,R2,Rgn_OR);
      DeleteObject(R1); DeleteObject(R2);
    end;
    XPos:=XShift;
  end;
end;                            { AddToRegion }

begin                           { PrintLine }
  SetFont(StartingFont);
  LineList.Insert(New(POneLine,Init(S,LHeight,Llen,LCharAscent,LCharDescent,
                   PrevDescent,StartingFont,Indent*PattIndLen)));
  ty:=ty+PrevDescent+LCharAscent; PrevDescent:=LCharDescent;

  if print and (ty>=ScreenHeight-LCharDescent) then NewPage(true);
  MoveTo(PaintDC,XShift+Indent*PattIndLen,ty);
  xp:=XShift+Indent*PattIndLen;
  i:=1; j:=1;
  while (i<=length(S)+1) do
  begin
    if (S[i]=OleObjectChar) and (i<length(S)-1) then   { Object }
    begin
      if i-j>0 then xp:=OutputText(@S[j],i-j,xp);
      xp:=DrawObject(Ord(S[i+1])+256*Ord(S[i+2]),print);
      j:=i+3; i:=j;
    end else if (i<length(S)) and (S[i]=FontChangeChar)then    { font change }
    begin
      if i-j>0 then xp:=OutputText(@S[j],i-j,xp);
      SetFont(Ord(S[i+1]));
      j:=i+2; i:=j;
    end else if (i<length(S)) and (S[i]=FieldStartChar) and (not OpenRegion.Active) then
    begin                                  { Beginning of field region }
      if i-j>0 then xp:=OutputText(@S[j],i-j,xp);
      with OpenRegion do
      begin
        fld:=Ord(S[i+1])-4;
        Xpos:=xp;
        Baseline:=ty;
        active:=true;
        lnum:=0; R:=0; HyperLink:=-1;
      end;
      j:=i+2; i:=j;
    end else if (i<length(S)-1) and
        (S[i]=HyperStartChar) and (OpenRegion.Active) then
    begin
      OpenRegion.Hyperlink:=Ord(S[i+1])+$100*Ord(S[i+2]);
      j:=i+3; i:=j;
    end else if (i<=length(S)) and (S[i]=FieldEndChar) and (OpenRegion.Active) then
    begin                        { end of field region }
      if (i>1) and (S[i-1]=' ') and (i-j-1>0) then xp:=OutputText(@S[j],i-j-1,xp)
      else if i-j>0 then xp:=OutputText(@S[j],i-j,xp);
      AddToRegion;
      j:=i+1; i:=j;
      with OpenRegion do
      begin
        { FrameRgn(PaintDC,R,GetStockObject(Black_Brush),1,1); }
        ShownList.Insert(New(PFieldRegion,init(fld,R,HyperLink)));
        R:=0;
        Active:=false;
      end;
    end else if (i<=length(S)) and (S[i]=FieldEndChar) then inc(i,2)
    else if i>length(S) then
    begin
      if i>j then xp:=OutputText(@S[j],i-j,xp);
      inc(i);
      if OpenRegion.Active then AddToRegion;
    end else inc(i);
  end;

  S:=''; llen:=0; lheight:=0;
  
  LCharAscent:=Fonts^[CurrentFont].Ascent;
  LCharDescent:=Fonts^[CurrentFont].Descent; 
end;                             { PrintLine }

begin                            { Printout }
  if Fonts^[FontInd].Default then FontInd:=NormalFontInd;
  OldHeight:=Lheight; OldCAscent:=LCharAscent; OldCDescent:=LCharDescent;
  if FontInd<>CurrentFont then
  begin
    SetFont(FontInd); Prefix:=FontChangeChar+Char(FontInd);
  end else Prefix:='';
  if llen=0 then
  begin
    StartingFont:=FontInd; ChrDelL(txt,' ');
  end;
  OrigTxt:=txt;
  if not Verbatim then StrRepl(txt,'~',' ',1,255,255);
  l:=LoWord(GetTextExtent(PaintDC,@txt[1],length(txt)));
  if Fonts^[FontInd].Height>Lheight then
  begin
    Lheight:=Fonts^[FontInd].Height;
    LCharAscent:=Fonts^[FontInd].Ascent;
    LCharDescent:=Fonts^[FontInd].Descent;
  end;
  if (llen=0) or (llen+l<=ScreenWidth-XShift-XShift2-Indent*PattIndLen) then
  begin
    Line^:=line^+Prefix+txt; llen:=llen+l;
    if ForceEOL or (llen>ScreenWidth-XShift-XShift2-Indent*PattIndLen) then
    begin
      PrintLine(line^);
      SetFont(FontInd);
      StartingFont:=FontInd;
    end;
  end else
  begin
    Lheight:=OldHeight;
    LCharAscent:=OldCAscent;
    LCharDescent:=OldCDescent;
    PrintLine(line^);
    SetFont(FontInd); StartingFont:=FontInd;
    txt:=OrigTxt; ChrDelL(txt,' ');
    if not Verbatim then StrRepl(txt,'~',' ',1,255,255);
    l:=LoWord(GetTextExtent(PaintDC,@txt[1],length(txt)));
    line^:=txt;
    llen:=l;
    if txt<>'' then
    begin
      Lheight:=Fonts^[FontInd].Height;
      LCharAscent:=Fonts^[FontInd].Ascent;
      LCharDescent:=Fonts^[FontInd].Descent;
    end;
    if ForceEOL then PrintLine(line^);
  end;
end;                              { Printout }

procedure SetFieldLimits(fld: byte; start: boolean);
begin
  if Start then
  begin
    line^:=line^+FieldStartChar+Char(fld+4);
    CurrentFld:=fld;
  end else
  begin
    line^:=line^+FieldEndChar; CurrentFld:=0;
  end;
end;                              { SetFieldLimits }

procedure StartHyper(HyperInd: integer);
begin
  line^:=line^+HyperStartChar+Chr(LoByte(HyperInd))+Chr(HiByte(HyperInd));
end;

procedure CR(N: integer);
var
  i: integer;
  negative: boolean;
begin
  negative:=false;
  if N<0 then
  begin
    N:=-N; Negative:=true;
  end;
  if (ty=InitialYShift) and (llen=0) and (not negative) then N:=0     { Eat spaces }
  else if (not negative) and (NewLines>0) then
  begin
    N:=N-NewLines; if N<0 then N:=0;
  end;
  if llen>0 then
  begin
    PrintOut('',CurrentFont,true);
  end;
  if N>0 then
  begin
    for i:=1 to N do
    begin
      LineList.Insert(New(POneLine,
                     Init('',Fonts^[CurrentFont].Height,llen,
                     LCharAscent,LCharDescent,PrevDescent,CurrentFont,
                     Indent*PattIndLen)));
      ty:=ty+PrevDescent+Fonts^[CurrentFont].Ascent;
      PrevDescent:=Fonts^[CurrentFont].Descent;
    end;
    if print and (ty>=ScreenHeight-Fonts^[CurrentFont].Descent) then NewPage(true);
    MoveTo(PaintDC,Xshift+Indent*PattIndLen,ty);
  end;
  NewLines:=NewLines+N;
end;                              { CR }

procedure InsertObject(i: integer);
var
  R: TRect;
  OleObj: POleObj;
  DoCR: boolean;
  Hei,Wid: integer;
begin
  OleObj:=POleObj(Objects.at(i));
  GetObjRect(i,R,false);
  Hei:=abs(R.Bottom-R.Top); Wid:=abs(R.Right-R.Left);
  DoCR:=(OleObj^.HAlign<>ObjAlign_Inline);
  if DoCr
     or ((llen>0) and (llen+Wid>ScreenWidth-XShift-XShift2-Indent*PattIndLen))
    then CR(0);
  OleObj^.left:=XShift+llen;  { Record X position }
  if LHeight<Hei then LHeight:=Hei;
  if LCharAscent<-imin(R.top,R.Bottom) then LCharAscent:=-imin(R.top,R.Bottom);
  if LCharDescent<imax(R.Top,R.bottom) then LCharDescent:=imax(R.Top,R.Bottom);
  line^:=line^+OleObjectChar+Chr(LoByte(i))+Chr(HiByte(i));
  llen:=llen+Wid;
  if llen>MaxLineLen then MaxLineLen:=llen;
  NewLines:=0;
  if DoCR then CR(0);
end;                 { InsertObject }

procedure pbig(var s; Slen: Word; KeepCase,EolDisplay,HideBraces: boolean;
               CharCase,CurFont: integer);
var
  ind,l,i,j,k,lline,j1,j2,EolInd,OldInd,Ind2,HyperStart,HyperEnd,BegInd: Word;
  icode,nword,BrDepth,cr_jump,OldCurFont,HyperType,nbr: integer;
  line,tmp: string;
  cut,beg,cr_find,TrailingSpace,ExtraBrace,Math,StrField: boolean;
  HyperOpen,quote,DelayedCloseHyper,process,NoNextSpace: boolean;
  HyperHTML: boolean;
  SS: BigType ABSOLUTE S;
  fld: byte;
  NewS: PChar;
  SSize: word;
  HyperEndChar: char;

procedure OpenHyperRegion(Start,arg1,arg2: word);
begin
  HyperLinks.Insert(new(PHyperLinkObj,init(@SS[arg1],arg2-arg1+1,
            HyperType,Start-1)));
  if fld<>0 then SetFieldLimits(fld,false);    { Close current region          }
  if OldInd>1 then Printout(' ',CurFont,false); EatSpace:=true;
  SetFieldLimits(fld,true);                    { Open hyperlink region         }
  StartHyper(HyperLinks.Count-1);              { Point to the proper hyperlink }
  OldCurFont:=CurFont;
  if Print then CurFont:=PrintHyperFont
  else CurFont:=HyperFont;                     { Change font }
  HyperOpen:=true;
  while (Ind<=SLen) and (SS[Ind]=' ') do inc(Ind);
end;                            { OpenHyperRegion }

function EndOfHyperRegion(var line: string): integer;
var
  j: integer;
begin
  if HyperHTML then
  begin
    j:=Pos('</a>',line);
    if j=0 then j:=Pos('</A>',line);
  end else
  begin
    j:=0; k:=1;
    while (k<=length(line)) and (nbr>0) do
    begin
      if line[k]=lbrace then inc(nbr)
      else if ((nbr>1) and (line[k]=rbrace)) or
              ((nbr=1) and (line[k]=HyperEndChar)) then dec(nbr);
      if nbr>0 then inc(k);
    end;
    if k<=length(line) then j:=k;
  end;
  EndOfHyperRegion:=j;
end;                           { EndOfHyperRegion }

function ResolveObject(pl: Word; IsImage: boolean): boolean;
var
  R: ObjInfoPtr;
  nbr,k,icode: integer;
  j: byte;
  i,IndStart,OrigInd: word;
  tmp2: string;
  O: POleObj;
  pre: string[2];
  o_k,quote,TrailingSpace: boolean;

procedure PutStrg(var P: PChar; var S: string);
begin
  ChrDelL(S,' '); ChrDelR(S,' ');
  if S<>'' then
  begin
    GetMem(P,255); StrPCopy(P,S);
  end;
  S:='';
end;

function PutDimen(var S: string; var res: real): integer;
var
  rtmp,factor: real;
  i: integer;

function GetFact(Ind: integer): boolean;
var
  i: integer;
begin
  GetFact:=false;
  with Units[Ind] do
  begin
    i:=Pos(U,S);
    if i>0 then
    begin
      Delete(S,i,length(U)); ChrDel(S,' '); factor:=f;
      GetFact:=true;
    end;
  end;
end;    { GetFact }

begin   { PutDimen }
  PutDimen:=0;
  if S='' then Exit;
  factor:=100;
  for i:=1 to NUnits do
    if GetFact(i) then PutDimen:=i;
  Val(S,rtmp,i);
  if i=0 then Res:=factor*rtmp;
end;              { PutDimen }

procedure TidyUp;
begin
  if R<>Nil then Dispose(R);
  ResolveObject:=o_k;
  if not o_k then Ind:=OrigInd;
end;

begin               { ResolveObject }
  o_k:=false; OrigInd:=Ind;
  IndStart:=pl-1;
  if IsImage then pl:=pl+length(ImageTeXMacro^)+1
  else pl:=pl+length(ObjectTeXMacro^)+1;
  i:=pl; nbr:=1; O:=Nil; ResolveObject:=false; R:=Nil;

  while (i<=SLen) and (nbr>0) do
  begin
    if SS[i]=lbrace then inc(nbr) else if SS[i]=rbrace then dec(nbr);
    if nbr>0 then inc(i);
  end;
  if (nbr>0) or (i-pl>254) then Exit;   { wrong syntax or too long }

  New(R);
  if (ParseObjectString(@SS[pl],i-pl,R^)=0) then
  begin
    TidyUp; Exit;
  end;

  if LoadObjects then
  begin
    if Parent=Application^.MainWindow then WaitingMessage('Resolving object...');
    New(O,init(@Self,R^.Class,R^.fname,R^.Part,R^.IcoName,IsImage,
               IconizeImages,bibname,Entry^.BinList,Nil));
    if O^.ok and O^.IsGraphic and (O^.IsIconized=ObjIcon_Std) then
    with R^ do
    begin
      Height.Num:=O^.DefHeight; Width.Num:=O^.DefWidth;
    end;
    if O^.ok then   { Valid object }
    begin
      R^.Width.Num:=abs(R^.Width.Num); R^.Height.Num:=abs(R^.Height.Num);
      if (R^.Width.num>0) or (R^.Height.Num>0) then
      begin        { Dimensions, optionally preserving aspect ratio }
        if R^.Width.Num>0 then
        begin
          O^.Width:=R^.Width.Num;
          if R^.Height.Num=0 then
            O^.Height:=O^.Height/O^.DefWidth*O^.Width;
        end;
        if R^.Height.Num>0 then
        begin
          O^.Height:=R^.Height.Num;
          if R^.Width.Num=0 then
            O^.Width:=O^.Width/O^.DefHeight*O^.Height;
        end;
      end;
      O^.HAlign:=R^.HAlign;
      if R^.BaseTop then O^.Base:=-O^.Height
      else if R^.BaseMid then O^.Base:=-O^.Height/2.0
      else if R^.BaseBottom then O^.Base:=0
      else O^.Base:=R^.Base.Num;
      O^.FlipUD:=R^.FlipUD; O^.FlipLR:=R^.FlipLR;
    end;
    Objects.Insert(O);
  end;
  inc(i); Ind:=i; pl:=i;
  if (i<Slen) and (SS[i]='[') then   { Optional second argument, ignore }
  begin
    inc(pl); i:=pl; nbr:=1;
    while (i<=SLen) and (nbr>0) do
    begin
      if SS[i]=lbrace then inc(nbr)
      else if SS[i]=rbrace then dec(nbr)
      else if (nbr=1) and (SS[i]=']') then dec(nbr);
      if nbr>0 then inc(i);
    end;
          { here parse the second argument }
    Ind:=i+1;
  end;
  with POleObj(Objects.at(MyObjectCounter))^ do
  begin
    o_k:=ok;
    StartInd:=IndStart; EndInd:=Ind-1;
  end;
  if o_k and (OldInd>1) then Printout(' ',CurrentFont,false);
  InsertObject(MyObjectCounter);
  inc(MyObjectCounter);
  if o_k then
  begin
    TrailingSpace:=(Ind<=SLen) and (SS[Ind]=' ');
    while (Ind<=Slen) and (SS[Ind]=' ') do inc(Ind);
    if TrailingSpace and (Ind<=SLen) and (OldInd=1) then
       Printout(' ',CurrentFont,false);
  end;
  TidyUp;
end;                 { ResolveObject }

begin                               { pbig }
  Verbatim:=false;
  if (Slen=0) or ((Slen=1) and (SS[1]=EmptyFieldChar)) then Exit;

  if (SLen>1) and (SS[1]='@') and ExpandMacros then    { Macro }
  begin
    NewS:=Nil;
    DecodeAbbrevs(SS[2],SLen-1,NewS,SLen,SSize);
    if NewS<>Nil then
    begin
      ExpandMacros:=false;
      PBig(NewS^,SLen,KeepCase,EolDisplay,HideBraces,CharCase,CurFont);
      FreeMem(NewS,SSize);
      ExpandMacros:=true;
    end;
    Exit;
  end;

  ind:=1; beg:=true; nword:=1; HyperOpen:=false; CurrentHyper:=-1;
  BrDepth:=0; ExtraBrace:=false; Math:=false; NoNextSpace:=false;
  TrailingSpace:=(Slen>0) and (SS[Slen]=' ');
  StrField:=(SS[1]='@');
  fld:=CurrentFld;
  HyperHTML:=false;
  while (ind<=Slen) and (SS[Ind]=' ') do inc(ind);
  while (ind>0) and (ind<=slen) do
  begin
    if NoNextSpace then EatSpace:=true;
    NoNextSpace:=false;
    DelayedCloseHyper:=false; Process:=true;
    OldInd:=Ind;
    TexWordGet(line,S,Slen,Ind); HyperType:=0;
    if ShowPattern then
        { Don't resolve hyperlinks and OLE objects }
    else if ResolveObjects and (line[1]='\')
      and (Copy(line,1,length(ObjectTeXMacro^)+1)=ObjectTeXMacro^+lbrace) then
    begin                     { OLE linked object }
      if ResolveObject(OldInd,false) then process:=false;
    end else if ResolveObjects and (line[1]='\')
      and (Copy(line,1,length(ImageTeXMacro^)+1)=ImageTeXMacro^+lbrace) then
    begin                     { Image }
      if ResolveObject(OldInd,true) then process:=false;
    end else if HyperlinkFlags.on and HyperlinkFlags.LaTeX
       and (not HyperOpen) and (line[1]='\') then
    begin         { LaTeX Macro version of hyperlink }
      j:=1; Verbatim:=false;
      while (j<=NHyperTypes) and (HyperType=0) do
      begin
        if Pos(HyperTypesArr^[j].TeXMacro^+lbrace,line)=1 then HyperType:=j
        else inc(j);
      end;
      if HyperType>0 then  { Identified as a legitimate hyperlink }
      begin
        Ind:=OldInd+length(HyperTypesArr^[j].TeXMacro^)+1; nbr:=1; tmp:='';
        BegInd:=Ind; j:=0; k:=0;
        while (Ind<=Slen) and (nbr>0) do
        begin
          if SS[Ind]=lbrace then inc(nbr)
          else if SS[Ind]=rbrace then dec(nbr);
          if nbr>0 then
          begin
            if j=0 then j:=Ind; k:=Ind;
          end;
          inc(Ind);
        end;
        nbr:=1;
        OpenHyperRegion(OldInd,j,k); process:=false; HyperHTML:=false;
        HyperEndChar:=rbrace;
{        while (Ind<=SLen) and (SS[Ind]=' ') do inc(Ind);}
        if (Ind>SLen) or not (SS[Ind] in [{lbrace,}'[']) then
        begin
          Ind:=BegInd; Verbatim:=true;  { Description = argument }
        end else if Ind<=Slen then
        begin
          if SS[Ind]='[' then HyperEndChar:=']';
          inc(Ind);
        end;
      end;
    end else if HyperlinkFlags.on and HyperlinkFlags.HTML
        and (not HyperOpen) and ((line='<a') or (line='<A')) then
    begin                                    { Open a Hyperlink }
      Ind2:=Ind; Verbatim:=false;
      tmp:='';
      while (ind2<=Slen) and (length(tmp)<=MaxHyperTypeLen)
       and ((tmp='') or (tmp[length(tmp)]<>'=')) do
      begin
        tmp:=tmp+SS[Ind2]; inc(Ind2);
      end;
      if (length(tmp)>1) and (tmp[length(tmp)]='=') then  { Detect hyperlink type }
      begin
        dec(tmp[0]); StrLwr(tmp);
        j:=1;
        while (j<=NHyperTypes) and (HyperType=0) do
        begin
          if tmp=HyperTypesArr^[j].pre^ then HyperType:=j
          else inc(j);
        end;
      end;
      if HyperType>0 then  { Identified as a legitimate hyperlink }
      begin
        Ind:=Ind2;
        while (Ind<=Slen) and (SS[Ind]=' ') do inc(Ind);
        quote:=false; j:=0; k:=0;
        while (ind<=Slen) and (quote or (SS[ind]<>'>')) do
        begin
          if (j=0) and (SS[Ind]<>' ') then j:=Ind;
          if j>0 then k:=Ind;
          if SS[Ind]='"' then Quote:=not Quote;
          inc(Ind);
        end;
        if (j>0) and (k-j>1) and (SS[j]='"') and (SS[k]='"') then
        begin
          inc(j); dec(k);
        end;
        if (Ind<=Slen) and (SS[Ind]='>') then inc(Ind);
        OpenHyperRegion(OldInd,j,k); process:=false; HyperHTML:=true;
      end;
    end;
    if Process and HyperlinkFlags.on and HyperOpen then { Look for end of hyperlink }
    begin
      j:=EndOfHyperRegion(line);
      if j>0 then               { Close a hyperlink }
      begin
        if HyperHTML then k:=4 else k:=1;
        if j=1 then
        begin
          Delete(line,1,k);
          ChrDelL(line,' ');
          if line='' then
          begin
            line:='~'; process:=false;
          end;
          SetFieldLimits(fld,false);   { Close current region }
          CurFont:=OldCurFont; printout('',CurFont,false);  { force font change }
          if (Ind>0) and (Ind<=Slen) and (fld>0) then SetFieldLimits(fld,true);
          CurrentHyper:=-1;
          HyperOpen:=false; NoNextSpace:=true; Verbatim:=false;
        end else
        begin
          line[0]:=Chr(j-1);
          Ind:=OldInd+j+k-1;
          if (Ind<=SLen) and (SS[Ind]<>' ') then NoNextSpace:=true;
          while (Ind<=SLen) and (SS[Ind]=' ') do inc(Ind);
          DelayedCloseHyper:=true;
        end;
        PHyperLinkObj(Hyperlinks.at(Hyperlinks.count-1))^.EndInd:=OldInd+j+k-1;
      end;
    end;
    if Process then
    begin
      if EatSpace then EatSpace:=false
      else if nword>1 then line:=' '+line;
      if (Ind>Slen) and TrailingSpace then line:=line+' ';
      repeat                       { Print and look for CRs }
        tmp:=line;
        cr_jump:=0; cr_find:=false; EolInd:=0; k:=0; j:=0;
        if EolDisplay and not Verbatim then
        while (EolInd=0) and (k<NEolStrings) do
        begin
          inc(k); j:=Pos(EolString[k]^,line);
          if j>0 then
          begin
            EolInd:=k; i:=j; j:=j+length(EolString[EolInd]^);
          end;
        end;
        if (EolInd>0) and ((j>length(line)) or
           ((j<=length(line)) and (line[j] in [' ',lbrace,'[','\','~']))) then
        begin
          j2:=0;
          if (j>length(line)) or (line[j] in ['\','~']) then
          begin
            cr_find:=true; j2:=j-1;
          end else if line[j]=' ' then
          begin
            cr_find:=true; j2:=j; 
          end else if line[j]=lbrace then
          begin
            cr_find:=true;
            j2:=ChrPosX(line,rbrace,j+1);
            if j2>j+1 then
            begin
              icode:=0;
              val(Copy(line,j+1,j2-j-1),cr_jump,icode);
              if icode>0 then cr_jump:=0;
            end else if j2<j then j2:=j;
          end else if line[j]='[' then
          begin
            cr_find:=true;
            j2:=ChrPosX(line,']',j+1);
            if j2<j then j2:=j;
          end;
          Delete(line,1,j2-i+1);
          if i=1 then tmp:=''
          else begin
            StrCut(tmp,i-1); cut:=true;
          end;
          Delete(line,1,length(tmp));
          if (length(line)>0) and (line[1]=' ') then Delete(line,1,1);
          ChrDelR(tmp,' ');
        end else line:='';
        if not KeepCase then
        begin
          if CharCase=-2 then StrUpr(tmp)
          else if CharCase=-3 then StrLwr(tmp);
        end;
        if HideBraces and not StrField then StripBraces(tmp,BrDepth,ExtraBrace,Math);
        PrintOut(tmp,CurFont,false);
        if cr_find then CR(cr_jump);
        if DelayedCloseHyper then
        begin
          SetFieldLimits(fld,false);   { Close current region }
          CurFont:=OldCurFont; printout('',CurFont,false); { force font change }
          if (Ind>0) and (Ind<=Slen) and (fld>0) then SetFieldLimits(fld,true);
          CurrentHyper:=-1;
          HyperOpen:=false; Verbatim:=false;
        end;
      until line='';
      inc(nword);
    end;
    while (ind<=Slen) and (SS[Ind]=' ') do inc(ind);
  end;
  EatSpace:=false; NewLines:=0; CurrentHyper:=-1;
end;                                 { pbig }

procedure PaintEntry;
var
  line,tmp: string;
  i,j,k,level,si,nbr,CharCase,CurFont,etype: integer;
  ch: char;
  Eval, LastEval, Exists, FoundEnd, IsIgnored: boolean;
  Attrib: array[1..100] of integer;
  FileDrive: string[1];
  FilePath,FileName,FileExt: Pstring;
  PFields: PFieldArr;

procedure prchar(ch: char);
var
  S: string[1];
begin                               { prchar }
  S:=ch;
  Printout(S,CurFont,false);
  NewLines:=0;
end;                                 { prchar }

procedure PrString(s: string; KeepCase,HideBraces: boolean);
begin
  if not ((S='') or (S=EmptyFieldChar)) then
    Pbig(S[1],length(S),KeepCase,EolDisplay,HideBraces,CharCase,CurFont);
  NewLines:=0;
end;

procedure emph(s: string; KeepCase: boolean);
var
  OldFont: integer;
begin
  OldFont:=CurFont; CurFont:=BoldFontInd;
  PrString(s,KeepCase,false);
  CurFont:=OldFont;
end;

function GetShowFormat(i: integer; first: boolean): char;
begin                            { GetShowFormat }
  if (i<1) or (i>ShowFormat[first].len) then 
    GetShowFormat:=#0
  else
    GetShowFormat:=ShowFormat[first].p^[i];
end;                                 { GetShowFormat }

begin                                { PaintEntry }
  AllocStrings(true,@FilePath,@FileName,@FileExt,Nil);
  LFNFsplit(bibname^,FilePath,FileName,FileExt);
  FileDrive:=FilePath^[1]; Delete(FilePath^,1,2);
  if (FileExt^<>'') and (FileExt^[1]='.') then Delete(FileExt^,1,1);
  if Print and not EditOnlyStrings then PFields:=PrintingFields
  else PFields:=Nil;

  si:=0;
  nbr:=1; CharCase:=-1; FoundEnd:=false;
  CurFont:=NormalFontInd; CurrentHyper:=-1; CurrentFld:=0;
  etype:=FindInETypeList(Entry^.EntryType);
  repeat
    repeat
      inc(si);
    until (si=ShowFormat[FirstShowBuf].len) or
          (GetShowFormat(si,FirstShowBuf)<>sf_NOP);
    ch:=GetShowFormat(si,FirstShowBuf);
    if ch=sf_BF then                  { begin \bf }
    begin
      Attrib[nbr]:=CurFont;
      inc(nbr);
      CurFont:=BoldFontInd;
    end else if ch=sf_Color then      { begin \color }
    begin
      Attrib[nbr]:=CurFont;
      inc(nbr);
      CurFont:=Ord(GetShowFormat(si+1,FirstShowBuf))+FontShift;
      Inc(si); Inc(si);
    end else if ch=sf_UpCase then     { begin \uc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-2;
    end else if ch=sf_DnCase then     { begin \lc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-3;
    end else if ch=sf_DefCase then    { begin \dc }
    begin
      Attrib[nbr]:=CharCase;
      inc(nbr);
      CharCase:=-1;
    end else if ch=sf_EndAtt then     { end attribute }
    begin
      dec(nbr);
      if Attrib[nbr]>0 then CurFont:=Attrib[nbr]
      else CharCase:=Attrib[nbr];
    end else if ch=sf_CR then                   { \cr }
    begin
      inc(si);
      CR(ShortInt(Ord(GetShowFormat(si,FirstShowBuf))));
    end else if ch=sf_FF then                  { \ff }
    begin
      if print then
      begin
        CR(0); NewPage(true);
      end;
    end else if (ch=sf_IF) or (ch=sf_ElseIf) then  { \if and \elseif }
    begin
      inc(si); tmp:='';
      while GetShowFormat(si,FirstShowBuf)<>sf_EndIf do
      begin
        if GetShowFormat(si,FirstShowBuf)<>sf_NOP then
           PStrCat(tmp,GetShowFormat(si,FirstShowBuf),255);
        inc(si);
      end;
      if (ch=sf_If) then   {\if}
      begin
        if EvalCondition(Entry,tmp,false,print,PFields) then
        begin
          LastEval:=true;
          inc(nbr);
        end else
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
          LastEval:=false;
        end;
      end else if ch=sf_ElseIf then  {\elseif}
      begin
        if LastEval then
        begin
          repeat
            inc(si);
          until (si>=ShowFormat[FirstShowBuf].len) or
                (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
        end else
        begin
          if EvalCondition(entry,tmp,false,print,PFields) then
          begin
            LastEval:=true;
            inc(nbr);
          end else
          begin
            repeat
              inc(si);
            until (si>=ShowFormat[FirstShowBuf].len) or
                  (Ord(GetShowFormat(si,FirstShowBuf))=sf_EndBrace+1+nbr);
            LastEval:=false;
          end;
        end;
      end;
    end else if Ord(ch)>sf_EndBrace then  {close of good \if}
    begin
      dec(nbr);
      LastEval:=true;
    end else if ch=sf_FldName then   { The (possibly alternate) field name }
    begin
      inc(si); j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
      if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^
      else begin
        tmp:=TypeField^[j]; tmp[1]:=UpCase(tmp[1]);
      end;
      PrString(tmp,false,false);
    end else if ch in [sf_Field,sf_Field1,sf_Field2,sf_Field3] then   { fields }
    begin
      inc(si); Exists:=false;
      if GetShowFormat(si,FirstShowBuf)=sfFld_Name then   { Name }
        Exists:=(entry^.name<>'')
      else if GetShowFormat(si,FirstShowBuf) in
        [sfFld_flFull,sfFld_flDrive,sfFld_flPath,sfFld_flName,sfFld_flExt,sfFld_Type]
          then Exists:=true                               { file name components, Type }
      else begin                                          { Field name }
        j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
        Exists:=((j=StringIndex) or (j<=Entry^.LastField)) and
                (entry^.index[j]>0) and
                ((PFields=Nil) or EditOnlyStrings or PFields^[j]);
        if (not Exists) and (not FirstShowBuf) and (etype>0) and (Entry^.nentry>0) then
          Exists:=(Pos(chr(j),Pstring(@required^[etype])^)>0)
             or (Pos(chr(byte(-j)),Pstring(@required^[etype])^)>0);
      end;
      if Exists then
      begin
        if (ch in [sf_Field1,sf_Field3])  then CR(0);    { \cr(0) }
        if ch=sf_Field3 then CR(1);               { \cr(1) }
        if GetShowFormat(si,FirstShowBuf)=sfFld_flFull then     { Full file path }
        begin
          if ch<>sf_Field then emph('File: ',true);
          PrString(bibname^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flDrive then { File drive }
        begin
          if ch<>sf_Field then emph('File drive: ',true);
          PrString(FileDrive,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flPath then  { File path }
        begin
          if ch<>sf_Field then emph('File path: ',true);
          PrString(FilePath^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flName then  { File name }
        begin
          if ch<>sf_Field then emph('File name: ',true);
          PrString(FileName^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_flExt then   { File extension }
        begin
          if ch<>sf_Field then emph('File extension: ',true);
          PrString(FileExt^,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Name then    { Entry Name }
        begin
          if ch<>sf_Field then emph('Entry name: ',true);
          PrString(Entry^.name,false,false);
        end else if GetShowFormat(si,FirstShowBuf)=sfFld_Type then    { Entry Type }
        begin
          if ch<>sf_Field then emph('Entry type: ',true);
          tmp:=Entry^.EntryType; tmp[1]:=UpCase(tmp[1]);
          PrString(tmp,false,false);
        end else                                                { A field }
        begin
          j:=Ord(GetShowFormat(si,FirstShowBuf))-sfFld_Offset;
          SetFieldLimits(j,true);
          isIgnored:=true;
          for k:=1 to required^[etype,0] do
            if j=abs(required^[etype,k]) then IsIgnored:=false;

          k:=entry^.index[j];
          if ch<>sf_Field then
          begin
            {if k>0 then tmp:=entry^.field[k]+': '
            else}
            if FieldParams^[j].AltName<>Nil then tmp:=FieldParams^[j].AltName^+': '
            else begin
              tmp:=TypeField^[j]+': '; tmp[1]:=UpCase(tmp[1]);
            end;
            emph(tmp,true);
          end;
          if k>0 then
          begin
            if entry^.BigIndex[j]=0 then
              PrString(entry^.content[k],false,not IsIgnored)
            else
              Pbig(entry^.Big[entry^.BigIndex[j]]^,entry^.Blen[entry^.Bigindex[j]],
                   false,EolDisplay,not IsIgnored,CharCase,CurFont);
          end;
          SetFieldLimits(j,false);
        end;
        if (ch in [sf_Field1,sf_Field3]) then CR(0);    { \cr(0) }
      end;
    end else if ch=sf_EOL then CR(0)     { Explicit CR }
    else if ch=sf_Quote then               { ASCII char }
    begin
      inc(si); prchar(GetShowFormat(si,FirstShowBuf));
    end else if (ch=sf_END) {and LastEval} then FoundEnd:=true
    else if (ch<>sf_NOP) then   { Characters in the ShowFormat }
    begin
      if ch=' ' then
      begin
        prchar(ch); inc(si);
      end;
      i:=si;
      while (i<ShowFormat[FirstShowBuf].len) and
            (GetShowFormat(i,FirstShowBuf)>=' ') and
            (Ord(GetShowFormat(i,FirstShowBuf))<sf_EndBrace) do inc(i);
      dec(i);
      Pbig(ShowFormat[FirstShowBuf].p^[si],i-si+1,false,EolDisplay,false,
              CharCase,CurFont);
      si:=i;
    end;
    
  until (si>=ShowFormat[FirstShowBuf].len) or (nbr<1) or (FoundEnd);
  CR(0);
  AllocStrings(false,@FilePath,@FileName,@FileExt,Nil);
end;                                   { PaintEntry }

procedure PaintPattern;
var
  tmp: string;
  i,j,strt,indlen: integer;
  plus: string[4];
  CaseSen,RegExp,NewReg,NewCase,Started: boolean;
  CurFont: integer;

procedure swrite(S: string);
begin
  Pbig(S[1],length(S),true,false,false,0,CurFont);
end;

begin                          { PaintPattern }
  if Pattern=Nil then Exit;
  indent:=0; Started:=false;
  CaseSen:=false; RegExp:=false;
  CurFont:=PattFieldFont;
  SetFont(CurFont); StartingFont:=CurrentFont;
  CurrentHyper:=-1; CurrentFld:=0;
  with Pattern^ do
  begin
    for i:=1 to noper do
    begin
      SetFieldLimits(i,true);
      if operation[i]>0 then
      begin
        if Started then inc(indent)
        else Started:=true;
        CurFont:=PattFieldFont;
        if field[operation[i]]=PattField_Tagged then             { Tagged entries }
          swrite(PattStr_Tagged)
        else if field[operation[i]]=PattField_Type then         { Type }
        begin
          swrite(PattStr_Type+': ');
          CurFont:=PattTextFont; swrite('"');
          tmp:=patrn[operation[i]];
          j:=1;
          while j<=length(tmp) do
            if (tmp[j]=#0) or (Ord(tmp[j])>StringTypeInd) then delete(tmp,j,1)
            else inc(j);
          for j:=1 to length(tmp) do
            if j<length(tmp) then swrite(TypeEntry^[Ord(tmp[j])]+' or ')
            else                  swrite(TypeEntry^[Ord(tmp[j])]);
          EatSpace:=true; swrite('"');
        end else
        begin
          { Case and regexp }
          NewCase:=(flag[i] and PattFlag_CaseSen)<>0;
          NewReg :=(flag[i] and PattFlag_Regexp) <>0;
          if (NewCase<>CaseSen) and (NewReg<>RegExp) then
              swrite(PattCaseStrings[NewCase]+'; '+PattRegStrings[NewReg])
          else if NewCase<>CaseSen then swrite(PattCaseStrings[NewCase])
          else if NewReg<>RegExp then swrite(PattRegStrings[NewReg]);
          if (NewCase<>CaseSen) or (NewReg<>RegExp) then CR(0);
          CaseSen:=NewCase; Regexp:=NewReg;
          { List of fields }
          plus:='';
          if length(field[operation[i]])>OrigFieldLast+1 then
            swrite(PattStr_All+': ')
          else begin
            for j:=1 to length(field[operation[i]]) do
            begin
              if field[operation[i],j]=PattField_Name then        { Name }
                swrite(plus+PattStr_Name)
              else if field[operation[i],j]=PattField_Undec then  { Undeclared }
                swrite(plus+PattStr_Undec)
              else if (Ord(field[operation[i],j])<=fieldlast) or
                      (ord(field[operation[i],j])=StringIndex) then
                swrite(plus+TypeField^[ord(field[operation[i],j])]);
              plus:='+';
            end;
            EatSpace:=true; swrite(': '); EatSpace:=true;
          end;
          CurFont:=PattTextFont;
          swrite('"');
          swrite(patrn[operation[i]]);
          EatSpace:=true; swrite('"');
        end;
      end else
      begin
        CurFont:=PattOpFont;
        if operation[i]=Patt_OR              then swrite('+')
        else if operation[i]=Patt_AND        then swrite('*');
        dec(indent);
      end;
      if (flag[i] and PattFlag_NOT)<>0 then
      begin
        CR(0); CurFont:=PattOpFont;
        swrite(' ^');
      end;
      SetFieldLimits(i,false);
      CR(0);
    end;
  end;
  CR(0);
end;                              { PaintPattern }

procedure PrintHeader;
var
  tmp: Pstring;
  X0,X,Down: word;
  Rect: TRect;
begin
  if ty<YShift then ty:=YShift;
  if ty>YShift then
  begin
    ty:=ty+MulDiv(EntrySeparation,7200,254);
    MoveTo(PaintDC,XShift,ty);
  end;
  if PrintEntryHeader then
  begin
    SetFont(PrintLabelFont);
    New(tmp);
    tmp^:=Entry^.EntryType; StrUpr(tmp^); tmp^:=tmp^+': '+Entry^.name;
    X0:=LoWord(GetCurrentPosition(PaintDC));
    PrintOut(tmp^,PrintLabelFont,true);
    X:=LoWord(GetTextExtent(PaintDC,@tmp^[1],length(tmp^)));
    Dispose(tmp);
    CR(0);
    SetFont(PrintNormalFont);
    Down:=Fonts^[PrintNormalFont].Height-Fonts^[PrintNormalFont].Ascent;
    ty:=ty+Fonts^[PrintLabelFont].Descent+Down;
    SetRect(Rect,X0,ty,X0+X,ty+10);
{    with rect do message(num2str(left)+','+num2str(right)+','+num2str(top)
       +','+num2str(bottom)); }
    FillRect(PaintDC,Rect,GetStockObject(Black_Brush));
    ty:=ty+Down;
    MoveTo(PaintDc,XShift,ty);
  end;
end;                        { PrintHeader }

var
  XExt,XRes,YExt,YRes,Down,SavedDC: integer;
  CRect: TRect;
  WasWaiting: boolean;

begin                             { TDisplayArea.PaintIt }
  if Entry=Nil then Exit;
  WasWaiting:=AmWaiting;
  SavedDC:=SaveDC(PaintDC);
  print:=(PrinterStats<>Nil);
  CurrentFont:=0; llen:=0; Lheight:=0; NewLines:=0;
  PrevDescent:=0;
  StartingFont:=0;
  Indent:=0;
  MaxLineLen:=0;
  MyObjectCounter:=0;
  EatSpace:=false;
  OpenRegion.Active:=false; LoadObjects:=false;
  SetBKMode(PaintDC,Transparent);
  SetTextAlign(PaintDC,ta_Baseline+ta_UpdateCP);

  ObjRects.FreeAll;
  GetMem(S,256); GetMem(S2,256); New(line); line^:='';

  if print then
  begin
    NormalFontInd:=PrintNormalFont; BoldFontInd:=PrintBoldFont;
    FontShift:=PrintNormalFont-NormalFont;
    with PrinterStats^ do
    begin
      ScreenWidth:=Width;
      ScreenHeight:=Height-BottomMar;
      XShift:=LeftMar;
      XShift2:=RightMar;
      YShift:=TopMar;
      ty:=YPos; if ty<YShift then ty:=YShift;
    end;
    InitialYShift:=ty;
    Objects.FreeAll; LoadObjects:=true;

    Down:=0;
    SetFont(NormalFontInd);
    line^:='MX';
    Units[EmUnit].F:=LoWord(GetTextExtent(PaintDC,@line^[1],1));
    Units[ExUnit].F:=HiWord(GetTextExtent(PaintDC,@line^[2],1));
    line^:='';
    if ty>YShift then
    begin
      if EntrySeparation<0 then
      begin
        NewPage(true); SetFont(NormalFontInd);
      end else Down:=MulDiv(EntrySeparation,7200,254);
    end;
    if PrintEntryHeader then
    begin
      SetFont(PrintLabelFont);
      Down:=Down+Fonts^[PrintLabelFont].Height+Fonts^[PrintLabelFont].Descent
                      +2*(Fonts^[NormalFontInd].Height-Fonts^[NormalFontInd].Ascent);
    end;
    i:=Fonts^[NormalFontInd].Height;
    if not EditOnlyStrings then i:=i*2;
    if PrinterStats^.FirstTime then NewPage(false)
    else if ty>ScreenHeight-Down-i then NewPage(true);
    MoveTo(PaintDC,XShift,ty);

    Printheader;
    PaintEntry;

    PrinterStats^.YPos:=ty;
    PrinterStats^.FirstTime:=false;
  end else
  begin
    XShift:=XShiftDef; XShift2:=XShift;
    YShift:=YShiftDef;
    SetMapMode(PaintDC,mm_Text);
    GetClientRect(HWindow,CRect);
    ScreenWidth:=CRect.right-CRect.left;
    ScreenHeight:=-1;
    NormalFontInd:=NormalFont; BoldFontInd:=BoldFont; FontShift:=0;

    if ShowPattern then SetFont(PattFieldFont)
    else SetFont(NormalFontInd);
    line^:='MX';
    Units[EmUnit].F:=LoWord(GetTextExtent(PaintDC,@line^[1],1));
    Units[ExUnit].F:=HiWord(GetTextExtent(PaintDC,@line^[2],1));
    line^:='';
    ty:=YShift+Fonts^[NormalFontInd].Descent;
    InitialYShift:=ty;
    MoveTo(PaintDC,XShift+Indent*PattIndLen,ty);

    if (OldDimensions.right<>CRect.right) or (OldDimensions.bottom<>CRect.bottom)
       or UpdateEntry then
    begin
      ShownList.FreeAll;
      LineList.FreeAll;
      Hyperlinks.FreeAll;
      if UpdateEntry then Objects.FreeAll;
      LoadObjects:=UpdateEntry;
      if ShowPattern then
      begin
        PaintPattern;
        Scroller^.Yunit:=Fonts^[PattFieldFont].height;
      end else
      begin
        PaintEntry;
        if OpenRegion.active then DeleteObject(OpenRegion.R);
        Scroller^.Yunit:=Fonts^[NormalFontInd].height;
      end;
      Scroller^.SetRange((MaxLineLen-CRect.right) div Scroller^.XUnit,
                       ((ty-CRect.bottom) div Scroller^.Yunit)+2);
      InvalidateRect(Hwindow,Nil,true);
    end else
    begin
      PrintLineList;
    end;
    LastY:=ty;
    OldDimensions:=CRect; UpdateEntry:=false;
    if FirstTime and (CaretInd>=0) then
    begin
      FirstTime:=false;
      DefCaretHeight:=Fonts^[CurrentFont].Height;
      CanUseCaret:=true;
      CaretMove(CaretInd,true);
    end;
    FirstTime:=false;
  end;
  SelectObject(PaintDC,GetStockObject(System_Font));
  RestoreDC(PaintDC,SavedDC);
  Dispose(line); FreeMem(S2,256); FreeMem(S,256);
  if (Parent=Application^.MainWindow) and not WasWaiting then WaitingOff;
end;                             { TDisplayArea.PaintIt }

procedure TDisplayArea.CaretRestore;
begin
  if CanUseCaret and not CaretIsActive then
  begin
    CaretMove(CaretInd,false);
    CaretIsActive:=true;
  end;
end;

procedure TDisplayArea.CaretDestroy;
begin
  if CaretIsActive then
  begin
    DestroyCaret;
    CaretIsActive:=false;
  end;
end;

procedure TDisplayArea.CaretVisible;
var
  x,y0,y1,WHeight,WWidth: integer;
  Rect: TRect;
  moved,ScrollX: boolean;
  XTo: longint;
begin
  if not (CanUseCaret and CaretIsActive) then Exit;
  GetClientRect(HWindow,Rect);
  WHeight:=Rect.bottom-Rect.top;
  Wwidth:=Rect.right-rect.left;
  moved:=false; ScrollX:=false;
  x :=CaretPos.X-Scroller^.XPos*Scroller^.XUnit;
  if (x>0) and (x<Wwidth) then XTo:=Scroller^.XPos
  else begin
    XTo:=(CaretPos.X+Wwidth div 2) div Scroller^.XUnit;
    if XTo>Scroller^.XRange then XTo:=Scroller^.XRange;
    ScrollX:=true;
  end;
  y0:=CaretPos.Y-Scroller^.YPos*Scroller^.YUnit;
  y1:=y0 + CaretHeight;
  if (y0<0) or ((y1>Wheight) and (CaretHeight>=WHeight)) then
  begin
    Scroller^.ScrollTo(XTo, CaretPos.Y div Scroller^.YUnit);
    Moved:=true;
  end else if y1>WHeight then
  begin
    Scroller^.ScrollTo(XTo, (CaretPos.Y+CaretHeight+Scroller^.YUnit-WHeight)
           div Scroller^.YUnit);
    Moved:=true;
  end else if ScrollX then
  begin
    Scroller^.ScrollTo(XTo,Scroller^.YPos); Moved:=true;
  end;
end;                        { TDisplayArea.CaretVisible }

procedure TDisplayArea.CaretMove(Ind: integer; visible: boolean);
var
  Rect: TRect;
  OldHeight: integer;
begin
  if not CanUseCaret then Exit;
  CaretInd:=Ind;
  if CaretInd<0 then CaretInd:=0;
  if CaretInd>ShownList.Count then CaretInd:=ShownList.Count;
  OldHeight:=CaretHeight;
  if CaretInd<ShownList.Count then
  begin
    GetRgnBox(PFieldRegion(ShownList.at(CaretInd))^.R,Rect);
    CaretPos.X:=Rect.left;
    CaretPos.Y:=Rect.top;
    CaretHeight:=Rect.bottom-Rect.top;
  end else
  begin
    if CaretInd=0 then CaretPos.Y:=0
    else begin
      GetRgnBox(PFieldRegion(ShownList.at(ShownList.Count-1))^.R,Rect);
      CaretPos.Y:=Rect.bottom+1;
    end;
    CaretPos.X:=Indent*PattIndLen; if CaretPos.X<4 then CaretPos.X:=4;
    CaretHeight:=DefCaretHeight;
  end;
  if Visible then CaretVisible;
  if not CaretIsActive then
  begin
    CreateCaret(HWindow,0,0,CaretHeight);
    CaretIsActive:=true;
  end else if Caretheight<>OldHeight then
  begin
    DestroyCaret;
    CreateCaret(HWindow,0,0,CaretHeight);
  end;
  SetCaretPos(CaretPos.X,CaretPos.Y-Scroller^.yPos*Scroller^.YUnit);
  ShowCaret(Hwindow);
end;                        { TDisplayArea.CaretMove }

procedure TDisplayArea.ButtonDown(btn: word; var Msg: TMessage);
var
  i,j,k: integer;
  P: TPoint;
begin
  i:=0; j:=-1;
  P.x:=Msg.LParamLo+Scroller^.Xpos*Scroller^.Xunit;
  P.y:=Msg.LparamHi+Scroller^.Ypos*Scroller^.Yunit;
  with ShownList do
  while (i<Count) and (j=-1) do
  begin
    if PtInRegion(PFieldRegion(at(i))^.R,P.x,P.y) then
    begin
      j:=i; PFieldRegion(at(i))^.Obj:=-1;
      k:=0;
      while (k<ObjRects.Count) and (PFieldRegion(at(i))^.Obj=-1) do
      begin
        if PtInRect(PObjRect(ObjRects.at(k))^.R,P) then
           PFieldRegion(at(i))^.Obj:=k;
        inc(k);
      end;
    end;
    inc(i);
  end;
  if j<>-1 then
    PostMessage(Parent^.HWindow,bib_ClickedOnField,j,MakeLong(Btn,Msg.wParam));
end;                   { TDisplayArea.ButtonDown }

procedure TDisplayArea.wmLButtonDown(var Msg: TMessage);
begin
  ButtonDown(mk_LButton,Msg);
  TWindow.wmLButtonDown(Msg);
end;

procedure TDisplayArea.wmRButtonDown(var Msg: TMessage);
begin
  ButtonDown(mk_RButton,Msg);
end;

procedure TDisplayArea.wmLButtonDblClk(var Msg: TMessage);
begin
  ButtonDown(mk_MButton,Msg);
end;

procedure TDisplayArea.wmMouseMove(var Msg: Tmessage);
var
  P: TPoint;
  PointedField: PFieldRegion;
  ClrHelpText: boolean;
  ObjInd,k: integer;

function FindMouseRegion(Item: pointer): boolean; far;
begin
  FindMouseRegion:=(PtInRegion(PFieldRegion(Item)^.R,P.x,P.y)<>bool(0));
end;

begin        { TDisplayArea.wmMouseMove }
  P.x:=LoWord(Msg.LParam)+Scroller^.Xpos*Scroller^.Xunit;
  P.y:=HiWord(Msg.Lparam)+Scroller^.Ypos*Scroller^.Yunit;
  PointedField:=ShownList.FirstThat(@FindMouseRegion);
  ClrHelpText:=true;
  if PointedField<>Nil then
  begin
    if (PointedField^.Hyperlink=-1) then
    begin
      k:=0; ObjInd:=-1;
      while (k<ObjRects.Count) and (ObjInd=-1) do
      begin
        if PtInRect(PObjRect(ObjRects.at(k))^.R,P) then ObjInd:=k;
        inc(k);
      end;
      if (ObjInd>-1) and (not POleObj(Objects.at(ObjInd))^.IsGraphic) and
         (POleObj(Objects.at(ObjInd))^.ok) then
      begin
        SetCursor(GuitarCursor);
        HelpBar^.PutHelpStr('play "'+StrPas(POleObj(Objects.at(ObjInd))^.fname)+'"',
          -ObjInd-2);
        ClrHelpText:=false;
      end else SetCursor(FingerCursor);
    end else if not
          PHyperLinkObj(HyperLinks.at(PointedField^.Hyperlink))^.Active then
    begin
      SetCursor(FingerCursor);
      with PHyperLinkObj(HyperLinks.at(PointedField^.Hyperlink))^ do
        HelpBar^.PutHelpStr('(disabled) '+HyperTypesArr^[Ltype].pre^+': "'+Link^+'"',
          -PointedField^.Hyperlink-2);
      ClrHelpText:=false;
    end else
    begin
      SetCursor(HyperCursor); 
      with PHyperLinkObj(HyperLinks.at(PointedField^.Hyperlink))^ do
        HelpBar^.PutHelpStr(HyperTypesArr^[Ltype].pre^+': "'+Link^+'"',
          -PointedField^.Hyperlink-2);
      ClrHelpText:=false;
    end;
  end else SetCursor(ArrowCursor);
  if (HelpBar<>Nil) and ClrHelpText then HelpBar^.ClearHelpText;
end;                           { TDisplayArea.wmMouseMove }

procedure TDisplayArea.BibObjectMsg(var Msg: TMessage);
begin
  if (Msg.wParam=Ole_Changed) and (Objects.Count>0) then
       InvalidateRect(HWindow,nil,true);
{  messagebeep(0);}
end;

destructor TDisplayArea.Done;
begin
  Objects.Done; ObjRects.Done;
  Hyperlinks.Done;
  ShownList.Done;
  LineList.Done;
  TWindow.Done;
end;                  { TDisplayArea.Done }

end.
