program MakeRC;

Uses
   Dos, bibstrg, objects;

Const
  NumRcFiles = 2;
  rcName: array[1..NumRcFiles] of PathStr  =
          ('..\both\strings.rc', '..\both\params.rc');
  IncName: array[1..NumRcFiles] of PathStr =
          ('..\both\rc_strng.pas', '..\both\rc_params.pas');
  ResName = 'rc_strng.drs';
type
  PIndVar = ^TIndVar;
  TIndVar = object(Tobject)
    IdName: Pstring;
    IdVal: word;
    Used: boolean;
    constructor Init(S: String; n: word);
    destructor Done; virtual;
  end;

var
  Ident, Strgs: TCollection;
  rc,inc: Text;
  Res: TResourceFile;
  F: PDosStream;
  StrList: PStrListMaker;
  RStrListMaker: TStreamRec;
  i,j,k,icode,FileInd: integer;
  line,idname,tmp: string;
  ind: byte;
  idval,TotalSize: word;
  P: PIndVar;
  ShowUnused: boolean;

constructor TIndVar.Init(S: string; n: word);
begin
  TObject.init;
  IdName:=NewStr(S);
  IdVal:=n;
  Used:=false;
end;

destructor TIndVar.Done;
begin
  DisposeStr(IdName);
  TObject.done;
end;

{ Main }

function FindID(id: string): word;
var
  Pvar: PIndVar;

function ThisOne(P: Pointer): boolean; far;
begin
  ThisOne:=PIndVar(P)^.IdName^=id;
end;

begin
  PVar:=Ident.FirstThat(@ThisOne);
  if PVar=Nil then
  begin
    writeln('Can''t find identifier "'+id+'"!');
    FindID:=0;
    Halt(1);
  end else
  begin
    FindID:=Pvar^.IdVal;
    PVar^.Used:=true;
  end;
end;
  
procedure FindUnUsed;

procedure DoIt(P: Pointer); far;
begin
  if not PIndVar(P)^.Used then
  writeln('Unused: ',PIndVar(P)^.IdName^,' '#9'(id number ',PIndVar(P)^.idVal,')');
end;

begin
  Ident.ForEach(@DoIt);
end;

procedure StrmErr(var T: TStream); far;
begin
  writeln('Stream error ',T.Status,'!');
  T.Reset;
end;

begin

  ShowUnused:=(ParamStr(1)='/unused');

{ Register the TStrListmaker }
  With RStrListMaker do
  begin
    ObjType := 52;
    VmtLink := Ofs(Typeof(TStrListMaker)^);
    Load    := Nil;
    Store   := @TStrListMaker.Store;
  end;
  RegisterType(RStrListmaker);

{ Identifiers }
  Ident.init(200,100);

  for FileInd:=1 to NumRcFiles do
  begin
    Assign(inc,IncName[FileInd]); reset(inc); line:='';
    Readln(inc,line);
    ChrDelL(line,' '); ChrDelL(line,#9); ChrDelR(line,' '); ChrDelR(line,#9);
    tmp:=line; strlwr(tmp);
    while (tmp<>'implementation') do
    begin
      if Pos('=',line)>0 then
      begin
        ind:=1;
        WrdToken(idname,line,' =;'#9,Ind); StrLwr(idname);
        WrdToken(tmp,line,' =;'#9,Ind);
        Val(tmp,idval,icode);
        if (idname='') or (tmp='') or (Icode<>0) then
        begin
          writeln('Bad line at ',line); Halt(1);
        end;
{        writeln(idname,' = ',idval);}
        Ident.Insert(New(PIndVar,Init(idname,idval)));
      end;
      Readln(inc,line);
      ChrDelL(line,' '); ChrDelL(line,#9); ChrDelR(line,' '); ChrDelR(line,#9);
      tmp:=line; StrLwr(tmp);
    end;
    close(inc);
  end;
  writeln('Read ',Ident.Count,' id elements.');

{ Strings }

  Strgs.Init(200,100); TotalSize:=0;
  for FileInd:=1 to NumRcFiles do
  begin
    Assign(rc,rcName[FileInd]); reset(rc);
    Readln(rc,line);
    ChrDelL(line,' '); ChrDelL(line,#9); ChrDelR(line,' '); ChrDelR(line,#9);
    while (not eof(rc)) and (line<>'END') do
    begin
      if Pos(',',line)>0 then
      begin
        ind:=1;
        WrdToken(idname,line,' ,'#9,Ind); StrLwr(idname);
        Delete(line,1,Ind); Delete(line,length(line),1);
        StrRepl(line,'""','"',1,255,255);
        StrRepl(line,'\042','"',1,255,255);
        StrRepl(line,'\\','\',1,255,255);
        idval:=FindID(idname);
        Strgs.Insert(New(PIndVar,Init(line,idval)));
        TotalSize:=TotalSize+length(line)+1;
      end;
      line:='END';
      Readln(rc,line);
      ChrDelL(line,' '); ChrDelL(line,#9); ChrDelR(line,' '); ChrDelR(line,#9);
    end;
    close(rc);
  end;
  writeln('Read ',Strgs.Count,' strings.');

  if ShowUnused then FindUnused;

{ StrListMaker }

  New(StrList,Init(TotalSize,Strgs.Count));
  for i:=0 to Strgs.Count-1 do
  begin
    P:=PIndVar(Strgs.At(i));
    StrList^.Put(P^.idval,P^.idname^);
  end;
  
{ Resource file }

  StreamError:=@StrmErr;
{
  New(F,Init(ResName,stCreate));
  if F^.status<>stOK then writeln('Error ',F^.status,' opening resource file');
}
  Res.Init(New(PDosStream,Init(ResName,stCreate)));
  Res.Put(StrList,'StringList');
  Res.Done;

{ Cleanup }

  Dispose(StrList,Done);
  Strgs.Done;
  Ident.Done;
end.
