{$N-,E-,V-}

Unit bibsedit;

Interface

uses
  bibwindo, objects, Dos, bibCrt, bibstrg, BibMouse, streams, bibstrm,
  bibvars, bibdisp, bibutil, bib8bit, bibfile, bibwild, bibclip;


procedure PutCursor(x0,y0: integer; var lastx,lasty: integer;
                    var OldAttr: byte; x,y: integer);
Procedure EnterSpecialChar(var ch: char);
procedure ReadEdit(prompt: string; Var S: string; y0,x0,maxlen,linelen: Byte;
                   exclude: CharSet; ALT: string; var accept: boolean;
                   var AltPress: char; MarkText: boolean);
procedure GetAString(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                     exclude: CharSet; var accept: boolean; MarkText: boolean);
procedure GetStringMode(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                        exclude: CharSet; var accept,CaseSen,RegExp: boolean;
                        MarkText: boolean);


Implementation

var
  Last_pl: longint;
  Restore_pl: boolean;

procedure PutCursor(x0,y0: integer; var lastx,lasty: integer;
                    var OldAttr: byte; x,y: integer);
var
  fore,back: byte;
begin
  if HardwareCur then
  begin
    if (lastx>0) and (lasty>0) then TpwAttr(LastY,LastX,1,1,OldAttr);
    GetPixelAttr(x0+x-1,y0+y-1,OldAttr);
    fore:=OldAttr mod 16; back:=OldAttr div 16;
    if fore>7 then fore:=fore-8;
    TpwAttr(y0+y-1,x0+x-1,1,1,Attr(back,fore));
  end else AbsGotoXY(x0+x-1,y0+y-1);
  lastx:=x0+x-1; lasty:=y0+y-1;
end;

procedure ReadEdit(prompt: string; Var S: string; y0,x0,maxlen,linelen: Byte;
                   exclude: CharSet; ALT: string; var accept: boolean;
                   var AltPress: char; MarkText: boolean);
var
  ch,memch: char;
  LeftArr,RightArr,Ent,BS,Home,Eend,Esc,Ins,Cut,Ccopy,Paste: boolean;
  special,Del,changed,insp,btrunc,etrunc,Restore,DelAll : boolean;
  withquote,Tab,BTab,DelW,Help,NoMovement,ShiftHome,ShiftEnd: Boolean;
  InpOutSide,ShiftLeftArr,ShiftRightArr,ChangedMark: boolean;
  i,x,xpro,y,l,pl,lpr : integer;
  xm,ym,mlen,mlen1,mlen2,mlen3,ty,tx,lastmlen,scroll,maxdisp: integer;
  memor,line: string;
  xfirst,att,OldAttr: byte;
  lastx,lasty: integer;
  Slen: word;
  plw: longint;

procedure ShowMarkRegion;
var
  mlen2,mlen3: integer;
begin
  mlen2:=mlen; mlen3:=mlen1;
  if mlen2>mlen3 then
  begin
    mlen2:=mlen1+1; mlen3:=mlen+1;
  end;
  if mlen3>length(S)+1 then mlen3:=length(S)+1;
  mlen2:=mlen2-scroll; mlen3:=mlen3-scroll;
  if mlen2<=0 then mlen2:=1;
  if mlen3>MaxDisp then mlen3:=MaxDisp;
  TpwAttrW(y0,x0+x-1,1,mlen2,DialogNorm);
  TpwAttrW(y0,x0+x-1+mlen2,1,mlen3-mlen2,DialogRev);
  TpwAttrW(y0,x0+x-1+mlen3,1,MaxDisp-mlen3+1,DialogNorm);
end;

procedure EraseMarkRegion;
var
  mlen2,mlen3: integer;
begin
  if mlen=mlen1 then Exit;
  mlen2:=mlen; mlen3:=mlen1;
  if mlen2>mlen3 then
  begin
    mlen2:=mlen1+1; mlen3:=mlen+1;
  end;
  if mlen2<=0 then mlen2:=1;
  if mlen3>length(S)+1 then mlen3:=length(S)+1;
  Delete(S,mlen2,mlen3-mlen2);
  pl:=mlen2; mlen:=pl; mlen1:=pl; ChangedMark:=true;
end;

begin                               { ReadEdit }
  SuspendWaiting(true);
  InpOutSide:=(AltPress=#255); AltPress:=#0;
  memor:=S;
  Ins:=true;
  if prompt<>'' then
  begin
    Tpwprint(y0,x0,prompt,DialogBright); x:=length(prompt);
  end else x:=0;
  y:=1; xpro:=x;
  lastx:=-1; lasty:=-1; OldAttr:=DialogNorm;
  maxdisp:=linelen-x;
  TitleWindow(1,DialogNorm,Concat('[',#254,']'));
  TitleWindow(6,DialogNorm,'[ok]');
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  mlen:=1; mlen1:=1; pl:=1; Scroll:=0;
  if Restore_pl then
  begin
    pl:=Last_pl;
    pl:=imin(MaxLen,Imax(pl,1));
    mlen:=pl; mlen1:=pl;
    scroll:=imax(0,pl-maxdisp);
  end else if MarkText then
  begin
    mlen:=1; mlen1:=length(s)+1;
    pl:=imin(MaxLen,mlen1);
    scroll:=imax(0,pl-maxdisp);
  end;
  line:=Copy(S,scroll+1,255); StrCut(line,MaxDisp);
  Tpwprint(y0,x0+x,line,DialogNorm);
  if MarkText or Restore_pl then ShowMarkRegion;
  PutCursor(x0,y0,lastx,lasty,OldAttr,x+pl-scroll,1);
  special:=true; Accept:=false;
  repeat
    if special then CLB;
    l:=length(S);
    LeftArr:=false; RightArr:=false; ShiftLeftArr:=false; ShiftRightArr:=false;
    Ent:=false; BS:=false; Home:=false; Eend:=false; Insp:=false; Esc:=false;
    Del:=false; Special:=false; changed:=false; Help:=false; ChangedMark:=false;
    btrunc:=false; etrunc:=false; Restore:=false; DelAll:=false;
    Tab:=false; BTab:=false; DelW:=false; ShiftHome:=false; ShiftEnd:=false;
    Cut:=false; Ccopy:=false; Paste:=false;
    if UseMouse then
    begin
      ShowMouseCursor; ShowMouseCursor;
    end;
    if Ins then LineCursor
    else BlockCursor;
    ch:=ReadKeyMouse;
    if (ch=#17) and ([#128..#254]*([#0..#255]-exclude)<>[]) 
      then EnterSpecialChar(ch);
    if UseMouse then HideMouseCursor;
    if Event.mpress then    { Mouse }
    begin
      mlen2:=mlen; mlen3:=mlen1;
      xm:=Event.x-x0; ym:=Event.y+1-y0;
      if ym=1 then
      begin
        mlen1:=(xm-x)+1+scroll;
        if mlen1<0 then mlen1:=0;
        if mlen1>length(s)+1 then mlen1:=length(s)+1;
        mlen:=mlen1; if mlen<1 then mlen:=1;
        PutCursor(x0,y0,lastx,lasty,OldAttr,x+imax(1,imin(maxlen,mlen1)-scroll),1);
      end;
      if Event.Shift or Event.RightButton then   { Extend the selection }
      begin
        if mlen2=mlen3 then mlen:=pl
        else mlen:=mlen2;
        ShowMarkRegion;
      end;
      ShowMouseCursor;
      lastmlen:=mlen;
      if (xm>=1) and (xm<=3) and (ym=0) then
      begin
        Esc:=true; Ent:=true;
        WaitForRelease(255);
      end else if (ym=1) then
      begin
        mlen1:=mlen; NoMovement:=true;
        if mlen2<>mlen3 then ShowMarkRegion;
        repeat
          lastmlen:=mlen1;
          repeat
            xm:=GetMouseX; ym:=GetMouseY;
            xm:=xm div 8+1-x0; ym:=ym div 8+2-y0;
            if (ym=1) then mlen1:=(xm-x)+1+scroll;
            if mlen1<0 then mlen1:=0;
            if mlen1>length(s)+1 then mlen1:=length(s)+1;
          until (mlen1<>lastmlen) or (not ButtonPressed);
          if mlen1<>Lastmlen then
          begin
            ShowMarkRegion; NoMovement:=false;
            PutCursor(x0,y0,lastx,lasty,OldAttr,
                      x+imax(1,imin(mlen1,maxlen)-scroll),1);
          end;
        until not ButtonPressed;
        if NoMovement then
        begin
          mlen:=mlen1; ShowMarkRegion;
        end;
        if (mlen=0) and (mlen1=0) then
        begin
          mlen:=1; mlen1:=1;
        end;
        pl:=mlen1;
      end else if (ym=1) and (xm=xpro-1) then Home:=true
      else if (ym=1) and (xm=linelen) then Eend:=true
      else begin
        if (xm>0) and (ym>1) then
        begin
          line:='';
          ReadScrStr(line,xm+x0,ym+y0-1,xfirst,att,['[','o','k',']'] );
          if line='[ok]' then Ent:=true
          else if InpOutSide then AltPress:=#255;
        end;
      end;
      WaitForRelease(255);
      HideMouseCursor;
    end else if ch=#0 then
    begin
      ch:=ReadKey;
      if InpOutSide and (ALT<>'') then
      begin
        AltChars(AltPress,ch,ALT);
      end;
      if Event.Shift then
      begin
        ShiftLeftArr:=(ch=#75);  ShiftRightArr:=(ch=#77);
        ShiftHome:=(ch=#71);     ShiftEnd:=(ch=#79);
        Cut:=(ch=#83);
        Paste:=(ch=#82);
      end else
      begin
        LeftArr:=(ch=#75);  RightArr:=(ch=#77);
        Home:=(ch=#71);     Eend:=(ch=#79);
        Del:=(ch=#83);
        Insp:=(ch=#82);
      end;
      Btrunc:=(ch=#119);  Etrunc:=(ch=#117);
      BTab:=(ch=#15);
      Help:=(ch=#59);
      DelAll:=(ch=#147);
      Ccopy:=(ch=#146);
      Special:=true;
    end else
    begin
      Ent:=(ch=#13); BS:=(ch=#8);
      Esc:=(ch=#27);
      Restore:=(ch=#19);
      Tab:=(ch=#9);
      DelW:=(ch=#23);
      Cut:=(ch=#24);
      Ccopy:=(ch=#3);
      Paste:=(ch=#22);
      Btrunc:=(ch=#21);
      Etrunc:=(ch=#11);
    end;
    special:=special or Ent or BS or Event.mpress or Restore or Tab or DelW
             or DelAll or Esc or Cut or Ccopy or Paste or Btrunc or Etrunc;
    if RightArr or LeftArr or Home or Eend or Tab or BTab or BS
       or DelAll or Etrunc or Btrunc then
    begin                      { Clear mark region }
      if mlen<>mlen1 then
      begin
        pl:=mlen1;
        ChangedMark:=true;
        mlen1:=pl; mlen:=pl;
        PutCursor(x0,y0,lastx,lasty,OldAttr,x+imax(1,imin(pl,MaxLen))-scroll,y);
      end;
    end;
    if (AltPress=#0) and (not special) then
    begin
      if not (ch in exclude) then
      begin
        EraseMarkRegion;
        if Ins then
        begin
          StrIns(S,ch,pl,maxlen);
        end else begin
          if l<maxlen then
          begin
            if pl>length(S) then S:=Concat(S,ch)
            else S[pl]:=ch;
          end else S[maxlen]:=ch;
        end;
        changed:=true;
        if pl<maxlen then pl:=pl+1;
      end;
    end else if DelAll then S:=''
    else if Help then ContextHelp('Edit String')
    else if Restore or Esc then S:=memor
    else if Del then
    begin
      if mlen<>mlen1 then EraseMarkRegion
      else Delete(S,pl,1);
    end else if DelW and (mlen=mlen1) then
    begin
      if pl<=length(S) then
      begin
        delete(S,pl,1);
        while (length(S)>pl) and (S[pl]<>' ') do delete(S,pl,1);
        if (length(S)>=pl) and (S[pl]<>' ') then delete(S,pl,1);
      end;
    end else if BS and (pl>1) then
    begin
      pl:=pl-1; Delete(S,pl,1);
    end else if LeftArr then pl:=pl-1
    else if RightArr and (pl<=maxlen) then pl:=pl+1
    else if ShiftLeftArr then
    begin
      dec(mlen1); pl:=mlen1;
    end else if ShiftRightArr then
    begin
      inc(mlen1); pl:=mlen1;
    end else if ShiftHome then mlen1:=0
    else if ShiftEnd then mlen1:=imin(MaxLen,length(S))+1
    else if Tab then
    begin
      while (pl<=length(S)) and (S[pl]<>' ') do Inc(pl);
      while (pl<=length(S)) and (S[pl]=' ') do  Inc(pl);
      while (pl>1) and (S[pl]=' ') do Dec(pl);
    end else if BTab then
    begin
      if (pl=1) or (S[pl]=' ') or (S[pl-1]=' ') then
      begin
        while (pl>1) and (S[pl]<>' ')  do Dec(pl);
        while (pl>1) and (S[pl]=' ')   do Dec(pl);
      end;
      while (pl>1) and (S[pl]<>' ')  do Dec(pl);
      while (pl<length(S)) and (S[pl]=' ') do Inc(pl);
    end else if Home then
    begin
      if pl=scroll+1 then pl:=1
      else pl:=Scroll+1;
      mlen:=pl; mlen1:=pl;
    end else if Eend then
    begin
      if pl=scroll+maxdisp then pl:=length(S)+1
      else pl:=Scroll+maxdisp;
      mlen:=pl; mlen1:=pl;
    end else if Insp then
    begin
      Ins:=not Ins;
    end else if btrunc then
    begin
      PStrCopy(S,S,pl,length(S)-pl+1); scroll:=0; pl:=1;
    end else if etrunc then PStrCopy(S,S,1,pl-1)
    else if (CCopy or Cut) and (mlen1<>mlen) then
    begin
      CopyToBuffer(S[1],mlen,mlen1);
      if cut then
      begin
        if mlen<>mlen1 then EraseMarkRegion
        else Delete(S,pl,1);
        changed:=true; ChangedMark:=true;
      end;
    end else if Paste then
    begin
      Slen:=length(S); plw:=pl;
      PasteFromBuffer(S[1],Slen,plw,mlen,mlen1,MaxLen);
      S[0]:=chr(imin(255,Slen)); pl:=imin(255,plw);
      mlen:=pl; mlen1:=pl;
      changed:=true; ChangedMark:=true;
    end;

    if mlen1<0 then mlen1:=0
    else mlen1:=imin(mlen1,imin(length(S),maxlen)+1);
    if (mlen<>mlen1) and (AltPress=#0) then pl:=mlen1;
    if pl<1 then pl:=1;
    if pl>length(S)+1 then pl:=length(S)+1;
    if pl<=scroll then
    begin
      scroll:=pl-1; changed:=true;
    end else if pl>scroll+maxdisp then
    begin
      scroll:=pl-maxdisp; changed:=true;
    end;
    if ShiftLeftArr or ShiftRightArr or ShiftHome or ShiftEnd
       or ChangedMark then ShowMarkRegion
    else if not (Event.mpress or (AltPress<>#0) or Ccopy) then
    begin
      if pl<1 then pl:=1
      else if pl>length(S)+1 then pl:=length(S)+1;
      pl:=imin(pl,MaxLen);
      mlen:=pl; mlen1:=pl;
    end;

    if changed or (length(S)<>l) then
    begin
      line:=S; if scroll>0 then Delete(line,1,Scroll);
      StrCut(line,maxdisp);
      TpwPrint(y0,x0+x,line,DialogNorm);
      if length(line)<maxdisp then Tpwfill(y0,x0+x+length(line),1,
              maxdisp-length(line),' ',DialogNorm);
      ShowMarkRegion;
    end;  
    PutCursor(x0,y0,lastx,lasty,OldAttr,x+imax(1,imin(pl,MaxLen))-scroll,y);
    l:=length(S);
  until Ent or Esc or (AltPress<>#0);
  Last_pl:=pl;
  Restore_pl:=false;
  CursorOff;
  Accept:=Ent;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  SuspendWaiting(false);
end;             { ReadEdit }

Procedure EnterSpecialChar(var ch: char);
var
  line: string[30];
  ASC,icode: integer;
  accept: boolean;
  AltPress: char;
begin
  Makewindow(10,28,3,21,DialogNorm,DialogNorm,2,RNorm,shadow,1);
  line:=''; AltPress:=#0;
  ReadEdit(' ASCII number ',line,11,29,3,19,[#0..#255]-['0'..'9'],'',
           accept,AltPress,false);
  RemoveWindow;
  if accept then
  begin
    Val(line,ASC,icode);
    if (icode=0) and (Asc>0) and (Asc<255) then ch:=chr(Asc);
  end else ch:=#0;
end;

procedure GetAString(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                     exclude: CharSet; var accept: boolean; MarkText: boolean);
var
  xstart: integer;
  AltPress: char;
begin
  AltPress:=#0;
  if UseMouse then WaitForRelease(255);
  xstart:=(ScrWidth-linelen-2) div 2+1;
  MakeWindow(y0,xstart,3,linelen+2,DialogNorm,DialogNorm,2,RNorm,Shadow,1);
  ReadEdit(prompt,S,y0+1,xstart+1,maxlen,linelen,exclude,'',accept,AltPress,
           MarkText);
  RemoveWindow;
end;

procedure GetStringMode(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                        exclude: CharSet; var accept,CaseSen,RegExp: boolean;
                        MarkText: boolean);
var
  xstart,xm,ym,i: integer;
  line: string;
  AltPress: char;
  xfirst,att: byte;
  first: boolean;
begin
  if UseMouse then WaitForRelease(255);
  xstart:=(ScrWidth-linelen-2) div 2+1;
  first:=true;
  MakeWindow(y0,xstart,3,linelen+2,DialogNorm,DialogNorm,2,RNorm,Shadow,1);
  repeat
    AltPress:=#255; if not first then Restore_pl:=true;
    if CaseSen then line:='[Case on ]' else line:='[Case off]';
    if RegExp then line:=line+#205+'[Regexp on ]'
    else line:=line+#205+'[Regexp off]';
    TitleWindow(4,DialogNorm,line);
    TpwAttr(y0+2,xstart+Pos('C',line)+1,1,1,EditBright);
    TpwAttr(y0+2,xstart+Pos('R',line)+1,1,1,EditBright);
{    if REstore_pl then message(num2str(Last_mlen)+', '+num2str(Last_mlen1));}
    if RegExp then
      ReadEdit(prompt,S,y0+1,xstart+1,maxlen,linelen,
               exclude-RegexpChars,'CR',accept,AltPress,MarkText)
    else
      ReadEdit(prompt,S,y0+1,xstart+1,maxlen,linelen,exclude,'CR',accept,
               AltPress,MarkText);
    MarkText:=false; First:=false;
    if AltPress='C' then CaseSen:=not CaseSen
    else if AltPress='R' then RegExp:=not RegExp
    else if AltPress=#255 then
    begin
      i:=length(line); line:='';
      xm:=Event.x-xstart; ym:=Event.y-y0;
      if (ym=2) and (xm>1) and (xm<i+2) then
          ReadScrStr(line,xm+xstart,ym+y0,xfirst,att,
            ['[','C','a','s','e',' ','o','n','f','R','g','x','p',']'] );
      if (line='[Case on ]') or (line='[Case off]') then
        CaseSen:=not CaseSen
      else if (line='[Regexp on ]') or (line='[Regexp off]') then
        RegExp:=not RegExp;
    end;
  until AltPress=#0;
  RemoveWindow;
end;

begin
  Last_pl:=1;
  Restore_pl:=false;
end.
