{$N-,E-,V-,F+,O+}

Unit bibedit;

Interface

uses
  bibwindo, objects, Dos, bibCrt, bibstrg, BibMouse, streams, bibstrm,
  bibvars, bibdisp, bibutil, bibclip, bib8bit, bibsedit, bibselct;


procedure ReadBig(prompt: string; Var Sin; var Slen: Word;
                  y0,x0,height,linelen: Byte;
                  exclude: CharSet; var modified, retain: boolean;
                  MaxBig: Word;
                  ChooseMode: boolean; var CaseSen,RegExp: boolean;
                  Negate: PBoolean;
                  MarkText,Author: boolean; Title: string);


Implementation


procedure RegChoose(Var memch: Char; Recall,SaveScr: Boolean);
var
  line,spaces: string[255];
  ch,chmore: char;
  leave,Ctrl: Boolean;
  x0,y0,shad: byte;
begin                                { RegChoose }
  if (ScrLen>25) and (ScrWidth>80) then shad:=2
  else shad:=0;
  spaces:='                                                           ';
  if UseMouse then
  begin
    WaitForRelease(255);
    ShowMouseCursor;
    HideMouseCursor;
  end;
  x0:=(ScrWidth div 2)-37;
  if SaveScr then
    MakeWindow(4,x0,20,76,ListNorm,ListNorm,2,ListNorm,shad,0)
  else
    MakeWindowNo(4,x0,20,76,ListNorm,ListNorm,2,ListNorm,shad,0);
  TpwFill(5,x0+38,18,1,#179,ListNorm);
  for ch:='A' to 'R' do
  begin
    line:='';
    TpwPrint(5+Ord(ch)-Ord('A'),x0+1,Concat(ch,':'),ListBright);
    RecallBufferStack(line[0],MemoryPos+Ord(ch)-Ord('A'));
    if line<>'' then
    begin
      line:=line+Spaces; line[0]:=#34;
      TpwPrint(Ord(ch)-Ord('A')+5,x0+4,line,ListNorm);
    end;
  end;
  for ch:='S' to 'Z' do
  begin
    line:='';
    TpwPrint(5+Ord(ch)-Ord('S'),x0+39,Concat(ch,':'),ListBright);
    RecallBufferStack(line[0],MemoryPos+Ord(ch)-Ord('A'));
    if line<>'' then
    begin
      line:=line+Spaces; line[0]:=#33;
      TpwPrint(Ord(ch)-Ord('S')+5,x0+42,line,ListNorm);
    end;
  end;
  for ch:='0' to '9' do
  begin
    line:='';
    TpwPrint(13+Ord(ch)-Ord('0'),x0+39,Concat(ch,':'),ListBright);
    RecallBufferStack(line,MemoryPos+Ord(ch)-Ord('0')+26);
    if line<>'' then
    begin
      line:=line+Spaces; line[0]:=#33;
      TpwPrint(13+Ord(ch)-Ord('0'),x0+42,line,ListNorm);
    end;
  end;
  TitleWindow(1,ListNorm,Concat('[',#254,']'));
  memch:=#0;
  repeat
    leave:=false; Ctrl:=false;
    if UseMouse then ShowMouseCursor;
    ch:=ReadKeyMouse;
    if UseMouse then
    begin
      HideMouseCursor;
      WaitForRelease(255);
    end;
    line:='';
    if Event.mpress then
    begin
      line:='';
      if (Event.x>x0) and (Event.x<x0+75) and (Event.x<>x0+38) and
         (Event.y>4) and (Event.y<23) then
      begin
        if Event.x<x0+38 then ch:=Chr(Ord('A')+Event.y-5)
        else if Event.y<13 then ch:=Chr(Ord('S')+Event.y-5)
        else ch:=Chr(Ord('0')+Event.y-13);
        ch:=UpCase(ch);
        if (ch in ['A'..'Z','0'..'9']) and
           (Event.Ctrl or Event.Shift or Event.RightButton) then Ctrl:=true;
      end else if (Event.y=4) and (Event.x>x0+1) and (Event.x<x0+5) then ch:=#27;
    end else if ch=#0 then
    begin
      ch:=ReadKey;
      if ch=#59 then ContextHelp('Memory Registers')
      else begin
        chmore:=ch;
        AltChars(ch,chmore,'');
        if chmore<>#255 then ch:=#0;
      end;
    end;
    ch:=UpCase(ch);
    if not Ctrl then
    begin
      if ch in [#1..#26] then
      begin
        Ctrl:=true; ch:=Chr(Ord(ch)+Ord('A')-1);
      end else if Event.Ctrl and (ch in ['0'..'9']) then Ctrl:=true;
    end;
    if ch in ['0'..'9','A'..'Z'] then
    begin
      line:='';
      if recall or Ctrl then
      begin
        if ch in ['A'..'Z'] then
          RecallBufferStack(line,MemoryPos+Ord(ch)-Ord('A'))
        else if ch in ['0'..'9'] then
          RecallBufferStack(line,MemoryPos+Ord(ch)-Ord('0')+26);
      end;
      if Ctrl then
      begin
        if line<>'' then message(line);
      end else if not (recall and (line='')) then
      begin
        memch:=ch;
        leave:=true;
      end;
    end else if ch=#27 then leave:=true;
  until leave;
  if ch=#27 then ch:=#0;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  RemoveWindow;
end;                                { RegChoose }

Procedure ReadBig(prompt: string; Var Sin; Var Slen: Word;
                  y0,x0,height,linelen: Byte;
                  exclude: CharSet; var modified, retain: boolean;
                  MaxBig: Word;
                  ChooseMode: boolean; var CaseSen,RegExp: boolean;
                  Negate: PBoolean;
                  MarkText,Author: boolean; Title: string);
var
  S: BigTypePtr;
  ch : char;
  UpArr,DownArr,LeftArr,RightArr,Ent,BS,Home,Eend,Esc,Ins : boolean;
  special,Del,insp,btrunc,etrunc,mpress,ScrBarHit : boolean;
  ShftLeft,ShftRight,ShftUp,ShftDn,NormalClick,changed: boolean;
  memSave,memRecall,Cap,ClrAll,Help,redraw: boolean;
  ScrlUp,ScrlDn,Extend,PgUp,PgDn,Tab,BTab,DelW,DelAll: Boolean;
  withquote,CPgUp,CPgDn,Cut,Ccopy,Paste,LoadFFile: boolean;
  UseScrBar,RXToggle,CaseToggle,ShftHome,ShftEnd,DoNegate: Boolean;
  WasEmpty: boolean;
  mlen,mlen1,mlen2,mlen3,lastmlen,i,Index,pl,curpos: longint;
  LastLine, OldScroll, Scroll, OScroll: LongInt;
  xm,ym,lastx,lasty,ty,tx,MaxClick,XAtEnd,YAtEnd: integer;
  x,y,l,lpr,PromptX,xx,ii,j: longint;
  PasteLen: Word;
  line,tmp,tmp1,space: string;
  xfirst,att,OldAttr: byte;
  memch: char;
  ScrBar: ScrBarType;

Procedure Cput(Var S: BigTypePtr; Var Slen: word; ch: char; pl: longint;
               MaxBig: Word);
begin
  if (pl<=Slen) or (Slen=MaxBig) then S^[pl]:=ch
  else begin
    Inc(Slen); S^[Slen]:=ch;
  end;
end;

procedure Display(Var S: BigTypePtr; Slen,mlen,mlen1,scroll: longint;
                  changed,ClrAll: boolean);
var
  tx,ty,xm,ym,Index: longint;
  a: real;
begin                             { Display }
  if Usemouse then
  begin
    ym:=(GetMouseY div ypixels) + 2;
    if ym-y0>0 then ym:=ym-y0
    else ym:=0;
  end;
  if mlen>mlen1 then
  begin
    Index:=mlen1; mlen1:=mlen+1; mlen:=Index+1;
  end;
  if changed then
  begin
    if Scroll=0 then
    begin
      if UseMouse and (ym=1) then
      begin
        HideMouseCursor;
        Tpwprint(y0,x0,prompt,EditBright);
      end else Tpwprint(y0,x0,prompt,EditBright);
      x:=length(prompt)+1; y:=1; Index:=1;
      PromptX:=x;
    end else
    begin
      index:=(linelen-PromptX+2) + (Scroll-1)*linelen;
      x:=1;
    end;
    tx:=x; ty:=y;
    while (index<=Slen) and (ty<height-1) do
    begin
      if (mlen=mlen1) or (index<mlen) or (index>=mlen1) then
           Tpwprint(y0-1+ty,x0-1+tx,S^[index],EditNorm)
      else
           Tpwprint(y0-1+ty,x0-1+tx,S^[index],EditRev);
      Inc(tx);
      if tx>linelen then
      begin
        tx:=1; Inc(ty);
        if UseMouse then
        begin
          if ty=ym then HideMouseCursor
          else ShowMouseCursor;
        end;
      end;
      Inc(Index);
    end;
    if (tx<=linelen) and (ty<height-1) then
            TpwFill(y0-1+ty,x0-1+tx,1,linelen-tx+1,' ',EditNorm);
    LastX:=-1; LastY:=-1;
  end;
  if ClrAll then
  begin
    if UseMouse then HideMouseCursor;
    if ty<height-2 then Tpwfill(y0+ty,x0,height-2-ty,linelen,' ',EditNorm);
  end;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
  end;
  tx:=(pl+PromptX-2) mod linelen;
  ty:=((pl+PromptX-2) div linelen)-scroll;
  if ty < 0 then
  begin
    pl:=pl-ty*linelen;
  end else if ty > height-3 then pl:=pl-(ty-height+3)*linelen;
  ty:=imin(height-3,imax(ty,0));
  PutCursor(x0,y0,lastx,lasty,OldAttr,tx+1,ty+1);
  if pl>Slen+1 then pl:=Slen+1;
  LastLine:=(Slen+PromptX) div linelen;
  if (Slen+PromptX) mod linelen>0 then Inc(LastLine);
end;                                { Display }

procedure KeepInView(ScrAction: boolean);
var
  i,OScroll,apl: longint;
begin
  if pl<linelen-PromptX then i:=0
  else i:=(pl-(linelen-PromptX+2)) div linelen + 1;
  if ScrAction then
  begin
    if i<Scroll then pl:=pl+(Scroll-i)*linelen
    else if i>=Scroll+height-2 then pl:=pl-(i-(Scroll+height-2)+1)*linelen;
  end else
  begin
    OScroll:=Scroll;
    if i<Scroll then Scroll:=i
    else if i>=Scroll+height-2 then Scroll:=i-(height-2)+1;
    if Scroll<>OScroll then redraw:=true;
    if Scroll>OScroll then ClrAll:=true;
  end;
end;

procedure LoadFromFile(mlen,mlen1: longint);
type
  MarkPosType = record
    ln,charpos,fpos: longint;
  end;
var
  fname: string;
  P: PSafeBufStream;
  Plines: PAuxStream;
  ch: char;
  lens: array[1..MaxScrLen-4] of longint;
  nafter,CurFilePos,xscroll,yscroll,xposit,nlines: longint;
  OldXscroll,OldYscroll,mlen2,mlen3: longint;
  height,width,x0,y0,n,yposit,LastX,LastY: integer;
  line,spaces,tmp: string[MaxScrWidth-4];
  Up,Down,PgUp,PgDn,Home,EEnd,Esc,Help,Enter: boolean;
  MarkStart,MarkEnd,ReDisp,ScrBarHit: boolean;
  Left,Right,CHome,CEnd,Find,Next: boolean;
  Markers: array[boolean] of MarkPosType;
  Start,Finish: MarkPosType;
  ScrBar: ScrBarType;
  FindStr: string;
  OldAttr: byte;

procedure TidyUp;
begin
  if P<>Nil then
  begin
    P^.reset; Dispose(P,Done);
  end;
  if Plines<>Nil then
  begin
    Plines^.reset; Dispose(Plines,Done);
  end;
  P:=Nil; Plines:=Nil;
  WaitingOff;
end;

procedure PrepareFile;
var
  fpos: longint;
  empty,accept: boolean;
begin
  FileChoose(fname,'.txt',TexInputList,
               AnyFile and (not (Directory or SysFile)),true,true,false,
               Nil,'Load from file:','',accept);
  if not accept then Exit;
  EditLoadFile:=fname;
  New(P,Init(fname,stOpenRead,AuxBufSize));
  if (P=Nil) or (P^.status<>stOK) then
  begin
    ErrorMessage(' Couldn''t open file "'+fname+'" for reading! ');
    TidyUp; exit;
  end;
  New(Plines,Init(WorkStreamOrder));
  if (Plines=Nil) or (Plines^.status<>stOK) then
  begin
    ErrorMessage(' Couldn''t build index stream! ');
    TidyUp; exit;
  end;
  P^.seek(0); Plines^.seek(0); Plines^.truncate; nlines:=0;
  WaitingMessage('Reading...');
  repeat
    fpos:=P^.getpos;
    Plines^.write(fpos,sizeof(longint));
    P^.read(ch,1); empty:=true;
    while (P^.status=stOK) and (ch<>#10) do
    begin
      empty:=false; P^.read(ch,1);
    end;
    inc(nlines);
  until (P^.status<>stOK) or (Plines^.status<>stOK);
  if (Plines=Nil) or (Plines^.status<>stOK) then
  begin
    ErrorMessage(' Couldn''t build index stream! ');
    TidyUp; exit;
  end;
  if Empty then dec(nlines);
  xscroll:=0; yscroll:=0;
  P^.reset; Plines^.reset;
  WaitingOff;
end;
  
procedure DisplayLines;
var
  i: longint;
begin
  n:=0;
  yscroll:=imax(0,imin(yscroll,nlines-height));
  Plines^.seek(yscroll*sizeof(longint));
  Plines^.read(i,sizeof(longint));
  P^.reset; P^.seek(i);
  repeat
    inc(n);
    lens[n]:=0;
    line:='';
    P^.read(ch,1);
    while (P^.status=stOK) and (ch<>#10) do
    begin
      if ch in [#0,#9] then ch:=' ';
      if ch<>#13 then
      begin
        if lens[n]>=xscroll then line:=line+ch;
        lens[n]:=lens[n]+1;
      end;
      P^.read(ch,1);
    end;
    line:=line+spaces; StrCut(line,width);
    TpwPrint(y0+n-1,x0,line,ListNorm);
  until (P^.status<>stOK) or (n=height);
  if n<height then TpwFill(y0+n,x0,height-n,width,' ',ListNorm);
  LastX:=-1; LastY:=-1;
end;                            { GetMoreLines }

procedure ShowMarkRegion;
var
  i: longint;

procedure MarkLine(ln,x1,x2: longint);
begin
  if x2=0 then x2:=lens[ln]; if x2=0 then x2:=1;
  x1:=x1-xscroll; x2:=x2-xscroll;
  if (x1>width) or (x2<1) then Exit;
  TpwAttr(y0+ln-1,x0+imax(x1,1)-1,1,imin(x2,Width)-imax(x1,1)+1,
          ListRev);
end;                       { MarkLine }

begin                      { ShowMarkRegion }
  TpwAttr(y0,x0,height,width,ListNorm);
  LastX:=-1; LastY:=-1;
  if (Markers[true].ln=-1) or (Markers[false].ln=-1) then exit;
  if (Markers[true].ln<Markers[false].ln) or
    ((Markers[true].ln=Markers[false].ln) and
     (Markers[true].charpos<=Markers[false].charpos)) then
  begin
    Start:=Markers[true]; Finish:=Markers[false];
  end else
  begin
    Start:=Markers[false]; Finish:=Markers[true];
  end;
  if (Start.ln>yscroll+n) or (Finish.ln<=yscroll) then exit;
  if Start.ln=Finish.ln then
    MarkLine(Start.ln-yscroll,Start.charpos,Finish.charpos)
  else begin
    if (Start.ln>yscroll) then
      MarkLine(Start.ln-yscroll,Start.charpos,0);
    for i:=imax(Start.ln+1,yscroll+1) to imin(Finish.ln-1,yscroll+n) do
      MarkLine(i-yscroll,1,0);
    if (Finish.ln<=yscroll+n) then
      MarkLine(Finish.ln-yscroll,1,Finish.charpos);
  end;
end;                         { ShowMarkRegion }

procedure LookForString(FindNextOne: boolean);
var
  fplace,nbufread: integer;
  fpos,xpos,ypos: longint;
  FS,tmp: string;
  Found,accept: boolean;
  ch: char;
begin
  if not FindNextOne then
  begin
    GetAString(' Find: ',FindStr,4,255,60,[#0..#20,#22..#31],accept,false);
    if (FindStr='') or (not accept) then exit;
  end;
  if FindStr='' then
  begin
    ErrorMessage(' No search string defined yet! ');
    exit;
  end;
  FS:=FindStr; StrUpr(FS);
  fplace:=1; ypos:=yscroll+yposit; xpos:=xposit+1;
  if xpos>lens[yposit] then
  begin
    inc(ypos); xpos:=1;
  end;
  Plines^.seek((ypos-1)*sizeof(longint));
  Plines^.read(fpos,sizeof(longint));
  P^.reset; P^.seek(fpos+xpos-1);             { Starting point }
  if P^.status<>stOK then exit;
  ch:=#0; tmp:=''; P^.read(ch,1); nbufread:=1;
  while (fplace<=length(FindStr)) and (P^.status=stOK) do
  begin
    if ch=#10 then
    begin
      inc(ypos); xpos:=1; fplace:=1; tmp:=''; nbufread:=1;
    end else
    begin
      if UpCase(ch)=FS[fplace] then
      begin
        if (fplace>1) and (nbufread-1>length(tmp)) then tmp:=tmp+ch;
        inc(fplace);
      end else if fplace>1 then
      begin
        xpos:=xpos-fplace+1;
        fplace:=1;
        tmp:=tmp+ch;
        nbufread:=1;
      end;
      inc(xpos);
    end;
    ch:=#0;
    if nbufread>length(tmp) then
    begin
      P^.read(ch,1);
      if fplace=1 then nbufread:=1
      else inc(nbufread);
    end else begin
      ch:=tmp[nbufread];
      if fplace=1 then
      begin
        Delete(tmp,1,nbufread); nbufread:=1;
      end else inc(nbufread);
    end;
  end;
  if fplace<=length(FindStr) then
  begin
    message(' String not found. '); exit;
  end;
  if (nlines-ypos<=height) then yscroll:=nlines-height
  else yscroll:= ypos-1;
  if yscroll<0 then yscroll:=0;
  yposit:=ypos-yscroll;
  xposit:=xpos-length(FindStr);
  ReDisp:=true;
end;                                  { LookForString }

begin                                 { LoadFromFile }
  P:=Nil; Plines:=Nil; fname:=EditLoadFile; FindStr:='';

  PrepareFile;
  if (fname='') or (P=Nil) or (Plines=Nil) then exit;
  
  with Markers[false] do
  begin
    ln:=-1; charpos:=-1; fpos:=-1;
  end;
  Markers[true]:=Markers[false];
  x0:=2; y0:=3; height:=ScrLen-5; width:=ScrWidth-4;
  ChrFill(spaces,' ',width);
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor; HideMouseCursor;
  end;
  MakeWindow(y0,x0,height+2,Width+2,ListNorm,ListNorm,2,RNorm,0,0);
  x0:=x0+1; y0:=y0+1;
  TitleWindow(1,ListNorm,'['+#254+']');
  TitleWindow(2,ListNorm,fname);
  line:='[Begin include]'+#205+'[End include]'+#205+'[Find]'+#205+'[Next]';
  TitleWindow(4,ListNorm,line);
  TpwAttr(y0+height, x0+pos('B',line),1,1,ListBright);
  TpwAttr(y0+height, x0+pos('E',line),1,1,ListBright);
  TpwAttr(y0+height, x0+pos('F',line),1,1,ListBright);
  TpwAttr(y0+height, x0+pos('N',line),1,1,ListBright);
  TitleWindow(6,ListNorm,'[ok]');
  ScrBar.HeldDown:=false;
  P^.seek(0);
  xposit:=1; yposit:=1; xscroll:=0; yscroll:=0;
  LastX:=-1; LastY:=-1; OldAttr:=DialogNorm;
  DisplayLines;
  if UseMouse then
  begin
    WaitForRelease(255);ShowMouseCursor; HideMouseCursor;
  end;
  repeat
    if YScroll+height<=nlines then
      ScrollBarMake(ScrBar,yScroll,x0+width,y0,y0+height-1,height,nlines,
                    CScrBarFinsert)
    else
      ScrollBarMake(ScrBar,YScroll,x0+width,y0,y0+height-1,height,
                    yScroll+height,CScrBarFinsert);
    OldXscroll:=Xscroll; OldYScroll:=YScroll;
    line:='('+num2str(yposit+yscroll)+','+num2str(xposit)+')';
    if length(line)<25 then
    begin
      ChrFill(tmp,#205,25-length(line)); line:=tmp+line;
    end;
    TitleWindow(3,ListNorm,line);
    
    Up:=false; Down:=false; PgUp:=false; PgDn:=false; Help:=false;
    Home:=false; Eend:=false; Esc:=false; MarkStart:=false;
    MarkEnd:=false; CHome:=false; CEnd:=false; ScrBarHit:=false;
    Left:=false; Right:=false; Enter:=false; ReDisp:=false;
    Find:=false; Next:=false;
  
    LineCursor;
    PutCursor(x0,y0,LastX,LastY,OldAttr,xposit-xscroll,yposit);
    CLB;
    if UseMouse then ShowMouseCursor;
    ch:=ReadKeyMouse;
    if UseMouse then HideMouseCursor;

    if Event.mpress then  { Mouse press }
    begin
      xm:=Event.x+1-x0; ym:=Event.y+1-y0;
      if (xm>1) and (xm<5) and (ym=0) then
      begin
        Esc:=true;
      end else if (xm=width+1) and (ym>0) and (ym<=height) then
        ScrBarHit:=true
      else if (xm>0) and (xm<=width) and (ym=height+1) then
      begin
        ReadScrStr(line,xm+x0-1,ym+y0-1,xfirst,att,
            ['[',']','A'..'Z','a'..'z','^',' ']);
        if      line='[Begin include]' then MarkStart:=true
        else if line='[End include]'   then MarkEnd:=true
        else if line='[Find]'          then Find:=true
        else if line='[Next]'          then Next:=true
        else if line='[ok]'            then Enter:=true;
      end else if (xm>0) and (xm<=width) and (ym>0) and (ym<=height) then
      begin
        yposit:=ym;
        xposit:=imin(xm+xscroll,lens[yposit]);
        if Event.LeftButton or Event.Ctrl or Event.Shift then MarkStart:=true
        else MarkEnd:=true;
      end;
    end else if ch=#0 then   { Special key }
    begin
      ch:=ReadKey;
      Home :=(ch=#71);     Eend :=(ch=#79);
      CHome:=(ch=#119);    CEnd :=(ch=#117);
      PgUp :=(ch=#73);     PgDn :=(ch=#81);
      Up   :=(ch=#72);     Down :=(ch=#80);
      Left :=(ch=#75);     Right:=(ch=#77);
      Help :=(ch=#59);         { F1    }
      Find :=(ch=#33);         { Alt-F }
      Next :=(ch=#49);         { Alt-N }
      MarkStart:=(ch=#48);     { Alt-B }
      MarkEnd  :=(ch=#18);     { Alt-E }
    end else
    begin
      MarkStart:=(ch=#2) or (UpCase(ch)='B') or
                 ((ch=' ') and (Markers[false].ln>-1));
      MarkEnd:=(ch=#5) or (UpCase(ch)='E') or
               ((ch=' ') and (Markers[false].ln=-1));
      Find:=(ch=#6) or (UpCase(ch)='F');
      Next:=(ch=#14) or (UpCase(ch)='N');
      Esc:=(ch=#27);
      Enter:=(ch=#13);
    end;
    if MarkEnd and (Markers[true].ln=-1) then
    begin
      ErrorMessage(' Beginning of Include region not marked yet! ');
      MarkEnd:=false;
    end;
    if Help then ContextHelp('Insert File Contents')
    else if Find or Next then
      LookForString(Next)
    else if MarkStart or MarkEnd then
    begin
      Markers[MarkStart].ln:=yscroll+yposit;
      Markers[MarkStart].charpos:=xposit;
      if MarkStart then Markers[false].ln:=-1;
      Plines^.seek((yscroll+yposit-1)*sizeof(longint));
      Plines^.read(Markers[MarkStart].fpos,sizeof(longint));
    end else if ScrBarHit then
    begin
      ScrollBarClick(ScrBar,YScroll);
      if Yscroll<>OldYScroll then ReDisp:=true;
    end else if Home then xposit:=1
    else if Up then
    begin
      if (yposit=1) and (yscroll>0) then
      begin
        dec(yposit);
        dec(yscroll); yposit:=1;
        ReDisp:=true;
      end else if yposit>1 then dec(yposit);
    end else if Down then
    begin
      if (yposit>=height) and (yscroll+height<nlines) then
      begin
        inc(yscroll); yposit:=height;
        ReDisp:=true;
      end else if yposit<n then inc(yposit);
    end else if Left and (xposit>1) then dec(xposit)
    else if Right and (xposit<lens[yposit]) then inc(xposit)
    else if Eend then xposit:=lens[yposit]
    else if PgDn then
    begin
      if yscroll+height<nlines then
      begin
        xscroll:=0; yscroll:=yscroll+height-1;
        ReDisp:=true;
        yposit:=1;
      end else
      begin
        yposit:=n; xposit:=lens[n];
        if yposit<1 then yposit:=1; if xposit<1 then xposit:=1;
      end;
    end else if (PgUp) and (yscroll>0) then
    begin
      yscroll:=yscroll-height+1;
      xscroll:=0;
      ReDisp:=true;
      yposit:=1;
    end else if CHome then
    begin
      xscroll:=0; yscroll:=0;
      ReDisp:=true;
      xposit:=1; yposit:=1;
    end else if CEnd then
    begin
      yscroll:=nlines-height;
      ReDisp:=true;
      yposit:=n; xposit:=lens[n];
      if yposit<1 then yposit:=1; if xposit<1 then xposit:=1;
    end;
    if ReDisp then DisplayLines;
    if (yposit<=n) and (xposit>lens[yposit]) then xposit:=lens[yposit];
    if xposit=0 then xposit:=1;
    if (xposit<=xscroll) or (xposit>xscroll+width) then
    begin
      while (xscroll>0) and (xposit<=xscroll) do xscroll:=xscroll-20;
      while xposit>xscroll+width do xscroll:=xscroll+20;
      DisplayLines;
    end;
    if MarkStart or MarkEnd or (Xscroll<>OldXScroll)
       or (YScroll<>OldYscroll) then ShowMarkRegion;
    if UseMouse and not ScrBar.HeldDown then WaitForRelease(255);
  until Enter or Esc;
  if Enter and (Markers[true].ln>-1) and (Markers[false].ln>-1) then { Do it! }
  begin
    if mlen<>mlen1 then
    begin
      mlen2:=mlen; mlen3:=mlen1;
      if mlen>mlen1 then
      begin
        mlen2:=mlen1+1; mlen3:=mlen+1;
      end;
      pl:=mlen2;
      SDelete(S,Slen,pl,mlen3-mlen2);
    end;
    if (Markers[true].ln<Markers[false].ln) or
      ((Markers[true].ln=Markers[false].ln) and
       (Markers[true].charpos<=Markers[false].charpos)) then
    begin
      Start:=Markers[true]; Finish:=Markers[false];
    end else
    begin
      Start:=Markers[false]; Finish:=Markers[true];
    end;
    Start.fpos:=Start.fpos+Start.charpos-1;
    Finish.fpos:=Finish.fpos+Finish.charpos-1;
    nafter:=Slen-pl+1;
    PushBufferStack(S^[pl],nafter,EnoughMem(nafter),0);
    P^.reset; P^.seek(Start.fpos);
    i:=Start.fpos;
    while (i<=Finish.fpos) and (P^.status=stOk) and (pl<=MaxBig) do
    begin
      P^.read(ch,1); inc(i);
      if ch in [#0,#9,#10] then ch:=' ';
      if (ch<>#13) and ((ch<>' ') or (pl=1) or (S^[pl-1]<>' ')) then
      begin
        S^[pl]:=ch; inc(pl);
      end;
    end;
    if pl>MaxBig then pl:=MaxBig;
    if pl+nafter>MaxBig then nafter:=MaxBig-pl;
    if nafter>0 then RecallPartBufStack(S^[pl],nafter,0);
    DiscardBufferStack;
    Slen:=pl+nafter-1;
  end;
  RemoveWindow;
  TidyUp;
  mlen1:=pl; mlen:=pl;
  mlen2:=pl; mlen3:=pl;
  ReDraw:=true; changed:=true; modified:=true;
end;                                 { LoadFromFile }

procedure StatusLine;
begin
  if Negate=Nil then
    line:='[Save]'+#205+'[Recall]'+#205+'[cAp]'
         +#205+'[Cut]'+#205+'[cOpy]'+#205+'[Paste]'
  else
    line:='[Save]'+#205+'[Recl]'+#205+'[cAp]'
         +#205+'[Cut]'+#205+'[cOpy]'+#205+'[Paste]'+#205+'[NOT]';
  if ChooseMode then
  begin
    if CaseSen then line:=line+#205+'[casE on ]'
    else line:=line+#205+'[casE off]';
    if RegExp then line:=line+#205+'[regeXp]'
    else line:=line+#205+'[sUbstr]';
  end else line:=line+#205+'[Load]';
         
  TitleWindow(4,EditNorm,line);
  TpwAttr(y0+height-2,x0+Pos('S',line),1,1,EditBright);
  TpwAttr(y0+height-2,x0+Pos('R',line),1,1,EditBright);
  TpwAttr(y0+height-2,x0+Pos('A',line),1,1,EditBright);
  TpwAttr(y0+height-2,x0+Pos('C',line),1,1,EditBright);
  TpwAttr(y0+height-2,x0+Pos('O',line),1,1,EditBright);
  TpwAttr(y0+height-2,x0+Pos('P',line),1,1,EditBright);
  if ChooseMode then
  begin
    TpwAttr(y0+height-2,x0+Pos('E',line),1,1,EditBright);
    if Regexp then
      TpwAttr(y0+height-2,x0+Pos('X',line),1,1,EditBright)
    else
      TpwAttr(y0+height-2,x0+Pos('U',line),1,1,EditBright);
    if Negate<>Nil then TpwAttr(y0+height-2,x0+Pos('N',line),1,1,EditBright);
  end else TpwAttr(y0+height-2,x0+Pos('L',line),1,1,EditBright);
end;                                { StatusLine }

begin                               { ReadBig }
  SuspendWaiting(true);
  S:=@Sin;
  if (x0+linelen<ScrWidth-1) and (height<10) then
    MakeWindowNo(y0,x0,height,linelen,EditNorm,EditNorm,2,RNorm,Shadow,1)
  else
    MakeWindowNo(y0,x0,height,linelen,EditNorm,EditNorm,2,RNorm,0,0);
  if length(Title)>linelen-10 then Title[0]:=chr(imax(0,linelen-10));
  retain:=true; modified:=false;
  ChrFill(Space,' ',ScrWidth-4);
  x0:=x0+1; y0:=y0+1; Linelen:=linelen-2;
  mlen:=1; mlen1:=1; mlen2:=1; mlen3:=1;
  Ins:=true; Scroll:=0; pl:=1;
  lastx:=-1; lasty:=-1;
  WasEmpty:=(Slen=0);
  if MarkText and (Slen>0) then
  begin
    mlen1:=Slen+1; pl:=Slen+1;
    if Slen+1>MaxBig then pl:=Slen;
  end;
  Display(S,Slen,mlen,mlen1,Scroll,true,true);
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor; HideMouseCursor;
  end;
  if MaxBig<linelen-PromptX then i:=0
  else i:=(MaxBig-(linelen-PromptX+2)) div linelen + 1;
  UseScrBar:=(i>height-3);
  TitleWindow(1,EditNorm,'['+#254+']');
  if Title<>'' then
  begin
    if (Negate=Nil) or not Negate^ then TitleWindow(2,EditNorm,Title+#205)
    else TitleWindow(2,EditNorm,'^'+Title);
  end;
  TitleWindow(6,EditNorm,'[ok]');
  StatusLine;
  mpress:=false; Special:=true;
  ScrBar.HeldDown:=false;
  repeat
    if special then CLB;
    if UseScrBar then
    begin
      if Scroll+height-2<=LastLine then
        ScrollBarMake(ScrBar,Scroll,x0+linelen,y0,y0+height-3,height-2,LastLine,
                      CScrBarEdField)
      else
        ScrollBarMake(ScrBar,Scroll,x0+linelen,y0,y0+height-3,height-2,
                      Scroll+height-2,CScrBarEdField);
    end;
    if (Slen+PromptX) mod linelen=0 then
      MaxClick:=linelen*((Slen+PromptX) div linelen) - PromptX+1
    else
      MaxClick:=linelen*((Slen+PromptX) div linelen + 1) - PromptX+1;
    UpArr:=false; DownArr:=false; LeftArr:=false; RightArr:=false;
    Ent:=false; BS:=false; Home:=false; Eend:=false; Insp:=false;
    Del:=false; Esc:=false; Special:=false; changed:=false; DelAll:=false;
    btrunc:=false; etrunc:=false; mpress:=false;
    memSave:=false;memRecall:=false; Cap:=false; Extend:=false;
    ShftUp:=false ;ShftDn:=false; ShftLeft:=false; ShftRight:=false;
    ScrlUp:=false; ScrlDn:=false; PgUp:=false; PgDn:=false;
    ClrAll:=false; Tab:=false; BTab:=false; DelW:=false;
    CPgUp:=false; CPgDn:=false; Help:=false; redraw:=false;
    ScrBarHit:=false; Cut:=false; CCopy:=false; Paste:=false;
    LoadFFile:=false; RXToggle:=false; CaseToggle:=false;
    NormalClick:=false; ShftHome:=false; ShftEnd:=false; DoNegate:=false;
    
    if Ins then LineCursor
    else BlockCursor;
    if UseMouse then ShowMouseCursor;
    ch:=ReadKeyMouse;
    if (ch=#17) and ([#128..#254]*([#0..#255]-exclude)<>[]) then 
      EnterSpecialChar(ch);
    if Event.mpress then    { Mouse }
    begin
      xm:=Event.x+1-x0; ym:=Event.y+1-y0;
      if (xm>1) and (xm<5) and (ym=0) then
        ESC:=true
      else if (xm=linelen+1) and (ym>0) and (ym<height) then
        ScrBarHit:=UseScrBar
      else if (xm>0) and (xm<=linelen) and (ym=height-1) then
      begin
        ReadScrStr(line,xm+x0-1,ym+y0-1,xfirst,att,
            ['[',']','A'..'Z','a'..'z',' ']);
        if      line='[ok]'     then Ent:=true
        else if line='[Save]'   then memSave:=true
        else if (line='[Recall]') or (line='[Recl]') then memRecall:=true
        else if line='[cAp]'    then Cap:=true
        else if line='[Cut]'    then Cut:=true
        else if line='[cOpy]'   then Ccopy:=true
        else if line='[Paste]'  then Paste:=true
        else if line='[Load]'   then LoadFFile:=true
        else if line='[NOT]'    then DoNegate:=true
        else if (line='[casE on ]')   or (line='[casE off]')   then CaseToggle:=true
        else if (line='[regeXp]') or (line='[sUbstr]') then RXToggle:=true;
      end else
      begin
        mlen2:=mlen; mlen3:=mlen1;
        XAtEnd:=(Slen+PromptX) mod linelen;
        YAtEnd:=((Slen+PromptX) div linelen)-scroll+1;
        mlen:=(ym-y+scroll)*linelen+(xm-promptx)+1;
        if mlen<0 then mlen:=0; if mlen>Slen+1 then mlen:=Slen+1;
        mlen1:=mlen;
        mpress:=true;
        if mlen=0 then PutCursor(x0,y0,lastx,lasty,OldAttr,promptx,1)
        else if mlen<=Slen then PutCursor(x0,y0,lastx,lasty,OldAttr,xm,ym)
        else PutCursor(x0,y0,lastx,lasty,OldAttr,XAtEnd,YAtEnd);
        if Event.Shift or Event.Ctrl or Event.RightButton then   { Extend the selection }
        begin
          if mlen2=mlen3 then mlen:=pl
          else mlen:=mlen2;
          Display(S,Slen,mlen,mlen1,Scroll,true,true);
        end;
        ShowMouseCursor;
        lastmlen:=mlen;
        if (xm>0) and (xm<=linelen+1) and (ym<height-1) and
           (ym>0) and (mlen1>=0) and {(mlen1<=slen+1)} (mlen1<=MaxClick) then
        begin                             { Mark region with the mouse }
          NormalClick:=(mlen2<>mlen3);
          repeat
            repeat
              xm:=GetMouseX div xpixels; xm:=xm+2-x0;
              ym:=GetMouseY div ypixels; ym:=ym+2-y0;
              if ym<0 then ym:=0;
              if ym>height-1 then ym:=height-1;
              if (xm>0) and (xm<=linelen+1) and ((ym>0) or (scroll>0)) then
              begin
                mlen1:=(ym-y+scroll)*linelen+(xm-promptx)+1;
                if mlen1<0 then mlen1:=0;
                if mlen1>Slen+1 then mlen1:=Slen+1;
              end;
            until (not ButtonPressed) or (mlen1<>lastmlen);
            if mlen1<>lastmlen then
            begin
              pl:=mlen1; if pl<1 then pl:=1;
              NormalClick:=false;
              HideMouseCursor;
              if (ym=0) or (ym=height-1) then
              begin
                if (ym=0) and (Scroll>0) then dec(Scroll)
                else Inc(Scroll);
                YAtEnd:=((Slen+PromptX) div linelen)-scroll+1;
                Display(S,Slen,mlen,mlen1,Scroll,true,true);
              end else
              begin
                if Scroll=0 then
                begin
                  Index:=1; xx:=PromptX;
                end else begin
                  index:=(linelen-PromptX+2) + (Scroll-1)*linelen;
                  xx:=1;
                end;
                tx:=xx; ty:=y;
                mlen2:=mlen; mlen3:=mlen1;
                if mlen2>mlen3 then
                begin
                  inc(mlen2); inc(mlen3);
                end;
                while (index<=Slen) and (ty<height-1) do
                begin
                  if (mlen2=mlen3) or (index<imin(mlen2,mlen3)) or
                     (index>=imax(mlen2,mlen3)) then
                       TpwAttr(y0-1+ty,x0-1+tx,1,1,EditNorm)
                  else
                       TpwAttr(y0-1+ty,x0-1+tx,1,1,EditRev);
                  Inc(tx);
                  if tx>linelen then
                  begin
                    tx:=1; Inc(ty);
                  end;
                  Inc(Index);
                end;
              end;
              if mlen1=0 then PutCursor(x0,y0,lastx,lasty,OldAttr,promptx,1)
              else if mlen1<=Slen then PutCursor(x0,y0,lastx,lasty,OldAttr,xm,ym)
              else PutCursor(x0,y0,lastx,lasty,OldAttr,XAtEnd,YAtEnd);          
              ShowMouseCursor;
            end;
            lastmlen:=mlen1;
          until not ButtonPressed;
          if (mlen=0) and (mlen1=0) then
          begin
            mlen:=1; mlen1:=1;
          end;
          if mlen<1 then mlen:=1;   if mlen>Slen+1 then mlen:=Slen+1;
          if mlen1<0 then mlen1:=0; if mlen1>Slen+1 then mlen1:=Slen+1;
          pl:=mlen1; if pl<1 then pl:=1;
        end;
      end;
    end else if ch=#0 then
    begin
      ch:=ReadKey;
      if Event.Shift then
      begin
        ShftUp:=(ch=#72);    ShftDn:=(ch=#80);
        ShftLeft:=(ch=#75);  ShftRight:=(ch=#77);
        ShftHome:=(ch=#71);  ShftEnd:=(ch=#79);
        Cut:=(ch=#83);
        Paste:=(ch=#82);
      end else
      begin
        UpArr:=(ch=#72);    DownArr:=(ch=#80);
        LeftArr:=(ch=#75);  RightArr:=(ch=#77);
        Home:=(ch=#71);     Eend:=(ch=#79);
        Del:=(ch=#83);
        Insp:=(ch=#82);     
      end;
      btrunc:=(ch=#119);  etrunc:=(ch=#117);
      memSave:=(ch=#31);  memRecall:=(ch=#19);
      Cap:=(ch=#30);
      PgUp:=(ch=#73);     PgDn:=(ch=#81);
      CPgUp:=(ch=#132);   CPgDn:=(ch=#118);
      Tab:=(ch=#116);
      Btab:=(ch=#15) or (ch=#115) or (ch=#148) or (ch=#165);
      Help:=(ch=#59);
      Cut:=Cut or (ch=#46);
      DelAll:=(ch=#147);
      Ccopy:=(ch=#24) or (ch=#146);
      Paste:=Paste or (ch=#25);
      LoadFFile:=(ch=#38);
      RXToggle:=(ch=#45) or (ch=#22);
      DoNegate:=(@Negate<>Nil) and (ch=#49);
      CaseToggle:=(ch=#18);
      special:=true;
    end else
    begin
      Ent:=(ch=#13); BS:=(ch=#8);
      Esc:=(ch=#27);
      Tab:=(ch=#9);
      DelW:=(ch=#23);
      Cut:=(ch=#24);
      Ccopy:=(ch=#3);
      Paste:=(ch=#22);
      Btrunc:=(ch=#21);
      Etrunc:=(ch=#11);
    end;
    special:=special or Ent or BS or MemSave or MemRecall or Esc or DelAll
                     or mpress or Extend or Tab or DelW or ScrBarHit or Cap
                     or Cut or CCopy or Paste or LoadFFile or RXToggle
                     or CaseToggle or NormalClick or Btrunc or Etrunc or DoNegate;
    if special and (NormalClick or not (mpress or Del or memSave or
            ShftUp or ShftDn or ShftLeft or Paste or memRecall or LoadFFile or
            ShftRight or PgUp or PgDn or ScrlUp or ScrlDn or Cap or ShftEnd or
            CPgUp or CPgDn or Extend or Help or ScrBarHit or ShftHome or
            Cut or Ccopy or RXToggle or CaseToggle)) then
    begin
      if NormalClick or (mlen<>mlen1) then
      begin
        redraw:=true;
        if mlen<mlen1 then pl:=mlen1-1
        else pl:=mlen1;
      end;
      if pl<1 then pl:=1;
      mlen1:=pl; mlen:=pl;
    end;
    if not special then
    begin
      if not ((ch in exclude) or ((ch=' ') and (pl=1))) then
      begin
        if mlen<>mlen1 then
        begin
          mlen2:=mlen; mlen3:=mlen1;
          if mlen>mlen1 then
          begin
            mlen2:=mlen1+1; mlen3:=mlen+1;
          end;
          pl:=mlen2; S^[pl]:=ch;
          if (mlen2=1) and (mlen3>Slen) then
          begin
            Slen:=1; ClrAll:=true;
          end else if mlen3-mlen2>1 then
          begin
            SDelete(S,Slen,pl+1,mlen3-mlen2-1);
            ClrAll:=true;
          end;
        end else
        begin
          if Ins then CInsert(ch,S,Slen,pl,MaxBig)
          else Cput(S,Slen,ch,pl,MaxBig);
        end;
        if pl<maxBig then pl:=pl+1;
        if (pl+PromptX-2) div linelen>Scroll+height-3 then Inc(Scroll);
        changed:=true;
      end;
    end else if Help then ContextHelp('Edit Field')
    else if ChooseMode and RXToggle    then RegExp :=not RegExp
    else if ChooseMode and CaseToggle  then CaseSen:=not CaseSen
    else if (Negate<>Nil) and DoNegate then Negate^:=not Negate^
    else if LoadFFile then LoadFromFile(mlen,mlen1)
    else if DelAll then
    begin
      Slen:=0; Scroll:=0;
      Changed:=true; ClrAll:=true;
    end else if Esc then
    begin
      if (not modified) or (WasEmpty and (Slen=0))
                    or YesNo(' Discard changes? ') then
      begin
        retain:=false; Ent:=true; modified:=false;
      end;
    end else if Cap then
    begin
      if mlen<>mlen1 then
      begin
        mlen2:=mlen; mlen3:=mlen1;
        if mlen>mlen1 then
        begin
          mlen2:=mlen1+1; mlen3:=mlen+1;
        end;
        Capitalize(S,Slen,mlen2,mlen3-1,Author);
      end else Capitalize(S,Slen,1,Slen,Author);
      changed:=true;
    end else if Del then
    begin
      if mlen=mlen1 then SDelete(S,Slen,pl,1)
      else begin
        pl:=mlen;
        if mlen>mlen1 then
        begin
          pl:=mlen1+1; mlen1:=mlen+1; mlen:=pl;
        end;
        SDelete(S,Slen,mlen,mlen1-mlen);
        ClrAll:=true;
      end;
      pl:=mlen; mlen1:=mlen; 
      changed:=true;
    end else if DelW then
    begin
      if pl<=Slen then
      begin
        Sdelete(S,Slen,pl,1);
        while (Slen>pl) and (S^[pl]<>' ') do Sdelete(S,Slen,pl,1);
        if (Slen>=pl) and (S^[pl]<>' ') then Sdelete(S,Slen,pl,1);
      end;
      changed:=true; ClrAll:=true;
    end else if BS and (pl>1) then
    begin
      pl:=pl-1;
      SDelete(S,Slen,pl,1);
      ClrAll:=true; changed:=true;
    end else if LeftArr or ShftLeft then pl:=pl-1
    else if (RightArr or ShftRight) and (pl<=maxBig) then pl:=pl+1
    else if Tab then
    begin
      while (pl<=SLen) and (S^[pl]<>' ') do Inc(pl);
      while (pl<=SLen) and (S^[pl]=' ') do  Inc(pl);
      while (pl>1) and (S^[pl]=' ') do Dec(pl);
    end else if BTab then
    begin
      if (pl=1) or (S^[pl]=' ') or (S^[pl-1]=' ') then
      begin
        while (pl>1) and (S^[pl]<>' ')  do Dec(pl);
        while (pl>1) and (S^[pl]=' ')   do Dec(pl);
      end;
      while (pl>1) and (S^[pl]<>' ')  do Dec(pl);
      while (pl<Slen) and (S^[pl]=' ') do Inc(pl);
    end else if PgUp then
    begin
      if Scroll=0 then pl:=1
      else begin
        OScroll:=Scroll;
        Scroll:=Scroll-(height-3); if Scroll<0 then Scroll:=0;
        pl:=pl+(Scroll-OScroll)*linelen;
        redraw:=true; ClrAll:=true;
      end;
    end else if PgDn then
    begin
      OScroll:=Scroll;
      Scroll:=imin(((Slen+PromptX-1) div linelen)-(height-3),Scroll+(height-3));
      if Scroll<Oscroll then Scroll:=OScroll;
      if Scroll<0 then Scroll:=0;
      if Scroll=OScroll then
      begin
        if Slen<MaxBig then pl:=Slen+1
        else pl:=Slen;
      end else
      begin
        pl:=pl+(Scroll-OScroll)*linelen;
        redraw:=true; ClrAll:=true;
      end;
    end else if CPgDn then
    begin
      if Scroll<((Slen+PromptX-1) div linelen)-(height-3) then
      begin
        Inc(Scroll); redraw:=true; ClrAll:=true;
        KeepInView(true);
      end;
    end else if (CPgUp) and (Scroll>0) then
    begin
      if scroll>0 then
      begin
        Dec(Scroll); redraw:=true; ClrAll:=true;
        KeepInView(true);
      end;
    end else if ScrBarHit then
    begin
      OldScroll:=Scroll;
      ScrollBarClick(ScrBar,Scroll);
      if Scroll<>OldScroll then
      begin
        redraw:=true; ClrAll:=true;
        KeepInView(true);
      end;
    end else if (Home or ShftHome) then pl:=1
    else if (Eend or ShftEnd) then
    begin
      pl:=Slen+1; if pl>maxBig then pl:=maxBig;
    end else if Insp then
    begin
      Ins:=not Ins;
      if Ins then LineCursor
      else BlockCursor;
    end else if UpArr or ShftUp then
    begin
      if pl>linelen-PromptX then pl:=pl-linelen;
    end else if DownArr or ShftDn then
    begin
      if (pl+PromptX-2) div linelen <(Slen+1+PromptX-2) div linelen then
            pl:=pl+linelen;
    end else if etrunc then
    begin
      changed:=true; ClrAll:=true;
      Slen:=pl-1;
    end else if btrunc then
    begin
      Sdelete(S,Slen,1,pl-1); pl:=1; mlen:=1; mlen1:=1;
      changed:=true; ClrAll:=true;
      Scroll:=0;
    end else if memSave and
      ((mlen<>mlen1) or YesNo(' No text highlighted. Erase register contents? '))
         then
    begin
      RegChoose(memch,false,true); redraw:=true;
      if memch<>#0 then
      begin
        memch:=UpCase(memch);
        if not (memch in ['0'..'Z']) then memch:=#0;
      end
      else memch:=#0;
      if memch<>#0 then
      begin
        tmp:='';
        if mlen<>mlen1 then
        begin
          if mlen<mlen1 then
            tmp:=SCopy(S,mlen,mlen1-mlen)
          else
            tmp:=SCopy(S,mlen1+1,mlen-mlen1);
        end;
        if memch in ['A'..'Z'] then
          PushBufferStack(tmp,256,MemoryMode,MemoryPos+Ord(memch)-Ord('A'))
        else if memch in ['0'..'9'] then
          PushBufferStack(tmp,256,MemoryMode,MemoryPos+Ord(memch)-Ord('0')+26);
        OptionsModified.Registers:=true;
      end;
      memSave:=false;
      mlen:=pl; mlen1:=pl;
    end else if memRecall then
    begin
      repeat
        RegChoose(memch,true,true); redraw:=true;
        if memch<>#0 then
        begin
          if mlen<>mlen1 then
          begin
            mlen2:=mlen; mlen3:=mlen1;
            if mlen>mlen1 then
            begin
              mlen2:=mlen1+1; mlen3:=mlen+1;
            end;
            pl:=mlen2;
            SDelete(S,Slen,pl,mlen3-mlen2);
          end;
          tmp:='';
          if memch in ['A'..'Z'] then
            RecallBufferStack(tmp,MemoryPos+Ord(memch)-Ord('A'))
          else
            RecallBufferStack(tmp,MemoryPos+Ord(memch)-Ord('0')+26);
          SInsert(S,Slen,tmp,pl,MaxBig);
          pl:=pl+length(tmp);
          memch:=#0;
          changed:=true; ClrAll:=true;
        end;
      until memch=#0;
      memRecall:=false; mlen:=pl; mlen1:=pl;
    end else if (CCopy or Cut) and (mlen1<>mlen) then
    begin
      CopyToBuffer(S^,mlen,mlen1);
      if cut then
      begin
        SDelete(S,Slen,mlen,mlen1-mlen);
        redraw:=true; ClrAll:=true; changed:=true;
        pl:=mlen; mlen1:=pl;
      end;
    end else if Paste then
    begin
      PasteFromBuffer(S^,Slen,pl,mlen,mlen1,MaxBig);
      redraw:=true; ClrAll:=true; changed:=true;
    end;

    if pl<1 then pl:=1; 
    if pl>slen+1 then pl:=slen+1;
    if (ShftUp or ShftDn or ShftLeft or ShftRight
        or ShftHome or ShftEnd) then
    begin
      if ShftHome then mlen1:=0
      else if ShftLeft and (pl=1) then dec(mlen1)
      else if ShftRight and (mlen1=0) then
      begin
        mlen1:=1; pl:=1;
      end else mlen1:=pl;
      redraw:=true;
    end else if not (mpress or memSave or ScrBarHit or Ccopy) then
    begin
      mlen:=pl; mlen1:=pl;
    end;
    if mlen1<0 then mlen1:=0
    else if mlen1>Slen+1 then mlen1:=Slen+1;
    KeepInView(false);
    {message(num2str(mlen)+','+num2str(mlen1)+','+num2str(pl));}
    if redraw then Display(S,Slen,mlen,mlen1,Scroll,true,true)
    else Display(S,Slen,mlen,mlen1,Scroll,changed,ClrAll);
    if ChooseMode and (CaseToggle or RxToggle) then StatusLine;
    if DoNegate and (Title<>'') then
    begin
      if (Negate=Nil) or not Negate^ then TitleWindow(2,EditNorm,Title+#205)
      else TitleWindow(2,EditNorm,'^'+Title);
    end;
    l:=slen;
    if changed then modified:=true;
    if UseMouse and not ScrBar.HeldDown then WaitForRelease(255);
  until Ent;
  CursorOff;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  if retain then pl:=slen+1;
  RemoveWindow;
  SuspendWaiting(false);
end;                                   { ReadBig }

end.
