{$IFDEF WINDOWS}
{$N-,B-,V-,W-,G+}
{$ELSE}
{$N-,E-,B-,V-,F+,O+}
{$ENDIF}

Unit BibMain;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, Wbibgui, wbibdisp, wbibslct, wbibinit, wbibabv1, wbibabv2,
  wbibeden, wbibdlg, WinTypes, WinProcs, wbiblist, wbibpatt, wbibesrt,
  wbibole, wbibclip,
{$ELSE}
  bibwindo, Dos, bibCrt, Objects, spawno, BibMouse, bibdisp, bibsedit,
  bibedit, bibdialg, bibselct, bibedent, biblist, bibedsrt, bibclip,
{$ENDIF}
  bibstrg, streams, bibstrm, bibvars, bibfile, bibutil, bib8bit, bibtext,
  bibreadB, bibwritO, bibreach, bibfilch, bibSrtPt, bibwild,
  bibprint, bibPchec, bibsave, rc_strng, bibflch2, bibcache, lfnunit;


procedure DealWithEdit(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                       WhichField: Longint;
{$ELSE}
                       var Scroll: LongInt;
{$ENDIF}
                       outside: boolean; selected: byte);
procedure TagFromAuxFile(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         fname: string; WarnNo: boolean);
procedure DealWithTagging(Entry: EntryRecPtr; Pattern: PatRecPtr;
                          selected: byte);
function  DealWithPattern(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                          Scroll: longint; FromFirst: boolean;
{$ELSE}
                          var Scroll: longint; FromFirst: boolean;
{$ENDIF}
                          selected: word): boolean;
procedure DealWithFiles(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        selected: SelectionType);


Implementation


{$IFNDEF WINDOWS}
procedure Shell(Entry: EntryRecPtr; Pattern: PatRecPtr);
var
  ok: boolean;
  retval: integer;
  oreal,oentry : Word ;

procedure heap_shrink;    {free up all unused heap}
var
  reg: registers;
begin
  reg.bx := memw[seg(heapptr) : ofs(heapptr) + 2] - prefixseg;
  reg.es := prefixseg;
  reg.ah := $4a;            {dos memory alloc. interrupt}
  msdos(reg);
end;

procedure heap_expand;    {reclaim unused heap}
var
  reg: registers;
begin
  reg.bx := memw[seg(heapend) : ofs(heapend) + 2] - prefixseg;
  reg.es := prefixseg;
  reg.ah := $4a;
  msdos(reg);
end;

begin                            { Shell }
  if not AllowShell then Exit;
  if COMSPEC='' then
  begin
    ErrorMessage(' Couldn''t find command interpreter - shelling disabled ');
    Exit;
  end;
  oreal:=entry^.realnum; oentry:=entry^.entrynum;
  CloseFile(bib);
  restore_mode;
  CursorOn;
  if SwapOn and ExecSwap then
  begin
    SwapVectors;
    SetCBreak(ExtendCBreak);
    heap_shrink;
    if DosArgString=Nil then
    begin
      retval := spawn(comspec,'',0);
      if retval=-1 then Exec(COMSPEC,'');
    end else
    begin
      retval := spawn(comspec,DosArgString^,0);
      if retval=-1 then Exec(COMSPEC,DosArgString^);
    end;
    heap_expand;
    SwapVectors;
    SetCBreak(false);
  end else
  begin
    SwapVectors;
    SetCBreak(ExtendCBreak);
    heap_shrink;
    if DosArgString=Nil then Exec(COMSPEC,DosArgString^)
    else Exec(COMSPEC,'');
    heap_expand;
    SwapVectors;        
    SetCBreak(false);
  end;
  set_bibdb_mode;
  Window(2,3,ScrWidth-2,ScrLen-2);
  if OrigUseMouse then
  begin
    RestoreMouse;
    InitMouse;
    MouseBox(0,0,ScrWidth*Xpixels-1,ScrLen*YPixels-1);
    HideMouseCursor;
    if MouseCursor.HardWare then
      HardwareTextCursor(MouseCursor.hfirst,MouseCursor.hlast);
  end;
  CursorOff;
  CheckForIndexFile(bib,bibname);
  ReachNumber(Entry,Pattern,oreal,oentry);
end;                                  { Shell }
{$ENDIF}

procedure DealWithEdit(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                       WhichField: longint;
{$ELSE}
                       var Scroll: longint;
{$ENDIF}
                       outside: boolean; selected: byte);
var
  ok,PatOK,Edited,OldPattConf,NewPattConf,Equiv,changed: boolean;
  OldScroll: longint;
  icode: integer;
  origname,line: string;
  orealnum,oentrynum: longint;
  Oplace: longint;
  i,j: word;
  k,EdExitCode: byte;
  SortPattern: PatRecPtr;
  OldSortRec,NewSortRec: SortRecType;
begin                               { DealWithEdit }
  AbortFlag:=false;
  if selected=0 then exit;
  if (CurrentBibFile<1) or (bibname^='') then Exit;
  if selected in [CEdit_Tag, CEdit_TagAll, CEdit_TagTeX, CEdit_UntagAll] then
  begin
    DealWithTagging(Entry,Pattern,selected);
    exit;
  end;
  if selected=CEdit_Bookmark then             { Place bookmark }
  begin
    if entry^.realnum>0 then
    begin
      BookMark^:=entry^.name;
      BibFiles^[CurrentBibFile].marked:=BookMark^;
    end;
    Exit;
  end;
  Edited:=false; SortPattern:=Nil;
  Oentrynum:=entry^.entrynum; Orealnum:=entry^.realnum;
  Oplace:=entry^.beginning;
  if selected=CEdit_Entry then                      { Edit entry }
  begin
    if Linked                 then ErrorMessageRC(Str_EditInLinkMode,'')
    else if Entry^.entrynum=0 then ErrorMessageRC(Str_EmptyEntry,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else begin
{$IFNDEF WINDOWS}
      OldScroll:=Scroll;
{$ENDIF}
      origname:=Entry^.name;
      SortPattern:=Nil;
      if CurrentSortMode^.SortingOn and (not EditOnlyStrings) then
      begin
        if CurrentSortMode^.SortPatternExists then
        begin
          New(SortPattern);
          RecallBufferStack(SortPattern^,SortPattPosCur);
        end;
        ExtractSortRec(OldSortRec,CurrentSortMode^,SortPattern,Entry);
        if SortPattern<>Nil then Dispose(SortPattern); SortPattern:=Nil;
      end;
{$IFDEF WINDOWS}
      WEditEntry(Entry,WhichField,changed);
{$ELSE}
      EditEntry(Entry,false,Scroll,changed,outside,Pattern^.on,false,EdExitCode);
{$ENDIF}
      if changed then
      begin
        Edited:=true;
        if CurrentSortMode^.SortingOn and (not EditOnlyStrings) then
        begin
          if CurrentSortMode^.SortPatternExists then
          begin
            New(SortPattern);
            RecallBufferStack(SortPattern^,SortPattPosCur);
          end;
        end;
        ExtractSortRec(NewSortRec,CurrentSortMode^,SortPattern,Entry);
        if SortPattern<>Nil then Dispose(SortPattern); SortPattern:=Nil;
        Equiv:=true;
        if OldSortRec.name<>NewSortRec.name then Equiv:=false;
        if OldSortRec.Patt<>NewSortRec.patt then Equiv:=false;
        if Equiv then
          for i:=1 to NSortKeys do
            if OldSortRec.Keys[i]<>NewSortRec.Keys[i] then Equiv:=false;
        { DeSuspend(Entry,Pattern); }
        BibFileChange(Pattern,Entry,
                      origname,Ac_Replace,Equiv,'',0,2,0,Nil);
        PatternCheck(Entry,Pattern,PatOK,true);
        if not PatOK then
        begin
{$IFNDEF WINDOWS}
          Tpwfill(2,2,ScrLen-2,ScrWidth-2,' ',EntryNorm);
          ChrFill(line,#205,ScrWidth-2);
          TitleWindow(2,EntryNorm,line); TitleWindow(5,EntryNorm,line);
{$ENDIF}
          Pattern^.on:=false;
        end;
      end else
      begin
{$IFNDEF WINDOWS}
        Scroll:=OldScroll;
{$ENDIF}
        if entry^.nentry=0 then
        begin
          ResetBib(Entry);
          if oentrynum>0 then
            ReachEntry(Entry,orealnum,oentrynum,oplace,false);
        end;
      end;
      if SortPattern<>Nil then Dispose(SortPattern); SortPattern:=Nil;
    end;
    EntryModified:=false;
  end else if selected=CEdit_Copy then        { Copy }
  begin
{$IFNDEF WINDOWS}
    if ClipboardMode=DontKeep then ErrorMessageRC(Str_NoClipboard,'')
    else
{$ENDIF}
    if Entry^.entrynum=0 then ErrorMessageRC(Str_EmptyEntry,'')
    else EntryToClipBoard(Entry);
  end else if selected=CEdit_Cut then        { Cut }
  begin
    line:='entry "'; if EditOnlyStrings then line:='string "';
{$IFNDEF WINDOWS}
    if ClipboardMode=DontKeep then ErrorMessageRC(Str_NoClipboard,'')
    else
{$ENDIF}
    if Linked                 then ErrorMessageRC(Str_CutInLinkMode,'')
    else if Entry^.entrynum=0 then ErrorMessageRC(Str_EmptyEntry,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else if MacroCommand or YesNo(' Delete '+line+entry^.name+'"? ') then
    begin
      EntryToClipBoard(Entry);
      DeSuspend;
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
      BibFileChange(Pattern,Entry,Entry^.name,Ac_Delete,false,'',0,2,0,Nil);
      edited:=true;
    end;
    EntryModified:=false;
  end else if selected=CEdit_Paste then    { Paste }
  begin
{$IFNDEF WINDOWS}
    if ClipboardMode=DontKeep then ErrorMessageRC(Str_NoClipboard,'')
    else
{$ENDIF}
    if Linked                 then ErrorMessageRC(Str_PasteInLinkMode,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if ClipBoardEmpty    then ErrorMessageRC(Str_EmptyClipboard,'')
    else if ClipboardString and not EditOnlyStrings then
                                   ErrorMessageRC(Str_ClipboardStr,'')
    else if EditOnlyStrings and not ClipboardString then
                                   ErrorMessageRC(Str_ClipboardEnt,'')
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else begin
      Edited:=true;
      if entry^.entrynum=0 then
      begin
        ResetBib(Entry);
        GetEntry(Entry,Nil,1,true,Pattern,ok);
        if ok then
        begin
          Oentrynum:=entry^.entrynum; Orealnum:=entry^.realnum;
          Oplace:=entry^.beginning;
        end;
      end;
      origname:=Entry^.name;
      ClipBoardToEntry(Entry);
      DeSuspend;
      BibFileChange(Pattern,Entry,origname,Ac_Insert,false,'',0,2,0,Nil);
      if not BibFileExists then BibFileExists:=LFNFileExist(bibname^);
    end;
    EntryModified:=false;
{$IFDEF WINDOWS}
  end else if selected=CEdit_PasteClip then      { Paste from clipboard }
  begin
    if Linked                 then ErrorMessageRC(Str_PasteInLinkMode,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else begin
      Edited:=true;
      if entry^.entrynum=0 then
      begin
        ResetBib(Entry);
        GetEntry(Entry,Nil,1,true,Pattern,ok);
        if ok then
        begin
          Oentrynum:=entry^.entrynum; Orealnum:=entry^.realnum;
          Oplace:=entry^.beginning;
        end;
      end;
      origname:=Entry^.name;
      icode:=WinClipToEntry(Entry,EditOnlyStrings);
      if      icode=ClipErr_NotEntry  then ErrorMessageRC(Str_ClipboardStr,'')
      else if icode=ClipErr_NotString then ErrorMessageRC(Str_ClipboardEnt,'')
      else if icode=ClipErr_CantRead  then ErrorMessageRC(Str_ClipWrongFormat,'')
      else begin
        BibFileChange(Pattern,Entry,origname,Ac_Insert,false,'',0,2,0,Nil);
        if not BibFileExists then BibFileExists:=LFNFileExist(bibname^);
        EntryModified:=false;
      end;
    end;
{$ENDIF}
  end else if selected=CEdit_Replace then        { Replace }
  begin
{$IFNDEF WINDOWS}
    if ClipboardMode=DontKeep then ErrorMessageRC(Str_NoClipboard,'')
    else
{$ENDIF}
    if Linked                 then ErrorMessageRC(Str_ReplaceInLinkMode,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if ClipBoardEmpty    then ErrorMessageRC(Str_EmptyClipboard,'')
    else if ClipboardString and not EditOnlyStrings then
                                   ErrorMessageRC(Str_ClipboardStr,'')
    else if EditOnlyStrings and not ClipboardString then
                                   ErrorMessageRC(Str_ClipboardEnt,'')
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else if entry^.entrynum=0 then ErrorMessageRC(Str_ReplaceEmptyEntry,'')
    else if MacroCommand or
            YesNo(' Replace "'+entry^.name+'" by "'+Clipboardname^+'"? ') then
    begin
      edited:=true;
      origname:=entry^.name;
      if entry^.entrynum=0 then
      begin
        ResetBib(Entry);
        GetEntry(Entry,Nil,1,true,Pattern,ok);
      end;
      ClipboardToEntry(Entry);
      DeSuspend;
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
      BibFileChange(Pattern,Entry,origname,Ac_Replace,false,'',0,2,0,Nil);
    end;
    EntryModified:=false;
  end else if selected=CEdit_Clear then                         { Clear }
  begin
    line:='entry "'; if EditOnlyStrings then line:='string "';
    if Linked                 then ErrorMessageRC(Str_ClearInLinkMode,'')
    else if Entry^.entrynum=0 then ErrorMessageRC(Str_EmptyEntry,'')
    else if BibReadOnly       then ErrorMessageRC(Str_FileIsReadOnly,bibname^)
    else if TempDirList^=''   then ErrorMessageRC(Str_NoAuxDir,'')
    else if MacroCommand or YesNo(Concat(' Delete ',line,entry^.name,'"? ')) then
    begin
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
      DeSuspend;
      BibFileChange(Pattern,Entry,Entry^.name,Ac_Delete,false,'',0,2,0,Nil);
      edited:=true;
    end;
    EntryModified:=false;
  end;
  if Edited then
  begin
    if EditOnlyStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
    PatternCheck(Entry,Pattern,PatOK,true);
    if not PatOK then Pattern^.on:=false;
  end;
end;                               { DealWithEdit }

procedure TagFromAuxFile(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         fname: string; WarnNo: boolean);
type
  AuxBufType = array[1..8192] of char;
var
  aux: text;
  Paux: PAuxStream;
  ok,found,cite,Includes,abort: boolean;
  ncite,i,j,ninp,inp: longint;
  line: string;
  fn2: string;
  ch: char;
  AuxBuf: ^AuxBufType;
  Dir,Name,Ext: PString;

procedure ScanOneFile(fn: PString);
var
  KeptPos: longint;
  fn2: PString;
begin
  logstring('Scan#2 1');
  fn2:=Nil;
  if (fn=Nil) or (fn^='') then Exit;
  logstring('Scan#2 2');
  if ((Pos('\',fn^)=0) and not LFNFileExist(Dir^+fn^)) or
     ((Pos('\',fn^)>0) and not LFNFileExist(fn^)) then Exit;

  if Pos('\',fn^)=0 then LFNAssign(aux,Dir^+fn^) else LFNAssign(aux,fn^);
  if Pos('\',fn^)=0 then LogSection('ScanOneFile#2 for "'+Dir^+fn^+'"',true)
  else logsection('ScanOneFile#2 for "'+fn^+'"',true);
  LFNreset(aux,0);

  while not eof(aux) do
  begin
    ReadLine(aux,line,true);
    logstring('Read "'+line+'"');
    ChrDel(line,' ');
    i:=Pos(lbrace,line);
    if (i=0) or (line='') or (line[1]<>'\') then   { nothing }
    else if Copy(line,1,i-1)='\@input' then  { Include file }
    begin
      fn2:=NewStr(Copy(line,i+1,length(line)-i-1));
      StrRepl(fn2^,'/','\',1,255,255);
      logstring('Found file "'+fn2^+'"');

      KeptPos:=TextFilePos(aux); LFNClose(aux);
      ScanOneFile(fn2);
      DisposeStr(fn2); fn2:=Nil;

      logstring('Returning to "'+fn^+'"');
      if Pos('\',fn^)=0 then LFNAssign(aux,Dir^+fn^) else LFNAssign(aux,fn^);
      LFNreset(aux,0);
      TextSeek(aux,KeptPos);
    end else if (Copy(line,1,i-1)='\citation') or (Copy(line,1,i-1)='\bibcite') then {bingo}
    begin          { Got a live one }
      delete(line,1,i); i:=Pos(rbrace,line); if i>0 then line[0]:=Char(i-1);
      if (line<>'') and (line<>'*') then
      begin
{        message('"'+line+'"');}
        logstring('Add citation "'+line+'"');
        Paux^.write(line[0],length(line)+1); inc(ncite);
      end;
    end;
  end;
  LFNClose(aux);
  logsection('ScanOneFile',false);
end;                  { ScanOneFile }

begin
  AbortFlag:=false;
  if (fname='') or (not BibFileExists) then Exit;
  logging_on:=true;
  logsection('TagFromAuxFile',true);
  ok:=false; Paux:=Nil; AuxBuf:=Nil; abort:=false;
  New(Dir); New(Name); New(Ext);
  LFNFSplit(fname,Dir,Name,Ext);
  New(AuxBuf);
  New(PAux,init(WorkStreamOrder));
  if (PAux<>Nil) and (PAux^.status=stOK) then
  begin
    Paux^.seek(0); Paux^.truncate;
    ninp:=0;
    ncite:=0;
    Includes:=false; abort:=false;
    LFNNew(aux,true);
    logstring('Calling ScanOneFile for "'+fname+'"');
    ScanOneFile(@fname);
    LFNDispose(aux);
    if Paux^.status=stOK then ok:=true;
  end;
  if not ok then
  begin
    ErrorMessageRC(Str_CantCreateTemp,''); Failure:=true;
  end;
  ok:=ok and (not Abort);
  if ok and (ncite=0) then
  begin
    if WarnNo and not MacroCommand then ErrorMessageRC(Str_TeXFileEmpty,'');
    ok:=false; Failure:=true;
  end;
  if ok then
  begin
    ResetBib(Entry);
    AllEntriesTagged:=true;
    GetEntry(Entry,Nil,1,false,Pattern,ok); j:=Entry^.realnum;
    if j=0 then ok:=false;
    if ok then
    repeat
      Paux^.seek(0);
      found:=false;
      i:=0;
      while (i<ncite) and (not found) do
      begin
        inc(i);
        Paux^.read(line[0],1); Paux^.read(line[1],Ord(line[0]));
        if Entry^.name=line then found:=true;
      end;
      if found then Tag(entry^.realnum,TagSet,Tags);
      GetEntry(Entry,Nil,entry^.entrynum+1,false,Pattern,ok);
      inc(j);
    until (not ok) or (entry^.realnum<j);
    AllEntriesTagged:=false;
  end;
  if Paux<>Nil then Dispose(PAux,Done); Paux:=Nil;
  if AuxBuf<>Nil then Dispose(AuxBuf); AuxBuf:=Nil;
  logsection('TagFromAuxFile',false);
  logging_on:=false;
end;                      { TagFromAuxFile }

procedure DealWithTagging(Entry: EntryRecPtr; Pattern: PatRecPtr;
                          selected: byte);
var
  ok,PatOK,accept: boolean;
  orealnum,oentrynum,NumberFound,i: longint;
  Oplace,OLast: longint;
  D,N,E,fname: Pstring;
begin
  AbortFlag:=false;
  if (not BibFileExists) and (Selected<>CEdit_UntagAll) then Exit;
  Oentrynum:=entry^.entrynum; Orealnum:=entry^.realnum;
  Oplace:=entry^.beginning;
  Failure:=false;
  if (selected=CEdit_Tag) and (Orealnum>0) then     { Toggle tag }
  begin
    Tag(Entry^.realnum,TagToggle,Tags);
    if ContainsTags(Pattern) then    { Pattern with a tag }
    begin
      PatternCheck(Entry,Pattern,PatOK,true);
      if not PatOK then   { Choice has changed }
      begin
        if EntryCache^.UseCache(Pattern) then
          OLast:=EntryCache^.Last-1
        else OLast:=-1;
        ResetBib(Entry); EntryCache^.Clear;
        if OLast>-1 then
        begin
          if (OEntryNum>1) and (Oentrynum>OLast) then
            GetEntry(Entry,Nil,Oentrynum-1,true,Pattern,ok)
          else if (OentryNum<=OLast) then
            GetEntry(Entry,Nil,Oentrynum,true,Pattern,ok)
        end else
        begin
          GetEntry(Entry,Nil,Oentrynum,true,Pattern,ok);
          if (not ok) or (Entry^.entrynum<>OEntrynum) then
          begin
            ResetBib(Entry);
            if OEntryNum>1 then
              GetEntry(Entry,Nil,Oentrynum-1,true,Pattern,ok);
          end;
        end;
      end;
    end;
  end else if (selected=CEdit_TagAll) or (selected=CEdit_UntagAll) then
  begin                         { set/clear all tags }
    if ActivePattern(Pattern) then
    begin
      ResetBib(Entry);
      NumberFound:=0;
      WaitingMessage('Tagging...');
      GetEntry(Entry,Nil,1,true,Pattern,ok);
      if ok then
      repeat
        if selected=CEdit_TagAll then Tag(entry^.realnum,TagSet,Tags)
        else Tag(entry^.realnum,TagClear,Tags);
        Inc(NumberFound);
        GetEntry(Entry,Nil,entry^.entrynum+1,true,Pattern,ok);
      until (not ok) or (Entry^.entrynum<=NumberFound);
      ReachEntry(Entry,orealnum,oentrynum,oplace,false);
      WaitingOff;
    end else if selected=CEdit_TagAll then
      for i:=0 to 4095 do Tags[i]:=65535    
    else if selected=CEdit_UntagAll then EraseTags(Tags);
    if ContainsTags(Pattern) then
    begin
      ResetBib(Entry); EntryCache^.Clear;
      ReachRealEntry(Entry,Pattern,ORealNum);
    end;
  end else if selected=CEdit_TagTeX then         { Read citations from .aux file }
  begin
    ok:=false;
    if MacroCommand then TexAuxFile^:=InputStr^;
    { Kludge }
    StrLwr(TexAuxFile^);
    if not (MacroCommand and (StrPosLI(TexAuxFile^,'.aux')<>length(TexAuxFile^)-3)
            and LFNFileExist(TeXAuxFile^)) then
    begin
      FileChoose(TeXAuxFile^,'.tex',TexInputList,
                 AnyFile and (not (Directory or SysFile)),
                 not MacroCommand,true,false,Nil,'TeX file:',LaTeXDesc,ok);
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
    end;
    if ok then
    begin
      AllocStrings(true,@fname,@D,@N,@E);
      LFNFSplit(TeXAuxFile^,D,N,E);
      fname^:=D^+N^+'.AUX'; CanonicalFname(fname^);
      if not LFNFileExist(fname^) then
      begin
        if not MacroCommand then ErrorMessageRC(Str_CantOpenFile,fname^);
        Failure:=true;
      end else
      begin
        TagFromAuxFile(Entry,Pattern,fname^,true);
        ResetBib(Entry); if ContainsTags(Pattern) then EntryCache^.Clear;
        if orealnum=0 then
        begin
          GetEntry(Entry,Nil,1,true,Pattern,ok);
        end else
        begin
          if ContainsTags(Pattern) then
            ReachRealEntry(Entry,Pattern,ORealNum)
          else
          ReachEntry(Entry,orealnum,oentrynum,oplace,false);
        end;
      end;
      AllocStrings(false,@fname,@D,@N,@E);
    end;
  end;
end;                               { DealWithTagging }

function DealWithPattern(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                         Scroll: longint; FromFirst: boolean;
{$ELSE}
                         var Scroll: longint; FromFirst: boolean;
{$ENDIF}
                         Selected: word): boolean;
var
  orealnum,i,j: longint;
  PatOk,ok,changed,On2Off: boolean;
  line: string[133];
{$IFDEF WINDOWS}
  DummyFile: text;
  TempPatt: PatRecPtr;
  P: PStream;
{$ENDIF}
begin                                 { DealWithPattern }
  Orealnum:=Entry^.realnum;
  On2Off:=false; AbortFlag:=false;
  DealWithPattern:=false; changed:=false;
  if Selected=CPatt_OnOff then
  begin
    On2Off:=Pattern^.on;
    changed:=true;
    if Pattern^.on then Pattern^.on:=false
    else if Pattern^.noper>0 then Pattern^.on:=true
    else changed:=false;
    On2Off:=On2Off and not Pattern^.on;
  end else if (Selected=CPatt_AllFields) or
     ((Selected>=CPatt_User) and (Selected<CPatt_User+PMenuNum)) then
  begin
    changed:=OneCritPattern(Pattern,Selected);
    if changed then Pattern^.on:=true;
  end else if Selected=CPatt_Tagged then
  with Pattern^ do
  begin
    noper:=1; npatt:=1;
    operation[1]:=1;
    Field[1]:=PattField_Tagged;
    on:=true;
    changed:=true;
  end else if Selected=CPatt_Edit then
{$IFNDEF WINDOWS}
    PatternGet(Pattern,changed);
{$ELSE}
    PatternGet(MainW,Pattern,changed)
  else if (Selected=CPatt_Macro) or (Selected=CPatt_Stream) then
  begin
    New(TempPatt); TempPatt^:=Pattern^;
    if Selected=CPatt_Macro then
      InputPattern(DummyFile,Nil,Pattern,InputStr^,false,false)
    else begin                                     
      move(InputStr^[1],P,sizeof(P));
      InputPattern(DummyFile,P,Pattern,'',true,false);
    end;
    if (Pattern^.npatt=0) then Pattern^:=TempPatt^
    else begin
      changed:=true; Pattern^.on:=true;
    end;
    Dispose(TempPatt);
  end else if (Selected>=cm_FirstPattHeirarchy) and
     (Selected<cm_FirstPattHeirarchy+PattHeirCount) then
  begin
    New(TempPatt); TempPatt^:=Pattern^;
    if (not GetMenuPattern(Pattern,Selected)) or (Pattern^.npatt=0)
         then Pattern^:=TempPatt^
    else begin
      changed:=true; Pattern^.on:=true;
    end;
    Dispose(TempPatt);
  end;
{$ENDIF}
  if changed then
  begin
    EntryCache^.Clear;
    EntryCache^.LoadCache(Pattern);
  end;
  if changed and EntryCache^.UseCache(Pattern) and (EntryCache^.Last=0) then
  begin
    ResetBib(Entry);
  end else if changed and (pattern^.on) then
  begin
    SearchingMessage;;
{$IFDEF WINDOWS}
    UpdateWindow(HMainW);
{$ENDIF}
    if Entry^.EntryNum>0 then
      PatternCheck(Entry,Pattern,PatOK,true)
    else PatOk:=false;
    ResetBib(Entry);
    if PatOK then
    begin
      FromFirst:=true;
      Scroll:=0;
      i:=1; j:=-1;
      repeat
        GetEntry(Entry,Nil,i,true,Pattern,ok);
        inc(i); inc(j);
      until (Entry^.realnum=orealnum) or (Entry^.realnum<j);
    end else
    begin
      GetEntry(Entry,Nil,1,true,Pattern,ok);
      if ok then ShowNewFields(Entry)
      else ResetBib(Entry);
    end;
    if Entry^.EntryNum=0 then EntryCache^.SetLast(0,Pattern);
    WaitingOff;
  end else if On2Off and (Entry^.EntryNum=0) then
  begin
    ResetBib(Entry);
    if BibFileExists then GetEntry(Entry,Nil,1,true,Pattern,ok);
  end;
  if not Pattern^.on then Entry^.entrynum:=Entry^.realnum;
  DealWithPattern:=Changed;
end;                                 { DealWithPattern }

procedure DealWithFiles(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        selected: SelectionType);
var
  tmp,IndName: string;
  Olink,finish,OldPatton,ok,changed,accept,IsCurrent: boolean;
  Old8bit,Old7bit,New8bit,New7bit: boolean;
  OldProg8bit,OldProg7bit,AutoGenerateIndex,Recurse: boolean;
  EOHeader,NShiftEnt,NShiftReal,OBeginning,OReal,OEntry: longint;
  EntryIndex,RealIndex,OldOffset,l: longint;
  OldEnc,NewEnc,OldDispEnc: integer;
  bibattr,Nent: Word;
  Ocurrent,i,j: byte;
  SortPattern: PatRecPtr;
  tfile: file;
  OldTags: ^TagType;
{$IFDEF WINDOWS}
  which: integer;
{$ENDIF}

function NewFile(selected: byte): boolean;
var
  i,xstart: byte;
  ok,IsReadOnly: boolean;
  fname,Dir,Name,Ext: PString;
begin
  NewFile:=false;
  AllocStrings(true,@fname,@Dir,@Name,@Ext);
  if MacroCommand then fname^:=InputStr^
  else begin
    fname^:=BibFiles^[selected].name;
    if fname^='' then fname^:='*';
  end;
  IsReadOnly:=ForbidEditing;
  if (not MacroCommand) or (fname^<>'') then
    FileChoose(fname^,DefExtension[BibTeXFormat]^,TexInputList,NormalFileAttr,
             (not MacroCommand) or (Pos('*',fname^)+Pos('?',fname^)>0),
             false,false,@IsReadOnly,'BibFile '+Chr(Ord('0')+selected)+':',
             DatabaseDesc,accept)
  else accept:=true;
  if not accept then
  begin
    AllocStrings(false,@fname,@Dir,@Name,@Ext);
    Exit;
  end;

  if fname^<>'' then                     { New file }
  begin
    IndexToBibExt(fname^);
    if not LFNFileExist(fname^) then
    begin
      LFNFSplit(fname^,Dir,Name,Ext);
      if Ext^='' then fname^:=fname^+DefExtension[BibTeXFormat]^;
    end;
    if (fname^<>'') and IsFileName(fname^) then
    begin
      ok:=false;
      fname^:=LFNFExpand(fname^); CanonicalFname(fname^);
      BibFiles^[selected].name:=fname^;
      BibFiles^[selected].entrynum:=0;
      BibFiles^[selected].realnum:=0;
      BibFiles^[selected].marked:='';
      BibFiles^[selected].Time:=GetFileTime(fname^);
      BibFiles^[selected].Ex:=false;
      BibFiles^[selected].RO:=IsReadOnly;
    end;
  end else
  begin                                 { Erase old file }
    if CurrentBibFile=selected then
    begin
      if not MacroCommand then ErrorMessageRC(Str_CurFileIsNull,'');
      Failure:=true;
    end else
    begin
      BibFiles^[selected].name:='';
      BibFiles^[selected].entrynum:=0;
      BibFiles^[selected].realnum:=0;
      BibFiles^[selected].marked:='';
      BibFiles^[selected].Time:=GetFileTime(fname^);
      BibFiles^[selected].Ex:=false;
      BibFiles^[selected].RO:=false;
    end;
  end;
  NewFile:=true;
  AllocStrings(false,@fname,@Dir,@Name,@Ext);
end;                           { NewFile }

procedure SelectFile(selected: byte);
var
  tmp: string;
  btmp: boolean;
begin
  tmp:=bibname^;
  bibname^:=BibFiles^[selected].name;
  NewBib(bibname^,(bibname^=''),true,false,btmp);
  if bibname^='' then bibname^:=tmp
  else begin
{    BibReadOnly:=BibReadOnly or BibFiles^[selected].RO;}
    CurrentBibFile:=selected;
  end;
end;

begin                                 { DealWithFiles }
  OldTags:=Nil;
  AbortFlag:=false;
  if (Selected[1]=0) or (Selected[1]=CFile_Exit) then Exit;
  AutoGenerateIndex:=false; Recurse:=false;
  if Selected[1]=CFile_AutoIndex then         { Auto-build index }
  begin
    Selected[1]:=CFile_Index; Recurse:=true;
  end;
{$IFNDEF WINDOWS}
  if selected[1]=CFile_Shell then             { DOS }
  begin
    if not AllowShell then
    begin
      if Multitasker=DesqView then
        ErrorMessage(' Shelling disabled in DESQview - open DOS window instead. ')
      else if Multitasker=Windows then
        ErrorMessage(' Shelling disabled in Windows 3.x - open DOS window instead. ')
      else
        ErrorMessage(' Shelling disabled. ');
    end else begin
      Shell(Entry,Pattern);
    end;
    Exit;
  end;
{$ENDIF}
  Failure:=false;
  if selected[1]=CFile_ReadOnly then
  begin
    if not BibFileExists then Exit;
    if Linked then
    begin
      if not MacroCommand then ErrorMessageRC(Str_UnlinkFiles,'');
      Failure:=true;
    end else
    begin
      assign(tfile,LFNShortName(bibname^));
      GetFAttr(tfile,bibattr);
      if bibattr and ReadOnly<>0 then
      begin
        if not MacroCommand then ErrorMessageRC(Str_ChangeROAttrib,'');
        failure:=true;
      end else BibReadOnly:=not BibReadOnly;
    end;
    exit;
  end else if selected[1]=CFile_Translate then
  begin
    if not BibFileExists then Exit;
    Old8bit:=File8bit; Old7bit:=File7bit;
    New8bit:=File8bit; New7bit:=File7bit;
    if not (New7bit or New8bit) then New7bit:=true;
    OldEnc:=FReadEncoding; NewEnc:=FReadEncoding;
{$IFDEF WINDOWS}
    if (application^.ExecDialog(New(PEncTranslateDlg,init(MainW,
         @Old8bit,@Old7bit,@New8bit,@New7bit,@OldEnc,@NewEnc)))=id_ok) and
       ((OldEnc<>NewEnc) or (Old8bit<>New8bit) or (Old7bit<>New7bit)) and
       (PEncoding(EncodingsList.at(NewEnc))^.Name^<>'<none>') then
    begin
      EntryCache^.Clear;
      OldProg8bit:=Prog8bit; OldProg7bit:=Prog7bit;
      Prog8bit:=Old8bit; Prog7bit:=Old7bit;
      FWrite8bit:=New8bit; FWrite7bit:=New7bit;
      HighBits(NewEnc,OldEnc,NewEnc);

      UseReadEncodingOnly:=false;
      selected[1]:=CFile_Reformat;
      DealWithFiles(Entry,Pattern,Selected);
      UseReadEncodingOnly:=true;

      Prog8bit:=OldProg8bit; Prog7bit:=OldProg7bit;
      File8bit:=New8bit; File7bit:=New7bit; FReadEncoding:=NewEnc;
      HighBits(DispEncoding,FReadEncoding,-1);
      RefreshEntry(Entry);
      OptionsModified.WindowsParams:=true;
    end;
{$ENDIF}
    exit;
  end;
                           { Preserve current file info }
  OEntry:=Entry^.EntryNum; OReal:=Entry^.RealNum; OBeginning:=Entry^.Beginning;
  tmp:=bibname^; Olink:=Linked;
  OCurrent:=CurrentBibFile;
  changed:=false; OldOffset:=0;

  if Linked then
  begin
    OldOffset:=BibFiles^[CurrentBibFile].realstart;
    if (Selected[1]<>CFile_Link) and (Selected[1]<>CFile_Exit) then
    begin
      if not MacroCommand then ErrorMessageRC(Str_UnlinkFiles,'');
      Failure:=true; Exit;
    end;
  end;
  if Linked then
  begin
    CurrentBibFile:=BibRing[BibInRing];
    BibFiles^[CurrentBibFile].realnum:=entry^.realnum
                     -BibFiles^[CurrentBibFile].realstart;
    BibFiles^[CurrentBibFile].entrynum:=entry^.entrynum
                     -BibFiles^[CurrentBibFile].entrystart;
  end else
  begin
    BibFiles^[CurrentBibFile].realnum :=entry^.realnum;
    BibFiles^[CurrentBibFile].entrynum:=entry^.entrynum;
    BibFiles^[CurrentBibFile].time:=GetFileTime(bibname^);
  end;
  BibFiles^[CurrentBibFile].PatOn:=Pattern^.on;
  BibFiles^[CurrentBibFile].Place:=Entry^.beginning;
  BibFiles^[CurrentBibFile].PatNum:=PatternNumber;
  BibFiles^[CurrentBibFile].Ex:=BibFileExists;
  BibFiles^[CurrentBibFile].RO:=BibReadOnly;

  if selected[1]=CFile_Close then          { Close file }
  begin
    if (CurrentBibFile<1) or (bibname^='') then Exit;
    i:=CurrentBibFile-1; j:=0;
    while (j=0) and (i<>CurrentBibFile) do
    begin
      if i<1 then i:=MaxBibFiles;
      if BibFiles^[i].name<>'' then j:=i;
      dec(i);
    end;
    BibFiles^[CurrentBibFile].name:='';
    BibFiles^[CurrentBibFile].entrynum:=0;
    BibFiles^[CurrentBibFile].realnum:=0;
    BibFiles^[CurrentBibFile].marked:='';
    BibFiles^[CurrentBibFile].Time:=0;
    BibFiles^[CurrentBibFile].Ex:=false;
    BibFiles^[CurrentBibFile].RO:=false;
    if j<>0 then SelectFile(j)
    else begin
      CloseFile(bib); CurrentBibFile:=1;
    end;
    changed:=true;
  end else if selected[1]=CFile_Link then           { Link/Unlink }
  begin
    if not Linked then
    begin
      linked:=true;
      BibRingNum:=0;
      for i:=1 to MaxBibFiles do
        if LFNFileExist(BibFiles^[i].name) then
        begin
          Inc(BibRingNum);
          BibRing[BibRingNum]:=i;
        end;
      if BibRingNum<=1 then linked:=false;
      if linked then
      begin
        CurrentBibFile:=BibRing[1];
        bibname^:=BibFiles^[CurrentBibFile].name;
        BibInRing:=1;
      end;
    end else
    begin
      CurrentBibFile:=OCurrent;
      Linked:=false;
    end;
    changed:=true;
  end else if (selected[1]>=CFile_List) and
              (selected[1]<CFile_List+MaxBibFiles) and
              ((selected[1]-CFile_List+1<>CurrentBibFile) or (bibname^='')) then
  begin                                                      { Select file }
    i:=selected[1]-CFile_List+1;
    if BibFiles^[i].name=''  then
    begin                                              { New file }
      if selected[2]=0 then
      begin
        NewFile(i);
        if (BibFiles^[i].name<>'') then SelectFile(i);
        changed:=true;
      end;
    end else
    begin                                              { Select file }
      SelectFile(i);
      changed:=true;
    end;
  end else if selected[1]=CFile_Open then                       { Open file }
  begin
    if BibFileExists then
    begin
      j:=0;
      for i:=1 to MaxBibFiles do if (j=0) and (BibFiles^[i].name='') then j:=i;
      if j=0 then j:=CurrentBibFile+1;
      if j>MaxBibFiles then j:=1;
    end else j:=CurrentBibFile;
    if j=0 then
    begin
      if not MacroCommand then ErrorMessageRC(Str_AllSlotsFull,'');
      Failure:=true;
    end else
    begin
      tmp:=BibFiles^[j].name; BibFiles^[j].name:='';
      if NewFile(j) then
      begin
        if (BibFiles^[j].name<>'') then
        begin
          SelectFile(j);
          changed:=true;
        end;
      end else BibFiles^[j].name:=tmp;
    end;
  end else if (selected[1]=CFile_Change) and (selected[2]<>0) then
  begin                                                { Edit file }
    NewFile(Selected[2]);
    if MacroCommand and (Selected[3]=1) and
       (BibFiles^[Selected[2]].name<>'') then SelectFile(Selected[2]);
    changed:=true;
  end else if selected[1]=CFile_Sort then             { Sort file }
  begin
    DeSuspend;
    CurrentSortMode^.SortingOn:=true;
    BibFileChange(Pattern,Entry,Entry^.name,Ac_Sort,false,'',0,2,0,Nil);
  end else if selected[1]=CFile_Reformat then             { Reformat file }
  begin
    DeSuspend;
    BibFileChange(Pattern,Entry,Entry^.name,Ac_Reformat,false,'',0,2,0,Nil);
  end else if (selected[1]=CFile_Index) then              { Index file }
  begin
    if UseIndexFile then
    begin
      DeSuspend;
      BibFileChange(Pattern,Entry,Entry^.name,Ac_Index,false,'',0,2,0,Nil);
    end else
    begin
      if not MacroCommand then ErrorMessageRC(Str_IndexUseIsOff,'');
      Failure:=true;
    end;
  end;

  { Post processing }

  if changed then
  begin
    EntryCache^.Clear;
    LastRealNum:=0;
    bibname^:=bibfiles^[CurrentBibFile].name;
{$IFDEF WINDOWS}
    UnlockOleServers;
{$ENDIF}
    BibFileExists:=LFNFileExist(bibname^);
    if not BibFileExists then BibReadOnly:=false;
    NewDump(false,bibname^);
    if not Linked then
    begin
      BibRing[1]:=CurrentBibFile; BibRingNum:=1; BibInRing:=1;
    end;
    SearchingMessage;
    if (Entry^.EntryNum=0) and (Linked and not OLink) then
    begin
      EntryCache^.LoadCache(Pattern);
      ResetBib(Entry);
    end else if Linked and (not OLink) then        { Link up }
    begin
      LFNClose(bib);
      for i:=1 to MaxBibFiles do
      begin
        BibFiles^[i].EntryStart:=0; BibFiles^[i].RealStart:=0;
      end;
      EntryCache^.LoadCache(Pattern);
      NShiftEnt:=0; NShiftReal:=0;
      Linked:=false;
      BibInRing:=1;
      for i:=1 to OCurrent-1 do                   
      if (BibFiles^[i].name<>'') and LFNFileExist(BibFiles^[i].name) then
      begin
        if BibFiles^[i+1].EntryStart>0 then
        begin
          NShiftEnt:=BibFiles^[i+1].EntryStart;
          NShiftReal:=BibFiles^[i+1].RealStart;
        end else
        begin
          BibFiles^[i].EntryStart:=NShiftEnt; BibFiles^[i].RealStart:=NShiftReal;
          BibName^:=BibFiles^[i].name; LFNAssign(Bib,Bibname^); IsCurrent:=false;
          if UseIndexFile and not Pattern^.on then 
            IndexFileStatus(Bib,@BibFiles^[i].name,IndName,Nil,Nil,false,IsCurrent,
                            Nent,EOHeader);
          if IsCurrent then
          begin
            NShiftEnt:=NShiftEnt+Nent; NShiftReal:=NShiftReal+Nent;
          end else
          begin
            ResetBib(Entry);
            repeat
              EntryIndex:=Entry^.Entrynum; RealIndex:=Entry^.RealNum;
              GetEntry(Entry,Nil,Entry^.EntryNum+1,false,Pattern,ok);
            until (not ok) or (RealIndex>=Entry^.RealNum);
            CloseFile(bib);
            NShiftEnt:=NShiftEnt+EntryIndex; NShiftReal:=NShiftReal+RealIndex;
          end;
          inc(BibInRing);
        end;
      end;
      CurrentBibFile:=OCurrent;
      BibFiles^[OCurrent].EntryStart:=NShiftEnt;
      BibFiles^[OCurrent].RealStart:=NShiftReal;
      BibName^:=BibFiles^[OCurrent].name;
      LFNAssign(bib,bibname^);
      CheckForIndexFile(bib,bibname);
      ResetBib(Entry);
      ReachEntry(Entry,oreal,oentry,Obeginning,false);
      Entry^.EntryNum:=Entry^.EntryNum+NShiftEnt;
      Entry^.RealNum:=Entry^.RealNum+NShiftReal;
      { Update tags }
      New(OldTags); Move(Tags,OldTags^,sizeof(Tags));
      EraseTags(Tags);
      for l:=1 to MaxTags do
        if IsTagged(l,OldTags^) then Tag(l+NShiftReal,TagSet,Tags);
      Dispose(OldTags);
      Linked:=true;
    end else if (StrCmpI(bibname^,tmp,1,1,255)<>0)
          or (OCurrent<>CurrentBibFile)
          or (Olink and (not Linked)) then
    begin
      if Olink and not Linked and (OldOffset>0) then      { Update tags }
      begin
        New(OldTags); Move(Tags,OldTags^,sizeof(Tags));
        EraseTags(Tags);
        for l:=OldOffset+1 to MaxTags do
          if IsTagged(l,OldTags^) then Tag(l-OldOffset,TagSet,Tags);
        Dispose(OldTags);
      end;
      LFNClose(bib);
      EntryCache^.LoadCache(Pattern);
      LFNAssign(bib,bibname^);
      UnixBib:=IsUnixFile(bib,bibname^);
      ResetBibFile(bib,bibname^);
      suspended:=false;

      { look for sort order info }

      CurrentSortMode^:=ConfigSortMode^;
      finish:=false;
      i:=0;
      PushBufferStack(Pattern^,sizeof(PatRec),EnoughMem(sizeof(PatRec)),0);
      MaxMemAvail;
      RecallBufferStack(Pattern^,SortPattPosDef);
      if BibFileExists then
      begin
        CurrentSortMode^.SortingOn:=SortedByDefault;
        while (not eof(bib)) and (not finish) and (i<=MaxLookForSort) do
        begin
          tmp:='';
          ReadLine(bib,tmp,UnixBib); ChrDel(tmp,' '); StrLwr(tmp);
          inc(i);
          if tmp='\sort'+lbrace then
          begin
            LoadSortMode(bib,Nil,CurrentSortMode^,Pattern);
            finish:=true;
          end;
        end;
      end else CurrentSortMode^.SortingOn:=SortNewFiles;
      PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur);
      PopBufferStack(Pattern^);

      { Check for index file }
      
      CheckForIndexFile(bib,bibname);
      AutoGenerateIndex:=AutoBuildIndex and (not Recurse) and UseIndexFile and
        BibFileExists and (not Linked) and (IndexFileName^='');

      { Go to new file, possibly restoring old position }

      SetTextBuf(bib,bibbuf^,FileBufSize);
      LFNReset(bib,0);
      ResetBib(Entry);
      LFNGetFAttr(bib,bibattr);
      BibReadOnly:=BibFileExists and
        (BibFiles^[CurrentBibFile].RO or (bibattr and ReadOnly <> 0));

      if EntryCache^.UseCache(Pattern) and (EntryCache^.Last=0) then
        ResetBib(Entry)           { Empty }
      else if BibFiles^[CurrentBibFile].time<>GetFileTime(bibname^) then
      begin                  { File has changed }
        GetEntry(Entry,Nil,1,true,Pattern,ok);
        if ok then ShowNewFields(Entry)
        else ResetBib(Entry);
      end else if (Olink and not Linked) then
      begin           { Unlinking, revise numbers }
        ReachEntry(Entry,bibfiles^[CurrentBibFile].realnum,
                         bibfiles^[CurrentBibFile].entrynum,
                         bibfiles^[CurrentBibFile].Place,false);
                         {
        ReachEntry(Entry,OReal-bibfiles^[CurrentBibFile].RealStart,
                         OEntry-bibfiles^[CurrentBibFile].EntryStart,
                         OBeginning,false);
                         }
      end else if BibFiles^[CurrentBibFile].realnum>0 then
      begin              { Go to remembered entry }
        ReachEntry(Entry,bibfiles^[CurrentBibFile].realnum,
                         bibfiles^[CurrentBibFile].entrynum,
                         bibfiles^[CurrentBibFile].Place,true);
        if Entry^.realnum<>bibfiles^[CurrentBibFile].realnum then
          Pattern^.on:=false
        else if PatternNumber=bibfiles^[CurrentBibFile].PatNum then
        begin
          Pattern^.on:=bibfiles^[CurrentBibFile].PatOn;
          Entry^.entrynum:=bibfiles^[CurrentBibFile].entrynum;
        end;
      end else
      begin
        GetEntry(Entry,Nil,1,true,Pattern,ok);
        if ok then ShowNewFields(Entry)
        else ResetBib(Entry);
      end;
      if Entry^.EntryNum=0 then EntryCache^.SetLast(0,Pattern);
      if Linked=OLink then EraseTags(Tags);
    end;
    WaitingOff;
    if not linked then BookMark^:=BibFiles^[CurrentBibFile].marked;
    if AutoGenerateIndex then   { Recursive call to auto-generate index files }
    begin
      Selected[1]:=CFile_AutoIndex; Selected[2]:=0;
      DealWithFiles(Entry,Pattern,Selected);
    end;
{$IFDEF WINDOWS}
                   { Pattern Heirarchy stuff }
    if GetPattHeirarchy(PattHeirarchy,0,bibname,true)<0 then
      GetPattHeirarchy(PattHeirarchy,0,Nil,false);
    InsertPattHeirarchyMenu(0,PattHeirarchy);
{$ENDIF}
  end;
end;                                 { DealWithFiles }


end.
