/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.etoolbox.EtoolboxList;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsTableChildEntries
extends AbstractGlsCommand {
    public GlsTableChildEntries(GlossariesSty glossariesSty) {
        this("glstableChildEntries", glossariesSty);
    }

    public GlsTableChildEntries(String string, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
    }

    @Override
    public Object clone() {
        return new GlsTableChildEntries(this.getName(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXParserListener teXParserListener = teXParser.getListener();
            int n = glossaryEntry.getInt("childcount", teXParser);
            if (n > 0) {
                TeXObjectList teXObjectList2 = teXParserListener.createStack();
                TeXObject teXObject = glossaryEntry.get("childlist");
                teXObjectList2.add(teXParserListener.getControlSequence("glstablePreChildren"));
                teXObjectList2.add(teXParserListener.getControlSequence("begin"));
                teXObjectList2.add(teXParserListener.createGroup("glstablesubentries"));
                if (teXObject instanceof EtoolboxList) {
                    EtoolboxList etoolboxList = (EtoolboxList)teXObject;
                    int n2 = etoolboxList.size();
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            teXObjectList2.add(teXParserListener.getControlSequence("glstableblocksubentrysep"));
                        }
                        teXObjectList2.add(teXParserListener.getControlSequence("glstableblocksubentry"));
                        teXObjectList2.add(TeXParserUtils.createGroup(teXParserListener, (TeXObject)etoolboxList.get(i)));
                    }
                } else {
                    String[] stringArray = teXParser.expandToString(teXObject, teXObjectList).split("|");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            teXObjectList2.add(teXParserListener.getControlSequence("glstableblocksubentrysep"));
                        }
                        teXObjectList2.add(teXParserListener.getControlSequence("glstableblocksubentry"));
                        teXObjectList2.add(teXParserListener.createGroup(stringArray[i]));
                    }
                }
                teXObjectList2.add(teXParserListener.getControlSequence("end"));
                teXObjectList2.add(teXParserListener.createGroup("glstablesubentries"));
                TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

