/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.EmUnit;
import com.dickimawbooks.texparserlib.ExUnit;
import com.dickimawbooks.texparserlib.FillUnit;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.MuUnit;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;

public abstract class TeXUnit
extends AbstractTeXObject {
    public static final FixedUnit PT = new FixedUnit(0);
    public static final FixedUnit SP = new FixedUnit(8);
    public static final FixedUnit BP = new FixedUnit(3);
    public static final FixedUnit CM = new FixedUnit(4);
    public static final FixedUnit MM = new FixedUnit(5);
    public static final FixedUnit IN = new FixedUnit(2);
    public static final EmUnit EM = new EmUnit();
    public static final ExUnit EX = new ExUnit();
    public static final MuUnit MU = new MuUnit();
    public static final FillUnit FIL = new FillUnit(1);
    public static final FillUnit FILL = new FillUnit(2);
    public static final FillUnit FILLL = new FillUnit(3);

    public abstract float toUnit(TeXParser var1, float var2, TeXUnit var3) throws TeXSyntaxException;

    public abstract float fromUnit(TeXParser var1, float var2, TeXUnit var3) throws TeXSyntaxException;

    @Override
    public abstract Object clone();

    public float toPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return this.toUnit(teXParser, f, FixedUnit.PT);
    }

    public float fromPt(TeXParser teXParser, float f) throws TeXSyntaxException {
        return this.fromUnit(teXParser, f, FixedUnit.PT);
    }

    public int toSp(TeXParser teXParser, float f) throws TeXSyntaxException {
        return (int)this.toUnit(teXParser, f, FixedUnit.SP);
    }

    public float fromSp(TeXParser teXParser, int n) throws TeXSyntaxException {
        return this.fromUnit(teXParser, n, FixedUnit.SP);
    }

    public static float muToEm(float f) {
        return f / 18.0f;
    }

    public static float emToMu(float f) {
        return 18.0f * f;
    }

    public String toString() {
        return String.format("%s[unit=%s]", this.getClass().getSimpleName(), this.format());
    }
}

