/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPdfTask;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class PdfMetaDataTask
extends AbstractPdfTask {
    private String author;
    private String creator;
    private String keywords;
    private String subject;
    private String title;

    public void execute() {
        try {
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input);
            PdfReader reader = this.createPdfReaderFromFile(input);
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            HashMap info = reader.getInfo();
            if (this.title != null) {
                info.put("Title", this.title);
            }
            if (this.subject != null) {
                info.put("Subject", this.subject);
            }
            if (this.keywords != null) {
                info.put("Keywords", this.keywords);
            }
            if (this.creator != null) {
                info.put("Creator", this.creator);
            }
            if (this.author != null) {
                info.put("Author", this.author);
            }
            stamper.setMoreInfo(info);
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

