/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFNumber;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFReal;
import de.tu_darmstadt.sp.pudl.DocDataType;

public class PDFRectangle
implements DocDataType {
    PDFArray rectangle;

    public PDFRectangle(double llx, double lly, double urx, double ury) {
        this.rectangle = new PDFArray();
        this.rectangle.add(new PDFReal(llx));
        this.rectangle.add(new PDFReal(lly));
        this.rectangle.add(new PDFReal(urx));
        this.rectangle.add(new PDFReal(ury));
    }

    public PDFRectangle(PDFArray points) {
        this.rectangle = new PDFArray(points);
        if (!(this.rectangle.size() == 4 && this.rectangle.get(0) instanceof PDFNumber && this.rectangle.get(1) instanceof PDFNumber && this.rectangle.get(2) instanceof PDFNumber && this.rectangle.get(3) instanceof PDFNumber)) {
            throw new IllegalArgumentException("Rectangle does not consist of 4 Numbers:" + this.rectangle.toString());
        }
        this.rectangle.get(0).setDirect();
        this.rectangle.get(1).setDirect();
        this.rectangle.get(2).setDirect();
        this.rectangle.get(3).setDirect();
    }

    public double getHeigth() {
        return ((PDFNumber)this.rectangle.get(3)).value() - ((PDFNumber)this.rectangle.get(1)).value();
    }

    public PDFNumber getLLX() {
        return (PDFNumber)this.rectangle.get(0);
    }

    public PDFNumber getLLY() {
        return (PDFNumber)this.rectangle.get(1);
    }

    public PDFObject getRepresentation() {
        return this.rectangle;
    }

    public PDFNumber getURX() {
        return (PDFNumber)this.rectangle.get(2);
    }

    public PDFNumber getURY() {
        return (PDFNumber)this.rectangle.get(3);
    }

    public double getWidth() {
        return ((PDFNumber)this.rectangle.get(2)).value() - ((PDFNumber)this.rectangle.get(0)).value();
    }
}

