


          TEX(1)               INTERACTIVE UNIX System               TEX(1)



          NAME
               tex, initex, virtex  - text formatting and typesetting

          SYNOPSIS
               tttteeeexxxx [ first line ]

               iiiinnnniiiitttteeeexxxx [ first line ]

               vvvviiiirrrrtttteeeexxxx [ first line ]

          DESCRIPTION
               TeX formats the interspersed text and commands contained in
               the named files and outputs a typesetter independent file
               (called _D_V_I which is short for _De_Vice _Independent).  TeX
               capabilities and language are described in _T_h_e _T_e_X_b_o_o_k by
               Donald E. Knuth, published by Addison-Wesley.

               TeX is normally used with a large body of precompiled mac-
               ros, and there are several specific formatting systems, such
               as LaTeX, which require the support of several macro files.
               The basic programs as compiled are called _i_n_i_t_e_x and _v_i_r_t_e_x,
               and are distinguished by the fact that _i_n_i_t_e_x can be used to
               precompile macros into a ._f_m_t file, which is used by _v_i_r_t_e_x.
               On the other hand, _v_i_r_t_e_x starts more quickly and can read a
               precompiled ._f_m_t file, but it cannot create one.  It is the
               version of TeX which is usually invoked in production, as
               opposed to installation.

               Any arguments given on the command line to the TeX programs
               are passed to them as the first input line.  (But it is
               often easier to type extended arguments as the first input
               line, since shells tend to gobble up or misinterpret TeX's
               favorite symbols, like backslashes, unless you quote them.)
               As described in _T_h_e _T_e_X_b_o_o_k, that first line should begin
               with a file name or a \controlsequence.  The normal usage is
               to say ``tttteeeexxxx _p_a_p_e_r'' to start processing _p_a_p_e_r._t_e_x. The name
               ``paper'' will be the ``jobname'', and is used in forming
               output file names.  If TeX doesn't get a file name in the
               first line, the jobname is ``texput''.  The default exten-
               sion, ._t_e_x, can be overridden by specifying an extension
               explicitly.

               If there is no paper.tex in the current directory, TeX will
               look look through a search path of directories to try to
               find it.  If ``paper'' is the ``jobname'' a log of error
               messages, with rather more detail than normally appears on
               the screen, will appear in _p_a_p_e_r._l_o_g, and the output file
               will be in _p_a_p_e_r._d_v_i. The system library
               ////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////iiiinnnnppppuuuuttttssss contains the basic macro package
               _p_l_a_i_n._t_e_x, described in _T_h_e _T_e_X_b_o_o_k, as well as several
               others.  Except when ._f_m_t files are being prepared it is
               hardly ever necessary to \input plain, since almost all
               instances of TeX begin by loading _p_l_a_i_n._f_m_t.  This means


          Rev. 9/25/90                                               Page 1






          TEX(1)               INTERACTIVE UNIX System               TEX(1)



               that all of the control sequences discussed in _T_h_e _T_e_X_b_o_o_k
               are known when you invoke _t_e_x.  For a discussion of ._f_m_t
               files, see below.

               Several environment variables can be used to set up direc-
               tory paths to search when TeX opens a file for input.  For
               example, the _c_s_h command
                   setenv TEXINPUTS
                   .:/usr/me/mylib:/usr/local/lib/tex/inputs
               or the _s_h command sequence
                   TEXINPUTS=.:/usr/me/mylib:/usr/local/lib/tex/inputs
                   export TEXINPUTS
               would cause all invocations of TeX and its derivatives to
               look for \input files first in the current directory, then
               in a hypothetical user's ``mylib'', and finally in the sys-
               tem library.  Normally, you would place the variable assign-
               ment which sets up the TEXINPUTS environment variable in
               your ._l_o_g_i_n or ._p_r_o_f_i_l_e file.  The environment variables
               section below lists the relevant environment variables, and
               their defaults.

               The _e response to TeX's error prompt causes the system
               default editor to start up at the current line of the
               current file.  There is an environment variable, TEXEDIT,
               that can be used to change the editor used.  It should con-
               tain a string with "%s" indicating where the filename goes
               and "%d" indicating where the decimal linenumber (if any)
               goes.  For example, a TEXEDIT string for _v_i can be set with
               the _c_s_h command
                   setenv TEXEDIT "/usr/ucb/vi +%d %s"

               A convenient file in the library is _n_u_l_l._t_e_x, containing
               nothing.  When TeX can't find a file it thinks you want to
               input, it keeps asking you for another file name;  respond-
               ing `null' gets you out of the loop if you don't want to
               input anything.  You can also type your EOF character (usu-
               ally control-D).

               The _i_n_i_t_e_x and _v_i_r_t_e_x programs can be used to create fast-
               loading versions of TeX based on macro source files.  The
               _i_n_i_t_e_x program is used to create a _f_o_r_m_a_t (._f_m_t) file that
               permits fast loading of fonts and macro packages.  After
               processing the fonts and definitions desired, a \dump com-
               mand will create the format file.  The format file is used
               by _v_i_r_t_e_x. It needs to be given a format file name as the
               first thing it reads.  A format file name is preceded by an
               &, which needs to be escaped with \ to prevent misinterpre-
               tation by your shell if given on the command line.

               Fortunately, it is no longer necessary to make explicit
               references to the format file.  The present version of TeX,
               when compiled from this distribution, looks at its own com-
               mand line to determine what name it was called under.  It


          Rev. 9/25/90                                               Page 2






          TEX(1)               INTERACTIVE UNIX System               TEX(1)



               then uses that name, with the ``.fmt'' suffix appended, to
               search for the appropriate format file.  During installa-
               tion,  one format file with the name _t_e_x._f_m_t, with only the
               _p_l_a_i_n._t_e_x macros defined, should have been created.  This
               will be your format file when you invoke _v_i_r_t_e_x with the
               name _t_e_x.  You can also create a file _m_y_t_e_x._f_m_t using _i_n_i_-
               _t_e_x, so that this will be loaded when you invoke _v_i_r_t_e_x with
               the name _m_y_t_e_x.  To make the whole thing work, it is neces-
               sary to link _v_i_r_t_e_x to all the names of format files that
               you have prepared.  Hard links will do for system-wide
               equivalences and Unix systems which do not use symbolic
               links.  Symbolic links can be used for access to formats for
               individual projects.  For example: _v_i_r_t_e_x can be hard linked
               to _t_e_x in the general system directory for executable pro-
               grams, but an individual version of TeX will more likely be
               linked by a symbolic link in a privately maintained path
                   ln -s /usr/local/bin/virtex mytex
               in a directory such as /_h_o_m_e/_m_e/_b_i_n.

               Another approach is to set up a alias using, for example,
               the C shell:
                   alias mytex virtex \&myfmt
               Besides being more cumbersome, however, this approach is not
               available to systems which do not accept aliases.  Finally,
               there is the system known as ``undump'' which takes the
               headers from an _a._o_u_t file (e.g. _v_i_r_t_e_x) and applies them to
               a core image which has been dumped by the Unix QUIT signal.
               This is very system-dependent, and produces extremely large
               files when used with a large-memory version of TeX.  This
               can produce executables which load faster, but the execut-
               ables also consume enormous amounts of disk space.

          ENVIRONMENT VARIABLES
               The defaults for all environment variables are set at the
               time of compilation in a file named _s_i_t_e._h in the web2c dis-
               tribution.  All paths are colon-separated. If you set an
               environment variable to a value that has a leading colon,
               the system default shown here is prepended.  Likewise for a
               trailing colon.  For example, if you say
                   setenv TEXFONTS :/u/karl/myfonts
               TeX will search
                   Furthermore, the person who installed TeX at your site
               may have chosen to allow one level of subdirectories to be
               searched automatically (by defining the symbol
               SEARCH_SUBDIRECTORIES in _s_i_t_e._h).  In that case, subdirec-
               tories of directories in the environment variable
               TEXFONTS_SUBDIR are also searched for fonts, and subdirec-
               tories of directories in the environment variable
               TEXINPUTS_SUBDIR are also searched for input files.  All the
               programs in the base TeX distribution use this same search
               method.

               Normally, TeX puts its output files in the current


          Rev. 9/25/90                                               Page 3






          TEX(1)               INTERACTIVE UNIX System               TEX(1)



               directory.  If any output file cannot be opened there, it
               tries to open it in the directory specified in the environ-
               ment variable TEXMFOUTPUT. There is no default value for
               that variable.  For example, if you say tttteeeexxxxpaper and the
               current directory is not writable, and TEXMFOUTPUT has the
               value ////ttttmmmmpppp, TeX attempts to create ////ttttmmmmpppp////ppppaaaappppeeeerrrr....lllloooogggg (and
               ////ttttmmmmpppp////ppppaaaappppeeeerrrr....ddddvvvviiii, if any output is produced.)

               TEXINPUTS
                    Search path for \input and \openin files.  This should
                    probably start with ``.''.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////iiiinnnnppppuuuuttttssss.

               TEXINPUTS_SUBDIR
                    Search path for directories with subdirectories of
                    input files.  Default:  ////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////iiiinnnnppppuuuuttttssss

               TEXFONTS
                    Search path for font metric (.tfm) files.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////ffffoooonnnnttttssss////ttttffffmmmm.

               TEXFONTS_SUBDIR
                    Search path for directories with subdirectories of
                    fonts.  Default:  ////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////ffffoooonnnnttttssss

               TEXFORMATS
                    Search path for format files.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////ffffoooorrrrmmmmaaaattttssss.

               TEXPOOL
                    Search path for INITEX internal strings.  Default:
                    ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx.

               TEXEDIT
                    Command template for switching to editor.  Default:
                    ////uuuussssrrrr////bbbbiiiinnnn////vvvviiii+%d%%%%ssss.

          FILES
               /usr/local/lib/tex  TeX's library areas

               /usr/local/lib/tex/tex.pool
                                   Encoded text of TeX's messages.

               /usr/local/lib/tex/fonts/*.tfm
                                   Metric files for TeX's fonts.

               /usr/local/lib/tex/fonts/*_n_n_n{gf,pk}
                                   Bitmaps for various devices.  These
                                   files are not used by TeX.

               /usr/local/lib/tex/formats/*.fmt
                                   TeX .fmt files.



          Rev. 9/25/90                                               Page 4






          TEX(1)               INTERACTIVE UNIX System               TEX(1)



               /usr/local/lib/tex/inputs/plain.tex
                                   The ``default'' macro package.

          SEE ALSO
               Donald E. Knuth, _T_h_e _T_e_X_b_o_o_k
               Leslie Lamport, _T_h_e _L_a_T_e_X _D_o_c_u_m_e_n_t _P_r_e_p_a_r_a_t_i_o_n _S_y_s_t_e_m
               Michael Spivak, _T_h_e _J_o_y _o_f _T_e_X
               _T_U_G_B_O_A_T (the publication of the TeX Users Group)

          TRIVIA
               TeX, pronounced properly, rhymes with ``blecchhh.''  Note
               that the proper spelling in typewriter-like media is ``TeX''
               and not ``TEX'' or ``tex.''

          AUTHORS
               TeX was designed by Donald E. Knuth, who implemented it
               using his WEB system for Pascal programs.  It was ported to
               Unix at Stanford by Howard Trickey, and at Cornell by Pavel
               Curtis.  The version now offered with the Unix TeX distribu-
               tion is that generated by the WEB to C system, written by
               Tomas Rokicki and Tim Morgan.


































          Rev. 9/25/90                                               Page 5



