/*
*  main.c:  Get and process the program options and launch the DVIChk program.
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



#ifdef RCSID
static char rcsid[]="$Id: main.c 0.04 2000/06/06 00:00:04 tom Exp $";
#endif



/*
*  Include header files.
*/
#include "tailor.h"
#if HAVE_CTYPE_H
#  include <ctype.h>
#endif
#if HAVE_LIMITS_H
#  include <limits.h>
#endif
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif
#include "common.h"
#include "getopt.h"
#include "help.h"
#include "dvichk.h"
#include "utils.h"
#include "main.h"
#include "globals.h"



/*
*  GLOBAL variables definitions.
*/
/* Stores the actual program options. */
PUBLIC The_options_struct  *the_options;

/* Stores the actual program name. */
PUBLIC char  *prgr_name=(char *)NULL;

#ifdef DJG
/* Set to SHRT_MAX for checking the maximum table range. */
PUBLIC Usint  testval=(Usint)0;
#else /* !DJG */
/* Set to INT_MAX for checking the maximum table range. */
PUBLIC Uint  testval=(Uint)0;
#endif /* !DJG */



/*
*  Function implementations.
*/
   PUBLIC int
main (argc, argv)
   int   argc;
   char *argv[];
/*
   The DVIChk program driver   =8^)
*/
{
   static   struct option        longopts[]=
    {
      {"columns",              1, NULL, 'c'},
      {"no-info",              0, NULL, 'i'},
      {"font-info",            0, NULL, 'f'},
      {"total-only",           0, NULL, 't'},
      {"pager",                0, NULL, 'p'},
      {"version",              0, NULL, 'V'},
      {"license",              0, NULL, 'L'},
      {"help",                 0, NULL, 'h'},
      {NULL,                   0, NULL, '?'},
      {NULL,                   0, NULL, '\0'}
    };
   register int                  i;
   register int                  len;
   auto     char                *str;
   auto     char                *ptr_str;


   /*
      Let's set `testval' to SHRT_MAX/INT_MAX if SHRT_MAX/INT_MAX itself
        isn't defined.  This solution only works on machines with internal
        arithmethics based on "two complements".
   */
#ifdef DJG
#  ifdef SHRT_MAX
   testval = SHRT_MAX;
#  else /* !SHRT_MAX */
   testval = ~0;
   testval >>= 1;
#  endif /* !SHRT_MAX */
#else /* !DJG */
#  ifdef INT_MAX
   testval = INT_MAX;
#  else /* !INT_MAX */
   testval = ~0;
   testval >>= 1;
#  endif /* !INT_MAX */
#endif /* !DJG */
   setbuf(stdout, NULL);
#if !USE_DE
#  ifdef DVICHK_NLS
   /*
      Now initialize the NLS functions.
   */
#    if HAVE_SETLOCALE
   setlocale(LC_ALL, "");
#    endif
#    ifndef LOCALEDIR
#      define LOCALEDIR  NULL
#    endif
   bindtextdomain(PACKAGE, LOCALEDIR);
   textdomain(PACKAGE);
#  else /* !DVICHK_NLS */
#  endif /* !DVICHK_NLS */
#endif /* !USE_DE */
   /*
      Detect the own program name.
   */
   i = (int)strlen(*argv);
   if (!i)
     len = strlen(PRGR_NAME);
   else
     len = i;
   str = (char *)my_malloc (len+1, ERR_NO_MEMORY_AVAILABLE, __FILE__, (long)__LINE__);
   if (!i)
     strcpy(str, PRGR_NAME);
   else
     strcpy(str, *argv);
#ifdef SUFFIX_SEP
   /*
      Eliminate version suffix under VMS.
   */
   ptr_str = strrchr(str, *SUFFIX_SEP);
   if (ptr_str != (char *)NULL)
     *ptr_str = '\0';
#endif
#ifdef DJG
   ptr_str = strrchr(str, *DIR2_SEP);
#else /* !DJG */
   ptr_str = strrchr(str, *DIR_SEP);
#endif /* !DJG */
   if (ptr_str != (char *)NULL)
    {
      ptr_str++;
      len = (int)strlen(ptr_str);
    }
   else
     ptr_str = str;
   if (tolower('A') == 'a')
    {
      auto char  *buf_ptr_str=ptr_str;


      for ( ; *ptr_str ; ptr_str++)
        *ptr_str = (char)tolower(*ptr_str);
      ptr_str = buf_ptr_str;
    }
   /*
      Suppress ".exe" suffix for MSDOS, OS/2 and VMS.
   */
   if (   (len > 4)
       && !strcmp(ptr_str+len-4, ".exe"))
    {
      len -= 4;
      *(ptr_str + len) = '\0';
    }
   /*
      The maximum length of the actual program name is always truncated
        to 6 characters for displaying purposes (e.g. in the help screens).
   */
   if (len > 6)
    {
      len = 6;
      *(ptr_str + len) = '\0';
    }
   prgr_name = (char *)my_malloc (len+1, ERR_NO_MEMORY_AVAILABLE, __FILE__, (long)__LINE__);
   strcpy(prgr_name, ptr_str);
   free(str);
   /*
      Allocate the memory for the `the_options' and set their defaults properly.
   */
   the_options = (The_options_struct *)my_malloc(sizeof(The_options_struct),
                                                 ERR_NO_MEMORY_AVAILABLE,
                                                 __FILE__, ((long)__LINE__)-2L);
   the_options->columns = COLUMNS_DFLT;
   the_options->no_info = FALSE;
   the_options->font_info = FALSE;
   the_options->total_only = FALSE;
   the_options->pager = FALSE;
   /*
      Decode the command line arguments.
   */
   while ((i=getopt_long (argc, argv, "?hVLiftpc:", longopts, NULL)) != EOF)
    {
      switch (i)
       {
         case 'c':
           the_options->columns = atoi(optarg);
           if (   the_options->columns < COLUMNS_MIN
               || the_options->columns > COLUMNS_MAX)
             (void)my_error (stderr, ERR_INVALID_OPTION, "", 0L);
           break;
         case 'i':
           the_options->no_info = !the_options->no_info;
           break;
         case 'f':
           the_options->font_info = !the_options->font_info;
           break;
         case 't':
           the_options->total_only = !the_options->total_only;
           break;
         case 'p':
           the_options->pager = !the_options->pager;
           break;
         case 'L':
           my_license (stdout);
           exit(EXIT_SUCCESS);
         case 'V':
           my_version (stdout);
           exit(EXIT_SUCCESS);
         case '?':
         case 'h':
           my_usage (stdout);
           S_NEWLINE(stdout);
           exit(EXIT_SUCCESS);
         default:
           (void)my_error (stderr, ERR_INVALID_OPTION, "", 0L);
       }
    }
   if (optind == argc)
     (void)my_error (stderr, ERR_NO_FILENAME_GIVEN, "", 0L);

   /*
      And run the DVIChk program.
   */
   return(run_dvichk (optind, argv));
}
