#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvidvi.h"
#include "dviframe.h"

#define Fixed unsigned long

static Fixed FixRatio(int numer, int denom)
{
    Fixed result;
    result = (Fixed)(numer/denom)<<16l;
    result |= ((Fixed)(numer%denom)<<16l)/denom;
    return result;
}

#ifndef ATARI_ST
static Fixed fixumul(Fixed x, Fixed y)
{
    register Fixed r, xi, yi, xf, yf;

    xi = x>>16;
    yi = y>>16;
    xf = x & 0xFFFF;
    yf = y & 0xFFFF;

    r = (unsigned long)(xi*yi)<<16l;
    r += (unsigned long)xf*(unsigned long)yi;
    r += (unsigned long)yf*(unsigned long)xi;
    r += ((unsigned long)xf*(unsigned long)yf)>>16l;

    return r;
}
#else
extern Fixed fixumul(Fixed,Fixed);
#endif

static void conv_line(Fixed *pixel, char *line, Fixed cw, int w_neu, Fixed conv)
{
    int     i;
    register Fixed  fpos, ffrac;

    register char   *fptr;
    register int    fmask, fpix;

    fpos = 0l;

    fpix  = 0;
    ffrac = 0x10000l;
    fmask = 128;
    fptr  = line;

    for (i=0; i<w_neu; i++, pixel++)
    {
	register Fixed  lpos  = fpos+cw;
	register Fixed  lfrac = lpos & 0xFFFFl;
	register int    lpix  = (int)(lpos>>16);

	if (fpix==lpix)
	{
	    if (*fptr & fmask)
		*pixel += fixumul(lfrac+ffrac-0x10000l,conv);
	}
	else
	{
	    register int j;

	    if (*fptr & fmask) *pixel += fixumul(ffrac,conv);
	    if ( (fmask >>= 1)==0 ) fmask=128, fptr++;

	    for (j=fpix+1; j<lpix; j++)
	    {
		if (*fptr & fmask) *pixel += conv;
		if ( (fmask >>= 1)==0 ) fmask=128, fptr++;
	    }
	    if (*fptr & fmask) *pixel += fixumul(lfrac,conv);
	}

	fpix  = lpix;
	fpos  = lpos;
	ffrac = 0x10000l-lfrac;
    }
}

char line[10000];
Fixed pixel[10000];

static void conv_pic(long screen, int offset, int height, int x, int y,
	      IMG_FILE *img, int w_alt, int w_neu, int h_alt,
	      int h_neu, double dens)
{
    int     i, xstart, ystart, xmask;
    Fixed   ch, cw, k, fpos, ffrac, *p;
    long    ptr;
    register int fpix, mask;

    ch    = FixRatio(h_alt,h_neu);
    cw    = FixRatio(w_alt,w_neu);
    k     = fixumul(ch,cw);
    fpos  = 0l;
    fpix  = 0;
    ffrac = 0x10000l;

    k = fixumul(k,FixRatio((int)(1000.0*(1.0-dens)),1000));
    xmask = 128>>(x%8);
    screen += (long)y*(long)offset;

    if (op.landscape)
    {
	if (y<0) ystart = -y, y=0;
	else ystart=0;
	x /= 8;
	if (x<0) return;
    }
    else
    {
	if (x<0) xstart = -x, x=0;
	else xstart=0;
	if (y>=height) return;
    }

    if (img_read(line,img)==NULL) return;

    for (i=0; i<h_neu; i++)
    {
	Fixed  lpos  = fpos+ch;
	Fixed  lfrac = lpos & 0xFFFFl;
	register int lpix  = (int)(lpos>>16);
	int j;

	memset((char*)pixel,0,sizeof(Fixed)*w_neu);

	if (fpix==lpix)
	{
	    conv_line(pixel,line,cw,w_neu,lfrac+ffrac-0x10000l);
	}
	else
	{
	    register int j;

	    conv_line(pixel,line,cw,w_neu,ffrac);
	    img_read(line,img);         
	    for (j=fpix+1; j<lpix; j++) 
	    {
		conv_line(pixel,line,cw,w_neu,0x10000l);
		img_read(line,img);
	    }
	    conv_line(pixel,line,cw,w_neu,lfrac);
	}

	if (op.landscape)
	{
	    ptr = screen + x;
	    p = pixel + ystart;
	    if (x<offset)
	    {
		j=w_neu-ystart;
		if (y+j>=height) j=height-y;
		for (; j--; ptr += offset)
		    if (*p++>k) frame_or(ptr,xmask);
	    }
	    if ( (xmask <<=1 )>128 )
	    {
		if (--x < 0) return;
		xmask=1;
	    }
	}
	else
	{
	    ptr  = screen+x/8;
	    mask = xmask;
	    p = pixel+xstart;
	    if (y>=0)
		for (j=w_neu-xstart; j-- > 0;)
		{
		    if (*p++>k) frame_or(ptr,mask);
		    if ( (mask>>=1)==0 )
		    {
			mask=128; 
			if (++ptr-screen>=offset) break;
		    }
		}
	    screen += offset;
	    if (++y >= height) break;
	}
	fpix  = lpix;
	fpos  = lpos;
	ffrac = 0x10000l-lfrac;
    }
}

int read_img(char *name, int x, int y, double dens)
{
    IMG_FILE *img;
    int w,h,bytes,pw,ph,hpixel,wpixel;

    img = img_open(name,&w,&h,&bytes,&pw,&ph,op.img_path);
    if (img==NULL) return 1;

    hpixel = (int)((double)op.vres*(double)ph*(double)h / 25400.0);
    wpixel = (int)((double)op.hres*(double)pw*(double)w / 25400.0);

    if (!op.show_img)
    {
	if (op.landscape)
	{
	    draw_rule(x,y,1,wpixel);
	    draw_rule(x,y,hpixel,1);
	    draw_rule(x,y+wpixel,hpixel,1);
	    draw_rule(x+hpixel,y,1,wpixel);
	}
	else
	{
	    draw_rule(x,y-hpixel,wpixel,1);
	    draw_rule(x,y,wpixel,1);
	    draw_rule(x,y-hpixel,1,hpixel);
	    draw_rule(x+wpixel,y-hpixel,1,hpixel);
	}
    }
    else
    {
	if (op.landscape)
	    conv_pic(0l,frame_width,frame_height,
		     x+hpixel,y,img,w,wpixel,h,hpixel,dens);
	else
	    conv_pic(0l,frame_width,frame_height,
		     x,y-hpixel,img,w,wpixel,h,hpixel,dens);
    }
    img_close(img);
    return 0;
}

