{$N-,E-,V-}

Unit bibselct;

Interface

uses
  bibwindo, Dos, objects, bibCrt, bibstrg, BibMouse, streams, bibstrm,
  bibvars, bibfile, bibdisp, bibutil, bibsedit, rc_strng, bibwild, lfnunit;


const
  DatabaseDesc='';
  PatternDesc ='';
  BstDesc     ='';
  AllDesc     ='';
  PreambleDesc='';
  TeXAuxDesc  ='';
  LaTeXDesc   ='';
type
  FileDescStr = string[32];

procedure FieldChoose(Var inlist; num, ncols,wid: integer;
                      Var Spec: SpecArr; Var n: integer; 
                      one, PgDn: boolean; nscreen,lastnum: integer;
                      LongList,RemoveWin: boolean);
procedure FileChoose(Var fname: string; Exten: string; PathList: PathListPtr;
                     FileAttr: Word; GetNew,MustExist,Printers: boolean;
                     IsReadOnly: PBoolean;
                     Prompt: string; Desc: FileDescStr; var accept: boolean);


Implementation


procedure FieldChoose(Var inlist; num, ncols,wid: integer;
                      Var Spec: SpecArr; Var n: integer; 
                      one, PgDn: boolean; nscreen,lastnum: integer;
                      LongList,RemoveWin: boolean);
type
  chosArr = array[1..MaxListArr] of boolean;
var
  ifld : Word;
  i,j,k,lf,last,next,look,nold,nrows,x,y,mlast : integer;
  xfirst,att,Shft,WinWid : Byte;
  xx,yy: integer;
  tmp,tmp1,spaces,HelpString : string[132];
  ch : char;
  UpArr,DownArr,LeftArr,RightArr,Esc,Ent,BS,Home,Eend,None : boolean;
  Space,special,newfield,mbut,PageU,PageD,PgUp,All,Help : boolean;
  FirstItem,LastItem,FirstLast: boolean;
  chosen: chosArr;

function list(n: integer): string;
begin
  if LongList then list:=ListArr(inlist)[n]
  else list:=ListArr2(inlist)[n];
end;
{
function wlength(S: string) : byte;
var
  i: byte;
begin
  i:=length(S); if i>wid then i:=wid;
  wlength:=i;
end;
}
function wlength(n: integer): integer;
var
  i: integer;
begin
  if LongList then i:=length(ListArr(inlist)[n])
  else i:=length(ListArr2(inlist)[n]);
  if i>wid then i:=wid;
  wlength:=i;
end;

function FieldX(l: integer): integer;
begin
  FieldX:=xx+1+shft+((l-1) mod ncols)*(wid+1);
end;

function FieldY(l: integer): integer;
begin
  FieldY:=yy+1+((l-1) div ncols);
end;

procedure MoveBar(last,next : integer; var chosen: ChosArr);
begin
  if UseMouse then HideMouseCursor;
  if last>0 then
  begin
    if one then TpwAttrW(FieldY(last),FieldX(last),1,wlength(last),ListNorm)
    else if chosen[last] then
      TpwAttrW(FieldY(last),FieldX(last),1,1,ListRev)
    else
      TpwAttrW(FieldY(last),FieldX(last),1,1,ListNorm);
  end;
  if next>0 then
  begin
    if one then TpwAttrW(FieldY(next),FieldX(next),1,wlength(next),ListRev)
    else if chosen[next] then
      TpwAttrW(FieldY(next),FieldX(next),1,1,Blink)
    else
      TpwAttrW(FieldY(next),FieldX(next),1,1,Blink);
  end;
  if UseMouse then ShowMouseCursor;
end;                                   { MoveBar }
 
begin                                  { FieldChoose }
  SuspendWaiting(true);
  HelpString:='';
  if nscreen<0 then
  begin
    nscreen:=-nscreen;
    PgUp:=false;
  end else
  begin
    PgUp:=(nscreen>1);
    if (not PgUp) and PgDn then nscreen:=1;
  end;
  FirstLast:=one and (PgUp or PgDn) and (LastNum>0);
  if not (one or PgUp or PgDn) then HelpString:='Choose Several';
  if one then
  begin
    if ncols=1 then HelpString:='Choose One, one column'
    else HelpString:='Choose One, several columns';
    if PgUp then HelpString:=HelpString+', PgUp';
    if PgDn then HelpString:=HelpString+', PgDn';
    if FirstLast then HelpString:=HelpString+', First/Last';
  end;

  xx:=2; yy:=3;
  look:=1; mlast:=0;
  spaces:='                                                           ';
  nrows:=(num-1) div ncols + 1;
  for i:=1 to num do chosen[i]:=false;
  for i:=1 to n do chosen[Spec[i]]:=true;
  Shft:=0;
  if ncols=1 then
  begin
    Shft:=1;
    WinWid:=ncols*(wid+1)+2+shft;
    if xx+WinWid-1>ScrWidth then Shft:=0;
  end;
  WinWid:=ncols*(wid+1)+2+shft;
  if xx+WinWid-1>ScrWidth then xx:=1;
  if xx+WinWid-1>ScrWidth then WinWid:=ScrWidth;
  if (yy+nrows+2<ScrLen-4) and (xx+WinWid<ScrWidth-8) then
    MakeWindow(yy,xx,2+nrows,WinWid,ListNorm,ListNorm,2,RNorm,shadow,0)
  else MakeWindow(yy,xx,2+nrows,WinWid,ListNorm,ListNorm,2,RNorm,0,0);
  MaxMemAvail;
  if (lastnum>0) and (lastnum>nscreen) then
    TitleWindow(3,ListNorm,Concat('(',num2str(nscreen),' to ',num2str(lastnum),')'))
  else if (lastnum>0) and (lastnum=nscreen) then
    TitleWindow(3,ListNorm,Concat('(',num2str(nscreen),')'))
  else if PgUp or PgDn then 
    TitleWindow(3,ListNorm,Concat('(page ',num2str(nscreen),')'));
    
  for ifld:=1 to num do
  begin
    tmp:=list(ifld);
    if length(tmp)>wid then StrCut(tmp,wid);
    TpwPrintW(FieldY(ifld),FieldX(ifld),tmp,ListNorm);
  end;
  for i:=0 to nrows-1 do for ifld:=2 to ncols do
    TpwPrint(FieldY(ifld+i*ncols),FieldX(ifld+i*ncols)-1,#179,ListNorm);
  for i:=1 to num do
    if chosen[i] then
    begin
      TpwAttrW(FieldY(i),FieldX(i),1,wlength(i),ListRev);
    end;
  tmp:='';
  if one then
  begin
    if (Spec[1]>0) and (Spec[1]<=num) then
    begin
      MoveBar(0,Spec[1],chosen); last:=spec[1]; next:=spec[1];
    end else
    begin
      MoveBar(0,1,chosen); last:=1; next:=1;
    end;
  end else
  begin
    MoveBar(0,1,chosen); last:=1; next:=1;
    tmp:='[All]'+#205+'[None]'+#205;
  end;
  if PgDn then tmp:=tmp+'[PgDn]'+#205;
  if PgUp then tmp:=tmp+'[PgUp]'+#205;
  if FirstLast and PgUp then tmp:=tmp+'[First]'+#205;
  if FirstLast and PgDn then tmp:=tmp+'[Last]';
  if tmp<>'' then TitleWindow(4,ListNorm,tmp);
  if not one then
  begin
    i:=Pos('A',tmp); if i>0 then TpwAttr(yy+nrows+1,xx+i+1,1,1,ListBright);
    i:=Pos('N',tmp); if i>0 then TpwAttr(yy+nrows+1,xx+i+1,1,1,ListBright);
  end else
  begin
    i:=Pos('F',tmp); if i>0 then TpwAttr(yy+nrows+1,xx+i+1,1,1,ListBright);
    i:=Pos('L',tmp); if i>0 then TpwAttr(yy+nrows+1,xx+i+1,1,1,ListBright);
  end;
  Titlewindow(1,ListNorm,'['+#254+']');
  if not one then TitleWindow(6,ListNorm,'[ok]');
  if UseMouse then
  begin
    WaitForRelease(255);
    ShowMouseCursor; ShowMouseCursor;
  end;
  repeat
    UpArr:=false; DownArr:=false; LeftArr:=false; RightArr:=false;
    Esc:=false; Ent:=false; Home:=false; Eend:=false; All:=false;
    None:=false; Space:=false; PageU:=false; PageD:=false;
    Help:=false; FirstItem:=false; LastItem:=false;
    ch:=ReadKeyMouse;
    if ch=#0 then
    begin
      ch:=ReadKey;
      UpArr:=(ch=#72);  DownArr:=(ch=#80);
      LeftArr:=(ch=#75); RightArr:=(ch=#77);
      Home:=(ch=#71); Eend:=(ch=#79);
      PageU:=(ch=#73) and PgUp;
      PageD:=(ch=#81) and PgDn;
      None:=(not one) and (ch in [#49,#46]);
      All:=(not one) and (ch=#30);
      Help:=(ch=#59);
      FirstItem:=(ch=#33) and FirstLast and PgUp;
      LastItem:= (ch=#38) and FirstLast and PgDn;
      ch:=#0;
    end else if Event.mpress then
    begin
      x:=Event.x-xx-2; y:=Event.y-yy-1;
      WaitForRelease(255);
      if ((y=-1) or (y=nrows)) and (x>0) and (x<ncols*wid-1) then
      begin
        ReadScrStr(tmp,x+xx+2,y+yy+1,xfirst,att,
               ['[',#254,']','a'..'z','P','U','D','F','L','A','N']);
        if tmp='[ok]' then Ent:=true
        else if tmp='[PgUp]'  then PageU:=true
        else if tmp='[PgDn]'  then PageD:=true
        else if tmp='[None]'  then None:=true
        else if tmp='[All]'   then all:=true
        else if tmp='[First]' then FirstItem:=true
        else if tmp='[Last]'  then LastItem:=true
        else if tmp=Concat('[',#254,']') then Esc:=true;
      end else if ((x>=0) and (x<ncols*wid)) and ((y>=0) and (y<nrows)) then
      begin
        next:=y*ncols+(x div wid)+1;
        Space:=true;
        if next>num then
        begin
          next:=last; Space:=false;
        end;
      end;
      if Ent or Esc or Space or None or All or PageU or PageD or FirstItem or
             LastItem then mlast:=0;
    end else
    begin
      Esc:=(ch=#27); Ent:=(ch=#13);
      None:=(not one) and (ch=#14); Space:=(ch=' ');
      All:=(not one) and (ch=#1);
      FirstItem:=PgUp and (ch=#6)  and FirstLast;
      LastItem:= PgDn and (ch=#12) and FirstLast;
      if Ent and one then space:=true;
    end;
    special:=UpArr or DownArr or LeftArr or RightArr or Esc or Ent
             or All or Home or Eend or None or Space or PageU or PageD
             or FirstItem or LastItem or Help;
    if Help then ContextHelp(HelpString);
    if UpArr  and (num>ncols) then next:=next-ncols;
    if DownArr and (num>ncols) then next:=Next+ncols;
    if LeftArr then next:=next-1;
    if RightArr then next:=next+1;
    if Home then next:=1;
    if Eend then next:=num;
    if special then look:=1;
    if ch<>#255 then mlast:=0;
    if not special then
    begin
      i:=last+1; if i>num then i:=i-num;
      tmp:=list(i);
      while (i<>last) and (Upcase(tmp[1])<>Upcase(ch)) do
      begin
        i:=i+1;
        if i>num then i:=i-num;
        tmp:=list(i);
      end;
      if Upcase(tmp[1])=Upcase(ch) then next:=i;
    end;
    if None then
    begin
      if UseMouse then HideMouseCursor;
      for i:=1 to num do chosen[i]:=false;
      TpwAttrW(yy+1,xx+1,nrows,ncols*wid,ListNorm);
      Movebar(0,1,chosen);
      last:=1;
      next:=1;
      mlast:=0;
      if UseMouse then ShowmouseCursor;
    end;
    if All then
    begin
      if UseMouse then HideMouseCursor;
      for i:=1 to num do
      begin
        chosen[i]:=true;
        TpwAttrW(Fieldy(i),FieldX(i),1,wlength(i),ListRev)
      end;
      Movebar(0,1,chosen);
      last:=1;
      next:=1;
      mlast:=0;
      if UseMouse then ShowmouseCursor;
    end;
    if space then
    begin
      chosen[next]:=not chosen[next];
      if UseMouse then HideMouseCursor;
      if chosen[next] then
      begin
        TpwAttrW(FieldY(next),FieldX(next),1,1,Blink);
        if length(list(next))>1 then
        TpwAttrW(FieldY(next),FieldX(next)+1,1,wlength(next)-1,ListRev);
      end else
      begin
        TpwAttrW(FieldY(next),FieldX(next),1,1,Blink);
        if length(list(next))>1 then
        TpwAttrW(FieldY(next),FieldX(next)+1,1,wlength(next)-1,ListNorm);
      end;
      if UseMouse then ShowMouseCursor;
      if one then Ent:=true;
    end;
    if next<>last then
    begin
      if next<1 then
      begin
        if num<=ncols then next:=num
        else begin
          next:=next+ncols*nrows;
          if next>num then next:=next-ncols;
        end;
      end;
      if next>num then
      begin
        if num<=ncols then next:=1
        else begin
          if next<=ncols*nrows then next:=next+ncols;
          next:=next-ncols*nrows;
        end;
      end;
      MoveBar(last,next,chosen);
      last:=next;
    end;
  until Esc or Ent or PageU or PageD or FirstItem or LastItem;
  if PageU then
  begin
    n:=1;
    Spec[1]:=ChoosePgUp;
  end else if PageD then
  begin
    n:=1;
    Spec[1]:=ChoosePgDn;
  end else if FirstItem then
  begin
    n:=1;
    Spec[1]:=ChooseFirst;
  end else if LastItem then
  begin
    n:=1;
    Spec[1]:=ChooseLast;
  end else
  begin
    n:=0;
    if not Esc then
    for i:=1 to num do
    if chosen[i] then
    begin
      n:=n+1;
      Spec[n]:=i;
    end;
  end;
  if UseMouse then HideMouseCursor;
  if RemoveWin then RemoveWindow;
  SuspendWaiting(false);
end;                                    { FieldChoose }

procedure GetFileName(var s: string; pre: string; var accept: boolean);
const
  y0 = 5;
  xlen = 60;
var
  x0,icode: byte;
  Dir: string;
  AltPress: char;
  jcode: integer;
  Ok_String: boolean;
begin
  AltPress:=#0; accept:=false;
  if UseMouse then WaitForRelease(255);
  x0:=(ScrWidth-Xlen) div 2;
  LFNFsplit(LFNFexpand(''),@Dir,Nil,Nil); CanonicalFname(Dir);
  MakeWindow(y0,x0,3,xlen,DialogNorm,DialogNorm,2,RNorm,Shadow,1);
  TitleWindow(2,DialogNorm,Dir);
  repeat
    ok_String:=true;
    ReadEdit(' '+pre+' ',s,y0+1,x0+1,64,58,
             [#0..#255]-FileNameSet-['*','?','[',']','^','!'],'',
             accept,AltPress,true);
    if accept and (S<>'') and IsWildcard(S) and
              not ValidRegexp(S,not MacroCommand) then Ok_String:=false;
  Until ok_String;
 
  if accept and (s<>'') then
  begin
    LFNFsplit(LFNFexpand(s),@Dir,Nil,Nil);
    if (not IsWildcard(Dir)) and IsDirName(Dir) then
    begin
      {$I-}
      ChDir(LFNShortName(Dir)); icode:=IoResult;
      {$I+}
    end;
  end;
  RemoveWindow;
end;                  { GetFileName }

procedure FileChoose(Var fname: string; Exten: string; PathList: PathListPtr;
                     FileAttr: Word; GetNew, MustExist, Printers: boolean;
                     IsReadOnly: PBoolean;
                     Prompt: string; Desc: FileDescStr; var accept: boolean);
const
  NMaxDisplay=40;
var
  Root,Path,FileList,FileListRoot: PathListPtr;
  Dir,HomePath,Name,Ext,fl,tmp,OrigName: string;
  Srec: TLFNSearchRec;
  FileSelect: ListArrPtr;
  Spec: SpecArr;
  NFiles,i,n: longint;
  selection,Page: Word;
  nspec,j,icode: integer;
  leave,finish,WildCard,IsPrinter: boolean;

function CheckFileName: boolean;
var
  icode: integer;
  Ext,Name: string;
begin
  CheckFileName:=false; IsPrinter:=false; WildCard:=false;
  LFNFsplit(fname,@Dir,@Name,@Ext); CanonicalFname(fname);
  if not IsDirName(Dir) then
  begin
    ErrorMessageRC(Str_IllegalPath,Dir); Exit;
  end;
  if Ext='' then
  begin
    Ext:=Exten; if (Ext<>'') and (Ext[1]<>'.') then Ext:='.'+Ext;
  end;
  fl:=Name+Ext;
  WildCard:=IsWildcard(fl);
  if not WildCard then
  begin
    if (StrCmpI(fname,'lpt1:',1,1,255)=0) or
       (StrCmpI(fname,'lpt2:',1,1,255)=0) or
       (StrCmpI(fname,'lpt3:',1,1,255)=0) or
       (StrCmpI(fname,'prn:' ,1,1,255)=0) then Delete(fname,4,1);
    if (StrCmpI(fname,'lpt1',1,1,255)=0) or
       (StrCmpI(fname,'lpt2',1,1,255)=0) or
       (StrCmpI(fname,'lpt3',1,1,255)=0) or
       (StrCmpI(fname,'prn' ,1,1,255)=0) then IsPrinter:=true;
  end;
  if IsPrinter and (not Printers) then
  begin
    ErrorMessageRC(Str_ForbidPrinters,''); Exit;
  end;
  if not (wildcard or IsPrinter or IsFileName(name)) then
  begin
    ErrorMessageRC(Str_IllegalFileName,name); Exit;
  end;
  if (Dir<>'') and not IsWildcard(Dir) then
  begin
    tmp:=LFNFExpand('.');
    if Dir[length(Dir)]='\' then Delete(Dir,length(Dir),1);
    {$I-}
    ChDir(LFNShortName(Dir)); icode:=IoResult;
    ChDir(LFNShortName(tmp)); if IoResult<>0 then;
    {$I+}
    if icode<>0 then
    begin
      ErrorMessageRC(Str_CantFindDir,Dir); Exit;
    end;
  end;
  CheckFileName:=true;
end;                             { CheckFileName }

procedure GetMatchingFileList;
var
  D,Nam,E,fll,tmp2: string;
  TP: PChar;
begin
  LFNFsplit(fl,@D,@Nam,@E); NFiles:=0;
  if not (IsDirName(D) and LFNFileExist(D+'.')) then Exit;
  WildCard:=isWildcard(fl);
  if Wildcard then
  begin
    if IsWildcard(Nam) then fll:='*'    else fll:=Nam;
    if IsWildCard(E) then fll:=fll+'.*' else fll:=fll+E;
  end else fll:=fl;

  New(Root); Root^.Next:=Nil; Root^.back:=Nil; HomePath:='';
  if Dir='' then
  begin
    HomePath:=LFNFexpand(''); CanonicalFname(HomePath);
    Root^.P:=NewStr(HomePath);
    Root^.Next:=PathList;
    if PathList<>Nil then PathList^.Back:=Root;
  end else Root^.P:=NewStr(LFNfexpand(Dir));
  Path:=Root;

  leave:=false; NFiles:=0;
  repeat
    if (Path^.P^='') or (IsDirName(Path^.P^)) then
    begin
      if (Path^.P^<>'') and (Path^.P^[length(Path^.P^)]<>'\') then
        tmp:=Path^.P^+'\'+fll
      else tmp:=Path^.P^+fll;
      LFNFindFirst(tmp,FileAttr,Srec);
      while (not leave) and (DosError=0) do
      begin
        TP:=@SRec.name; tmp2:=StrPas(TP);
        if (not Wildcard) or FilenameMatch(tmp2,Nam,E) then
        begin
          inc(NFiles);
          if NFiles=1 then    { First one }
          begin
            New(FileList); FileListRoot:=FileList;
            FileList^.Back:=Nil;
          end else
          begin
            New(FileList^.Next);
            FileList^.Next^.Back:=FileList;
            FileList:=FileList^.Next;
          end;
          if (Path^.P^<>'') and (Path^.P^[length(Path^.P^)]<>'\') then
            tmp:=Path^.P^+'\'+tmp2
          else tmp:=Path^.P^+tmp2;
          CanonicalFname(tmp);
          FileList^.P:=NewStr(tmp); FileList^.Next:=Nil;
          if not WildCard then leave:=true;
    {       message(' Found "'+tmp+'" '); }
        end;
        LFNFindNext(Srec);
      end;
      if MaxAvail<4000 then leave:=true;
    end;
    LFNFindClose(Srec);
    if not leave then
    repeat
      Path:=Path^.Next;
    until (Path=Nil) or (Path^.P^<>HomePath);
    if Path=Nil then leave:=true;
  until leave;
  DisposeStr(Root^.P); Dispose(Root);
  if PathList<>Nil then PathList^.Back:=Nil;
end;                             { GetMatchingFileList }

procedure KillMatchingFileList;
begin
  FileList:=FileListRoot;
  if FileList<>Nil then
  begin
    while FileList^.Next<>Nil do FileList:=FileList^.Next;
    while FileList<>Nil do
    begin
      if FileList^.P<>Nil then DisposeStr(FileList^.P);
      if FileList^.Back<>Nil then
      begin
        FileList:=FileList^.Back;
        Dispose(FileList^.Next);
      end else
      begin
        Dispose(FileList); FileList:=Nil;
      end;
    end;
  end;
end;                                    { KillMatchingFileList }

begin                                  { FileChoose }
  accept:=false; finish:=false;
  OrigName:=fname;
  if IsWildcard(fname) and not ValidRegexp(fname,not MacroCommand) then
    Exit;
  FileList:=Nil; FileListRoot:=Nil; FileSelect:=Nil; Root:=Nil; Path:=Nil;
  repeat
    if GetNew then
    begin
      if fname='' then fname:='*'; GetFileName(fname,Prompt,accept);
      accept:=accept and (fname<>'') and CheckFileName;
      if (not accept) then Exit;
    end;
    if (fname='') or (not CheckFileName) then Exit;
    if IsPrinter then Exit;
    GetNew:=true;
    accept:=false;

    GetMatchingFileList;
    MaxMemAvail;
    if (MustExist) and (Nfiles=0) then ErrorMessage(' Can''t find "'+fname+'"! ')
    else if WildCard then
    begin
      New(FileSelect);
      MaxMemAvail;
      Page:=0; selection:=0;
      repeat
        FileList:=FileListRoot;
        for i:=1 to Page*NMaxDisplay do FileList:=FileList^.Next;
        n:=0;
        for i:=1 to NMaxDisplay do
          if FileList<>Nil then
          begin
            inc(n);
            FileSelect^[n]:=TruncateFilename(FileList^.P^,37);
            FileList:=FileList^.Next;
          end;
        nspec:=0;
        FieldChoose(FileSelect^,n,2,37,Spec,nspec,true,(NFiles>(Page+1)*NMaxDisplay),
                    Page+1,0,true,true);
        if nspec>0 then
        begin
          if Spec[1]=ChoosePgUp then Dec(Page)
          else if Spec[1]=ChoosePgDn then Inc(Page)
          else if Spec[1]<=n then selection:=Spec[1];
        end;
      until (nspec=0) or (selection>0);
      if selection>0 then
      begin
        FileList:=FileListRoot;
        for i:=1 to Page*NMaxDisplay+selection-1 do
          FileList:=FileList^.Next;
        fname:=FileList^.P^;
        accept:=true;
      end else finish:=true;
      Dispose(FileSelect);
    end else
    begin
      if FileListRoot<>Nil then
      begin
        fname:=FileListRoot^.P^; accept:=true;
      end else if MustExist then
        ErrorMessage(' File "'+fname+'" not found! ')
      else begin
        LFNFSplit(LFNFExpand(fname),@Dir,@Name,@Ext);
        if Ext='' then Ext:=Exten;
        fname:=Dir+Name+Ext; CanonicalFname(fname);
        accept:=true;
      end;
    end;
    KillMatchingFileList;
    if accept and MustExist and not LFNFileExist(fname) then
    begin
      accept:=false;
      ErrorMessage(' File "'+fname+'" does not exist! ');
    end;
  until accept or finish;
  if not accept then fname:=OrigName;
  StrRepl(fname,'\\','\',1,255,255);
end;                                  { FileChoose }

end.
