/* Do not edit: automatically built by gen_rpc.awk. */
#include "db_config.h"

#ifndef NO_SYSTEM_INCLUDES
#include <sys/types.h>
#include <rpc/rpc.h>
#include <rpc/xdr.h>

#include <errno.h>
#include <string.h>
#endif

#include "db_server.h"
#include "db_int.h"
#include "db_page.h"
#include "db_ext.h"
#include "rpc_client_ext.h"
#include "txn.h"

#include "gen_client_ext.h"

int
__dbcl_envcachesize(dbenv, gbytes, bytes, ncache)
	DB_ENV * dbenv;
	u_int32_t gbytes;
	u_int32_t bytes;
	int ncache;
{
	CLIENT *cl;
	__envcachesize_msg req;
	static __envcachesize_reply *replyp = NULL;
	int ret;

	ret = 0;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___envcachesize_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbenv == NULL)
		req.dbenvcl_id = 0;
	else
		req.dbenvcl_id = dbenv->cl_id;
	req.gbytes = gbytes;
	req.bytes = bytes;
	req.ncache = ncache;

	replyp = __db_envcachesize_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_envclose(dbenv, flags)
	DB_ENV * dbenv;
	u_int32_t flags;
{
	CLIENT *cl;
	__envclose_msg req;
	static __envclose_reply *replyp = NULL;
	int ret;

	ret = 0;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___envclose_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbenv == NULL)
		req.dbenvcl_id = 0;
	else
		req.dbenvcl_id = dbenv->cl_id;
	req.flags = flags;

	replyp = __db_envclose_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_envclose_ret(dbenv, flags, replyp));
out:
	return (ret);
}

int
__dbcl_envopen(dbenv, home, config, flags, mode)
	DB_ENV * dbenv;
	const char * home;
	char * const * config;
	u_int32_t flags;
	int mode;
{
	CLIENT *cl;
	__envopen_msg req;
	static __envopen_reply *replyp = NULL;
	int ret;

	ret = 0;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___envopen_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbenv == NULL)
		req.dbenvcl_id = 0;
	else
		req.dbenvcl_id = dbenv->cl_id;
	if (home == NULL)
		req.home = "";
	else
		req.home = (char *)home;
	req.flags = flags;
	req.mode = mode;

	replyp = __db_envopen_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_envopen_ret(dbenv, home, config, flags, mode, replyp));
out:
	return (ret);
}

int
__dbcl_envremove(dbenv, home, config, flags)
	DB_ENV * dbenv;
	const char * home;
	char * const * config;
	u_int32_t flags;
{
	CLIENT *cl;
	__envremove_msg req;
	static __envremove_reply *replyp = NULL;
	int ret;

	ret = 0;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___envremove_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbenv == NULL)
		req.dbenvcl_id = 0;
	else
		req.dbenvcl_id = dbenv->cl_id;
	if (home == NULL)
		req.home = "";
	else
		req.home = (char *)home;
	req.flags = flags;

	replyp = __db_envremove_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_envremove_ret(dbenv, home, config, flags, replyp));
out:
	return (ret);
}

int
__dbcl_txnabort(txnp)
	DB_TXN * txnp;
{
	CLIENT *cl;
	__txnabort_msg req;
	static __txnabort_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = txnp->mgrp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___txnabort_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;

	replyp = __db_txnabort_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_txnabort_ret(txnp, replyp));
out:
	return (ret);
}

int
__dbcl_txnbegin(envp, parent, txnpp, flags)
	DB_ENV * envp;
	DB_TXN * parent;
	DB_TXN ** txnpp;
	u_int32_t flags;
{
	CLIENT *cl;
	__txnbegin_msg req;
	static __txnbegin_reply *replyp = NULL;
	int ret;

	ret = 0;
	if (envp == NULL || envp->cl_handle == NULL) {
		__db_err(envp, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___txnbegin_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)envp->cl_handle;

	if (envp == NULL)
		req.envpcl_id = 0;
	else
		req.envpcl_id = envp->cl_id;
	if (parent == NULL)
		req.parentcl_id = 0;
	else
		req.parentcl_id = parent->txnid;
	req.flags = flags;

	replyp = __db_txnbegin_1(&req, cl);
	if (replyp == NULL) {
		__db_err(envp, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_txnbegin_ret(envp, parent, txnpp, flags, replyp));
out:
	return (ret);
}

int
__dbcl_txncommit(txnp, flags)
	DB_TXN * txnp;
	u_int32_t flags;
{
	CLIENT *cl;
	__txncommit_msg req;
	static __txncommit_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = txnp->mgrp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___txncommit_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;
	req.flags = flags;

	replyp = __db_txncommit_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_txncommit_ret(txnp, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbbtcompare(dbp, func)
	DB * dbp;
	int (*func) __P((const DBT *, const DBT *));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbbtcompare method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbbtmaxkey(dbp, maxkey)
	DB * dbp;
	u_int32_t maxkey;
{
	CLIENT *cl;
	__dbbtmaxkey_msg req;
	static __dbbtmaxkey_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbbtmaxkey_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.maxkey = maxkey;

	replyp = __db_dbbtmaxkey_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbbtminkey(dbp, minkey)
	DB * dbp;
	u_int32_t minkey;
{
	CLIENT *cl;
	__dbbtminkey_msg req;
	static __dbbtminkey_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbbtminkey_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.minkey = minkey;

	replyp = __db_dbbtminkey_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbbtprefix(dbp, func)
	DB * dbp;
	size_t (*func) __P((const DBT *, const DBT *));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbbtprefix method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbcachesize(dbp, gbytes, bytes, ncache)
	DB * dbp;
	u_int32_t gbytes;
	u_int32_t bytes;
	int ncache;
{
	COMPQUIET(gbytes, 0);
	COMPQUIET(bytes, 0);
	COMPQUIET(ncache, 0);
	__db_err(dbp->dbenv,
	    "dbcachesize method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbclose(dbp, flags)
	DB * dbp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbclose_msg req;
	static __dbclose_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbclose_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.flags = flags;

	replyp = __db_dbclose_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbclose_ret(dbp, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbdel(dbp, txnp, key, flags)
	DB * dbp;
	DB_TXN * txnp;
	DBT * key;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbdel_msg req;
	static __dbdel_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbdel_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;
	req.keydlen = key->dlen;
	req.keydoff = key->doff;
	req.keyflags = key->flags;
	req.keydata.keydata_val = key->data;
	req.keydata.keydata_len = key->size;
	req.flags = flags;

	replyp = __db_dbdel_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbfd(dbp, fdp)
	DB * dbp;
	int * fdp;
{
	COMPQUIET(fdp, 0);
	__db_err(dbp->dbenv,
	    "dbfd method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbfeedback(dbp, func)
	DB * dbp;
	void (*func) __P((DB *, int, int));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbfeedback method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbflags(dbp, flags)
	DB * dbp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbflags_msg req;
	static __dbflags_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbflags_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.flags = flags;

	replyp = __db_dbflags_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbget(dbp, txnp, key, data, flags)
	DB * dbp;
	DB_TXN * txnp;
	DBT * key;
	DBT * data;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbget_msg req;
	static __dbget_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbget_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;
	req.keydlen = key->dlen;
	req.keydoff = key->doff;
	req.keyflags = key->flags;
	req.keydata.keydata_val = key->data;
	req.keydata.keydata_len = key->size;
	req.datadlen = data->dlen;
	req.datadoff = data->doff;
	req.dataflags = data->flags;
	req.datadata.datadata_val = data->data;
	req.datadata.datadata_len = data->size;
	req.flags = flags;

	replyp = __db_dbget_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbget_ret(dbp, txnp, key, data, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbhffactor(dbp, ffactor)
	DB * dbp;
	u_int32_t ffactor;
{
	CLIENT *cl;
	__dbhffactor_msg req;
	static __dbhffactor_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbhffactor_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.ffactor = ffactor;

	replyp = __db_dbhffactor_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbhhash(dbp, func)
	DB * dbp;
	u_int32_t (*func) __P((const void *, u_int32_t));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbhhash method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbhnelem(dbp, nelem)
	DB * dbp;
	u_int32_t nelem;
{
	CLIENT *cl;
	__dbhnelem_msg req;
	static __dbhnelem_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbhnelem_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.nelem = nelem;

	replyp = __db_dbhnelem_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dblorder(dbp, lorder)
	DB * dbp;
	int lorder;
{
	CLIENT *cl;
	__dblorder_msg req;
	static __dblorder_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dblorder_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.lorder = lorder;

	replyp = __db_dblorder_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbmalloc(dbp, func)
	DB * dbp;
	void *(*func) __P((size_t));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbmalloc method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbopen(dbp, name, subdb, type, flags, mode)
	DB * dbp;
	const char * name;
	const char * subdb;
	DBTYPE type;
	u_int32_t flags;
	int mode;
{
	CLIENT *cl;
	__dbopen_msg req;
	static __dbopen_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbopen_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (name == NULL)
		req.name = "";
	else
		req.name = (char *)name;
	if (subdb == NULL)
		req.subdb = "";
	else
		req.subdb = (char *)subdb;
	req.type = type;
	req.flags = flags;
	req.mode = mode;

	replyp = __db_dbopen_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbopen_ret(dbp, name, subdb, type, flags, mode, replyp));
out:
	return (ret);
}

int
__dbcl_dbpagesize(dbp, pagesize)
	DB * dbp;
	u_int32_t pagesize;
{
	CLIENT *cl;
	__dbpagesize_msg req;
	static __dbpagesize_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbpagesize_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.pagesize = pagesize;

	replyp = __db_dbpagesize_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbpanic(dbp, func)
	DB * dbp;
	void (*func) __P((DB_ENV *, int));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbpanic method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbput(dbp, txnp, key, data, flags)
	DB * dbp;
	DB_TXN * txnp;
	DBT * key;
	DBT * data;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbput_msg req;
	static __dbput_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbput_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;
	req.keydlen = key->dlen;
	req.keydoff = key->doff;
	req.keyflags = key->flags;
	req.keydata.keydata_val = key->data;
	req.keydata.keydata_len = key->size;
	req.datadlen = data->dlen;
	req.datadoff = data->doff;
	req.dataflags = data->flags;
	req.datadata.datadata_val = data->data;
	req.datadata.datadata_len = data->size;
	req.flags = flags;

	replyp = __db_dbput_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbput_ret(dbp, txnp, key, data, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbrealloc(dbp, func)
	DB * dbp;
	void *(*func) __P((void *, size_t));
{
	COMPQUIET(func, 0);
	__db_err(dbp->dbenv,
	    "dbrealloc method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbredelim(dbp, delim)
	DB * dbp;
	int delim;
{
	CLIENT *cl;
	__dbredelim_msg req;
	static __dbredelim_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbredelim_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.delim = delim;

	replyp = __db_dbredelim_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbrelen(dbp, len)
	DB * dbp;
	u_int32_t len;
{
	CLIENT *cl;
	__dbrelen_msg req;
	static __dbrelen_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbrelen_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.len = len;

	replyp = __db_dbrelen_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbrepad(dbp, pad)
	DB * dbp;
	int pad;
{
	CLIENT *cl;
	__dbrepad_msg req;
	static __dbrepad_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbrepad_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.pad = pad;

	replyp = __db_dbrepad_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbresource(dbp, re_source)
	DB * dbp;
	const char * re_source;
{
	COMPQUIET(re_source, NULL);
	__db_err(dbp->dbenv,
	    "dbresource method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbremove(dbp, name, subdb, flags)
	DB * dbp;
	const char * name;
	const char * subdb;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbremove_msg req;
	static __dbremove_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbremove_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (name == NULL)
		req.name = "";
	else
		req.name = (char *)name;
	if (subdb == NULL)
		req.subdb = "";
	else
		req.subdb = (char *)subdb;
	req.flags = flags;

	replyp = __db_dbremove_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbremove_ret(dbp, name, subdb, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbstat(dbp, sp, func, flags)
	DB * dbp;
	void * sp;
	void *(*func) __P((size_t));
	u_int32_t flags;
{
	CLIENT *cl;
	__dbstat_msg req;
	static __dbstat_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbstat_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (func != NULL) {
		__db_err(sp, "User functions not supported in RPC.");
		return (EINVAL);
	}
	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.flags = flags;

	replyp = __db_dbstat_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbstat_ret(dbp, sp, func, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbswapped(dbp)
	DB * dbp;
{
	CLIENT *cl;
	__dbswapped_msg req;
	static __dbswapped_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbswapped_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;

	replyp = __db_dbswapped_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbsync(dbp, flags)
	DB * dbp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbsync_msg req;
	static __dbsync_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbsync_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	req.flags = flags;

	replyp = __db_dbsync_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbupgrade(dbp, fname, flags)
	DB * dbp;
	const char * fname;
	u_int32_t flags;
{
	COMPQUIET(fname, NULL);
	COMPQUIET(flags, 0);
	__db_err(dbp->dbenv,
	    "dbupgrade method meaningless in RPC environment");
	return (EINVAL);
}

int
__dbcl_dbcursor(dbp, txnp, dbcpp, flags)
	DB * dbp;
	DB_TXN * txnp;
	DBC ** dbcpp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbcursor_msg req;
	static __dbcursor_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbcursor_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if (txnp == NULL)
		req.txnpcl_id = 0;
	else
		req.txnpcl_id = txnp->txnid;
	req.flags = flags;

	replyp = __db_dbcursor_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbcursor_ret(dbp, txnp, dbcpp, flags, replyp));
out:
	return (ret);
}

static int __dbcl_dbjoin_curslist __P((__dbjoin_curslist **, DBC **));
static void __dbcl_dbjoin_cursfree __P((__dbjoin_curslist **));
int
__dbcl_dbjoin(dbp, curs, dbcp, flags)
	DB * dbp;
	DBC ** curs;
	DBC ** dbcp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbjoin_msg req;
	static __dbjoin_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbjoin_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbp == NULL)
		req.dbpcl_id = 0;
	else
		req.dbpcl_id = dbp->cl_id;
	if ((ret = __dbcl_dbjoin_curslist(&req.curslist, curs)) != 0)
		goto out;
	req.flags = flags;

	replyp = __db_dbjoin_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	__dbcl_dbjoin_cursfree(&req.curslist);
	return (__dbcl_dbjoin_ret(dbp, curs, dbcp, flags, replyp));
out:
	__dbcl_dbjoin_cursfree(&req.curslist);
	return (ret);
}

int
__dbcl_dbjoin_curslist(locp, pp)
	__dbjoin_curslist **locp;
	DBC ** pp;
{
	DBC ** p;
	u_int32_t *q;
	int ret;
	__dbjoin_curslist *nl, **nlp;

	*locp = NULL;
	if (pp == NULL)
		return (0);
	nlp = locp;
	for (p = pp; *p != 0; p++) {
		if ((ret = __os_malloc(sizeof(*nl), NULL, nlp)) != 0)
			goto out;
		nl = *nlp;
		nl->next = NULL;
		nl->ent.ent_val = NULL;
		nl->ent.ent_len = 0;
		if ((ret = __os_malloc(sizeof(u_int32_t), NULL, &nl->ent.ent_val)) != 0)
			goto out;
		q = (u_int32_t *)nl->ent.ent_val;
		*q = (*p)->cl_id;
		nl->ent.ent_len = sizeof(u_int32_t);
		nlp = &nl->next;
	}
	return (0);
out:
	__dbcl_dbjoin_cursfree(locp);
	return (ret);
}

void
__dbcl_dbjoin_cursfree(locp)
	__dbjoin_curslist **locp;
{
	__dbjoin_curslist *nl, *nl1;

	if (locp == NULL)
		return;
	for (nl = *locp; nl != NULL; nl = nl1) {
		nl1 = nl->next;
		if (nl->ent.ent_val)
			__os_free(nl->ent.ent_val, nl->ent.ent_len);
		__os_free(nl, sizeof(*nl));
	}
}

int
__dbcl_dbc_close(dbc)
	DBC * dbc;
{
	CLIENT *cl;
	__dbc_close_msg req;
	static __dbc_close_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_close_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;

	replyp = __db_dbc_close_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbc_close_ret(dbc, replyp));
out:
	return (ret);
}

int
__dbcl_dbc_count(dbc, countp, flags)
	DBC * dbc;
	db_recno_t * countp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbc_count_msg req;
	static __dbc_count_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_count_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;
	req.flags = flags;

	replyp = __db_dbc_count_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbc_count_ret(dbc, countp, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbc_del(dbc, flags)
	DBC * dbc;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbc_del_msg req;
	static __dbc_del_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_del_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;
	req.flags = flags;

	replyp = __db_dbc_del_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

int
__dbcl_dbc_dup(dbc, dbcp, flags)
	DBC * dbc;
	DBC ** dbcp;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbc_dup_msg req;
	static __dbc_dup_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_dup_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;
	req.flags = flags;

	replyp = __db_dbc_dup_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbc_dup_ret(dbc, dbcp, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbc_get(dbc, key, data, flags)
	DBC * dbc;
	DBT * key;
	DBT * data;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbc_get_msg req;
	static __dbc_get_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_get_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;
	req.keydlen = key->dlen;
	req.keydoff = key->doff;
	req.keyflags = key->flags;
	req.keydata.keydata_val = key->data;
	req.keydata.keydata_len = key->size;
	req.datadlen = data->dlen;
	req.datadoff = data->doff;
	req.dataflags = data->flags;
	req.datadata.datadata_val = data->data;
	req.datadata.datadata_len = data->size;
	req.flags = flags;

	replyp = __db_dbc_get_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	return (__dbcl_dbc_get_ret(dbc, key, data, flags, replyp));
out:
	return (ret);
}

int
__dbcl_dbc_put(dbc, key, data, flags)
	DBC * dbc;
	DBT * key;
	DBT * data;
	u_int32_t flags;
{
	CLIENT *cl;
	__dbc_put_msg req;
	static __dbc_put_reply *replyp = NULL;
	int ret;
	DB_ENV *dbenv;

	ret = 0;
	dbenv = NULL;
	dbenv = dbc->dbp->dbenv;
	if (dbenv == NULL || dbenv->cl_handle == NULL) {
		__db_err(dbenv, "No server environment.");
		return (DB_NOSERVER);
	}

	if (replyp != NULL) {
		xdr_free((xdrproc_t)xdr___dbc_put_reply, (void *)replyp);
		replyp = NULL;
	}
	cl = (CLIENT *)dbenv->cl_handle;

	if (dbc == NULL)
		req.dbccl_id = 0;
	else
		req.dbccl_id = dbc->cl_id;
	req.keydlen = key->dlen;
	req.keydoff = key->doff;
	req.keyflags = key->flags;
	req.keydata.keydata_val = key->data;
	req.keydata.keydata_len = key->size;
	req.datadlen = data->dlen;
	req.datadoff = data->doff;
	req.dataflags = data->flags;
	req.datadata.datadata_val = data->data;
	req.datadata.datadata_len = data->size;
	req.flags = flags;

	replyp = __db_dbc_put_1(&req, cl);
	if (replyp == NULL) {
		__db_err(dbenv, clnt_sperror(cl, "Berkeley DB"));
		ret = DB_NOSERVER;
		goto out;
	}
	ret = replyp->status;
out:
	return (ret);
}

