#!/usr/bin/perl

package eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingCheckoutRedirectPreferenceType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType

=head1 DESCRIPTION

ProStores listing level preferences.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingCheckoutRedirectPreferenceType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'ProStoresStoreName', 'xs:string', '', '', '' ]
	, [ 'SellerThirdPartyUsername', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setProStoresStoreName()

The name of the store, if ThirdPartyCheckout is true.
To remove this value when revising or relisting an item, use DeletedField.

MaxLength: 200

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setProStoresStoreName {
  my $self = shift;
  $self->{'ProStoresStoreName'} = shift
}

=head2 getProStoresStoreName()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getProStoresStoreName {
  my $self = shift;
  return $self->{'ProStoresStoreName'};
}


=head2 setSellerThirdPartyUsername()

The user name of the associated store, if ThirdPartyCheckout is true.
To remove this value when revising or relisting an item, use DeletedField.

MaxLength: 200

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setSellerThirdPartyUsername {
  my $self = shift;
  $self->{'SellerThirdPartyUsername'} = shift
}

=head2 getSellerThirdPartyUsername()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getSellerThirdPartyUsername {
  my $self = shift;
  return $self->{'SellerThirdPartyUsername'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
