#!/usr/bin/perl

package eBay::API::XML::Call::IssueRefund::IssueRefundResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. IssueRefundResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::IssueRefund::IssueRefundResponseType

=head1 DESCRIPTION

Indicates the refund amount that a seller issued to a buyer for a single Half.com transaction.
Refunds may only be issued for a specific transaction. Sellers do not have the ability to issue a 
general refund (not tied to a transaction) to a buyer.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::IssueRefund::IssueRefundResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'RefundFromSeller', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TotalRefundToBuyer', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setRefundFromSeller()

Total amount that the seller asked Half.com to refund to 
a buyer for a Half.com transaction.

#    Argument: 'ns:AmountType'

=cut

sub setRefundFromSeller {
  my $self = shift;
  $self->{'RefundFromSeller'} = shift
}

=head2 getRefundFromSeller()

  Returned: Always
#    Returns: 'ns:AmountType'

=cut

sub getRefundFromSeller {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RefundFromSeller'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTotalRefundToBuyer()

Total amount that Half.com refunded to the buyer (which could include the refund amount 
from the seller plus a refund amount from Half.com).

#    Argument: 'ns:AmountType'

=cut

sub setTotalRefundToBuyer {
  my $self = shift;
  $self->{'TotalRefundToBuyer'} = shift
}

=head2 getTotalRefundToBuyer()

  Returned: Always
#    Returns: 'ns:AmountType'

=cut

sub getTotalRefundToBuyer {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalRefundToBuyer'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
