package WordList::ID::KBBI::ByClass::Adjective;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-11-19'; # DATE
our $DIST = 'WordList-ID-KBBI-ByClass-Adjective'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

use Role::Tiny::With;
with 'WordListRole::RandomSeekPick';

our %STATS = ("shortest_word_len",3,"longest_word_len",27,"avg_word_len",7.56483367277665,"num_words",4419,"num_words_contains_unicode",0,"num_words_contain_unicode",0,"num_words_contain_nonword_chars",284,"num_words_contains_nonword_chars",284,"num_words_contains_whitespace",49,"num_words_contain_whitespace",49); # STATS

1;
# ABSTRACT: Indonesian adjective words from Kamus Besar Bahasa Indonesia (KBBI), 3e

=pod

=encoding UTF-8

=head1 NAME

WordList::ID::KBBI::ByClass::Adjective - Indonesian adjective words from Kamus Besar Bahasa Indonesia (KBBI), 3e

=head1 VERSION

This document describes version 0.001 of WordList::ID::KBBI::ByClass::Adjective (from Perl distribution WordList-ID-KBBI-ByClass-Adjective), released on 2024-11-19.

=head1 SYNOPSIS

 use WordList::ID::KBBI::ByClass::Adjective;

 my $wl = WordList::ID::KBBI::ByClass::Adjective->new;

 # Pick a (or several) random word(s) from the list
 my ($word) = $wl->pick;
 my ($word) = $wl->pick(1);  # ditto
 my @words  = $wl->pick(3);  # no duplicates

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }  # case-sensitive

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words (beware, some wordlists are *huge*)
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This wordlist uses random-seek picking, which gives higher probability for
longer words. See L<File::RandomLine> for more details.

=head1 WORDLIST STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 7.56483367277665 |
 | longest_word_len                 | 27               |
 | num_words                        | 4419             |
 | num_words_contain_nonword_chars  | 284              |
 | num_words_contain_unicode        | 0                |
 | num_words_contain_whitespace     | 49               |
 | num_words_contains_nonword_chars | 284              |
 | num_words_contains_unicode       | 0                |
 | num_words_contains_whitespace    | 49               |
 | shortest_word_len                | 3                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ID-KBBI-ByClass-Adjective>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ID-KBBI-ByClass-Adjective>.

=head1 SEE ALSO

L<ArrayData::Lingua::Word::ID::KBBI::ByClass::Adjective> contains the same data.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ID-KBBI-ByClass-Adjective>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
Maha Esa
Romawi
Rumi
abadi
abaktinal
abdominal
abiotik
abjadiah
abnormal
abortif
abras
absah
absolut
absonan
absorptif
abstrak
absurd
abtar
abuh
abuh-abuhan
acak
acak-acakan
acap kali
aco-acoan
acoan
adaktil
adaptabel
adaptif
adati
adekuat
adhesif
adiabatik
adiaktinik
adidaya
adigang
adiguna
adigung
adika
adikodrati
adiktif
adikuasa
adiluhung
adinamia
adisional
aditama
aditif
adiwarna
adjektival
administratif
adoptif
adrenergik
adventisius
adverbial
aerobik
aerodinamik
afdal
afektif
afiat
afirmatif
afotik
agalaksia
agam
agamais
agamawi
agentif
agitatif
aglutinatif
agraris
agregatif
agresif
ahistoris
ahmak
ajaib
akademik
akademis
akal-akal
akbar
akhlaki
akli
akliah
akmal
akomodatif
akrab
akrilik
akseptabel
aksiomatis
aktif
aktinik
aktual
akuatik
akumulatif
akurat
akustik
ala
alakrima
alami
alamiah
alang
alang-alangan
albinoid
albuminoit
albuminuria
alegoris
alegreto
alegro
alem, aleman
alergis
alfabetis
alga
algoid
alifatik
alisiklik
alkalis
alpa
altruistis
aluvial
amaliah
amatir-amatiran
ambekan
ambigu
ambisius
ambivalen
ambulatori
amburadul
ameboid
amelioratif
amenorea
amerta
ametria
amfoterik
amikal
amniotik
amoral
ampai
ampang
anaerobik
anaforis
anakronistis
anakusis
analitis
analog
anarkistis
anasional
anatomis
andal
andam
aneka jenis
aneka ragam
anestetis
anggal
anggun
angin-anginan
angker
angkuh
aniridia
anisotropis
anodonsia
anonim
anorganik
anorgastik
antagonistis
antap
antarbangsa
antarbenua
antarkelompok
antarlingkungan
antarmaster
antarnegara
antarplanet
antarpribadi
antarpulau
antarras
antarruang
antemeridiem
anter-anter
anterior
antik
antikarat
antiklinal
antisiklonal
antisiklonis
antisipatif
antitank
antropoid
antroposentris
antusias
anumerta
apatis
apatride
apikal
aplikatif
apodal
apokaliptik
apokrin
apokromatik
apolitis
apologetis
aposematik
aposisional
apositif
apostolik
apresiatif
apriori
aprit-apritan
arbitrer
argumentatif
aring
aristokratis
aritenoid
arkais
arkeologis
arogan
aromatik
artetis
artifisial
artistik
asa-asaan
asal
asal-asalan
asasi
aseksual
aseptik
asiklik
asilabis
asimetris
asimilatif
asiri
askriptif
asosial
asosiatif
aspirasional
aspiratif
asri
astasia
astatik
astenik
astral
astronomis
asumtif
asusila
asyik-asyiknya
ateistis
atmosferis
atomistis
atraktif
atributif
audio
audiolingual
audiovisual
aural
autarkis
autentik
autistik
autodidaktik
autogen
autokton
automotif
autotrofik
avirulen
awaair
awaarang
awabau
awabeku
awabulu
awabusa
awadara
awahama
awamineral
awanama
awang, berawang
awaracun
awawarna
azali
azospermi
baal
babil
babur
bacar
bacul
badani
baduk
badung
bagak
bagas
bagur
bagus
bagusan
bahasa
bahenol
bahimiah
baik
baik-baik
baka
bakero
bakhil
bakir
bakup
balak
balam
balar
balig
balistik
balut
balut-balut
bambang
banal
bancar
banci
bancuh
bandang
bandel
bangga
bangir
bangkar
bangkas
bangkot
bangkotan
bangkut
banglas
bangpak
bangsai
bantat
bantau
banter
banyak
banyak-banyak
banyol
baplang
barbar
baru
basah
basau
basi
basilari
basir
bata-bata
batal
batangan
baung
bawat
bawel
bayak
bayan
bayu
bebal
bebas
bebel
bebuyutan
becek
becus
bedebah
begana-begini
begap
begar
bego
beken
beku
belacak
belalah
belalak
belalang
belam
belandung
belantara
belecak
belel
belengkok
belengkokan
belengkong
belengset
belenting
beleter
belia
belimbing
beliut
belobor
belodok
belok
belon
belongkot, belongkotan
beloon
belus
beluwek
benak
benar
benar-benar
bencat
benci
bencong
bendawi
benderang
benefaktif
bengal
bengang
bengang-bengut
bengap
benggal
benggang
benggil
benggol
bengis
bengkah
bengkak
bengkal-bengkil
bengkang-bengkok
bengkang-bengkong
bengkang-bengkung
bengkeng
bengkil
bengkong
bengkung
bengot
benguk
bengung
bening
benjol
benjut
bentan
bentar
bentong
benyai
benyek
benyot
bera
berandang
beraneka
beraneka ragam
berang
berangsang
berangsangan
berani
berani-berani
berapi-api
beraspirasi
berat
berbahagia
berbahasa-bahasa
berbangga
berbatuan
berbidai-bidai
bercabiran
bercamping-camping
bercuang-caing
berdegap
berduri-duri
berdus
berempak
berenggan-enggan
berengsek
beres
bergajul
bergemal-gemal
bergemuruh
bergenggam
bergerigi
bergontai
bergores
bergores-gores
bergosong
bergulut-gulut
berida
beringas
beringsang
beristibdad
berjendul
berjumbai-jumbai
berjuntaian
berkaca-kaca
berkepanjangan
berketi-keti
berkilauan
berlama-lama
berlangau
berlapang-lapang
berlapar
berlebih-lebih
berlebihan
berlimpit-limpit
berlutu
bermacam
bermacam-macam
bermekaran
bernas
berpada-pada
berpangkat-pangkat
berpanjang-panjang
berpenyakitan
berprihatin
bersaf-saf
bersahaja
bersemarak
bersembunyi-sembunyi
bersempuras
berserak-serak
berseran
bersesat
bersetia
bersibaran
bersih
bersilutu
bersinau-sinau
bersuaian
bersut
berusuh
besar
besar-besaran
beser
beset
besing
betah
betak-betak
betas
betul
betul-betul
biadab
biadat
biang
biang-biang
biasa
bienial
bigami
bijak
bijaksana
bikonkaf
bikonveks
bilabial
bilateral
bilineal
bilingual
bilis
bimbang
binal
binasa
bincacak
bindam
bineka
binen
biner
bingas
bingit
bingung
bintulbahar
biogenik
biologis
birang
biring
birokratis
biseksual
bising
bisu
biverbal
blangko
blirik
bobol
bobos
bobrok
bodoh
bogel
bogot
bohong
bois
bokek
bolehan
bolong
bombastis
bonafide
bongak
bongkar-bangkir
bongok
bongsor
bonyok
bopok
boros
bosan
bosor
botak
botanis
boya
boyak
brakisefalik
brakiurus
brilian
brutal
buani
buas
bubung
budek
bugar
bugil
bujal
bukan-bukan
bukat
bulat
buluk
bulukan
bulus
bumiah
bumpet
buncah
buncang
buncit
bundar
bundas
bungkam
bungkang
bungking
bungkuk
buntak
buntang
buntar
buntek
buntung
buram
burik
buruk
busik
busuk
busung
buta
butek
butut
buyutan
caba
cabak
cabik
cabik-cabik
cabir
cabul
cabur
cacak
cacar
cacau
caem
cahang
cahar
caing
caing-caing
cair
cakah
cakap
cakep
calak
calar-balar
calui
campah
campang-camping
campin
camping
candala
candramawa
canggih
canggung
cangkang
cangkat
cangkih
cangut
cantas
cantik
capai
capang
capek
capik
capuk
carik
carut
casciscus
caung
cebol
cedera
ceding
cegak
cegar
cekah
cekal
cekang
cekat, cekatan
cekdel
cekel
cekuk
cekung
celemotan
celengkak-celengkok
celi
celomes
celomok
celonok
celopar
celung
celus
cemar
cemberut
cembung
cemburu
cemeh
cemer
cemerlang
cemomot
cemong
cempreng
cenal-cenil
cendekia
cenderung
cengang
cengeh
cengeng
cengis-cengis
cengkar
cengki
cengkol
cengkong
cengkung
cengli
centil
cepak
cepat
ceper
ceples
cepo
cerabah
cerah
cerai-berai
ceramah
cerap
cerdas
cerdik
cerewet
cergas
ceria
ceriwis
cermat
cerna
ceroboh
ceronggah
cerucup
ceruh
cerun
cespleng
cialat
cilik
cingkrang
cinta
ciut
cobar-cabir
cocok
cogok
comel
comot
comot-comot
compang-camping
compeng
compes
condong
condong-mondong
congak
congeh
congget
conggok
congkah-cangkih
congkah-mangkih
congkak
copak-capik
corak-carik
coreng-moreng
corot
cuai
cuang, cuang-caing
cuek
cukup
cukupan
culas
culun
cumil
cungap
cupar
cupul
curam
curang
curiga
dadu
dahaga
dahsyat
daif
dakar
dalam
damat
damba
damping
dangkal
dangkar
datar
dauk
debil
debus
dedai
dedak
dedara
dedel
dedikatif
deduktif
defensif
definit
definitif
defisien
deformatif
degeneratif
degil
deiktis
dekaden
dekat
deklaratif
dekoratif
delikat
deltoid
delusif
demagogis
demam
demen
demes
demografis
demokratis
demonstratif
dempak
dempang
dempet
dendam
dengkel
dengki
dengkik
dengkol
dengu
denominal
denotatif
dentat
departemental
dependen
deras
derivatif
derman
deskriptif
despotik
destruktif
determinatif
deverbal
dewasa
diagonal
diakronis
dialektal
dialektis
dialogis
diametral
diaterman
diatermik
diatonik
dibasa
didaktis
diferensial
digdaya
digital
dihedral
dihidroksil
dikit
dikromatik
diktatorial
diktatoris
dilematik
diminutif
dimorfik
dinamik
dinamis
dingin
dingkit
dini
diploid
diplomatik
diplomatis
direk
dirgahayu
disagio
disilabik
disinsentif
diskoid
diskontinu
diskriminatif
diskursif
dispareunia
distal
distingtif
dito
diurnal
divergen
dobel
dodong
dodor
dogel
dogmatis
dogol
dokumenter
dol
dolak-dalik
dolikosepalik
domestik
dominan
domot
dompak
dongkol
dongok
dorman
dorsal
dower
doyan
doyong
dramatik
dramatis
drastis
dualistis
dubius
dugal
dugdeng
duka
dungkul
dungu
duniawi
duplo
duratif
durhaka
durkarsa
durnois
durnoisme
dursila
dusta
dwiganda
edentat
edukatif
efektif
efisien
egaliter
egoistis
egosentris
egresif
eidetik
ejektif
ekabahasa
ekdemik
eklektik
ekliptis
ekologis
ekonomis
eks
eksak
eksentrik
eksesif
eksklusif
ekskursif
eksobiotik
eksoergik
eksogam
eksotermik
eksotik
eksotis
ekspansif
ekspansionistis
eksperimental
eksplisit
eksploratif
eksplosif
eksponensial
ekspres
ekspresif
ekspresionistik
ekstensif
ekstern
eksternal
ekstrakardial
ekstraktif
ekstrakurikuler
ekstralinguistis
ekstramarital
ekstraparlementer
ekstraseluler
ekstraterestrial
ekstrauterin
ekstrem
ekstrinsik
ektotermik
ekuivalen
ekumenis
elastis
elegan
elektris
elektromagnetik
elektronegatif
elektronis
elektropositif
elementer
eliptis
elitis
elusif
eluvial
embrionik
emeritus
eminen
emosional
emotif
empiris
empot
empuk
encer
endemis
endogen
endosentris
endotermal
endotermis
endut-endutan
energetik
energik
enggan-enggan
engkah
ensefalitogen
ensiform
ensiklopedis
entah-berentah
enteng
enzootik
epileptik
episiklik
episkopal
episodik
epitermal
epizoik
epizootik
erang
ergonomis
erotis
esensial
eskatologis
esoteris
estetik
estetis
estuarin
etimologis
etnik
etnis
etnografis
etnologis
eufemistis
euploid
eurihalin
eurosentris
eusinantropus
eutektik
evaluatif
eviden
evokatif
evolusioner
faali
faktual
fakultatif
falsafi
familier
fana
fanatik
fani
fantastis
faringal
farmakologis
fasih
fatal
fatala
fatanah
faunistik
federal
federalistis
feminin
fenomenal
feodal
feodalistis
feral
fertil
fibrokistik
figuratif
fikli
fiktif
filantropis
filatelik
filmis
filologis
filosofis
finansial
firauniah
firdausi
fisibel
fisiognomis
fisiologis
fisis
fiskal
fitofag
flegmatis
fleksibel
fluktuatif
fluoresen
fonemis
fonetis
fonis
fonologis
formal
formalistis
forte
fotogenik
fotografis
fotokromik
fototropis
fragmentaris
frekuen
frekuentatif
frigid
frontal
fundamental
fundamentalistis
fungibel
fungistatik
fungoid
fungsional
futuristik
futuristis
futurologis
gabas
gabuk
gaduh
gadungan
gaek
gagah
gagu
gaguk
galaba(h)
galak
galan
galau
galgal
galib
galir
galvanis
gamak
gamam
gamang
gamblang
gamopetal
gampang
gampang-gampangan
gampangan
ganar
ganas
gancang
ganda
gandem
gandes
gandrung
gangsar
gani
ganjat
ganjil
ganoid
ganteng
ganyar
ganyut
gapah
gapah-gopoh
gapil
garang
garau
garib
garing
gasal
gasang
gastrointestinal
gatal
gawat
gayal
gayang
gayat
geblek
gebyar-gebyar
gecer
gecul
gede
gedembal
gedempol
gegai
gegap
gegar
geger
gejah
geladak
geladir
gelagap, gelagapan
gelang
gelap
gelatak
geleber
gelepai
gelepot
gelimbir
gelimbiran
gelinggaman
gelisah
gelita
gelodar
gelojoh
gemang
gemar
gemas
gemawan
gembeng
gembira
gembos
gembul
gembur
gemebyar
gemerlap
gemerlapan
gemetar
gemilang
gemilap
gemirang
gempal
gempar
gempita
gempor
gemuk
gemulai
gemulung
gemuntur
gemuruh
genap
gencar
gencat
gendut
genealogis
generatif
generik
genetis
genial
genit
genital
genitif
genius
genjah
genjang-genjot
genjur
gentas
gentat
genting
genyot
geofisis
geografis
geologis
geometris
geosentris
geostasioner
geotermal
gepeng
gerabang
gerah
geram
geregetan
gerejani
gerejawi
gerek
gerenik
gerenyau
gerenyot
gerepes
gerigis
geringging, geringgingan
geripis
gerlap
gerlip
germang
germinal
gerowong
gersang
gerugut
geruh
geruh-gerah
gerumpung
gerun
gerutu
gesit
getas
getek
getir
gial
giat
gidik
giga-
gigih
gigil
gigis
gila
gila-gila
gilang
gilap
gilap-gemilap
gimbal
gingsul
girah
girang
girap-girap
giring
global
gobar
goblok
gogos
gombang
gombrang
gombroh
gompal
gompiok
gondok
gondrong
gonjing
gonjong
gontai
gopoh
gosong
goyah
gradual
grafemis
grafis
gramatikal
gratak
gratis
grogi
gual, gual-gail
gugu
gugup
gulana
gulita
gumal
guncang
gundul
gunolugu
guntung
guram
gurih
guyub
habis-habis
habluk
hakiki
hakimah
halai-balai
halal
halimunan
halus
hambar
hamik
hampa
hana
hancur luluh
hancur-hancuran
hangat
hangit
harak, terharak-harak
haram
harbi
harfiah
haring
harmonis
harum
hasud
haul
haus
hayati
hebat
heboh
hebring
hegemonik
helat
heliotrop
hemat
hengkang
hening
heran
herediter
hermetis
heroik
heterodoks
heterofil
heterogen
heteroseksual
heterosiklis
heterotrof
hewani
hialin
hibridis
hidraulis
hidrostatis
hidrotermal
hierarkis
higienis
higroskopis
hijriah
hilofagus
hina
hina dina
hiperaktif
hiperbarik
hiperbolis
hiperkorek
hiperkritis
hiperseksual
hipersensitif
hipersonik
hipertonik
hipertradisional
hipnotis
hipogen
hipokrit
hipokritis
hipomastia
hipotetis
hipotiroid
hipotonik
hiruk
histeris
historis
hitam putih
holistis
holografis
holozoik
homogen
homoiotermal
homorgan
homoseksual
homoterm
honorer
honorifik
horizontal
hormat
hubar-habir
huji
human
humanistis
humaniter
humoristis
hura-hura
ideal
idealistis
identik
ideografis
ideologis
idiil
idiomatis
idrak
igau-igauan
ijtimaiah
ikhlas
ikhtiari
ikonis
iktidal
ilegal
ilmiah
ilusif
ilustratif
imajinatif
imajiner
imanen
imani
imbak
imbal
imbang
imbang-imbangan
imbesil
imitatif
imperfek
imperial
impersonal
implisit
impoten
impresif
impresionistik
impulsif
imunologis
inartikulat
inca-binca
incang-incut
incut
indah
indikatif
indisipliner
individual
individualistis
indolen
indranila
indriawi
induktif
inferensial
inferior
infertil
infiradi
inflatoar
infleksibel
infleksif
informal
informatif
infrasonik
inggang-inggung
inggung
inheren
inklusif
inkognito
inkompeten
inkomplet
inkonfeso
inkonsisten
inkonstitusional
inkonvensional
inkremental
inovatif
insaf
insani
insidental
insinuatif
insolven
instan
instingtif
institusional
instruksional
instruktif
instrumental
insuler
integral
integralistik
inteligen
intens
intensif
intensional
interaksionistik
interaktif
interdepartemental
interdependen
interdisipliner
interesan
interetnik
interglasial
interinsuler
interkonsonantal
interkontinental
interlokal
intermolekuler
intern
internal
internasional
interogatif
interpretatif
intertestial
interzona
intim
intoleran
intradermal
intrakalimat
intralinguistis
intramolekul
intramuskuler
intransitif
intraseluler
intrauniversiter
intravena
intrinsik
introver
intuitif
invalid
inventif
investigatif
irasional
iri hati
iritatif
ironis
isentropik
islami
islamiah
islamis
isobarik
isodinamik
isokemi
isokorik
isolatif
isomorfis
isopiestik
isotermal
istan
istiazah
istimaiah
istimewa
istiwa
isytiak
jabir
jabrik
jagur
jahanam
jahar
jahat
jahil
jahiriah
jail
jais
jaiz
jalang
jalil
jamak
jambon
jamil
janat
jangak
janggal
jangkih, jangkih mangkih
jangkung
jantang
jarang
jarang-jarang
jarotan
jasadi
jasmaniah
jati
jatmika
jauh
jaya
jebab
jeblok
jeblos
jegang
jejas
jelabir
jelak
jelas
jelata
jelek
jeli
jelita
jeluk
jembar
jembel
jempolan
jemu
jemuas
jenaka
jendal, jendal-jendul
jendala
jendol
jendul
jeneng
jenggar, jenggar-jenggur
jenggul
jengkel
jengkot
jenjam
jenjang
jentaka
jenuh
jeput
jera
jerah
jerah, jerah-jerih
jerau
jereket
jereng
jeri
jernih
jerungkis
jidur
jijik
jinak
jinak-jinak
jirus
jitu
jompo
jongang
jonget
jorok
jorong
judes
juih
jujur
juling
jumbul
junior
juvenil
kabihat
kabil
kabir-kabiran
kabur
kabut
kacak
kacau
kacau-balau
kacuk
kadastral
kadir
kadru
kafaah
kafah
kafarat
kaget
kagok
kagum
kahar
kaifiah
kakek-kakek
kaku
kalang, kalang kabut
kalap
kalas
kalbi
kaleidoskopis
kalem
kalengan
kaligrafis
kalis
kalut
kalut-malut
kamariah
kamilmukamil
kampungan
kancap
kangen
kanjang
kanonis
kantang
kaotis
kapabel
kapisa
kapitalistis
kapok
kaprah
karatan
karbolik
kardiak
kardiovaskular
karib
karikatural
karismatik
karitatif
karsinogenik
karut-marut
kasang
kasap
kasar
kasatmata
kasim
kasuistik
kaswah
katadrom
katai
katak
katawi
kategorial
kategoris
kausal
kaustik
kawak
kawakan
kawi
kaya
kayun
keabu-abuan
kearab-araban
keasinan
keasyik-asyikan
kebal
kebapakan
kebarat-baratan
kebas
kebasah-basahan
kebata-bataan
kebayi-bayian
kebayuan
kebebangan
kebelanda-belandaan
kebelet
kebiri
kebiru-biruan
kebocahan
kebudak-budakan
kebuluran
kecabaian
kecai
kecapaian
kece
kecele
keceng
kecewa
kecil
kecil hati
kecil-kecilan
kecil-mengecil
kecilan
kecit
kecoh
kecokelat-cokelatan
kecokelatan
kecuh-kecah
kecut
kedah
kedaluwarsa
kedam
kedang
kedap
kedekut
kedempung
kedengkik
kedesa-desaan
kedik
kedinginan
kedodoran
keedanan
kegadis-gadisan
kegatalan
kegelap-gelapan
kegenangan
kegerahan
kegila-gilaan
kegirang-girangan
kehausan
kehel
kehijau-hijauan
kehitam-hitaman
kehitaman
keibuan
keinggris-inggrisan
kejam
kejang
kejat
kejengkolan
keji
kejur
kejut
kekabur-kaburan
kekal
kekanak-kanakan
kekar
kekau
kekel
kekencangan
keki
kekoboi-koboian
kekok
kekota-kotaan
kekudusan
kekuning-kuningan
kekuningan
kelam
kelamaan
kelang-kelok
kelar
kelasah
kelat
kelebek
kelelahan
keletah
keletik
kelewat
kelewatan
kelih
keliru
kelompang
kelop
kelu
kelunturan
kelus
kelusuh-kelasah
kemahalan
kemalu-maluan
kemanja-manjaan
kemarah-marahan
kemarau
kemas
kemasam-masaman
kemasinan
kematu
kematus
kemayu
kembar
kembera
kembung
kemerah-merahan
kemik
kemilap
kempal
kempang, kempang-kempis
kempis
kempot
kempung
kemuning
kencang
kencong
kendur
kental
kentara
kenteng
kenyal
kenyang
kenyat, kenyat-kenyit
kenyat-kenyut
kenyi
kenyih
kenyir
keorganisasian
kepagian
kepalang
kepam
kepancingan
kepecong
kepeningan
keperak-perakan
keperakan
kepialu
kepil
kepinggiran
kepot
kepucat-pucatan
keputih-putihan
keputihan
kerabik
keracak
kerajang
keramat
kerancak-rancakan
kerang
kerang-keroh
kerap
keras
kerasan
kerdil
kerekot
kerempeng
keren
kerendahan
kerepes
kereseng
keresot
kerih
kerimut
kering
kering-kering air
kerintil
kerisut
kerobak
kerobak-kerabit
kerobak-kerobek
kerobak-kerobik
keropok
keropos
kerot
kerotot
kersai
kersang
kertang
keruan
keruh
kerul
keruntang-pungkang
kesak
kesakitan
kesal
kesangatan
kesat
kesempitan
kesemutan
kesip
kesohor
kesorangan
kesorean
ketai
ketak
ketam
ketar
ketat
ketegar
keterlaluan
ketua-tuaan
ketuaan
ketul
ketus
keungu-unguan
kewangi-wangian
kewangian
khafi
khalis
kharab
khasi
khawatir
khayali
khidmat
khilaf
khisit
khuduk
khunsa
khusus
khusyuk
kiasi
kibang-kibut
kibir
kidal
kikir
kikuk
kimiawi
kimpal
kincup
kinetik
kinred
kiruh
kisruh
kisut
kiting
kizib
klasik
klasikal
klerikal
klimis
klinis
kliyengan
koaksial
kocah-kacih
kocak
kocar-kacir
kocoh
kodrati
koersif
kognat
kognatif
kognitif
kohesif
kohong
koinsiden
kojoh
kolateral
kolegial
kolektif
koleng
koloidal
kolokan
kolonial
kolosal
kolot
komaran
kombor
komeng
komersial
komikal
kompak
komparatif
kompatibel
kompeten
kompetitif
kompleks
kompleksitas
komplementer
komplet
komplikatif
komprang
komprehensif
kompromistis
kompulsif
komunal
komunalistik
komunikatif
komunistis
kondang
kondusif
koneksitas
konfrontatif
kongenital
konis
konjungtif
konkaf
konklusif
konkomitan
konkret
konotatif
konsekuen
konsekutif
konsentris
konsepsional
konseptual
konservatif
konsesif
konsesional
konsisten
konspiratif
konstipasi
konstitusional
konstruktif
konsumtif
kontan
kontekstual
kontemplatif
kontemporer
kontet
kontinental
kontinu
kontra
kontradiktif
kontraktual
kontras
kontraseptif
kontroversial
konveks
konvektif
konvensional
konvergen
konyol
kooperatif
koordinat
koordinatif
kopak
kopek
kopel
kopet
kopong
kopulatif
kopyor
kordial
korek
korektif
korelatif
koreng
koreng-koreng
koreografis
koronal
korporat
korporatif
korsleting
korup
koruptif
kosmis
kosmologis
kosmopolitan
kosong
kotai
koteng
kotok
kotong
kotor
koyak
koyak-koyak
kreatif
kreditabel
kresendo
kribo
kriminal
kriminologis
kriofil
krisis
kristiani
kritis
kromatis
kronis
kronologis
krusial
kuadripartit
kuadrupleks
kualitatif
kuantitatif
kuarterner
kuasi
kuat
kuboid
kubra
kucak
kucam
kudung
kudus
kujur
kukuh
kultural
kumal
kumuh
kumulatif
kunar-kunar
kunjung
kuno
kuntul
kuratif
kurikuler
kuring
kursif
kurus
kurusan
kusam
kusau
kusut
kutung
kuyu
kuyup
labial
labil
labiodental
labiovelar
laboratoris
labuh
labut
lacur
ladung
lagau
laguh-lagah
lahab
lahap
lahiriah
laif
laik
lain
lajak
lajang
laju
lakar
lakonik
lakustrin
lalah
lalai
lali
lama
lamban
lambat
lambat-lambat
lambuk
lampai
lampas
lampau
lampias
lamur
lanau
lancang
lancap
lancar
lancip
lancung
lancut
landai
landung
landur
langgas
langgeng
langguk
langka
langkas
langking
langlai
langsai
langsam
langsar
langsing
langu
lanjai
lanjang
lanjar
lanjung
lanjur
lanjut
lantam
lantang
lapang
lapar
lapuk
laram
larap
laras
laringal
laris
larut
lasa
lasak
lasian
lata
latah
laten
lateral
latur
laun
laur
lawa
lawah
lawak
layah
layak
layap
layu
lazim
lebam
lebang
lebat
lebih
lebuk
lebur
lecak
lecap
lecat
leceh
lecek
lecet
leco
lecok
lecuh
lecur
lega
legal
legap
legat
legendaris
legislatif
legit
legok
leha-leha
lejas
leka
lekak-lekuk
lekang
lekap
lekas-lekas
lekat
lekir
lekit
leksikal
leksikografis
lekuk
lelah
lelas
leler
leluasa
lemah
lemas
lemau
lembam
lembang
lembap
lembek
lembok
lembut
lempeng
lempung
lena
lencang
lencir
lendung
lendut, melendut
lengai
lengang
lengar
lengas
lenggang
lengkai
lengkap
lengket
lengkok
lentik
lentoid
lentok
lentuk
lenyah
lenyai
lenyak
lenyap
lenyau
lepak
lepas
leper
lepok
lerai
lerak
lesa
lesak
lesi
lestari
lesu
leta
letal
leter
letih
letoi
leuca
leukositosis
lewah
lezat
liar
liat
liberal
liberalistis
libidis
licak
licau
licik
licin
lihai
likat
likuid
limfadenosis
limfatik
limitatif
limun
lincah
lincir
lincun
linear
lingar
lingat
linglung
linier
lintap
lintup
linu
liplap
lipu
liris
lisut
liturgis
liut
loba
lodoh
logis
lokek
lokos
lompong
loncos
longgar
longgor
lonjong
lonjoran
lontok
lonyok
lopak
lopak-lapik
lorek
loreng
los
losong
lota
lotak
lowong
loya
loyak
loyal
loyo
luak
luang
luar biasa
luas
luat
lucah
lucu
lucut
ludes
lugas
luhur
lumat
lumayan
lumer
lumpuh
lumrah
lunak
luncai
luncung
luner
lungkah
lungkum
lunglai
lungse
lungsungan
luntang-lantung
luntur
lunyai
lupa-lupa ingat
lurus
lusuh
lut
luti
luwes
luyu
mabrur
mabuk
mabul-mabul
macet
madang
madani
madi
magang
magel
magis
magnetis
magribi
mahakuasa
mahal
mahamulia
mahardika
maharupa
mahasuci
mahatahu
mahatma
mahir
majakaya
majal
majasi
majelis
majemuk
majir
majuh
makar
makiyah
makmur
maknawi
makro
makrosefalik
makroskopis
makruh
maksi
maksimal
mala
malafide
malan
malang
malap
malar
malas
malasuai
malis
malu
malu-malu
mamai
mamang
mambung
mamik
mampu
mampung
manai
manajerial
manasuka
mancawarna
mancung
manda
mandiri
mandraguna
mandul
manggah
mangkak
mangkar
mangkas
mangkir
mangkus
mangut
manipulatif
manis
manise
manja
manjur
mantan
mantap
mantiki
manual
manusiawi
mapan
marah
marak
maras
marem
marginal
marine
marital
maritim
marpaud
masa bodoh
masak
masam
masif
masin
masinal
masir
maskulin
massal
masygul
masyhur
matang
matematis
materialistis
materiil
matriarkal
matrilineal
matrilokal
maujud
maya
mayeng
mazarin
mbeling
medial
medikamentosa
medikolegal
medis
medisinal
medu
megah
megak
megat
mejam
mejan
mekanis
melanjai
melankolis
melantang
melar
melarat
melaut
melawas
melekang
melempem
melengah
melentik
melimpah
melingkar
melintah
melit
melodius
melodramatik
melodramatis
meloya
meluah
meluar
meluat
melucut
memar
membaru
membawang
memesat
memper
memunjung
menceng
mencla-mencle
mencong
mencos
mencuat
mending
mendingan
mendunia
menegak
menganak sungai
mengentak-entak
mengetren
mengganda
menggeledek
menggendut
menggenting
menggerlap
menggerlip
menggerugut
mengot
menjabal
menor
mentah
mentereng
menyemak
menyembilu
menyeni
menyumbang
mepet
meraga
merah
merajak
merakyat
merana
merdeka
merdesa
merdu
meres
meriang
merinding
merot
mersik
merubi
mesodermik
mesra
mesum
metabolik
metabolis
metaforis
metalik
metalurgis
metamorfis
meteorologis
metodis
metris
metronomis
mewah
midi
mikro
mikrobiologis
mikroskopis
militeristis
minder
mineralogis
mini
minim
minimal
minus
miotik
miring
mirip
mirmekofag
misioner
miskin
misterius
mistis
mitologis
mobil
moblong
moderat
moderato
modernisme
modifikatif
modis
modular
moksa
molar
molek
molekuler
molor
molos
momental
mondial
mondok
moneter
mongkok
mongoloid
monofag
monogam
monokarpa
monoklin
monoklinal
monokromatis
monolingual
monolitik
monoploid
monopolistik
monoton
montok
monumental
moralistis
morat-marit
morfemis
morfofonemis
moril
motorik
muak
mual
muasir
mubah
mubarak
mubazir
mubut
muda
mudah
mufakat
muhal
mujarab
mujur
mukhlis
mukibat
muktabar
muktamad
mulas
mulia
multibahasa
multidimensi
multidisipliner
multifaset
multifungsi
multiguna
multikompleks
multilateral
multilingual
multinasional
multinegara
multipara
multipel
multipleks
multipolar
multirasial
multiseluler
multivalen
muluk
muluk-muluk
mulus
mumuk
mumut
munafik
mungil
mungkar
munjung
murah
murahan
muram
murba
murni
murung
musikal
musikologis
muskil
mustahak
mustahil
mustaid
mustajab
mustakim
mutakadim
mutakhir
mutlak
mutu
nabati
nadir
nahas
naif
naim
najis
nakal
naluriah
nanang
nanar
napas
naqli
naratif
nasal
nasional
nasionalistis
nativistik
natural
naturalistis
naturopatis
nautik
nautikal
necis
negatif
negativistik
nekat
nekat-nekat
nekrofagus
nelangsa
neofeodalistis
neositosis
neritik
neritopelagik
nestapa
neto
netral
neural
neuralgia
neurologis
neurotik
ngakngikngok
ngebet
ngeri
ngilu
nifak
nihil
nikmat
niraksara
nirgagasan
nirguna
nirkabel
nirlaba
nirleka
nirselera
nisbi
niskala
nista
nitrofili
nokturia
nokturnal
nominal
nonagresi
nonaktif
nonblok
nondepartemental
nonformal
nonhistoris
nonintervensi
nonkimia
nonkonvensional
nonkooperatif
nonmedis
nonmiliter
nonong
nonpatogenik
nonpredikatif
nonproduktif
nonsilabis
nonstandar
nonstop
nonteknis
nontradisional
nonverbal
norak
normal
normatif
nuklir
numerik
nurani
nuriah
nyalang
nyaman
nyamleng
nyanyar
nyanyuk
nyarik
nyaring
nyata
nyelekit
nyenyai
nyenyak
nyenyep
nyeri
nyinyir
nyonyong
objektif
oblak
obsesif
obsolet
odoh
ogah-ogahan
ogok
oklusif
oksiasetilena
oktal
okuler
okupasional
olahan
oligofagus
oligopolistis
oligotrofik
om swastiastu
oncer
ongahangih
onkogen
opalesen
operasional
operatif
oportunistis
opsional
optik
optimal
optimistis
optimum
optis
oratoris
ordinal
ordiner
organik
organis
organisatoris
orgasmik
oriental
orisinal
orisinalitas
ornamental
ornitologis
orografis
ortodoks
ortografis
ortopedis
osmoregulasi
otomatis
otomotif
otonom
otoriter
ovenan
pacak
pada
padam
padat
padi
padu
pagan
pagon
pahit
pailit
pajuh
pakem
palatal
paleografis
paleolitik
pales
paling-paling
palsu
pampat
panas
panas-panas
pandai
pandak
pandialektal
pandir
pangus
panik
panjang
pankromatis
pankronis
panlektal
pantas
panteistis
papa
papak
papar
paradigmatis
paradoksal
parah
parak
paralel
paralinguistis
paralitis
paramarta
paramiliter
paranoid
paranormal
paras
parataktis
parenial
parental
paripurna
parlementer
parokial
parsial
partikelir
partitif
pas
pas-pasan
pasai
pascabedah
pascadoktoral
pascakawin
pascakrisis
pascalahir
pascalarva
pascalikuidasi
pascamodern
pascamodernisme
pascaoperasi
pascapanen
pascaproduksi
pascareformasi
pascasarjana
pascausaha
pascayuwana
pasif
pasim
pasit
pasti
pastoral
patah
paternalistis
patetis
patih
patirasa
patogenik
patologis
patrilineal
patriotik
patuh
patut
payah
payau
pecak
pedagogis
pedar
pedih
pedis
pegah
pegal
pegan
pego
pejal
peka
pekak
pekak-pekak
pekat
pelah
pelak
pelan
pelekuk
pelengset
pelik
pelit
peloh
penahiran
penangis
penasaran
penat
pencong
pendaging
pendek
penengkar
pengang
pengap
pengar
pengeng
penggar
pengkal
pengkar
pengkol
pengkor
pengos
pening
penting
penuh
penuju
penyakitan
penyek
penyok
peok
peot
pepat
pepek
peraba
perbani
perca
percis
percuma
perdeo
pere
peredus
pereh
perencah
perenial
perenyuk
peres
perfek
perfektif
perifer
perifrastis
perigel
perih
pering
peringisan
periodik
perit
perivaskuler
perkasa
perlahan
perlahan-lahan
perlente
perlup
permai
permanen
permeabel
permisif
pernikel
peroi
peroneal
peronyok
perseptif
persis
personal
persuasif
perus
pesam
pesat
pesek
pesimistis
pesing
pesong
petah
peyot
piak
piat
piawai
pica, terpica
picik
pikun
pileh
pilu
pincang
pingai
pingul
pintar
pipih
piramidal
pirang
pirektik
pisah
pitam
planologis
plasmosis
plastis
platonik
pleno
plinplan
plontos
plural
pluralistis
plutonik
pluvial
pokah
polemis
poleng-poleng
poler
poligam
poliglot
polipetal
polisepal
polisiklis
polisional
politeistis
politis
polos
polutif
pondik
pongah
ponggok
populer
porak-parik
porak-peranda
porak-poranda
pornografis
portabel
posesif
positif
positivistik
potensial
pradini
pragmatik
pragmatis
praktis
pralahir
pramodern
pranikah
praremaja
prasejahtera
predikatif
preliminer
prenatal
presentabel
presidensial
preskriptif
prestisius
presto
preventif
prihatin
prima
primer
primitif
primordial
prinsipiil
privat
pro
pro forma
proaktif
prodemokrasi
prodeo
produktif
profan
profesional
profetik
profitabel
progresif
proksimal
prominen
promotif
pronominal
proporsional
prosais
prosedural
prosodis
prospektif
protektif
proteolitik
protokoler
protolitik
provisional
provokatif
prudensial
psikis
psikofisiologis
psikologis
psikomotor
psikomotorik
psikoseksual
psikosomatik
psikoteknis
puas
pucat
pudar
pudat
puitis
pujur
pukul rata
pulan
pulas
pulen
pulik
punah
punggal
pungguk
punjul
puntul
pupus
purba
purgatif
puristis
purnabakti
purnaintegrasi
purnajabatan
purnajual
purnakarya
purnama
purnapugar
purnasarjana
purnatugas
purnawaktu
purut
purwa
puso
puspas
raba-rubu
rabak
rabit
rabun
radial
radikal
radioaktif
radiotelegrafis
radu
rafi
ragam
ragawi
ragu
ragu-ragu
raharja
rahayu
rahim
rajabiah
rajin
raka
raksi
rakus
ramah
ramah tamah
rambang
rampak
rampang
ramping
rampus
ramus, beramus
rana
ranap
rancau
rancu
rancung
randat
randuk
rangah
ranggas
ranggung
rani
ranjing
rantas
ranum
rapat
rapi
rapuh
raras
rasial
rasional
rata
rata-rata
ratah
rawak
rawan
rawit
raya
rayang
rayu
reaksioner
reaktif
real
realistis
rebak
rebeh
rebes
recok
redaksional
redam
redam-redam
redefinisi
redep-redup
referensial
reflektif
regang
regional
reglementer
regresif
regulatif
reguler
rehabilitatif
rejeh
rekonstruktif
relai
relaks
relatif
relevan
reliabel
religius
remai
remaja
remanen
rematoid
rembah
rembah-rembah
rembang
rembet
remedial
remeh
remeh-cemeh
remeh-temeh
remis
remoh
rempak
remuk
renal
renceh
renceng
rendabel
rendah
renes
rengat
renggang
rengkah
rengsa
renik
renjul
rentan
renyah
renyam
renyang
renyap
renyem
repang
repas
repetitif
repih
repot
repot-repot
representatif
represif
reput
rerak
reras
resah
reseptif
residivistis
resik
resiprokal
resistan
resmi
responsif
restiformis
restriktif
retak
retas
retikuler
retorik
retroaktif
retrogresif
retrolingual
retromamal
retromandibuler
revolusioner
rewel
reyot
riak
riang
ribut
ricuh
rida
riil
rikuh
rimas
rimbun
rimpuh
rimpung
rincu
rindang
rinding
rindu
ringan
ringkai
ringkas
ringkih
ripuh
ripuk
risau
risi
riskan
ritmis
ritual
riuh
riuk
robak-rabik
robek
rocet
rodong
rohaniah
romantik
romantika
romantis
rombang-rambing
rombeng
rombik
rompang
rompeng
rompes
rompoh
rompong
rongak
ronggang
rongkoh
rongseng
rongsok
ronyok
ropak-rapik
royal
royal-royalan
rucah
rugi
ruhbaniat
ruit
rukun
rumbing
rumbu
rumit
rumpang
runcing
runcit
rungkuh
runjung
runyam
rupa-rupa
rusak
rusuh
ruwet
ruyung
ruyup
saban
sabar
sableng
sabun
sabur
sadak
sadar
sadik
sadis
sadistis
sado, sado masokis
safi
safih
sahih
sakelek
sakit
sakral
sakramental
sakratulmaut
sakrokoksigeal
sakrolumbal
saksama
sakti
salah
saleh
sali
salihah
sama
samad
samar
samar-samar
samawi
sambalewa
sampakan
sampilik
sangar
sangsi
saniter
santai
santun
santung
sapai
sarak
sarat
sareh
sarit-sarit
sarkastis
saru
sarut
sasar
sasau
sastrawi
satu-satunya
sauvinistis
sayang
sayangkan
sayu
sayung
sayup
sebaik
sebak
sebal
sebam
sebat
seberuntung-beruntungnya
sebu
sebun
secampin
secepat
secukup
sedaging
sedang
sedap
sedat
sedatar
sedeng
sederajat
sederhana
sedih
sedikit
sedimenter
sedondon
seelok
seenaknya
sega
segah
segan
segan-segan
segar
segmental
sehat
sehina
seimbang
seismik
sejahtera
sejat
sejati
sejibun
sejuk
sekakar
sekakmat
sekal
sekarat
sekecil
seketek
seketeng
seksi
seksual
sektarian
sektoral
sekuler
sekunder
sekutil
seladang
selamat
selebu
selektif
selengkap
selengkatan
selidik
selingkuh
selit
seloroh
seloyak
seluler
semacam
semampai
semampu
semanis
semantan
semantis
semarak
sembab
sembam
sembap
sembarang
sembarangan
sembelit
sember
sembiluan
sembrono
sememeh
semena
semenggah
semenjana
semerbak
semiang
semidiurnal
semifinal
seminau
semipermanen
semok
sempak
sempit
semplak
sempoyong, sempoyongan
sempurna
semrawut
semu
semudah
semujur
semujur-mujurnya
semuka
semut-semutan
sen-senan
senak
senang
sendat
sendeng
senderut
sendu
senewen
sengal
sengar
sengau
senget
senggang
sengir
sengit
sengsem
senguk
seni
senil
senior
senjang
senonoh
senoyong
sensasional
sensibel
sensitif
sensoris
sensual
senteng
sentimental
sentol
sentosa
sentralistis
sentrifugal
sentripetal
senuh
senyap
senyar
senyawa
sepadan (dng)
sepakat
sepan
sepandai-pandai
sepat
sepele
sepenuh
sepepak
seperuah
sepet
sepi
sepoi
sepusat
seput
serak
serak-serak
serakah
seram
serampangan
serasi
serat
serau
serbaada
serbabaru
serbabisa
serbadua
serbaemas
serbaguna
serbah-serbih
serbaindah
serbakeemasan
serbakurang
serbamacam
serbaneka
serbaputih
serbarumah
serbasalah
serbasama
serbasusah
serbausaha
serdih
serebral
serebrospinal
seregang
serembah-serembih
seremeh
seremonial
serempak
serendeng
serentak
sergam
sergut
seri
serial
serik
serindai
sering
serius
serkah
sernak
serobeh
seroma (dng)
serompok
serondok
serong
seronok
seroplastik
seroyong
seroyongan
serpih
seru
seruah
serudi
serui
serul
serunda
sesak
sesat
sesuai
sesuka
sesuka-suka
setebal
setegak
seteranah
seterpuruk
setia
setiawan
setimbal
setimbang
setimbangan
setimpal
setip
setori
setungging
seukur
seutuh
sewajar
sewingit
sewot
sewot-sewotan
sezarah
sfenoidal
sia-sia
siah
sial
sian
siang
siang-siang
siau
sibuk
sidi
sidik
sigap
signifikan
sigot
sikap
sikit
siklis
sikloid
silabis
silam
silap
silau
silindris
silir
silu
simbah
simbiotis
simbolis
simetris
simpatik
simpel
simpetal
simpleks
simplistis
simtomatis
simultan
sinematik
sinematografis
sinemikrografik
sinergis
singit
singkat
singkil
singset
sinis
sinkretis
sinkron
sinkronis
sinoptis
sinovia
sintagmatis
sintal
sintas
sintetik
sintetis
sinting
sinusal
sinusoid
sipi
sipil
sipit
sipu
sirik
sirna
sistaltik
sistematis
sistemis
sistolik
situasional
skematis
skeptis
skizoid
slebor
soak
sobek
solar
solid
solider
soliter
solven
somatis
sombong
sompek
sompong
songgeng
songong
sonik
sonor
sontak
sopan
sorangan
sosial
sosialistis
sosiokultural
sosiologis
sosionasional
soyak
spasial
spasmodis
spastik
spektakuler
spekulatif
spesial
spesialistis
spesifik
spiritual
spontan
sporadis
sportif
sregep
stabil
stagnan
stasioner
statis
statistis
statuter
stereofonik
stereotipikal
steril
steroidal
stimulatif
stokastik
stomatogastrik
strategis
struktural
suam
suam-suam
suang
subal
subjektif
subletal
submarine
subsider
subsonik
substandar
substansial
substitutif
subtil
subur
subversif
suci
suci hama
sudoriferus
sugul
suka
sukacita
sukar
sukarela
sukaria
sukses
suksesif
sulah
sulat-sulit
sulit
sultani
sumasi
sumbing
sumengit
sumir
sumpek
sundal
sungguh
sungkan
sungsang
sunyi
supel
super
supercepat
superfisial
superheterodin
superlatif
superlunar
supernatural
supersonik
suportif
supramolekuler
supranasional
supresif
suram
suram-suram
surati
surgawi
surup
surut
susah
susah hati
susah payah
susila
susuk
susut
suwir
suwir-suwir
swaharga
swasta
syahdu
syahriah
syamsiah
taala
taat
taat asas
tabah
tabelaris
tahan
tahir
tajam
tajur
takabur
takah-takahnya
takjub
taksa
taktil
taktis
takur
takut
takut-takutan
takzim
tamak
tambun
tambung
tampan
tampas
tandas
tandus
tangar
tanggap
tangguh
tanggung
tanggung-tanggung
tangkas
tanjak
tapis
tarah
tartir
tawaduk
tawar
tayib
tayibah
teatris
tebal
tedas
teduh
tega
tegak
tegak-tegak
tegang
tegap
tegar
tegas
teguh
teguk
tegun
teklok
teknis
teknokratik
tekor
tekstural
tektonis
tekun
tela
telak
telat
teledor
telegenik
telegrafis
teleng
teler
teliti
telut
temara
temaram
tematik
tembakul
tembam
tembelang
tembuk
temetu
temperamental
temporal
temporer
tenang
tenar
tenat
tendensius
tengik
tengil
tengkes
tentatif
tenteram
tentu
teokratis
teologis
teoretis
teosofis
tepa salira
tepas
tepat
tepercaya
tepermanai (tiada permana )
tepos
tepu
teradil
terakhir
terala
teralpa
teramai
terampil
terang
terang-terang, terang laras
teranja-anja
terapeutik
terbagus
terbaik
terbancut
terbanyak
terbaru
terbatas
terbawah
terbayan
terbeda-bedakan
terbelakang
terbenar
terbengang
terbesar
terbeti
tercantik
tercemas
tercondong
tercungap-cungap
terdahulu
terdekat
terdepan
terenak
terenyuh
terereng
tergesa-gesa
tergila-gila
tergopoh
tergulut
tergulut-gulut
terheran-heran
terhormat
terik
terindah
terindil
terinfeksi
terionisasi
terisolasi
teristimewa
teritorial
terjal
terjangkang
terjelak
terjumbai
terjungkat
terkaing-kaing
terkanan
terkaya
terkayai
terkebelakang
terkecai
terkeluh
terkemudian
terkemuka
terkokol
terkokol-kokol
terlaris
terlatih
terlayak
terleka
terlembut
terluang
terluluk
terlunta-lunta
terlut
termaestesia
termal
termala
termasyhur
termata-mata
termodern
termodinamis
termoelektris
termolabil
termonyong-monyong
termuda
termulia
ternista
terondol
terpana
terpegun
terpintar
terpuji
tersabar
tersedikit
tersenget
terserat
tersikut
tersilam
tersimpuh
tersirah
terteleng
terteleng-teleng
tertentu
tertib
tertimpang-timpang
tertinggi
teruk
terus
terutama
tetal
tiap
tiap-tiap
timbal
timbang
timpang
timpas
timpus
tinggi
tipis
tipologis
tiris
tirus
tituler
togel
tohor
tokcer
tokong
toleran
tolol
tonggek
tonggong
tongong
tonik
top
topografis
totaliter
totok
tradisional
tragis
trakeid
transenden
transendental
transformatif
transgenik
transitif
translusens
transnasional
transonik
transparan
traumatis
trendi
trifoliat
trigemius
trikuspid
tropis
tualang
tuding
tujul
tulen
tuli
tulus
tuman
tumpat
tumpul
tumpur
tunaaksara
tunabusana
tunadaksa
tunaganda
tunagizi
tunagrahita
tunakarya
tunalaras
tunanetra
tunapolitik
tunarungu
tunasosial
tunasusila
tunatenaga
tunawicara
tunawisma
tunggang
tunggik
tungkus
tuntas
tuntung
turbulen
turistik
tutung
ugal-ugalan
ultramikroskopiks
ultramodern
ulung
unggal
unggul
ungkal
uniform
unilateral
unilineal
unilinear
uniseluler
universal
universiter
untung-untungan
urban
urgen
urut
usilan
utama
utopis
vakum
valid
vandalistis
variabel
variatif
vasal
vaskular
vasomotor
vegetaris
velar
venal
verbal
verbalistis
verbatim
verstek
vertikal
veteriner
viabel
virilis
virtual
virulen
visibel
visual
vital
vokal
vokasional
volatil
vulgar
vulkanis
wadak
wagu
wajar
walang
wangi
warak
waras
waris
waskita
waspada
waswas
waterpruf
westernis
wigata
wingit
witir
wosi
wreda
wulung
wungu
xerosis
xifoid
xiloid
yahud
yakin
yatim
yogia
yudikatif
yudisial
yuridis
yuvenil
yuwana
zakelek
zalim
zimotik
