#!/usr/bin/env perl6
use v6;

use Test;
use DOM::Tiny;

# Unicode and escaped selectors
my $html
  = '<html><div id="☃x">Snowman</div><div class="x ♥">Heart</div></html>';
my $dom = DOM::Tiny.parse($html);
is $dom.at("#\\\n\\002603x").text,                  'Snowman', 'right text';
is $dom.at('#\\2603 x').text,                       'Snowman', 'right text';
is $dom.at("#\\\n\\2603 x").text,                   'Snowman', 'right text';
is $dom.at(qq{[id="\\\n\\2603 x"]}).text,           'Snowman', 'right text';
is $dom.at(qq{[id="\\\n\\002603x"]}).text,          'Snowman', 'right text';
is $dom.at(qq{[id="\\\\2603 x"]}).text,             'Snowman', 'right text';
is $dom.at("html #\\\n\\002603x").text,             'Snowman', 'right text';
is $dom.at('html #\\2603 x').text,                  'Snowman', 'right text';
is $dom.at("html #\\\n\\2603 x").text,              'Snowman', 'right text';
is $dom.at(qq{html [id="\\\n\\2603 x"]}).text,      'Snowman', 'right text';
is $dom.at(qq{html [id="\\\n\\002603x"]}).text,     'Snowman', 'right text';
is $dom.at(qq{html [id="\\\\2603 x"]}).text,        'Snowman', 'right text';
is $dom.at('#☃x').text,                           'Snowman', 'right text';
is $dom.at('div#☃x').text,                        'Snowman', 'right text';
is $dom.at('html div#☃x').text,                   'Snowman', 'right text';
is $dom.at('[id^="☃"]').text,                     'Snowman', 'right text';
is $dom.at('div[id^="☃"]').text,                  'Snowman', 'right text';
is $dom.at('html div[id^="☃"]').text,             'Snowman', 'right text';
is $dom.at('html > div[id^="☃"]').text,           'Snowman', 'right text';
is $dom.at('[id^=☃]').text,                       'Snowman', 'right text';
is $dom.at('div[id^=☃]').text,                    'Snowman', 'right text';
is $dom.at('html div[id^=☃]').text,               'Snowman', 'right text';
is $dom.at('html > div[id^=☃]').text,             'Snowman', 'right text';
is $dom.at(".\\\n\\002665").text,                   'Heart',   'right text';
is $dom.at('.\\2665').text,                         'Heart',   'right text';
is $dom.at("html .\\\n\\002665").text,              'Heart',   'right text';
is $dom.at('html .\\2665').text,                    'Heart',   'right text';
is $dom.at(qq{html [class\$="\\\n\\002665"]}).text, 'Heart',   'right text';
is $dom.at(qq{html [class\$="\\2665"]}).text,       'Heart',   'right text';
is $dom.at(qq{[class\$="\\\n\\002665"]}).text,      'Heart',   'right text';
is $dom.at(qq{[class\$="\\2665"]}).text,            'Heart',   'right text';
is $dom.at('.x').text,                              'Heart',   'right text';
is $dom.at('html .x').text,                         'Heart',   'right text';
is $dom.at('.♥').text,                            'Heart',   'right text';
is $dom.at('html .♥').text,                       'Heart',   'right text';
is $dom.at('div.♥').text,                         'Heart',   'right text';
is $dom.at('html div.♥').text,                    'Heart',   'right text';
is $dom.at('[class$="♥"]').text,                  'Heart',   'right text';
is $dom.at('div[class$="♥"]').text,               'Heart',   'right text';
is $dom.at('html div[class$="♥"]').text,          'Heart',   'right text';
is $dom.at('html > div[class$="♥"]').text,        'Heart',   'right text';
is $dom.at('[class$=♥]').text,                    'Heart',   'right text';
is $dom.at('div[class$=♥]').text,                 'Heart',   'right text';
is $dom.at('html div[class$=♥]').text,            'Heart',   'right text';
is $dom.at('html > div[class$=♥]').text,          'Heart',   'right text';
is $dom.at('[class~="♥"]').text,                  'Heart',   'right text';
is $dom.at('div[class~="♥"]').text,               'Heart',   'right text';
is $dom.at('html div[class~="♥"]').text,          'Heart',   'right text';
is $dom.at('html > div[class~="♥"]').text,        'Heart',   'right text';
is $dom.at('[class~=♥]').text,                    'Heart',   'right text';
is $dom.at('div[class~=♥]').text,                 'Heart',   'right text';
is $dom.at('html div[class~=♥]').text,            'Heart',   'right text';
is $dom.at('html > div[class~=♥]').text,          'Heart',   'right text';
is $dom.at('[class~="x"]').text,                    'Heart',   'right text';
is $dom.at('div[class~="x"]').text,                 'Heart',   'right text';
is $dom.at('html div[class~="x"]').text,            'Heart',   'right text';
is $dom.at('html > div[class~="x"]').text,          'Heart',   'right text';
is $dom.at('[class~=x]').text,                      'Heart',   'right text';
is $dom.at('div[class~=x]').text,                   'Heart',   'right text';
is $dom.at('html div[class~=x]').text,              'Heart',   'right text';
is $dom.at('html > div[class~=x]').text,            'Heart',   'right text';
is $dom.at('html'), $html, 'right result';
is $dom.at('#☃x').parent,     $html, 'right result';
is $dom.at('#☃x').root,       $html, 'right result';
is $dom.children('html').first, $html, 'right result';
is $dom.Str, $html, 'right result';
is $dom.content,   $html, 'right result';

done-testing;
