# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130802;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"432848", "Pfaffenschlag\ bei\ Waidhofen",
"435578", "Höchst",
"434232", "Völkermarkt",
"436467", "Mühlbach\ am\ Hochkönig",
"432635", "Neunkirchen",
"434279", "Sirnitz",
"432627", "Pitten",
"432575", "Ladendorf",
"432825", "Göpfritz\ an\ der\ Wild",
"432732", "Krems\ an\ der\ Donau",
"433115", "Studenzen",
"435236", "Gries\ im\ Sellrain",
"436417", "Hüttschlag",
"436456", "Obertauern",
"433845", "Mautern\ in\ Steiermark",
"433461", "Trahütten",
"432168", "Mannersdorf\ am\ Leithagebirge",
"437434", "Haag",
"436476", "St\.\ Margarethen\ im\ Lungau",
"43662", "Salzburg",
"437665", "Unterach\ am\ Attersee",
"432682", "Eisenstadt",
"433638", "Palfau",
"437712", "Schärding",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"432555", "Herrnbaumgarten",
"434285", "Tröpolach",
"432954", "Göllersdorf",
"437615", "Scharnstein",
"433578", "Obdach",
"437762", "Raab",
"437281", "Aigen\ im\ Mühlkreis",
"435558", "Gaschurn",
"433613", "Admont",
"432824", "Allentsteig",
"434277", "Glanegg",
"432629", "Warth\,\ Lower\ Austria",
"432574", "Gaweinstal",
"433114", "Markt\ Hartmannsdorf",
"436246", "Grödig",
"433150", "Paldau",
"432283", "Angern\ an\ der\ March",
"437482", "Scheibbs",
"434783", "Reisseck",
"432872", "Ottenschlag",
"432522", "Laa\ an\ der\ Thaya",
"433333", "Sebersdorf",
"437736", "Pram",
"432841", "Vitis",
"435418", "Schönwies",
"432634", "Gutenstein",
"437614", "Vorchdorf",
"432852", "Gmünd",
"432784", "Perschling",
"437288", "Ulrichsberg",
"432716", "Gföhl",
"432757", "Pöchlarn",
"432989", "Brunn\ an\ der\ Wild",
"435333", "Söll",
"435212", "Seefeld\ in\ Tirol",
"436566", "Bramberg\ am\ Wildkogel",
"434266", "Strassburg",
"433571", "Möderbrugg",
"433844", "Kammern\ im\ Liesingtal",
"434823", "Tresdorf\,\ Rangersdorf",
"432766", "Kleinzell",
"433631", "Unterlaussa",
"437664", "Weyregg\ am\ Attersee",
"433170", "Fischbach",
"437435", "St\.\ Valentin",
"434257", "Fürnitz",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432554", "Stützenhofen",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"43316", "Graz",
"435262", "Telfs",
"432955", "Grossweikersdorf",
"434284", "Kirchbach",
"437672", "Vöcklabruck",
"437480", "Langau\,\ Gaming",
"434226", "St\.\ Margareten\ im\ Rosental",
"433861", "Aflenz",
"435583", "Lech",
"435274", "Gries\ am\ Brenner",
"434847", "Obertilliach",
"437443", "Ybbsitz",
"432144", "Deutsch\ Jahrndorf",
"432242", "St\.\ Andrä\-Wördern",
"432271", "Ried\ am\ Riederberg",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"433152", "Feldbach",
"432726", "Puchenstuben",
"43512", "Innsbruck",
"437755", "Mettmach",
"433141", "Hirschegg",
"433172", "Weiz",
"432864", "Kautzen",
"435254", "Sölden",
"435445", "Kappl",
"433583", "Unzmarkt",
"435287", "Tux",
"437476", "Aschbach\-Markt",
"436434", "Bad\ Gastein",
"433328", "Kukmirn",
"432814", "Langschlag",
"432619", "Lackendorf",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"433124", "Gratkorn",
"433623", "Bad\ Mitterndorf",
"436131", "Obertraun",
"432278", "Absdorf",
"437722", "Braunau\ am\ Inn",
"432536", "Drösing",
"435275", "Trins",
"434230", "Globasnitz",
"433833", "Traboch",
"433868", "Tragöss",
"432145", "Prellenkirchen",
"437246", "Gunskirchen",
"437253", "Wolfern",
"435255", "Umhausen",
"435444", "Ischgl",
"432667", "Schwarzau\ im\ Gebirge",
"437273", "Aschach\ an\ der\ Donau",
"432815", "Grossschönau",
"437584", "Molln",
"433137", "Söding",
"433125", "Übelbach",
"437754", "Waldzell",
"432258", "Alland",
"432617", "Drassmarkt",
"432912", "Geras",
"432643", "Lichtenegg",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"435289", "Häusling",
"433148", "Kainach\ bei\ Voitsberg",
"437566", "Rosenau\ am\ Hengstpass",
"432865", "Litschau",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432237", "Gaaden",
"435245", "Hinterriss",
"437276", "Peuerbach",
"436234", "Zell\ am\ Moos",
"432175", "Apetlon",
"433474", "Deutsch\ Goritz",
"437744", "Munderfing",
"433354", "Bernstein",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"437949", "Rainbach\ im\ Mühlkreis",
"433387", "Söchau",
"432248", "Markgrafneusiedl",
"433158", "St\.\ Anna\ am\ Aigen",
"437563", "Spital\ am\ Pyhrn",
"436229", "Hof\ bei\ Salzburg",
"436132", "Bad\ Ischl",
"435374", "Walchsee",
"434879", "St\.\ Veit\ in\ Defereggen",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435354", "Fieberbrunn",
"437267", "Mönchdorf",
"433460", "Soboth",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432533", "Neusiedl\ an\ der\ Zaya",
"435515", "Au",
"433322", "Güssing",
"433454", "Leutschach",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"435474", "Pfunds",
"437256", "Ternberg",
"437243", "Marchtrenk",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"437745", "Lochen",
"433151", "Gnas",
"433355", "Stadtschlaining",
"435375", "Kössen",
"432272", "Tulln\ an\ der\ Donau",
"432239", "Breitenfurt\ bei\ Wien",
"437353", "Gaflenz",
"434877", "Prägraten\ am\ Grossvenediger",
"433514", "Seckau",
"435244", "Jenbach",
"432174", "Wallern\ im\ Burgenland",
"436235", "Thalgau",
"436227", "St\.\ Gilgen",
"437473", "Blindenmarkt",
"433586", "Mühlen",
"437728", "Schwand\ im\ Innkreis",
"437947", "Kefermarkt",
"433475", "Hürth",
"433862", "Bruck\ an\ der\ Mur",
"435514", "Bezau",
"434223", "Maria\ Saal",
"433455", "Arnfels",
"437269", "Baumgartenberg",
"435550", "Thüringen",
"435475", "Feichten",
"432252", "Baden",
"437219", "Vorderweissenbach",
"435355", "Jochberg",
"432160", "Jois",
"433171", "Gasen",
"433142", "Voitsberg",
"432723", "Rabenstein\ an\ der\ Pielach",
"435572", "Dornbirn",
"432842", "Waidhofen\ an\ der\ Thaya",
"432747", "Ober\-Grafendorf",
"437683", "Frankenburg\ am\ Hausruck",
"432713", "Spitz",
"436563", "Uttendorf",
"437229", "Traun",
"433685", "Gröbming",
"435336", "Alpbach",
"434263", "Hüttenberg",
"434238", "Eisenkappel\-Vellach",
"434826", "Mörtschach",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"433854", "Langenwang",
"432738", "Fels\ am\ Wagram",
"436276", "Nussdorf\ am\ Haunsberg",
"437234", "Ottensheim",
"434247", "Afritz",
"435524", "Satteins",
"434213", "Launsdorf",
"435632", "Stanzach",
"436547", "Kaprun",
"432945", "Zellerndorf",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"432162", "Bruck\ an\ der\ Leitha",
"434359", "Reichenfels",
"432214", "Kopfstetten",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433632", "St\.\ Gallen",
"432286", "Obersiebenbrunn",
"437718", "Waldkirchen\ am\ Wesen",
"436243", "Abtenau",
"432688", "Steinbrunn",
"436217", "Mattsee",
"433572", "Judenburg",
"434714", "Dellach\ im\ Drautal",
"435552", "Bludenz",
"437733", "Neumarkt\ im\ Hausruckkreis",
"433336", "Waldbach",
"432264", "Rückersdorf\,\ Harmannsdorf",
"433855", "Krieglach",
"437235", "Gallneukirchen",
"437227", "Neuhofen\ an\ der\ Krems",
"436473", "Mariapfarr",
"432749", "Prinzersdorf",
"435525", "Nenzing",
"432731", "Idolsberg",
"432944", "Haugsdorf",
"436549", "Piesendorf",
"435677", "Vils",
"437488", "Steinakirchen\ am\ Forst",
"434231", "Mittertrixen",
"435412", "Imst",
"433684", "St\.\ Martin\ am\ Grimming",
"433362", "Grosspetersdorf",
"433616", "Selzthal",
"432878", "Traunstein",
"437282", "Neufelden",
"436219", "Obertrum\ am\ See",
"432858", "Moorbad\ Harbach",
"434715", "Kötschach\-Mauthen",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432265", "Hausleiten",
"4316", "Vienna",
"437711", "Suben",
"433537", "St\.\ Georgen\ ob\ Murau",
"432215", "Probstdorf",
"433462", "Deutschlandsberg",
"436453", "Filzmoos",
"434354", "Preitenegg",
"437723", "Altheim",
"433326", "Stegersbach",
"437478", "Oed\-Oehling",
"434769", "Möllbrücke",
"433832", "Kraubath\ an\ der\ Mur",
"437252", "Steyr",
"436483", "Göriach",
"433534", "Stadl\ an\ der\ Mur",
"433622", "Bad\ Aussee",
"436215", "Strasswalchen",
"432269", "Niederfellabrunn",
"434245", "Feistritz\ an\ der\ Drau",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432947", "Theras",
"432913", "Hötzelsdorf",
"432642", "Aspangberg\-St\.\ Peter",
"436136", "Gosau",
"432728", "Wienerbruck",
"437224", "St\.\ Florian",
"433885", "Greith",
"437239", "Lichtenberg",
"437241", "Steinerkirchen\ an\ der\ Traun",
"433687", "Schladming",
"437272", "Eferding",
"433859", "Mürzsteg",
"434228", "Feistritz\ im\ Rosental",
"432745", "Pyhra",
"435674", "Bichlbach",
"432243", "Klosterneuburg",
"432256", "Leobersdorf",
"435223", "Hall\ in\ Tirol",
"433535", "Krakaudorf",
"436214", "Henndorf\ am\ Wallersee",
"434767", "Rothenthurn",
"4318", "Vienna",
"433153", "Riegersburg",
"433146", "Modriach",
"437673", "Schwanenstadt",
"434355", "Gemmersdorf",
"432267", "Sierndorf",
"435582", "Klösterle",
"437471", "Neustadtl\ an\ der\ Donau",
"434717", "Steinfeld",
"437442", "Waidhofen\ an\ der\ Ybbs",
"433582", "Scheifling",
"432538", "Velm\-Götzendorf",
"432949", "Niederfladnitz",
"437248", "Grieskirchen",
"432744", "Kasten\ bei\ Böheimkirchen",
"435675", "Tannheim",
"434221", "Gallizien",
"433866", "Breitenau\ am\ Hochlantsch",
"434244", "Bad\ Bleiberg",
"436544", "Rauris",
"433173", "Ratten",
"432276", "Reidling",
"433857", "Neuberg\ an\ der\ Mürz",
"437225", "Hargelsberg",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"433884", "Wegscheid",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437483", "Oberndorf\ an\ der\ Melk",
"433576", "Bretstein",
"434782", "Obervellach",
"435359", "Hochfilzen",
"437215", "Hellmonsödt",
"435517", "Riezlern",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"432873", "Kottes",
"432711", "Dürnstein",
"433332", "Hartberg",
"435556", "Schruns",
"437265", "Pabneukirchen",
"432166", "Parndorf",
"436478", "Zederhaus",
"432282", "Gänserndorf",
"433636", "Wildalpen",
"436241", "St\.\ Koloman",
"434822", "Winklern",
"434735", "Kremsbrücke",
"436272", "Oberndorf\ bei\ Salzburg",
"436458", "Hüttau",
"435238", "Zirl",
"435263", "Silz",
"433385", "Ilz",
"432846", "Raabs\ an\ der\ Thaya",
"437944", "Sandl",
"432853", "Schrems",
"435576", "Hohenems",
"433359", "Loipersdorf\-Kitzladen",
"435332", "Wörgl",
"435213", "Scharnitz",
"434874", "Virgen",
"432235", "Maria\-Lanzendorf",
"432177", "Podersdorf\ am\ See",
"436224", "Hintersee",
"437264", "Windhaag\ bei\ Perg",
"435519", "Schröcken",
"432733", "Schönberg\ am\ Kamp",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"4313", "Vienna",
"435357", "Kirchberg\ in\ Tirol",
"436471", "Tweng",
"433466", "Eibiswald",
"432718", "Lichtenau\ im\ Waldviertel",
"434855", "Assling",
"437286", "Lembach\ im\ Mühlkreis",
"435477", "Tösens",
"437214", "Reichenthal",
"434233", "Griffen",
"434268", "Friesach",
"433457", "Gleinstätten",
"437250", "Maria\ Neustift",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432234", "Gramatneusiedl",
"434875", "Matrei\ in\ Osttirol",
"4314", "Vienna",
"436225", "Eugendorf",
"437763", "Kopfing\ im\ Innkreis",
"433366", "Kohfidisch",
"433612", "Liezen",
"434734", "Rennweg",
"432683", "Purbach\ am\ Neusiedler\ See",
"437747", "Kirchberg\ bei\ Mattighofen",
"437713", "Schardenberg",
"433357", "Pinkafeld",
"437955", "Königswiesen",
"437587", "Wartberg\ an\ der\ Krems",
"433134", "Heiligenkreuz\ am\ Waasen",
"435447", "Flirsch",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"432664", "Semmering",
"435285", "Mayrhofen",
"433363", "Rechnitz",
"437766", "Andorf",
"433338", "Lafnitz",
"436472", "Mauterndorf",
"437716", "Münzkirchen",
"432288", "Auersthal",
"437757", "Gurten",
"432686", "Drassburg",
"432614", "Kleinwarasdorf",
"436278", "Ostermiething",
"432736", "Paudorf",
"435232", "Kematen\ in\ Tirol",
"436452", "Radstadt",
"433463", "Stainz",
"435279", "St\.\ Jodok\ am\ Brenner",
"433611", "Johnsbach",
"437283", "Sarleinsbach",
"437415", "Altenmarkt\,\ Yspertal",
"434236", "Eberndorf",
"437240", "Sipbachzell",
"435338", "Kundl",
"432762", "Lilienfeld",
"435449", "Fliess",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432615", "Lutzmannsburg",
"435633", "Hägerau",
"435266", "Ötztal\-Bahnhof",
"435573", "Hörbranz",
"432856", "Weitra",
"432843", "Dobersberg",
"437954", "St\.\ Georgen\ am\ Walde",
"433127", "Peggau",
"437682", "Vöcklamarkt",
"433135", "Kalsdorf\ bei\ Graz",
"432712", "Aggsbach",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"437759", "Antiesenhofen",
"436562", "Mittersill",
"432665", "Prein\ an\ der\ Rax",
"4312", "Vienna",
"434262", "Treibach",
"435284", "Gerlos",
"433573", "Fohnsdorf",
"434220", "Köttmannsdorf",
"437486", "Lunz\ am\ See",
"437414", "Weins\-Isperdorf",
"435331", "Brandenberg",
"432147", "Zurndorf",
"433618", "Hohentauern",
"435553", "Raggal",
"437732", "Haag\ am\ Hausruck",
"432526", "Stronsdorf",
"432876", "Els",
"433182", "Wildon",
"432163", "Petronell\-Carnuntum",
"433633", "Landl",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437472", "Amstetten",
"437617", "Traunkirchen",
"437258", "Bad\ Hall",
"432959", "Sitzendorf\ an\ der\ Schmida",
"433863", "Turnau",
"432754", "Loosdorf",
"432985", "Gars\ am\ Kamp",
"43732", "Linz",
"434254", "Faak\ am\ See",
"432557", "Bernhardsthal",
"433176", "Stubenberg",
"433847", "Trofaiach",
"432273", "Tulbing",
"437667", "St\.\ Georgen\ im\ Attergau",
"432648", "Hochneukirchen",
"435226", "Neustift\ im\ Stubaital",
"432253", "Oberwaltersdorf",
"432246", "Gerasdorf\ bei\ Wien",
"436415", "Schwarzach\ im\ Pongau",
"434274", "Velden\ am\ Wörther\ See",
"432577", "Asparn\ an\ der\ Zaya",
"432827", "Schönbach",
"433143", "Krottendorf",
"432722", "Kirchberg\ an\ der\ Pielach",
"436240", "Krispl",
"433117", "Eggersdorf\ bei\ Graz",
"437278", "Neukirchen\ am\ Walde",
"437676", "Ottnang\ am\ Hausruck",
"432625", "Bad\ Sauerbrunn",
"432774", "Innermanzing",
"432637", "Grünbach\ am\ Schneeberg",
"433581", "Oberwölz",
"434255", "Arnoldstein",
"432984", "Eggenburg",
"437619", "Kirchham",
"436470", "Atzmannsdorf",
"432916", "Riegersburg\,\ Hardegg",
"432957", "Hohenwarth",
"437562", "Windischgarsten",
"436133", "Ebensee",
"437251", "Schiedlberg",
"433849", "Vordernberg",
"437448", "Kematen\ an\ der\ Ybbs",
"436589", "Unken",
"432755", "Mank",
"432532", "Zistersdorf",
"433323", "Eberau",
"433588", "Katsch\ an\ der\ Mur",
"433119", "St\.\ Marein\ bei\ Graz",
"432829", "Schweiggers",
"432624", "Ebenfurth",
"437242", "Wels",
"436414", "Grossarl",
"432641", "Kirchberg\ am\ Wechsel",
"435230", "Sellrain",
"434275", "Ebene\ Reichenau",
"432639", "Bad\ Fischau",
"432672", "Berndorf",
"436541", "Saalbach",
"434272", "Pörtschach\ am\ Wörther\ See",
"437228", "Kematen\ an\ der\ Krems",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432741", "Flinsbach",
"435513", "Hittisau",
"432877", "Grainbrunn",
"432739", "Tiefenfucha",
"432527", "Wulzeshofen",
"434224", "Pischeldorf",
"432535", "Hohenau\ an\ der\ March",
"432772", "Neulengbach",
"435276", "Gschnitz",
"435678", "Weissenbach\ am\ Lech",
"437487", "Gresten",
"432146", "Nickelsdorf",
"437245", "Lambach",
"435243", "Maurach",
"435256", "Untergurgl",
"433513", "Bischoffeld",
"434358", "St\.\ Andrä",
"432173", "Gols",
"437474", "Euratsfeld",
"432816", "Karlstift",
"432857", "Bad\ Grosspertholz",
"432752", "Melk",
"437719", "Taufkirchen\ an\ der\ Pram",
"433126", "Frohnleiten",
"432689", "Hornstein",
"435280", "Hochfügen",
"434252", "Wernberg",
"437565", "St\.\ Pankraz",
"436462", "Bischofshofen",
"433453", "Ehrenhausen",
"432534", "Niedersulz",
"434237", "Miklauzhof",
"434225", "Grafenstein",
"432622", "Wiener\ Neustadt",
"432748", "Kilb",
"435473", "Nauders",
"437244", "Sattledt",
"435353", "Waidring",
"437221", "Hörsching",
"436548", "Niedernsill",
"434248", "Treffen",
"436412", "St\.\ Johann\ im\ Pongau",
"437489", "Purgstall\ an\ der\ Erlauf",
"432674", "Weissenbach\ an\ der\ Triesting",
"432725", "Frankenfels",
"437717", "St\.\ Aegidi",
"432982", "Horn",
"433353", "Oberschützen",
"432687", "Siegendorf",
"437743", "Maria\ Schmolln",
"432859", "Brand\-Nagelberg",
"435373", "Ebbs",
"437564", "Hinterstoder",
"437355", "Weyer",
"432610", "Horitschon",
"435446", "St\.\ Anton\ am\ Arlberg",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437767", "Eggerding",
"436233", "Oberwang",
"433473", "Straden",
"437586", "Pettenbach",
"433185", "Preding",
"435234", "Axams",
"436454", "Mandling",
"436245", "Hallein",
"437948", "Hirschbach\ im\ Mühlkreis",
"432620", "Willendorf",
"432231", "Purkersdorf",
"432249", "Gross\-Enzersdorf",
"433159", "Bad\ Gleichenberg",
"436228", "Faistenau",
"437735", "Gaspoltshofen",
"437727", "Ach",
"433179", "Passail",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"434858", "Nikolsdorf",
"433132", "Kumberg",
"433683", "Donnersbach",
"432662", "Gloggnitz",
"436565", "Neukirchen\ am\ Grossvenediger",
"437211", "Reichenau\ im\ Mühlkreis",
"434265", "Weitensfeld\ im\ Gurktal",
"432765", "Kaumberg",
"436474", "Tamsweg",
"434215", "Liebenfels",
"437261", "Schönau\ im\ Mühlkreis",
"432943", "Obritz",
"432956", "Ziersdorf",
"432612", "Oberpullendorf",
"436221", "Koppl",
"434842", "Sillian",
"434713", "Techendorf",
"437412", "Ybbs\ an\ der\ Donau",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437941", "Neumarkt\ im\ Mühlkreis",
"432238", "Kaltenleutgeben",
"432636", "Puchberg\ am\ Schneeberg",
"432263", "Grossrussbach",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432576", "Ernstbrunn",
"432826", "Rastenfeld",
"433157", "Kapfenstein",
"437729", "Neukirchen\ an\ der\ Enknach",
"433116", "Kirchbach\ in\ Steiermark",
"432213", "Lassee",
"432247", "Deutsch\-Wagram",
"436455", "Untertauern",
"436244", "Golling\ an\ der\ Salzach",
"433853", "Spital\ am\ Semmering",
"433846", "Kalwang",
"432764", "Hainfeld",
"437268", "Grein",
"436475", "Ramingstein",
"437666", "Attersee",
"437233", "Feldkirchen\ an\ der\ Donau",
"434214", "Brückl",
"435523", "Götzis",
"432556", "Grosskrut",
"433177", "Puch\ bei\ Weiz",
"434286", "Weissbriach",
"437616", "Grünau\ im\ Almtal",
"437952", "Weitersfelden",
"432786", "Oberwölbling",
"437218", "Grosstraberg",
"432714", "Rossatz",
"437684", "Frankenmarkt",
"436564", "Krimml",
"434264", "Klein\ St\.\ Paul",
"435282", "Zell\ am\ Ziller",
"432277", "Zwentendorf",
"434824", "Heiligenblut",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"434240", "Bad\ Kleinkirchheim",
"433856", "Veitsch",
"437236", "Pregarten",
"437663", "Steinbach\ am\ Attersee",
"436274", "Lamprechtshausen",
"436583", "Leogang",
"435526", "Laterns",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432783", "Traismauer",
"437613", "Laakirchen",
"437942", "Freistadt",
"433867", "Pernegg\ an\ der\ Mur",
"435334", "Westendorf",
"434872", "Huben",
"433615", "Trieben",
"434784", "Mallnitz",
"434852", "Lienz",
"434716", "Lesachtal",
"433334", "Kaindorf",
"432633", "Markt\ Piesting",
"432266", "Stockerau",
"432823", "Grossglobnitz",
"432573", "Wilfersdorf",
"434766", "Millstatt",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"433147", "Salla",
"433329", "Jennersdorf",
"432257", "Klausen\-Leopoldsdorf",
"432618", "Markt\ St\.\ Martin",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"432284", "Oberweiden",
"434848", "Kartitsch",
"432232", "Fischamend",
"433686", "Haus",
"435335", "Hopfgarten\ im\ Brixental",
"433614", "Rottenmann",
"432279", "Kirchberg\ am\ Wagram",
"436137", "Strobl",
"434825", "Grosskirchheim",
"437433", "Wallsee",
"434732", "Gmünd\ in\ Kärnten",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"433382", "Fürstenfeld",
"432953", "Nappersdorf",
"432946", "Pulkau",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437262", "Perg",
"432285", "Marchegg",
"434785", "Ausserfragant",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432259", "Münchendorf",
"437212", "Zwettl\ an\ der\ Rodl",
"435288", "Fügen",
"433149", "Geistthal",
"433335", "Pöllau",
"433327", "St\.\ Michael\ im\ Burgenland",
"437746", "Friedburg",
"437753", "Eberschwang",
"433356", "Markt\ Allhau",
"432644", "Grimmenstein",
"432849", "Schwarzenau",
"435579", "Alberschwende",
"435376", "Thiersee",
"434278", "Gnesau",
"435417", "Roppen",
"435443", "Galtür",
"437274", "Alkoven",
"433585", "St\.\ Lambrecht",
"437583", "Kremsmünster",
"432230", "Schwadorf",
"433476", "Bad\ Radkersburg",
"432621", "Sieggraben",
"435672", "Reutte",
"436461", "Dienten\ am\ Hochkönig",
"434352", "Wolfsberg",
"433456", "Fresing",
"4319", "Vienna",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"435585", "Dalaas",
"437287", "Peilstein\ im\ Mühlviertel",
"433834", "Wald\ am\ Schoberpass",
"432758", "Pöggstall",
"435476", "Serfaus",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437254", "Grossraming",
"433532", "Murau",
"435356", "Kitzbühel",
"437260", "Waldhausen",
"433579", "Pöls",
"433624", "Pichl\-Kainisch",
"433467", "Schwanberg",
"434258", "Gummern",
"435559", "Brand",
"433516", "Kleinlobming",
"435253", "Längenfeld",
"432628", "Felixdorf",
"435246", "Achenkirch",
"436433", "Dorfgastein",
"432176", "Tadten",
"436468", "Werfen",
"433584", "Neumarkt\ in\ Steiermark",
"432847", "Gross\-Siegharts",
"435577", "Lustenau",
"432813", "Arbesbach",
"432742", "St\.\ Pölten",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"436418", "Kleinarl",
"434242", "Villach",
"432645", "Wiesmath",
"434271", "Steuerberg",
"436542", "Zell\ am\ See",
"433882", "Mariazell",
"432863", "Eggern",
"437289", "Rohrbach\ in\ Oberösterreich",
"436212", "Seekirchen\ am\ Wallersee",
"433637", "Gams\ bei\ Hieflau",
"432988", "Neupölla",
"432167", "Neusiedl\ am\ See",
"4315", "Vienna",
"435516", "Doren",
"435557", "St\.\ Gallenkirch",
"433577", "Zeltweg",
"433469", "St\.\ Oswald\ im\ Freiland",
"435273", "Matrei\ am\ Brenner",
"437444", "Opponitz",
"437255", "Losenstein",
"432143", "Kittsee",
"432164", "Rohrau",
"434762", "Spittal\ an\ der\ Drau",
"4317", "Vienna",
"432212", "Orth\ an\ der\ Donau",
"437259", "Sierning",
"432958", "Maissau",
"433634", "Hieflau",
"433465", "Pölfing\-Brunn",
"434843", "Ausservillgraten",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433574", "Pusterwald",
"435510", "Damüls",
"434712", "Greifenburg",
"437413", "Marbach\ an\ der\ Donau",
"435554", "Sonntag",
"432262", "Korneuburg",
"437946", "Gutau",
"432844", "Karlstein\ an\ der\ Thaya",
"437953", "Liebenau",
"432649", "Mönichkirchen",
"432631", "Pöttsching",
"435574", "Bregenz",
"434876", "Kals\ am\ Grossglockner",
"436226", "Fuschl\ am\ See",
"433587", "Schönberg\-Lachtal",
"433365", "Deutsch\ Schützen\-Eisenberg",
"435283", "Kaltenbach",
"437279", "Haibach\ ob\ der\ Donau",
"433852", "Mürzzuschlag",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"435522", "Feldkirch",
"435634", "Elbigenalp",
"437284", "Oberkappel",
"433575", "St\.\ Johann\ am\ Tauern",
"437618", "Neukirchen\,\ Altmünster",
"437257", "Grünburg",
"437216", "Helfenberg",
"437266", "Bad\ Kreuzen",
"432165", "Hainburg\ a\.d\.\ Donau",
"432951", "Guntersdorf",
"433848", "Eisenerz",
"4346", "Klagenfurt",
"436588", "Lofer",
"433464", "Gross\ St\.\ Florian",
"433635", "Radmer",
"433118", "Sinabelkirchen",
"434736", "Innerkrems",
"432828", "Rappottenstein",
"432647", "Krumbach\,\ Lower\ Austria",
"435635", "Elmen",
"432942", "Retz",
"432613", "Deutschkreutz",
"433386", "Grosssteinbach",
"432845", "Weikertschlag\ an\ der\ Thaya",
"435575", "Langen\ bei\ Bregenz",
"433133", "Nestelbach",
"432663", "Schottwien",
"432236", "Mödling",
"435414", "Wenns",
"433682", "Stainach",
"432638", "Winzendorf\-Muthmannsdorf",
"437277", "Waizenkirchen",
"433364", "Hannersdorf",
"435352", "St\.\ Johann\ in\ Tirol",
"432255", "Deutsch\ Brodersdorf",
"433536", "St\.\ Peter\ am\ Kammersberg",
"436413", "Wagrain",
"437751", "St\.\ Martin\ im\ Innkreis",
"433339", "Friedberg",
"433145", "Edelschrott",
"436463", "Annaberg\-Lungötz",
"433452", "Leibnitz",
"434356", "Lavamünd",
"433324", "Strem",
"432623", "Pottendorf",
"435472", "Prutz",
"432289", "Matzen",
"435441", "See",
"433617", "Gaishorn\ am\ See",
"436232", "Mondsee",
"433680", "Donnersbachwald",
"433472", "Mureck",
"435278", "Navis",
"433865", "Kindberg",
"435676", "Jungholz",
"433352", "Oberwart",
"432983", "Sigmundsherberg",
"437742", "Mattighofen",
"432275", "Atzenbrugg",
"436134", "Hallstatt",
"435372", "Kufstein",
"437226", "Wilhering",
"435339", "Wildschönau",
"435512", "Egg",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"433337", "Vorau",
"434710", "Oberdrauburg",
"435448", "Pettneu\ am\ Arlberg",
"432773", "Eichgraben",
"437588", "Ried\ im\ Traunkreis",
"432254", "Ebreichsdorf",
"432287", "Strasshof\ an\ der\ Nordbahn",
"436216", "Neumarkt\ am\ Wallersee",
"437758", "Obernberg\ am\ Inn",
"434273", "Reifnitz",
"433144", "Köflach",
"434253", "St\.\ Jakob\ im\ Rosental",
"434246", "Radenthein",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437230", "Altenberg\ bei\ Linz",
"433619", "Oppenberg",
"432274", "Sieghartskirchen",
"436135", "Bad\ Goisern",
"436277", "St\.\ Pantaleon",
"433886", "Weichselboden",
"435242", "Schwaz",
"435337", "Brixlegg",
"433512", "Knittelfeld",
"432172", "Frauenkirchen",
"432753", "Gansbach",
"432746", "Wilhelmsburg",
"433864", "St\.\ Marein\ im\ Mürztal",
"434243", "Bodensdorf",
"434256", "Nötsch\ im\ Gailtal",
"432915", "Drosendorf\-Zissersdorf",
"433174", "Birkfeld",
"435358", "Ellmau",
"436543", "Taxenbach",
"432767", "Hohenberg",
"432862", "Heidenreichstein",
"433883", "Terz",
"435252", "Oetz",
"436479", "Muhr",
"436432", "Bad\ Hofgastein",
"434267", "Metnitz",
"432812", "Gross\ Gerungs",
"432717", "Unter\-Meisling",
"432743", "Böheimkirchen",
"432756", "St\.\ Leonhard\ am\ Forst",
"437674", "Attnang\-Puchheim",
"435272", "Steinach\ am\ Brenner",
"435239", "Kühtai",
"432630", "Ternitz",
"432142", "Gattendorf",
"435224", "Wattens",
"432244", "Langenzersdorf",
"436213", "Oberhofen\ am\ Irrsee",
"437748", "Eggelsberg",
"433358", "Litzelsdorf",
"436247", "Grossgmain",
"434276", "Feldkirchen\ in\ Kärnten",
"435442", "Landeck",
"435518", "Mellau",
"432769", "Türnitz",
"437582", "Kirchdorf\ an\ der\ Krems",
"435673", "Ehrwald",
"432719", "Dross",
"437752", "Ried\ im\ Innkreis",
"432986", "Irnfritz",
"433175", "Anger",
"432914", "Japons",
"434269", "Flattnitz",
"436477", "St\.\ Michael\ im\ Lungau",
"437223", "Enns",
"433533", "Turrach",
"435225", "Fulpmes",
"432245", "Wolkersdorf\ im\ Weinviertel",
"436484", "Lessach",
"436416", "Lend",
"436457", "Flachau",
"433155", "Fehring",
"437675", "Ampflwang\ im\ Hausruckwald",
"434353", "Prebl",
"437724", "Mauerkirchen",
"436466", "Werfenweng",
"432626", "Mattersburg",
"435248", "Steinberg\ am\ Rofan",
"437750", "Andrichsfurt",
"437479", "Ardagger",
"437432", "Strengberg",
"434768", "Kleblach\-Lind",
"434733", "Malta",
"437714", "Esternberg",
"432684", "Schützen\ am\ Gebirge",
"432952", "Hollabrunn",
"432616", "Lockenhaus",
"433383", "Burgau",
"435265", "Nassereith",
"434718", "Dellach",
"432855", "Waldenstein",
"433136", "Dobl",
"432268", "Grossmugl",
"432233", "Pressbaum",
"432666", "Reichenau",
"437764", "Riedau",
"437485", "Gaming",
"437213", "Bad\ Leonfelden",
"437247", "Kematen\ am\ Innbach",
"434234", "Ruden",
"432875", "Grafenschlag",
"432525", "Gnadendorf",
"437238", "Mauthausen",
"437263", "Bad\ Zell",
"432734", "Langenlois",
"433858", "Mitterdorf\ im\ Mürztal",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432782", "Herzogenburg",
"437612", "Gmunden",
"437956", "Unterweissenbach",
"432854", "Kirchberg\ am\ Walde",
"437943", "Windhaag\ bei\ Freistadt",
"435214", "Leutasch",
"434873", "St\.\ Jakob\ in\ Defereggen",
"435286", "Ginzling",
"437765", "Lambrechten",
"436223", "Anthering",
"437477", "St\.\ Peter\ in\ der\ Au",
"433842", "Leoben",
"437662", "Seewalchen\ am\ Attersee",
"437357", "Kleinreifling",
"432552", "Poysdorf",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432685", "Rust",
"435264", "Mieming",
"434282", "Hermagor",
"434761", "Stockenboi",
"432572", "Mistelbach",
"432822", "Zwettl\,\ Lower\ Austria",
"433112", "Gleisdorf",
"432735", "Hadersdorf\ am\ Kamp",
"432948", "Weitersfeld",
"437231", "Herzogsdorf",
"437249", "Bad\ Schallerbach",
"434846", "Abfaltersbach",
"434853", "Ainet",
"437484", "Göstling\ an\ der\ Ybbs",
"437416", "Wieselburg",
"432874", "Martinsberg",
"432524", "Kautendorf",
"434227", "Ferlach",
"434235", "Bleiburg",
"432632", "Pernitz",
"433688", "Tauplitz",};
$areanames{de} = {"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"432242", "Sankt\ Andrä\-Wördern",
"434226", "Sankt\ Margareten\ im\ Rosental",
"437566", "Rosenau\ am\ Hengstpaß",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432617", "Draßmarkt",
"432815", "Großschönau",
"433868", "Tragöß",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432955", "Großweikersdorf",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"437435", "Sankt\ Valentin",
"434266", "Straßburg",
"434783", "Reißeck",
"432629", "Warth\,\ Niederösterreich",
"433632", "Sankt\ Gallen",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"436276", "Nußdorf\ am\ Haunsberg",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"433537", "Sankt\ Georgen\ ob\ Murau",
"4316", "Wien",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433362", "Großpetersdorf",
"433684", "Sankt\ Martin\ am\ Grimming",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434879", "Sankt\ Veit\ in\ Defereggen",
"433158", "Sankt\ Anna\ am\ Aigen",
"435245", "Hinterriß",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"437219", "Vorderweißenbach",
"436227", "Sankt\ Gilgen",
"434877", "Prägraten\ am\ Großvenediger",
"436241", "Sankt\ Koloman",
"4314", "Wien",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"4313", "Wien",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"437224", "Sankt\ Florian",
"432642", "Aspangberg\-Sankt\ Peter",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"436215", "Straßwalchen",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"4318", "Wien",
"437667", "Sankt\ Georgen\ im\ Attergau",
"436414", "Großarl",
"433119", "Sankt\ Marein\ bei\ Graz",
"435279", "Sankt\ Jodok\ am\ Brenner",
"432686", "Draßburg",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"4312", "Wien",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"437954", "Sankt\ Georgen\ am\ Walde",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"435449", "Fließ",
"436565", "Neukirchen\ am\ Großvenediger",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"432249", "Groß\-Enzersdorf",
"434264", "Klein\ Sankt\ Paul",
"437218", "Großtraberg",
"434286", "Weißbriach",
"432556", "Großkrut",
"432263", "Großrußbach",
"437565", "Sankt\ Pankraz",
"432857", "Bad\ Großpertholz",
"434358", "Sankt\ Andrä",
"435678", "Weißenbach\ am\ Lech",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437717", "Sankt\ Aegidi",
"432674", "Weißenbach\ an\ der\ Triesting",
"436412", "Sankt\ Johann\ im\ Pongau",
"437254", "Großraming",
"433834", "Wald\ am\ Schoberpaß",
"4319", "Wien",
"433585", "Sankt\ Lambrecht",
"433469", "Sankt\ Oswald\ im\ Freiland",
"435557", "Sankt\ Gallenkirch",
"4315", "Wien",
"432742", "Sankt\ Pölten",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"432847", "Groß\-Siegharts",
"432618", "Markt\ Sankt\ Martin",
"432823", "Großglobnitz",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"433327", "Sankt\ Michael\ im\ Burgenland",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"434785", "Außerfragant",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"434825", "Großkirchheim",
"437751", "Sankt\ Martin\ im\ Innkreis",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"435352", "Sankt\ Johann\ in\ Tirol",
"433864", "Sankt\ Marein\ im\ Mürztal",
"436277", "Sankt\ Pantaleon",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434253", "Sankt\ Jakob\ im\ Rosental",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"434876", "Kals\ am\ Großglockner",
"434843", "Außervillgraten",
"4317", "Wien",
"433386", "Großsteinbach",
"432647", "Krumbach\,\ Niederösterreich",
"433464", "Groß\ Sankt\ Florian",
"433575", "Sankt\ Johann\ am\ Tauern",
"432233", "Preßbaum",
"432268", "Großmugl",
"432822", "Zwettl\-Niederösterreich",
"437477", "Sankt\ Peter\ in\ der\ Au",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"437956", "Unterweißenbach",
"436247", "Großgmain",
"432756", "Sankt\ Leonhard\ am\ Forst",
"432812", "Groß\ Gerungs",
"436477", "Sankt\ Michael\ im\ Lungau",
"432719", "Droß",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;