package Test::Ping::Ties::SERVICE_CHECK;
$Test::Ping::Ties::SERVICE_CHECK::VERSION = '0.204';
use strict;
use warnings;
# ABSTRACT: Service Check Tie variable to Test::Ping

use Net::Ping;
use Test::Ping;
use Tie::Scalar;

sub TIESCALAR { return bless {}, shift;                               }
sub FETCH     { return Test::Ping->_ping_object()->{'econnrefused'};  }
sub STORE     { Test::Ping->_ping_object()->{'econnrefused'} = $_[1]; }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Test::Ping::Ties::SERVICE_CHECK - Service Check Tie variable to Test::Ping

=head1 VERSION

version 0.204

=head1 DESCRIPTION

In order to allow complete procedural interface to Net::Ping, even though it's
an object, I use a Tie::Scalar interface. Every variable is also defined
separately to make it cleaner and easier.

At some point they might be joined together in a single file, but I doubt it.

Please refrain from using this directly.

=head1 EXPORT

None.

=head1 AUTHOR

Sawyer X

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by Sawyer X.

This is free software, licensed under:

  The MIT (X11) License

=cut
