#!/usr/bin/perl

package eBay::API::XML::Call::GetBestOffers::GetBestOffersRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetBestOffersRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetBestOffers::GetBestOffersRequestType

=head1 DESCRIPTION

Retrieves the best offers associated with an ItemID, according to the
BestOfferStatus filter, where Active is the default value. 
You can specify a best offer ID to retrieve the details for a specific best offer.
A buyer can use GetBestOffers to see the buyer's best offer (BestOfferID, etc.)
and the current state of the best offer (e.g., whether the seller has made a counter offer).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetBestOffers::GetBestOffersRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::BestOfferIDType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::BestOfferStatusCodeType;


my @gaProperties = ( [ 'BestOfferID', 'ns:BestOfferIDType', ''
	     ,'eBay::API::XML::DataType::BestOfferIDType', '1' ]
	, [ 'BestOfferStatus', 'ns:BestOfferStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BestOfferStatusCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOfferID()

Need not be specified by a buyer or a seller.
The BestOfferID is the specific Best Offer you want information about.
If you are the seller, you can get a list of all best offers
(according to BestOfferStatus) by omitting this field.

  RequiredInput: No
#    Argument: 'ns:BestOfferIDType'

=cut

sub setBestOfferID {
  my $self = shift;
  $self->{'BestOfferID'} = shift
}

=head2 getBestOfferID()

#    Returns: 'ns:BestOfferIDType'

=cut

sub getBestOfferID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferID'
		,'eBay::API::XML::DataType::BestOfferIDType');
}


=head2 setBestOfferStatus()

A filter determining which Best Offers to return for an item. Active is the default.

  RequiredInput: No
  OnlyTheseValues: All, Active
#    Argument: 'ns:BestOfferStatusCodeType'

=cut

sub setBestOfferStatus {
  my $self = shift;
  $self->{'BestOfferStatus'} = shift
}

=head2 getBestOfferStatus()

#    Returns: 'ns:BestOfferStatusCodeType'

=cut

sub getBestOfferStatus {
  my $self = shift;
  return $self->{'BestOfferStatus'};
}


=head2 setItemID()

The item for which Best Offer information is to be returned.
If you are a buyer and you have a valid best offer, 
then your best-offer information will be returned for the item you specify.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
