######################################################################
#
# 2200_letsj_by_jipse.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x21",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\x22",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\x23",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\x24",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\x25",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\x06",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\x17",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\x28",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\x29",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\x2A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\x2B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x2C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\x09",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\x0A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\x1B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\x30",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\x31",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\x1A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\x33",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\x34",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\x35",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\x36",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\x08",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\x38",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\x39",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\x3A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\x3B",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x04",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x14",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\x3E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\xE1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\xB1",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'letsj','jipse',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\x4F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x20\x20"],
        ["\x4F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\x4F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\x4F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\x4F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\x4F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\x4F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\x4F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\x4F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\x4F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\x4F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\x4F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\x4F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\x4F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\x4F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\x4F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\x4F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\x4F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\x4F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\x4F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\x4F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\x4F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\x4F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\x4F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\x4F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\x4F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\x4F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\x4F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\x4F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\x4F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\x4F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\x4F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\x4F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\x4F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\x4F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\x4F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\x4F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\x4F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\x4F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\x4F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\x4F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\x4F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\x4F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\x4F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\x4F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\x4F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\x4F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\x4F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\x4F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\x4F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\x4F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\x4F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\x4F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\x4F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\x4F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\x4F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\x4F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\x4F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\x4F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\x4F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\x4F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\x4F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\x4F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\x4F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\x4F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\x4F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\x4F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\x4F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\x4F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\x4F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\x4F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\x4F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\x4F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\x4F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\x4F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\x4F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\x4F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\x4F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\x4F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\x4F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\x4F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\x4F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\x4F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\x4F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\x4F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\x4F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\x4F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\x4F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\x4F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\x7F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\x7F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\x7F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\x7F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\x7F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\x7F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\x7F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\x7F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\x7F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\x7F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\x7F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\x7F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\x7F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\x7F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\x45\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],
        ["\x45\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],
        ["\x46\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],
        ["\x46\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\x45\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\x45\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\x60\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\x60\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\x45\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],
        ["\x45\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],
        ["\x46\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],
        ["\x46\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],
        ["\x45\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],
        ["\x45\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],
        ["\x60\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],
        ["\x60\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],
        ["\x46\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],
        ["\x45\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],
        ["\x46\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],
        ["\x60\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],
        ["\x60\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],
        ["\x45\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],
        ["\x45\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],
        ["\x60\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],
        ["\x45\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],
        ["\x45\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],
        ["\x60\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],
        ["\x60\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],
        ["\x46\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],
        ["\x44\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],
        ["\x44\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],
        ["\x46\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],
        ["\x46\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],
        ["\x46\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],
        ["\x45\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],
        ["\x45\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],
        ["\x45\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],
        ["\x46\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],
        ["\x7B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\x7B\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\x7B\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\x7B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\x7B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\x7B\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\x7B\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\x7B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\x7B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\x7B\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\x7B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\x7B\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\x7B\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\x7B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\x7B\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\x7B\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\x7B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\x7B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\x7B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\x7B\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\x7B\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\x7B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\x7B\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\x7B\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\x7B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\x7B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\x7B\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\x7B\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\x7B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\x7B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\x7B\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\x7B\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\x7B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\x7B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\x7B\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\x7B\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\x7B\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\x7B\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\x7B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\x7B\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\x7B\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\x7B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\x7B\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\x7B\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\x7B\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\x7B\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\x7B\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\x7B\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\x7B\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\x7B\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\x7B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\x7B\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\x7B\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\x7B\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\x7B\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\x7B\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\x7B\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\x7B\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\x7B\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\x7B\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\x7B\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\x7B\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xE0\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xE0\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xE0\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xE0\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xE0\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xE0\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xE0\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xE0\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xE0\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xE0\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xE0\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xE0\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xE0\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xE0\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xE0\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xE0\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xE0\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xE0\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xE0\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xE0\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xE0\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xE0\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xE0\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xE0\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xE0\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xE0\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xE0\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xE0\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xE0\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xE0\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xE0\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xE0\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xE0\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xE0\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xE0\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xE0\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xE0\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xE0\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xE0\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xE0\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xE0\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xE0\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xE0\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xE0\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xE0\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xE0\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xE0\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xE0\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xE0\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xE0\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xE0\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xE0\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xE0\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xE0\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xE0\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xE0\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xE0\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xE0\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xE0\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xE0\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xE0\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xE0\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xE0\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xE0\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xE0\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xE0\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xE0\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xE0\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xE0\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xE0\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xE0\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xE0\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xE0\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xE0\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xE0\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xE0\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xE0\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xE0\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xE0\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xE0\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xE0\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xE0\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xE0\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\x6C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\x6C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\x6C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\x6C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\x6C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\x6C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\x6C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\x6C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\x6C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\x6C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\x6C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\x6C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\x6C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\x6C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\x6C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\x6C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\x6C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\x6C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\x6C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\x6C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\x6C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\x6C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\x6C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\x6C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\x6C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\x6C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\x6C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\x6C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\x6C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\x6C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\x6C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\x6C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\x6C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\x6C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\x6C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\x6C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\x6C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\x6C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\x6C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\x6C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\x6C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\x6C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\x6C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\x6C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\x6C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\x6C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\x6C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\x6C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\x6C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\x6C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\x6C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\x6C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\x6C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\x6C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\x6C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\x6C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\x6C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\x6C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\x6C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\x6C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\x6C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\x6C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\x6C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\x6C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\x6C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\x6C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\x6C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\x6C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\x6C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\x6C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\x6C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\x6C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\x6C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\x6C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\x6C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\x6C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\x6C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\x6C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\x6C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\x6C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\x6C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\x6C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\x6C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\x6C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\x6C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\x6C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\x50\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\x50\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\x50\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\x50\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\x50\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\x50\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\x50\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\x50\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\x50\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\x50\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\x50\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\x50\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\x50\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\x50\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\x50\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\x50\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\x50\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\x50\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\x50\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\x50\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\x50\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\x50\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\x50\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\x50\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\x50\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\x50\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\x50\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\x50\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\x50\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\x50\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\x50\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\x50\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\x50\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\x50\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\x50\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\x50\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\x50\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\x50\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\x50\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\x50\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\x50\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\x50\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\x50\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\x50\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\x50\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\x50\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\x50\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\x50\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\x7D\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\x7D\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\x7D\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\x7D\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\x7D\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\x7D\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\x7D\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\x7D\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\x7D\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\x7D\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\x7D\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\x7D\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\x7D\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\x7D\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\x7D\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\x7D\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\x7D\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\x7D\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\x7D\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\x7D\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\x7D\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\x7D\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\x7D\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\x7D\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\x7D\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\x7D\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\x7D\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\x7D\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\x7D\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\x7D\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\x7D\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\x7D\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\x7D\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\x7D\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\x7D\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\x7D\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\x7D\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\x7D\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\x7D\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\x7D\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\x7D\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\x7D\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\x7D\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\x7D\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\x7D\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\x7D\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\x7D\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\x7D\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\x7D\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\x7D\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\x7D\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\x7D\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\x7D\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\x7D\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\x7D\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\x7D\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\x7D\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\x7D\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\x7D\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\x7D\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\x7D\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\x7D\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\x7D\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\x7D\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\x7D\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\x7D\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\x6B\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],
        ["\x6B\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],
        ["\x6B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],
        ["\x6B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],
        ["\x6B\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],
        ["\x6B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],
        ["\x6B\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],
        ["\x6B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],
        ["\x6B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],
        ["\x6B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],
        ["\x6B\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],
        ["\x6B\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],
        ["\x6B\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],
        ["\x6B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],
        ["\x6B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],
        ["\x6B\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],
        ["\x6B\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],
        ["\x6B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],
        ["\x6B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],
        ["\x6B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],
        ["\x6B\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],
        ["\x6B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],
        ["\x6B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],
        ["\x6B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],
        ["\x6B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],
        ["\x6B\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],
        ["\x6B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],
        ["\x6B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],
        ["\x6B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],
        ["\x6B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],
        ["\x6B\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],
        ["\x6B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],
        ["\x60\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\x71"],
        ["\xF0\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xF0\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xF0\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xF0\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xF0\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xF0\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xF0\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xF0\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xF0\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xF0\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xF0\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xF0\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xF0\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xF0\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xF0\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xF0\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xF0\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xF0\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\x77\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\xF0\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xF0\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xF0\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xF0\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xF0\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xF0\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xF0\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xF0\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xF0\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xF0\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xF0\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xF0\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xF0\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xF0\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xF0\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xF0\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xF0\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xF0\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xF0\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xF0\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xF0\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xF0\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xF0\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xF0\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xF0\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xF0\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xF0\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xF0\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xF0\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xF0\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xF0\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xF0\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xF0\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xF0\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xF0\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xF0\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xF0\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xF0\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xF0\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xF0\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xF0\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xF0\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xF0\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xF0\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xF0\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xF0\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xF0\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xF0\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xF0\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xF0\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xF0\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xF0\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xF0\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xF0\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xF0\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xF0\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xF0\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xF0\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xF0\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xF0\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xF0\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xF0\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xF0\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xF0\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xF0\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xF0\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xF0\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xF0\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xF0\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xF0\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xF0\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xF0\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xF0\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xF0\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xF0\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xF1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xF1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xF1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xF1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xF1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xF1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xF1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xF1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xF1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xF1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xF1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xF1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xF1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xF1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xF1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xF1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xF1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xF1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xF1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xF1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xF1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xF1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xF1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xF1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xF1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xF1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xF1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xF1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xF1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xF1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xF1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xF1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xF1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xF1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xF1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xF1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xF1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xF1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xF1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xF1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xF1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xF1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xF1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xF1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xF1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xF1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xF1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xF1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xF1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xF1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xF1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xF1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xF1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xF1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xF1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xF1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xF1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xF1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xF1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xF1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xF1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xF1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xF1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xF1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xF1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xF1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xF1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xF1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xF1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xF1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xF1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xF1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xF1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xF1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xF1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xF1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xF1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xF1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xF1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xF1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xF1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xF1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xF1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xF1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xF1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xF1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xF1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xF1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xF1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xF1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xF1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xF1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xF1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xF1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xF2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xF2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xF2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xF2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xF2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xF2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xF2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xF2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\x77\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\xF2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xF2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xF2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xF2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xF2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xF2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xF2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xF2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xF2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xF2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xF2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xF2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xF2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xF2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xF2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xF2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xF2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xF2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xF2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xF2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xF2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xF2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xF2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xF2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xF2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xF2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xF2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xF2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xF2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xF2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xF2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xF2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xF2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xF2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xF2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xF2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xF2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xF2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xF2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xF2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xF2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xF2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xF2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xF2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xF2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xF2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xF2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xF2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xF2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xF2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xF2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xF2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xF2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xF2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xF2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xF2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xF2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xF2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xF2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xF2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xF2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xF2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xF2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xF2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xF2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xF2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xF2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xF2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xF2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xF2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xF2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xF2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xF2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xF2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xF2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xF2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xF2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xF2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xF2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xF2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xF2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xF2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xF2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xF2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xF2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xF3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xF3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xF3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xF3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xF3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xF3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xF3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xF3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xF3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xF3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xF3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xF3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xF3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xF3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xF3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xF3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xF3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xF3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xF3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xF3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xF3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xF3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xF3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xF3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xF3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xF3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xF3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xF3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xF3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xF3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xF3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xF3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xF3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\x68\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xF3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xF3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xF3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xF3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xF3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xF3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xE8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xF3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xF3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xF3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xF3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xF3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xF3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xF3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xF3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xF3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xF3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xF3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xF3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xF3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xF3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xF3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xF3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xF3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xF3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xF3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xF3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xF3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xF3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xF3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xF3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xF3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xF3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xF3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xF3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xF3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xF3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xF3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xF3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xF3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xF3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xF3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xF3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xF3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xF3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xF3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xF3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xF3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xF3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xF3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xF3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\x62\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xF3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xF3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xF3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xF3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xF3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xF3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xF3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xF3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xF4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xF4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xF4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xF4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xF4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xF4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xF4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xF4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xF4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xF4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xF4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xF4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xF4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xF4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xF4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xF4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xF4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xF4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xF4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xF4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xF4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xF4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xF4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xF4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xF4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xF4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xF4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xF4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xF4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xF4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xF4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xF4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xF4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xF4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\x5F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xF4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xF4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xF4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xF4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xF4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xF4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xF4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xF4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xF4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xF4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xF4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xF4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xF4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xF4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\x70\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xF4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xF4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xF4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xF4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xF4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xF4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xF4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xF4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xF4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xF4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xF4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xF4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xF4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xF4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xF4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xF4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xF4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xF4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xF4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xF4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xF4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xF4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xF4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xF4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xF4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xF4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xF4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xF4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xF4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xF4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xF4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xF4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xF4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xF4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xF4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xF4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xF4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xF4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xF4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xF4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xF4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xF4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xF4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xF4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xF5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xF5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xF5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xF5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xF5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xF5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xF5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xF5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xF5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xF5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xF5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xF5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xF5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xF5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xF5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xF5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xF5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xF5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xF5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xF5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xF5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xF5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xF5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xF5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xF5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xF5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xF5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xF5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xF5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xF5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xF5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xF5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xF5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xF5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xF5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xF5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xF5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xF5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xF5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xF5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xF5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xF5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xF5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xF5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xF5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xF5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xF5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xF5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xF5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xF5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xF5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xF5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xF5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xF5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xF5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xF5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xF5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xF5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xF5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xF5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xF5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xF5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xF5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xF5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xF5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xF5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xF5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xF5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xF5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xF5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xF5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xF5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xF5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xF5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xF5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xF5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xF5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xF5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xF5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xF5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xF5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xF5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xF5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xF5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xF5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xF5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xF5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xF5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xF5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xF5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xF5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xF5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xF5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xF5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xF6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xF6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xF6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xF6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xF6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xF6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xF6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xF6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xF6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xF6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xF6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xF6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xF6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xF6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xF6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xF6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xF6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xF6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xF6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xF6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xF6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xF6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xF6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xF6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xF6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xF6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xF6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xF6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xF6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xF6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xF6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xF6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xF6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xF6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xF6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xF6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xF6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\x86\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xF6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xF6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xF6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xF6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xF6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xF6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xF6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xF6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xF6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xF6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xF6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xF6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xF6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xF6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xF6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xF6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xF6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xF6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xF6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xF6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xF6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xF6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xF6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xF6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xF6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xF6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xF6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xF6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xF6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xF6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xF6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xF6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xF6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xF6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xF6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xF6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xF6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xF6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xF6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xF6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xF6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xF6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xF6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xF6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xF6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xF6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xF6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xF6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xF6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xF6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xF6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xF6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xF6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xF6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xF6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xF6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xF7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xF7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xF7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xF7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xF7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xF7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xF7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xF7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xF7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xF7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xF7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xF7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xF7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xF7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xF7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xF7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xF7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xF7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xF7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xF7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xF7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xF7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xF7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xF7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xF7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xF7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xF7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xF7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xF7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xF7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xF7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xF7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xF7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xF7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xF7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xF7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xF7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xF7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xF7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xF7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xF7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xF7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xF7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xF7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xF7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xF7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xF7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xF7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xF7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xF7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xF7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xF7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xF7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xF7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xF7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xF7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xF7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xF7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\x75\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xF7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xF7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xF7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xF7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xF7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xF7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xF7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xF7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xF7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xF7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xF7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xF7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xF7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xF7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xF7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xF7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xF7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xF7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xF7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xF7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xF7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xF7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xF7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xF7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xF7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xF7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xF7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xF7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xF7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xF7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xF7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xF7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xF7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xF7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xF7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xF8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xF8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xF8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xF8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xF8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xF8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xF8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xF8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xF8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xF8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xF8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xF8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xF8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xF8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xF8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xF8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xF8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xF8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xF8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xF8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xF8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xF8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xF8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xF8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xF8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xF8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xF8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xF8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xF8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xF8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xF8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xF8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xF8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xF8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xF8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xF8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xF8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xF8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xF8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xF8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xF8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xF8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xF8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xF8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xF8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xF8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xF8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xF8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xF8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xF8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xF8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xF8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xF8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xF8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xF8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xF8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xF8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xF8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xF8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xF8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xF8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xF8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xF8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xF8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xF8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xF8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xF8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xF8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xF8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xF8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xF8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xF8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xF8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xF8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xF8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xF8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xF8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xF8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xF8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xF8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xF8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xF8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xF8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xF8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xF8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xF8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xF8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xF8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xF8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xF8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xF8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xF8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xF8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xF8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xF9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xF9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xF9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xF9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xF9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xF9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xF9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xF9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xF9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xF9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xF9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xF9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xF9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xF9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xF9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xF9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xF9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xF9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xF9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xF9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xF9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xF9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\x8E\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\xF9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xF9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xF9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xF9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xF9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xF9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xF9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xF9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xF9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xF9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xF9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xF9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xF9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xF9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xF9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xF9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xF9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xF9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xF9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xF9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xF9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xF9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xF9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xF9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xF9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xF9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xF9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xF9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xF9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xF9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xF9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xF9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xF9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xF9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xF9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xF9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\x59\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xF9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xF9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xF9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xF9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xF9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xF9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xF9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xF9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xF9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xF9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xF9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xF9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xF9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xF9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xF9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xF9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xAC\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],
        ["\xF9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xF9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xF9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xF9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xF9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xF9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xF9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xF9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xF9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xF9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xF9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xF9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xF9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xF9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xF9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xF9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xF9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\x7A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\x7A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\x7A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\x7A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\x7A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\x7A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\x7A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\x7A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\x7A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\x7A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\x7A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\x7A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\x7A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\x7A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\x7A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\x7A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\x7A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\x7A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\x7A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\x7A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\x7A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\x7A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\x7A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\x7A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\x7A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\x7A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\x7A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\x7A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\x7A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\x7A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\x7A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\x7A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\x7A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\x7A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\x7A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\x7A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\x7A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\x7A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\x7A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\x7A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\x7A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\x7A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\x7A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\x7A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\x7A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\x7A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\x7A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\x7A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\x7A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\x7A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\x7A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\x7A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\x7A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\x7A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\x7A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\x7A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\x7A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\x7A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\x7A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\x7A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\x7A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\x7A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\x7A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\x7A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\x7A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\x7A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\x7A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\x7A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\x7A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\x7A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\x7A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\x7A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\x7A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\x7A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\x7A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\x7A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\x7A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\x7A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\x7A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\x7A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\x7A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\x7A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\x7A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\x7A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\x7A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\x7A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\x7A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\x7A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\x7A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\x7A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\x7A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\x7A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\x7A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\x7A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\x5E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\x5E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\x5E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\x5E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\x5E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\x5E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\x5E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\x5E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\x5E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\x5E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\x5E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\x5E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\x5E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\x5E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\x5E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\x5E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\x5E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\x5E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\x5E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\x5E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\x5E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\x5E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\x5E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\x5E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\x5E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\x5E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\x5E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\x5E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\x5E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\x5E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\x5E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\x5E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\x5E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\x5E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\x5E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\x5E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\x5E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\x5E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\x5E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\x5E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\x5E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\x5E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\x5E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\x5E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\x5E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\x5E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\x5E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\x5E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\x5E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\x5E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\x5E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\x5E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\x5E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\x5E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\x5E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\x5E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\x5E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\x5E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\x5E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\x5E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\x5E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\x5E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\x5E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\x5E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\x5E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\x5E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\x5E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\x5E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\x5E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\x5E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\x5E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\x5E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\x5E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\x5E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\x5E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\x5E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\x5E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\x5E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\x5E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\x5E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\x5E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\x5E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\x5E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\x5E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\x5E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\x5E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\x5E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\x5E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\x5E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\x5E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\x5E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\x5E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\x5E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\x5E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\x4C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\x4C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\x4C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\x4C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\x4C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\x4C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\x4C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\x4C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\x4C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\x4C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\x4C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\x4C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\x4C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\x4C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\x4C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\x4C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\x4C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\x4C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\x4C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\x4C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\x4C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\x4C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\x4C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\x4C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\x4C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\x4C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\x4C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\x4C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\x4C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\x4C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\x4C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\x4C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\x4C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\x4C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\x4C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\x4C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\x4C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\x4C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\x4C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\x4C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\x68\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\x4C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\x4C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\x4C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\x4C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\x4C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\x4C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\x4C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\x4C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\x4C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\x4C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\x4C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\x4C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\x4C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\x4C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\x4C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\x4C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\x4C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\x4C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\x4C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\x4C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\x4C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\x4C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\x4C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\x4C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\x4C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\x4C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\x4C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\x4C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\x4C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\x4C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\x4C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\x4C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\x4C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\x4C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\x4C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\x4C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\x4C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\x4C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\x4C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\x4C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\x4C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\x4C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\x4C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\x4C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\x4C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\x4C\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\x4C\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\x4C\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\x4C\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\x4C\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\x4C\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\x4C\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\x4C\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\x7E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\x7E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\x7E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\x7E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\x7E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\x7E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\x7E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\x7E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\x7E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\x7E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\x7E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\x7E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\x7E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\x7E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\x7E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\x7E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\x7E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\x7E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\x7E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\x7E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\x7E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\x7E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\x7E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\x7E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\x7E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\x7E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\x7E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\x7E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\x7E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\x7E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\x7E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\x7E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\x7E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\x7E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\x7E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\x7E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\x7E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\x7E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\x7E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\x7E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\x7E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\x7E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\x7E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\x7E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\x7E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\x7E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\x7E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\x7E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\x7E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\x7E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\x7E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\x7E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\x7E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\x7E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\x7E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\x7E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\x7E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\x7E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\x7E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\x7E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\x7E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\x7E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\x7E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\x7E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\x7E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\x7E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\x7E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\x7E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\x7E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\x7E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\x7E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\x7E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\x7E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\x7E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\x7E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\x7E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\x7E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\x7E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\x7E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\x7E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\x7E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\x7E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\x7E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\x7E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\x7E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\x7E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\x7E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\x7E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\x7E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\x7E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\x7E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\x7E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\x7E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\x7E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\x6E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\x6E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\x6E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\x6E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\x6E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\x6E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\x6E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\x6E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\x6E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\x6E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\x6E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\x6E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\x6E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\x6E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\x6E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\x6E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\x6E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\x6E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\x6E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\x6E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\x6E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\x6E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\x6E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\x6E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\x6E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\x6E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\x6E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\x6E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\x6E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\x6E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\x6E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\x6E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\x6E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\x6E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\x6E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\x6E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\x6E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\x6E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\x6E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\x6E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\x6E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\x6E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\x6E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\x6E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\x6E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\x6E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\x6E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\x6E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\x6E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\x6E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\x6E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\x6E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\x6E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\x6E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\x6E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\x6E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\x6E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\x6E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\x6E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\x6E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\x6E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\x6E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\x6E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\x6E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\x6E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\x6E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\x6E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\x6E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\x6E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\x6E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\x6E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\x6E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\x6E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\x6E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\x6E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\x6E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\x6E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\x6E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\x6E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\x6E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\x6E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\x6E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\x6E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\x6E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\x6E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\x6E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\x6E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\x6E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\x6E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\x6E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\x6E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\x6E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\x6E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\x6E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\x6F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\x6F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\x6F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\x6F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\x6F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\x6F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\x6F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\x6F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\x6F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\x6F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\x6F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\x6F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\x6F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\x6F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\x6F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\x6F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\x6F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\x6F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\x6F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\x6F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\x6F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\x6F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\x6F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\x6F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\x6F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\x6F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\x6F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\x6F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\x6F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\x6F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\x6F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\x6F\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\x6F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\x6F\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\x6F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\x6F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\x6F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\x6F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\x6F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\x6F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\x6F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\x6F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\x6F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\x6F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\x6F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\x6F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\x6F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\x6F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\x6F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\x6F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\x6F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\x6F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\x6F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\x6F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\x6F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\x6F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\x75\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\x6F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\x6F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\x6F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\x6F\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\x6F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\x6F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\x6F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\x6F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\x6F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\x6F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\x6F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\x6F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\x6F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\x6F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\x6F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\x6F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\x6F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\x6F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\x6F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\x6F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\x6F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\x6F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\x6F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\x6F\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\x6F\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\x6F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\x6F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\x6F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\x6F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\x6F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\x6F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\x6F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\x6F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\x6F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\x6F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\x6F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\x6F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\x7C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\x7C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\x7C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\x7C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\x7C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\x7C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\x7C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\x7C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\x7C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\x7C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\x7C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\x7C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\x7C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\x7C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\x7C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\x7C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\x7C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\x7C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\x7C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\x7C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\x7C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\x7C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\x7C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\x7C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\x7C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\x7C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\x7C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\x7C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\x7C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\x7C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\x7C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\x7C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\x7C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\x7C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\x7C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\x7C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\x7C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\x7C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\x7C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\x7C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\x7C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\x7C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\x7C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\x7C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\x7C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\x7C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\x7C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\x7C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\x7C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\x7C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\x7C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\x7C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\x7C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\x7C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\x7C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\x7C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\x7C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\x7C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\x7C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\x7C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\x7C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\x7C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\x7C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\x7C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\x7C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\x7C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\x7C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\x7C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\x7C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\x7C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\x7C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\x7C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\x7C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\x7C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\x7C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\x7C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\x7C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\x7C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\x7C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\x7C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\x7C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\x7C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\x7C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\x7C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\x7C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\x7C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\x7C\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\x7C\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\x7C\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\x7C\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\x7C\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\x7C\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\x7C\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\x7C\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xC1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xC1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xC1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xC1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xC1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xC1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xC1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\x71\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xC1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xC1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xC1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xC1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xC1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xC1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xC1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xC1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xC1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xC1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xC1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xC1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xC1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xC1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xC1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xC1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xC1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xC1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xC1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xC1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xC1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xC1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xC1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xC1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xC1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xC1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xC1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xC1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xC1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xC1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xC1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xC1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xC1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xC1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xC1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xC1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xC1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xC1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xC1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xC1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xC1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xC1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xC1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xC1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xC1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xC1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xC1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xC1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xC1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xC1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xC1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xC1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xC1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xC1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xC1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xC1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xC1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xC1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xC1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xC1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xC1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xC1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xC1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xC1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xC1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xC1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xC1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xC1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xC1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xC1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xC1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xC1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xC1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xC1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xC1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xC1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xC1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xC1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xC1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xC1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xC1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xC1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xC1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xC1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xC1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xC1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xC2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xC2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xC2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xC2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xC2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xC2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xC2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xC2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xC2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xC2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xC2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xC2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xC2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xC2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xC2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xC2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xC2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xC2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xC2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xC2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xC2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xC2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xC2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xC2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xC2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xC2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xC2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xC2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xC2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xC2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xC2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xC2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xC2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xC2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xC2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xC2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xC2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xC2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xC2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xC2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xC2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xC2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xC2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xC2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xC2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xC2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xC2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xC2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xC2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xC2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xC2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xC2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xC2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xC2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xC2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xC2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xC2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xC2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xC2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xC2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xC2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xC2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xC2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xC2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xC2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xC2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xC2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xC2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xC2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xC2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xC2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xC2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xC2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xC2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xC2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xC2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xC2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xC2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xC2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xC2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xC2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xC2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xC2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xC2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xC2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xC2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xC2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xC2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xC2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xC2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xC2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xC2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xC2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xC3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xC3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xC3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xC3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xC3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xC3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xC3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xC3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xC3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xC3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xC3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xC3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xC3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xC3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xC3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xC3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xC3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xC3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xC3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xC3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xC3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xC3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xC3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xC3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xC3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xC3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xC3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xC3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xC3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xC3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xC3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xC3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xC3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xC3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xC3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xC3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xC3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xC3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xC3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xC3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xC3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xC3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xC3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xC3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xC3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xC3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xC3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xC3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xC3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xC3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xC3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xC3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xC3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xC3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xC3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xC3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xC3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xC3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xC3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xC3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xC3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xC3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xC3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xC3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xC3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xC3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xC3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xC3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xC3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xC3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xC3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xC3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xC3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xC3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xC3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xC3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xC3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xC3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xC3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xC3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xC3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xC3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xC3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xC3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xC3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xC3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xC3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xC3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xC3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xC3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xC3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xC3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xC3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xC3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xC4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xC4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xC4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xC4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xC4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xC4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xC4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xC4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xC4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xC4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xC4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xC4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xC4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xC4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xC4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xC4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xC4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xC4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xC4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xC4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xC4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xC4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xC4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xC4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xC4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xC4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xC4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xC4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xC4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xC4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xC4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xC4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xC4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xC4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xC4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xC4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xC4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xC4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xC4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xC4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xC4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xC4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xC4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xC4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\x86\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xC4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xC4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xC4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xC4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xC4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xC4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xC4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xC4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xC4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xC4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xC4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xC4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xC4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xE3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xC4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xC4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xC4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xC4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xC4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xC4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xC4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xC4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xC4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xC4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xC4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xC4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xC4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xC4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xC4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xC4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xC4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xC4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xC4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xC4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xC4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xC4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xC4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xC4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xC4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xC4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xC4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xC4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xC4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xC4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xC4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xC4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xC4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xC4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xC5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xC5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xC5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xC5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xC5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xC5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xC5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xC5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xC5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xC5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xC5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xC5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xC5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xC5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xC5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xC5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xC5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xC5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xC5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xC5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xC5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xAC\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xC5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xC5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xC5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xC5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xC5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xC5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xC5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xC5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xA9\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\xC5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xC5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xC5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xC5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xC5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xC5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xC5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xC5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xC5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xC5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xC5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xC5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xC5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xC5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xC5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xC5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xC5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xC5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xC5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xC5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xC5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xC5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xC5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\x59\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xC5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xC5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xC5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xC5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xC5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xC5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xC5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xC5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xC5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xC5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xC5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xC5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xC5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xC5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xC5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xC5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xC5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xC5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xC5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xC5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xC5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xC5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\x4A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xC5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xC5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xC5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xC5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\x5F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xC5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xC5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xC5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xC5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xC5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xC5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xC5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xC5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xC5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xC5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xC5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xC6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xC6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xC6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xC6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xC6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xC6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xC6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xC6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xC6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xC6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xC6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xC6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xC6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xC6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xC6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xC6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xC6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xC6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xC6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xC6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xC6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xC6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xC6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xC6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xC6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xC6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xC6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xC6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xC6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xC6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xC6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xC6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xC6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xC6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xC6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xC6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xC6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xC6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xC6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xC6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xC6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xC6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xC6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xC6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xC6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xC6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xC6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xC6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xC6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xC6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xC6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xC6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xC6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xC6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xC6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xC6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xC6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xC6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xC6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xC6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xC6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xC6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xC6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xC6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xC6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xC6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xC6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xC6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xC6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xC6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xC6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xC6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xC6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xC6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xC6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xC6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xC6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xC6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xC6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xC6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xC6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xC6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xC6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xC6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xC6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\x72\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xC6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xC6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xC6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xC6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xC6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xC6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xC6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xC6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xC7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xC7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xC7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xC7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xC7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xC7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xC7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xC7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xC7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xC7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xC7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xC7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xC7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xC7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xC7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xC7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xC7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xC7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xC7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xC7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xC7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xC7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xC7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xC7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xC7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xC7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xC7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xC7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xC7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xC7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xC7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xC7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xC7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xC7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xC7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xC7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xC7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xC7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xC7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xC7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xC7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xC7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xC7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xC7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xC7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xC7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xC7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xC7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xC7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xC7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xC7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xC7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xC7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xC7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xC7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xC7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xC7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xC7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xC7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xC7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xC7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xC7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xC7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xC7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xC7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xC7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xC7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xC7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xC7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xC7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xC7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\x69\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xC7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xC7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xC7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xC7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xC7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xC7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xC7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xC7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xC7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xC7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xC7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xC7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xC7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xC7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xC7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xC7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xC7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xC7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xC7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xC7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xC7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xC7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xC8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xC8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xC8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xC8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xC8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xC8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xC8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xC8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xC8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xC8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xC8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xC8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xC8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xC8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xC8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xC8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xC8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xC8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xC8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xC8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xC8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xC8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xC8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xC8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xC8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xC8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xC8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xC8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xC8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xC8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xC8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xC8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xC8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xC8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xC8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xC8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xC8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xC8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xC8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xC8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xC8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xC8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xC8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xC8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xC8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xC8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xC8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xC8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xC8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xC8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xC8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xC8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xC8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xC8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xC8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xC8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xC8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xC8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xC8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xC8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xC8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xC8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xC8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xC8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xC8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xC8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xC8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xC8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xC8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xC8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xC8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xC8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xC8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xC8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xC8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xC8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xC8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xC8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xC8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xC8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xC8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xC8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xC8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xC8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xC8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xC8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xC8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xC8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xC8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xC8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xC8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xC8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xC8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xC8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xC9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xC9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xC9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xC9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xC9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xC9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xC9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xC9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xC9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xC9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xC9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xC9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xC9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xC9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xC9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\x4A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xC9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xC9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xC9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xC9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xC9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xC9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xC9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xC9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xC9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xC9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xC9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xC9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xC9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xC9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xC9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xC9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xC9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xC9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xC9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xC9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xC9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xC9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xC9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xC9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xC9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xC9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xC9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xC9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xC9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xC9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xC9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xC9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xC9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xC9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xC9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xC9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xC9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xC9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xC9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xC9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xC9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xC9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xC9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xC9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xC9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xC9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xC9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xC9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xC9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xC9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xC9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xC9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xC9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xC9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xC9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xC9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xC9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xC9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xC9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xC9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xC9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xC9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xC9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xC9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xC9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xC9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xC9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xC9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xC9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xC9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xC9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xC9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xC9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xC9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xC9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xC9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xC9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xD1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xD1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xD1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xD1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xD1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xD1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xD1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xD1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xD1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xD1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xD1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xD1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xD1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xD1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xD1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xD1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xD1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xD1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xD1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xD1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xD1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xD1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xD1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xD1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xD1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xD1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xD1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xD1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xD1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xD1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xD1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xD1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xD1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xD1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xD1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xD1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xD1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xD1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xD1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xD1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xD1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xD1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xD1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xD1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xD1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xD1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xD1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xD1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xD1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xD1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xD1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xD1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xD1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xD1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xD1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xD1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xD1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xD1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xD1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xD1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xD1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xD1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xD1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xD1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xD1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xD1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xD1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xD1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xD1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xD1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xD1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xD1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xD1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xD1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xD1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xD1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xD1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xD1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xD1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xD1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xD1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xD1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xD1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xD1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xD1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xD1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xD1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xD1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xD1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xD1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xD1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xD1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xD1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xD1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xD2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xD2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xD2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xD2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xD2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xD2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xD2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xD2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xD2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xD2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xD2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xD2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xD2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xD2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xD2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xD2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xD2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xD2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xD2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xD2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xD2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xD2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xD2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xD2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xD2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xD2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xD2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xD2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xD2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xD2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xD2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xD2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xD2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xD2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xD2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xD2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xD2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xD2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xD2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xD2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xD2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xD2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xD2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xD2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xD2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xD2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xD2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xD2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xD2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xD2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xD2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xD2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xD2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xD2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xD2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xD2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xD2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xD2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xD2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xD2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xD2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xD2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xD2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xD2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xD2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xD2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xD2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xD2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xD2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xD2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xD2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xD2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xD2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\x90\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\xD2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xD2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xD2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xD2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xD2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xD2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xD2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xD2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xD2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xD2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xD2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xD2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xD2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xD2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xD7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xD2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xD2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xD2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xD2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xD2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xD3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xD3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xD3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xD3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xD3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xD3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xD3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xD3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xD3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xD3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xD3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xD3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xD3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xD3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xD3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xD3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xD3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xD3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xD3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xD3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xD3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xD3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xD3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xD3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xD3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xD3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xD3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xD3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xD3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xD3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xD3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xD3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xD3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xD3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xD3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xD3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xD3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xD3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xD3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xD3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xD3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xD3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xD3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xD3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xD3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xD3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xD3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xD3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xD3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xD3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xD3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xD3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xD3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xD3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xD3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xD3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xD3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xD3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xD3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xD3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xD3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xD3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xD3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xD3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xD3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xD3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xD3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xD3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xD3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xD3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xD3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xD3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xD3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xD3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xD3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xD3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xD3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xD3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xD3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xD3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xD3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xD3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xD3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xD3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xD3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xD3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xD3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xD3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\x68\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xD3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xD3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xD3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xD3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xD3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xD4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xD4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xD4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xD4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xD4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xD4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xD4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xD4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xD4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xD4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xD4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xD4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xD4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xD4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xD4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xD4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xD4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xD4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xD4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xD4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xD4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xD4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xD4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xD4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xD4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xD4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xD4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xD4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xD4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xD4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xD4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xD4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xD4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xD4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xD4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xD4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xD4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xD4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xD4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xD4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xD4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xD4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xD4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xD4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xD4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xD4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xD4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xD4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xD4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xD4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xD4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xD4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xD4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xD4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xD4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xD4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xD4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xA5\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xD4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xD4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xD4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xD4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xD4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xD4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xD4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xD4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xD4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xD4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xD4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xD4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xD4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xD4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xD4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xD4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xD4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xD4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xD4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xD4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xD4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xD4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xD4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xD4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xD4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xD4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xD4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xD4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xD4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xD4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xD4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xD4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xD4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xD4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xD4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xD4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xD5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xD5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xD5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xD5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xD5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xD5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xD5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xD5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xD5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xD5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xD5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xD5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xD5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xD5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xD5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xD5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xD5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xD5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xD5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xD5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xD5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xD5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xD5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xD5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xD5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xD5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xD5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xD5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xD5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xD5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xD5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xD5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xD5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xD5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xD5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xD5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xD5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xD5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xD5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xD5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xD5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xD5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xD5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xD5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xD5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xD5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xD5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xD5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xD5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xD5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xD5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xD5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xD5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xD5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xD5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xD5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xD5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xD5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xD5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xD5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xD5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xD5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xD5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xD5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xD5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xD5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xD5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xD5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xD5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xD5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xD5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xD5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xD5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xD5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xD5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xD5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xD5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xD5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xD5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xD5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xD5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xD5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xD5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xD5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xD5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xD5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xD5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xD5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xD5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xD5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xD5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xD5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xD5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xD5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xD6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xD6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xD6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xD6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xD6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xD6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xD6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xD6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xD6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xD6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xD6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xD6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xD6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xD6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xD6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xD6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xD6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xD6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xD6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xD6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xD6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\x63\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xD6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xD6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xD6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xD6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xD6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xD6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xD6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xD6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xD6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xD6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xD6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xD6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xD6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xD6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xD6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xD6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xD6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xD6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xD6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xD6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xD6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xD6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xD6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xD6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xD6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xD6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xD6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xD6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xD6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xD7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xD7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xD7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xD7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xD7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xD7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xD7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xD7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xD7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xD7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xD7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xD7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xD7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xD7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xD7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xD7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xD7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xD7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xD7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xD7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xD7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xD7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xD7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xD7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xD7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xD7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xD7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xD7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xD7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xD7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xD7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xD7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xD7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xD7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xD7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xD7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xD7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xD7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xD7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xD7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xD7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xD7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xD7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xD7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xD7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xD7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xD7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xD7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xD7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xD7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xD7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xD7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xD7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xD2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xD7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xD7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xD7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xD7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xD7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xD7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xD7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xD7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xD7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xD7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xD7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xD7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xD7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xD7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xD7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xD7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xD7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xD7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xD7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xD7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xD7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xD7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xD7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xD7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xD7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xD7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xD7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xD7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xD7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xD7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xD7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xD7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xD7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xD7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xD7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xD7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xD7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xD7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xD7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xD7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xD8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xD8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xD8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xD8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xD8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xD8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xD8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xD8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xD8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xD8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xD8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xD8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xD8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xD8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xD8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xD8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xD8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xD8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xD8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xD8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xD8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xD8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xD8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xD8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xD8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xD8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xD8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xD8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xD8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xD8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xD8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xD8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xD8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xD8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xD8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xD8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xD8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xD8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xD8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xD8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xD8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xD8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xD8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xD8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xD8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xD8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xD8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xD8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xD8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xD8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xD8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xD8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xD8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xD8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xD8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xD8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xD8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xD8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xD8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xD8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xD8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xD8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xD8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xD8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xD8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xD8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xD8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xD8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xD8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xD8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xD8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xD8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xD8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xD8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xD8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xD8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xD8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xD8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xD8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xD8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xD8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xD8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xD8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xD8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xD8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xD8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xD8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xD8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xD8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xD8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xD8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xD8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xD8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xD8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xD9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xD9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xD9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xD9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xD9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xD9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xD9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xD9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xD9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xD9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xD9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xD9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xD9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xD9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xD9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xD9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xD9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xD9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xD9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xD9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xD9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xD9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xD9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xD9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xD9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xD9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xD9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xD9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xD9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xD9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xD9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xD9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xD9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xD9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xD9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xD9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xD9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xD9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xD9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xD9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xD9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xD9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xD9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xD9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xD9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xD9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xD9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xD9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xD9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xD9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xD9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xD9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xD9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xD9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xD9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xD9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xD9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xD9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xD9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xD9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xD9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xD9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xD9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xD9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xD9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xD9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xD9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xD9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xD9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xD9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xD9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xD9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xD9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xD9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xD9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xD9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xD9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xD9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xD9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xD9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xD9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xD9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xD9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xD9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xD9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xD9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xD9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xD9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xD9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xD9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xD9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xD9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xD9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xD9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xE2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xE2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xE2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xE2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xE2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xE2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xE2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xE2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xE2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xE2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xE2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xE2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xE2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xE2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xE2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xE2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xE2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xE2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xE2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xE2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xE2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xE2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xE2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xE2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xE2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xE2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xE2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xE2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xE2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xE2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xE2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xE2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xE2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xE2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xE2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xE2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xE2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xE2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xE2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xE2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xE2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xE2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xE2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xE2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xE2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xE2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xE2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xE2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xE2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xE2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xE2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xE2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xE2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xE2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xE2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xE2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xE2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xE2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xE2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xE2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xE2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xE2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xE2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xE2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xE2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xE2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xE2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xE2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xE2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xE2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xE2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xE2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xE2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xE2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xE2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xE2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xE2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xE2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xE2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xE2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xE2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xE2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xE2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xE2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xE2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xE2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xE2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xE2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xE2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xE2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xE2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xE2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xE2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xE2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xE3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xE3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xE3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xE3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xE3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xE3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xE3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xE3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xE3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xE3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xE3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xE3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xE3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xE3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xE3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xE3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xE3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xE3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xE3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xE3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xE3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xE3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xE3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xE3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xE3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xE3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xE3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xE3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xE3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xE3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xE3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xE3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xE3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xE3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xE3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xE3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xE3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xE3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xE3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xE3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xE3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xE3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xE3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xE3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xE3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xE3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xE3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xE3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xE3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xE3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xE3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xE3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xE3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xE3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xE3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xE3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xE3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xE3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xE3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xE3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xE3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xE3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xE3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xE3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xE3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xE3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xE3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xC4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xE3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xE3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xE3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xE3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xE3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xE3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xE3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xE3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xE3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xE3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xE3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xE3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xE3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xE3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xE3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xE3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xE3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xE3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xE3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xE3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xE3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xE3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xE3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xE3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xE3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xE3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xE4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xE4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xE4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xE4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xE4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xE4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xE4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xE4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xE4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xE4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xE4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xE4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xE4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xE4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xE4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xE4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xE4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xE4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xE4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xE4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xE4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xE4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xE4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xE4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xE4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xE4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xE4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xE4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xE4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xE4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xE4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xE4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xE4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xE4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xE4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xE4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xE4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xE4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xE4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xE4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xE4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xE4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xE4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xE4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xE4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xE4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xE4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xE4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xE4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xE4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xE4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xE4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xE4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xE4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xE4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xE4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xE4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xE4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xE4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xE4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xE4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xE4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xE4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xE4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xE4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xE4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xE4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xE4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xE4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xE4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xE4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xE4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xE4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xE4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xE4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xE4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xE4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xE4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xE4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xE4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xE4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xE4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xE4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xE4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xE4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xE4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xE4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xE4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xE4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xE4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xE4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xE4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xE4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xE4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xE5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xE5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xE5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xE5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xE5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xE5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xE5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xE5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xE5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xE5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xE5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xE5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xE5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xE5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xE5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xE5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xE5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xE5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xE5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xE5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xE5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xE5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xE5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xE5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xE5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xE5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xE5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xE5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xE5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xE5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xE5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xE5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xE5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xE5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xE5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xE5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xE5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xE5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xE5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xE5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xE5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xE5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xE5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xE5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xE5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xE5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xE5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xE5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xE5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xE5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xE5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xE5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xE5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xE5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xE5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xE5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xE5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xE5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xE5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xE5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xE5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xE5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xE5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xE5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xE5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xE5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xE5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xE5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xE5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xE5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xE5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xE5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xE5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xE5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xE5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xE5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xE5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xE5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xE5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xE5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xE5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xE5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xE5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xE5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xE5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xE5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xE5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xE5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xE5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xE5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xE5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xE5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xE5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xE5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xE6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xE6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xE6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xE6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xE6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xE6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xE6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xE6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xE6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xE6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xE6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xE6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xE6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xE6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xE6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xE6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xE6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xE6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xE6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xE6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xE6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xE6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xE6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xE6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xE6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xE6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xE6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xE6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xE6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xE6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xE6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xE6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xE6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xE6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xE6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xE6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xE6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xE6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xE6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xE6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xE6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xE6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xE6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xE6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xE6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xE6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xE6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xE6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xE6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xE6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xE6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xE6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xE6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xE6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xE6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xE6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xE6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xE6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xE6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xE6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xE6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xE6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xE6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xE6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xE6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xE6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xE6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xE6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xE6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xE6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xE6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xE6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xE6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xE6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xE6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xE6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xE6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xE6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xE6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xE6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xE6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xE6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xE6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xE6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xE6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xE6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xE6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xE6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xE6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xE6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xE6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xE6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xE6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xE7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xE7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xE7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xE7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xE7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xE7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xE7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xE7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xE7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xE7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xE7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xE7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xE7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xE7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xE7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xE7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xE7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xE7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xE7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xE7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xE7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xE7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xE7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xE7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xE7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xE7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xE7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xE7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xE7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xE7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xE7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xE7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xE7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xE7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xE7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xE7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xE7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xE7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xE7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xE7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xE7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xE7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xE7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xE7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xE7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xE7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xE7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xE7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xE7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xE7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xE7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xE7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xE7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xE7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xE7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xE7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xE7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xE7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xE7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xE7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xE7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xE7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xE7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xE7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xE7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xE7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xE7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xE7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xE7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xE7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xE7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xE7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xE7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xE7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xE7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xE7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xE7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xE7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xE7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xE7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xE7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xE7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xE7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xE7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xE7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xE7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xE7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xE7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xE7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xE7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xE7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xE7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xE7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xE7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xE8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xE8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xE8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xE8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xE8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xE8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xE8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xE8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xE8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xE8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xE8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xE8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xE8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xE8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xE8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xE8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xE8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xE8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xE8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xE8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xE8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xE8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xE8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xE8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xE8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xE8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xE8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xE8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xE8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xE8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xE8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xE8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xE8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xE8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xE8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xE8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xE8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xE8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xE8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xE8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xE8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xE8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xE8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xE8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xE8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xE8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xE8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xE8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xE8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xE8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xE8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xE8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xE8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xE8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xE8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xE8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xE8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xE8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xE8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xE8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xE8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xE8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xE8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xE8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xE8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xE8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xE8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xE8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xE8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xE8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xE8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xE8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xE8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xE8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xE8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xE8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xE8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xE8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xE8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xE8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xE8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xE8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xE8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xE8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xE8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xE8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xE8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xF3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xE8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xE8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xE8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xE8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xE8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xE8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xE9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xE9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xE9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xE9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xE9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xE9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xE9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xE9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xE9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xE9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xE9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xE9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xE9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xE9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xE9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xE9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xE9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xE9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xE9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xE9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xE9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xE9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xE9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xE9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xE9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xE9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xE9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xE9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xE9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xE9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xE9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xE9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xE9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xE9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xE9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xE9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xE9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xE9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xE9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xE9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xE9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xE9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xE9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xE9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xE9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xE9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xE9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xE9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xE9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xE9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xE9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xE9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xE9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xE9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xE9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xE9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xE9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xE9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xE9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xE9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xE9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xE9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xE9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xE9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xE9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xE9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xE9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xE9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xE9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xE9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xE9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xE9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xE9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xE9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xE9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xE9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xE9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xE9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xE9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xE9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xE9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xE9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xE9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xE9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xE9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xE9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xE9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xE9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xE9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xE9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xE9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xE9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xE9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xE9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\x4A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\x4A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\x4A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\x4A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\x4A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\x4A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\x4A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\x4A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\x4A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\x4A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\x4A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\x4A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\x4A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\x4A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\x4A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\x4A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\x4A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\x4A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\x4A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\x4A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\x4A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\x4A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\x4A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\x4A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\x4A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\x4A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\x4A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\x4A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\x4A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\x4A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\x4A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\x4A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\x4A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\x4A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\x4A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\x4A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\x4A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\x4A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\x4A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\x4A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\x4A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\x4A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\x4A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\x4A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\x4A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\x4A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\x4A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\x4A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\x4A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\x4A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\x4A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\x4A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\x4A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\x4A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\x4A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xC9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\x4A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\x4A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\x4A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\x4A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\x4A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\x4A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\x4A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\x4A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\x4A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\x4A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\x4A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\x4A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\x4A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\x4A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\x4A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\x4A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\x4A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\x4A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\x4A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\x4A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xC5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\x4A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\x4A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\x4A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\x4A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\x4A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\x4A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\x4A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\x4A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\x4A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\x4A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\x4A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\x4A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\x4A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\x4A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\x4A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\x4A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\x4A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\x5B\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\x5B\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\x5B\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\x5B\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\x5B\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\x5B\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\x5B\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\x5B\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\x5B\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\x5B\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\x5B\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\x5B\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\x5B\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\x5B\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\x5B\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\x5B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\x5B\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\x5B\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\x5B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\x5B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\x5B\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\x5B\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\x5B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\x5B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\x5B\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\x5B\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\x5B\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\x5B\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\x5B\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\x5B\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\x5B\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\x5B\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\x5B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\x5B\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\x5B\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\x5B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\x5B\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\x5B\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\x5B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\x5B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\x5B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\x5B\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\x5B\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\x5B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\x5B\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\x5B\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\x5B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\x5B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\x5B\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\x5B\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\x5B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\x5B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\x5B\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\x5B\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\x5B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\x5B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\x5B\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\x5B\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\x5B\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\x5B\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\x5B\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\x5B\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\x5B\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\x5B\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\x5B\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\x5B\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\x5B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\x5B\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\x5B\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\x5B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\x5B\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\x5B\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\x5B\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\x5B\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\x5B\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\x5B\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\x5B\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\x5B\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\x5B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\x5B\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\x5B\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\x5B\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\x5B\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\x5B\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\x5B\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\x5B\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\x5B\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\x5B\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\x5B\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\x5B\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\x5B\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\x5B\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\x5B\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\x5B\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\x5A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\x5A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\x5A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\x5A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\x5A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\x5A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\x5A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\x5A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\x5A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\x5A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\x5A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\x5A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\x5A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\x5A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\x5A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\x5A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\x5A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\x5A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\x5A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\x5A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\x5A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\x5A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\x5A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\x5A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\x5A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\x5A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\x5A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\x5A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\x5A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\x5A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\x5A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\x5A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\x5A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\x5A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\x5A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\x5A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\x5A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\x5A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\x5A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\x5A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\x5A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\x5A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\x5A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\x5A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\x5A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\x5A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\x5A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\x5A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\x5A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\x5A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\x5A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\x5A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\x5A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\x5A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\x5A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\x5A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\x5A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\x5A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\x5A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\x5A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\x5A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\x5A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\x5A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\x5A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\x5A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\x5A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\x5A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\x5A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\x5A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\x5A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\x5A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\x5A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\x5A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\x5A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\x5A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\x5A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\x5A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\x5A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\x5A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\x5A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\x5A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\x5A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\x5A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\x5A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\x5A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\x5A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\x5A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\x5A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\x5A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\x5A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\x5A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\x5A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\x5A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\x5A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\x5F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\x5F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\x5F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\x5F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\x5F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\x5F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\x5F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\x5F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\x5F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\x5F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\x5F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\x5F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\x5F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\x5F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\x5F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\x5F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\x5F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\x5F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\x5F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\x5F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\x5F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\x5F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\x5F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\x5F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xC5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\x5F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\x5F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\x5F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\x5F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\x5F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\x5F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\x5F\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\x5F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\x5F\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\x5F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\x5F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\x5F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\x5F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\x5F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\x5F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\x5F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\x5F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\x5F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\x5F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\x5F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\x5F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\x5F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\x5F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\x5F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\x5F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\x5F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\x5F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\x5F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\x5F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\x5F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\x5F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\x5F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\x5F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\x5F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\x5F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\x5F\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\x5F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\x5F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\x5F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\x5F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\x5F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\x5F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\x5F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\x5F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\x5F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\x5F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\x5F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\x5F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\x5F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\x5F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\x5F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\x5F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\x5F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\x5F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\x5F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\x5F\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\x5F\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\x5F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\x5F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xF4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\x5F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\x5F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\x5F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\x5F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\x5F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\x5F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\x5F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\x5F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\x5F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\x6D\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\x6D\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\x6D\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\x6D\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\x6D\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\x6D\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\x6D\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\x6D\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\x6D\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\x6D\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\x6D\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\x6D\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\x6D\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\x6D\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\x6D\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\x6D\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\x6D\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\x6D\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\x6D\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\x6D\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\x6D\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\x6D\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\x6D\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\x6D\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\x6D\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\x6D\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\x6D\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\x6D\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\x6D\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\x6D\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\x6D\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\x6D\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\x6D\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\x6D\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\x6D\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\x6D\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\x6D\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\x6D\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\x6D\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\x6D\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\x6D\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\x6D\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\x6D\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\x6D\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\x6D\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\x6D\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\x6D\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\x6D\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\x6D\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\x6D\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\x6D\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\x6D\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\x6D\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\x6D\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\x6D\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\x6D\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\x6D\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\x6D\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\x6D\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\x6D\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\x6D\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\x6D\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\x6D\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\x6D\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\x6D\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\x6D\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\x6D\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\x6D\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\x6D\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\x6D\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\x6D\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\x6D\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\x6D\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\x6D\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\x6D\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\x6D\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\x6D\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\x6D\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\x6D\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\x6D\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\x6D\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\x6D\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\x6D\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\x6D\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\x6D\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\x6D\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\x6D\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\x6D\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\x6D\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\x6D\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\x6D\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\x6D\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\x6D\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\x6D\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\x79\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\x79\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\x79\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\x79\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\x79\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\x79\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\x79\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\x79\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\x79\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\x79\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\x79\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\x79\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\x79\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\x79\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\x79\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\x79\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\x79\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\x79\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\x79\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\x79\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\x79\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\x79\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\x79\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\x79\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\x79\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\x79\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\x79\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\x79\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\x79\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\x79\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\x79\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\x79\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\x79\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\x79\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\x79\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\x79\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\x79\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\x79\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\x79\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\x79\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\x79\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\x79\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\x79\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\x79\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\x79\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\x79\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\x79\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\x79\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\x79\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\x79\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\x79\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\x79\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\x79\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\x79\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\x79\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\x79\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\x79\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\x79\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\x79\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\x79\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\x79\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\x79\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\x79\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\x79\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\x79\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\x79\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\x79\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\x79\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\x79\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\x79\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\x79\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\x79\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\x79\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\x79\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\x79\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\x79\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\x79\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\x79\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\x79\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\x79\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\x79\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\x79\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\x79\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\x79\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\x79\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\x95\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\x79\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\x79\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\x79\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\x79\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\x79\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\x79\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\x79\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\x79\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\x57\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\x57\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\x57\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\x57\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\x57\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\x57\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\x57\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\x57\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\x57\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\x57\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\x57\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\x57\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\x57\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\x57\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\x57\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\x57\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\x57\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\x57\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\x57\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\x57\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\x57\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\x57\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\x57\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\x57\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\x57\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\x57\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\x57\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\x57\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\x57\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\x57\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\x57\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\x57\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\x57\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\x57\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\x57\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\x57\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\x57\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\x57\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\x57\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\x57\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\x57\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\x57\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\x57\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\x57\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\x57\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\x57\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\x57\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\x57\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\x57\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\x57\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\x57\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\x57\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\x57\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\x57\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\x57\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\x57\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\x57\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\x57\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\x57\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\x57\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\x57\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\x57\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\x57\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\x57\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\x57\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\x57\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\x57\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\x57\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\x57\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\x57\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\x57\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\x57\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\x57\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\x57\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\x57\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\x57\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\x57\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\x57\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\x57\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\x57\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\x57\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\x57\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\x57\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\x57\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\x57\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\x57\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\x57\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\x57\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\x57\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\x57\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\x57\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\x57\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\x57\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\x57\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\x59\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\x59\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\x59\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\x59\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\x59\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\x59\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\x59\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\x59\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\x59\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\x59\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\x59\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\x59\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\x59\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\x59\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\x59\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\x59\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\x59\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\x59\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\x59\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\x59\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\x59\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\x59\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\x59\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\x59\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\x59\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\x59\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\x59\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\x59\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\x59\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\x59\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\x59\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\x59\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\x59\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\x59\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\x59\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\x59\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\x59\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\x59\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\x59\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\x59\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\x59\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\x59\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\x59\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\x59\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\x59\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\x59\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\x59\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\x59\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\x59\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\x59\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\x59\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\x59\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\x59\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\x59\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\x59\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\x59\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\x59\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\x59\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\x59\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\x59\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\x59\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\x59\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\x59\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\x59\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\x59\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\x59\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\x59\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\x59\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\x59\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\x59\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\x59\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xF9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\x59\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xC5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\x59\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\x59\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\x59\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\x59\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\x59\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\x59\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\x59\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\x59\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\x59\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\x59\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\x59\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\x59\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\x59\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\x59\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\x59\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\x59\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\x59\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\x59\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\x59\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\x59\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\x62\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\x62\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\x62\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\x62\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\x62\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\x62\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\x62\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\x62\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\x62\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\x62\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\x62\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\x62\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\x62\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\x62\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\x62\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\x62\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\x62\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\x62\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\x62\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\x62\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\x62\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\x62\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\x62\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\x62\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\x62\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\x62\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\x62\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\x62\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\x62\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\x62\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\x62\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\x62\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\x62\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\x62\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\x62\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\x62\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\x62\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\x62\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\x62\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\x62\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\x62\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\x62\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\x62\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\x62\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\x62\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\x62\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\x62\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\x62\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\x62\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\x62\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\x62\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\x62\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\x62\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\x62\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\x62\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\x62\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\x62\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\x62\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\x62\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\x62\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\x62\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xF3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\x62\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\x62\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\x62\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\x62\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\x62\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\x62\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\x62\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\x62\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\x62\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\x62\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\x62\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\x62\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\x62\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\x62\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\x62\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\x62\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\x62\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\x62\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\x62\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\x62\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\x62\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\x62\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\x62\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\x62\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\x62\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\x62\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\x62\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\x62\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\x62\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\x62\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\x62\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\x62\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\x63\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\x63\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\x63\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\x63\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\x63\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\x63\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\x63\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\x63\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\x63\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\x63\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\x63\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\x63\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\x63\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\x63\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\x63\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\x63\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\x63\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\x63\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\x63\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\x63\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\x63\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\x63\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\x63\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\x63\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\x63\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\x63\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\x63\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\x63\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\x63\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\x63\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\x63\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\x63\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\x63\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\x63\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\x63\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\x63\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\x63\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xD6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\x63\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\x63\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\x63\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\x63\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\x63\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\x63\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\x63\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\x63\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\x63\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\x63\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\x63\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\x63\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\x63\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\x63\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\x63\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\x63\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\x63\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\x63\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\x63\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\x63\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\x63\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\x63\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\x63\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\x63\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\x63\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\x63\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\x63\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\x63\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\x63\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\x63\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\x63\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\x63\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\x63\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\x63\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\x63\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\x63\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\x63\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\x63\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\x63\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\x63\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\x63\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\x63\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\x63\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\x63\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\x63\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\x63\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\x63\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\x63\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\x63\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\x63\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\x63\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\x63\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\x63\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\x63\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\x63\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\x63\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\x64\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\x64\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\x64\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\x64\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\x64\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\x64\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\x64\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\x64\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\x64\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\x64\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\x64\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\x64\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\x64\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\x64\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\x64\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\x64\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\x64\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\x64\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\x64\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\x64\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\x64\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\x64\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\x64\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\x64\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\x64\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\x64\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\x64\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\x64\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\x64\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\x64\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\x64\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\x64\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\x64\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\x64\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\x64\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\x64\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\x64\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\x64\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\x64\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\x64\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\x64\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\x64\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\x64\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\x64\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\x64\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\x64\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\x64\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\x64\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\x64\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\x64\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\x64\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\x64\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\x64\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\x64\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\x64\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\x64\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\x64\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\x64\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\x64\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\x64\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\x64\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\x64\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\x64\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\x64\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\x64\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\x64\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\x64\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\x64\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\x64\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\x64\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\x64\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\x64\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\x64\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\x64\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\x64\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\x64\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\x64\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\x64\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\x64\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\x64\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\x64\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\x64\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\x64\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\x64\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\x64\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\x64\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\x64\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\x64\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\x64\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\x64\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\x64\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\x64\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\x64\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\x64\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\x65\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\x65\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\x65\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\x65\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\x65\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\x65\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\x65\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\x65\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\x65\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\x65\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\x65\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\x65\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\x65\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\x65\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\x65\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\x65\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\x65\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\x65\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\x65\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\x65\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\x65\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\x65\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\x65\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\x65\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\x65\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\x65\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\x65\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\x65\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\x65\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\x65\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\x65\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\x65\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\x65\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\x65\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\x65\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\x65\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\x65\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\x65\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\x65\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\x65\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\x65\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\x65\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\x65\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\x65\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\x65\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\x65\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\x65\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\x65\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\x65\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\x65\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\x65\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\x65\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\x65\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\x65\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\x65\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\x65\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\x65\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\x65\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\x65\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\x65\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\x65\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\x65\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\x65\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\x65\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\x65\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\x65\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\x65\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\x65\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\x65\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\x65\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\x65\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\x65\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\x65\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\x65\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\x65\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\x65\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\x65\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\x65\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\x65\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\x65\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\x65\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\x65\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\x65\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\x65\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\x65\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\x65\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\x65\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\x65\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\x65\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\x65\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\x65\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\x65\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\x65\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\x65\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\x66\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\x66\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\x66\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\x66\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\x66\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\x66\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\x66\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\x66\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\x66\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\x66\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\x66\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\x66\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\x66\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\x66\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\x66\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\x66\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\x66\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\x66\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\x66\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\x66\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\x66\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\x66\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\x66\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\x66\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\x66\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\x66\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\x66\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\x66\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\x66\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\x66\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\x66\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\x66\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\x66\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\x66\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\x66\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\x66\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\x66\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\x66\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\x66\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\x66\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\x66\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\x66\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\x66\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\x66\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\x66\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\x66\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\x66\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\x66\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\x66\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\x66\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\x66\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\x66\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\x66\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\x66\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\x66\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\x66\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\x66\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\x66\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\x66\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\x66\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\x66\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\x66\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\x66\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\x66\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\x66\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\x66\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\x66\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\x66\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\x66\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\x66\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\x66\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\x66\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\x66\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\x66\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\x66\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\x66\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\x66\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\x66\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\x66\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\x66\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\x66\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\x66\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\x66\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\x66\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\x66\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\x66\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\x66\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\x66\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\x66\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\x66\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\x66\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\x66\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\x66\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\x66\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\x67\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\x67\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\x67\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\x67\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\x67\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\x67\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\x67\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\x67\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\x67\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\x67\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\x67\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\x67\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\x67\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\x67\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\x67\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\x67\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\x67\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\x67\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\x67\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\x67\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\x67\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\x67\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\x67\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\x67\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\x67\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\x67\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\x67\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\x67\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\x67\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\x67\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\x67\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\x67\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\x67\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\x67\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\x67\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\x67\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\x67\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\x67\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\x67\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\x67\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\x67\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\x67\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\x67\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\x67\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\x67\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\x67\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\x67\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\x67\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\x67\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\x67\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\x67\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\x67\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\x67\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\x67\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\x67\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\x67\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\x67\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\x67\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\x67\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\x67\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\x67\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\x67\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\x67\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\x67\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\x67\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\x67\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\x67\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\x67\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\x67\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\x67\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\x67\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\x67\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\x67\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\x67\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\x67\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\x67\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\x67\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\x67\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\x67\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\x67\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\x67\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\x67\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\x67\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\x67\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\x67\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\x67\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\x67\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\x67\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\x67\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\x67\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\x67\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\x67\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\x67\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\x67\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\x68\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\x4C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\x68\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\x68\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\x68\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\x68\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\x68\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\x68\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\x68\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\x68\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\x68\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\x68\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\x68\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xD3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\x68\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\x68\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\x68\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\x68\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\x68\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\x68\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\x68\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\x68\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\x68\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\x68\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\x68\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\x68\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\x68\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\x68\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\x68\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\x68\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\x68\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\x68\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\x68\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\x68\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\x68\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\x68\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\x68\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\x68\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\x68\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\x68\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\x68\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\x68\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\x68\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\x68\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\x68\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\x68\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\x68\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\x68\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\x68\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\x68\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\x68\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\x68\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\x68\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\x68\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\x68\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\x68\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\x68\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xF3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\x68\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\x68\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\x68\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\x68\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\x68\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\x68\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\x68\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\x68\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\x68\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\x68\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\x68\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\x68\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\x68\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\x68\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\x68\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\x68\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\x68\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\x68\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\x68\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\x68\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\x68\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\x68\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\x68\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\x68\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\x68\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\x68\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\x68\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\x68\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\x68\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\x68\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\x68\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\x68\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\x68\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\x68\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\x68\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\x68\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\x69\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\x69\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\x69\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xC7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\x69\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\x69\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\x69\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\x69\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\x69\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\x69\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\x69\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\x69\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\x69\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\x69\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\x69\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\x69\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\x69\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\x69\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\x69\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\x69\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\x69\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\x69\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\x69\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\x69\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\x69\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\x69\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\x69\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\x69\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\x69\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\x69\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\x69\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\x69\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\x69\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\x69\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\x69\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\x69\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\x69\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\x69\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\x69\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\x69\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\x69\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\x69\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\x69\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\x69\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\x69\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\x69\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\x69\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\x69\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\x69\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\x69\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\x69\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\x69\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\x69\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\x69\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\x69\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\x69\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\x69\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\x69\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\x69\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\x69\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\x69\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\x69\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\x69\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\x69\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\x69\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\x69\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\x69\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\x69\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\x69\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\x69\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\x69\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\x69\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\x69\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\x69\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\x69\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\x69\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\x69\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\x69\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\x69\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\x69\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\x69\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\x69\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\x69\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\x69\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\x69\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\x69\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\x69\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\x69\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\x69\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\x69\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\x69\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\x69\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\x69\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\x69\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\x70\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\x70\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\x70\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\x70\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\x70\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\x70\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\x70\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\x70\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\x70\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\x70\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\x70\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\x70\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\x70\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\x70\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\x70\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\x70\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\x70\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\x70\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\x70\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\x70\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\x70\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\x70\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\x70\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\x70\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\x70\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\x70\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\x70\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\x70\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\x70\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\x70\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\x70\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\x70\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\x70\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\x70\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\x70\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\x70\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\x70\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\x70\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\x70\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\x70\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\x70\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\x70\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\x70\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\x70\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\x70\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\x70\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\x70\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\x70\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\x70\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\x70\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\x70\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\x70\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\x70\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\x70\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\x70\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\x70\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\x70\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\x70\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\x70\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\x70\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xF4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\x70\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\x70\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\x70\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\x70\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\x70\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\x70\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\x70\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\x70\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\x70\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\x70\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\x70\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\x70\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\x70\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\x70\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\x70\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\x70\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\x70\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\x70\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\x70\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\x70\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\x70\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\x70\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\x70\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\x70\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\x70\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\x70\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\x70\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\x70\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\x70\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\x70\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\x70\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\x70\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\x70\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\x71\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\x71\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\x71\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\x71\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\x71\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\x71\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\x71\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\x71\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\x71\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\x71\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\x71\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\x71\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\x71\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\x71\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\x71\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\x71\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\x71\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\x71\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\x71\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\x71\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\x71\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\x71\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\x71\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\x71\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\x71\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\x71\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\x71\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\x71\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\x71\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\x71\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\x71\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\x71\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\x71\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\x71\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\x71\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\x71\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\x71\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\x71\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\x71\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\x71\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\x71\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\x71\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\x71\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\x71\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xC1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\x71\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\x71\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\x71\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\x71\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\x71\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\x71\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\x71\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\x71\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\x71\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\x71\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\x71\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\x71\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\x71\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\x71\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\x71\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\x71\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\x71\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\x71\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\x71\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\x71\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\x71\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\x71\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\x71\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\x71\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\x71\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\x71\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\x71\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\x71\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\x71\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\x71\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\x71\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\x71\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\x71\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\x71\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\x71\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\x71\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\x71\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\x71\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\x71\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\x71\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\x71\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\x71\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\x71\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\x71\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\x71\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\x71\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\x71\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\x71\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\x71\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\x72\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\x72\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\x72\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\x72\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\x72\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\x72\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\x72\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\x72\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\x72\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\x72\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\x72\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\x72\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\x72\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\x72\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\x72\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\x72\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\x72\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\x72\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\x72\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\x72\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\x72\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\x72\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\x72\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\x72\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\x72\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\x72\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\x72\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\x72\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\x72\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\x72\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\x72\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\x72\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\x72\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\x72\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\x72\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\x72\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\x72\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\x72\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\x72\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\x72\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\x72\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\x72\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\x72\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\x72\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\x72\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\x72\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\x72\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\x72\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\x72\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\x72\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\x72\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\x72\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\x72\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\x72\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\x72\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\x72\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\x72\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\x72\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\x72\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\x72\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\x72\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\x72\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\x72\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\x72\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\x72\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\x72\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\x72\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\x72\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\x72\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\x72\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\x72\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\x72\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\x72\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\x72\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\x72\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\x72\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\x72\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xC6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\x72\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\x72\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\x72\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\x72\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\x72\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\x72\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\x72\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\x72\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\x72\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\x72\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\x72\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\x72\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\x72\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\x72\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\x72\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\x72\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\x73\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\x73\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\x73\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\x73\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\x73\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\x73\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\x73\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\x73\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\x73\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\x73\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\x73\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\x73\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\x73\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\x73\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\x73\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\x73\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\x73\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\x73\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\x73\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\x73\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\x73\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\x73\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\x73\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\x73\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\x73\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\x73\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\x73\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\x73\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\x73\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\x73\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\x73\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\x73\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\x73\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\x73\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\x73\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\x73\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\x73\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\x73\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\x73\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\x73\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\x73\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\x73\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\x73\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\x73\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\x73\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\x73\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\x73\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\x73\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\x73\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\x73\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\x73\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\x73\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\x73\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\x73\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\x73\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\x73\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\x73\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\x73\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\x73\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\x73\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\x73\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\x73\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\x73\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\x73\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\x73\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\x73\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\x73\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\x73\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\x73\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\x73\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\x73\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\x73\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\x73\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\x73\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\x73\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\x73\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\x73\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\x73\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\x73\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\x73\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\x73\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\x73\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\x73\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\x73\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\x73\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\x73\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\x73\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\x73\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\x73\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\x73\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\x73\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\x73\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\x73\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\x73\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\x74\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\x74\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\x74\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\x74\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\x74\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\x74\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\x74\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\x74\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\x74\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\x74\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\x74\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\x74\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\x74\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\x74\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\x74\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\x74\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\x74\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\x74\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\x74\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\x74\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\x74\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\x74\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\x74\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\x74\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\x74\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\x74\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\x74\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\x74\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\x74\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\x74\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\x74\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\x74\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\x74\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\x74\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\x74\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\x74\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\x74\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\x74\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\x74\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\x74\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\x74\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\x74\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\x74\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\x74\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\x74\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\x74\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\x74\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\x74\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\x74\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\x74\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\x74\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\x74\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\x74\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\x74\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\x74\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\x74\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\x74\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\x74\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\x74\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\x74\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\x74\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\x74\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\x74\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\x74\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\x74\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\x74\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\x74\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\x74\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\x74\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\x74\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\x74\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\x74\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\x74\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\x74\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\x74\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\x74\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\x74\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\x74\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\x74\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\x74\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\x74\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\x74\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\x74\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\x74\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\x74\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\x74\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\x74\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\x74\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\x74\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\x74\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\x74\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\x74\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\x74\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\x74\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\x75\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\x75\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\x75\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\x75\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\x75\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\x75\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\x75\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\x75\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\x75\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\x75\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\x75\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\x75\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\x75\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\x75\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\x75\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\x75\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\x75\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\x75\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\x75\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\x75\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\x75\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\x75\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\x75\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\x75\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\x75\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\x75\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\x75\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\x75\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\x75\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\x75\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\x75\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\x75\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\x75\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\x75\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\x75\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\x75\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\x75\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\x75\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\x75\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\x75\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\x75\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\x75\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\x75\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\x75\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\x75\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\x75\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\x75\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\x75\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\x75\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\x75\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\x75\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\x75\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\x75\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\x75\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\x6F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\x75\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\x75\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\x75\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\x75\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\x75\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\x75\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\x75\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\x75\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\x75\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\x75\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\x75\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\x75\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\x75\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\x75\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\x75\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\x75\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\x75\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\x75\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\x75\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\x75\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\x75\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\x75\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\x75\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\x75\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\x75\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\x75\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\x75\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\x75\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\x75\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\x75\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\x75\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\x75\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\x75\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\x75\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\x75\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\x75\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\x75\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\x75\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\x76\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\x76\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\x76\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\x76\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\x76\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\x76\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\x76\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\x76\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\x76\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\x76\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\x76\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\x76\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\x76\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\x76\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\x76\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\x76\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\x76\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\x76\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\x76\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\x76\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\x76\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\x76\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\x76\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\x76\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\x76\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\x76\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\x76\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\x76\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\x76\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\x76\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\x76\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\x76\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\x76\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\x76\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\x76\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\x76\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\x76\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\x76\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\x76\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\x76\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\x76\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\x76\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\x76\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\x76\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\x76\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\x76\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\x76\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\x76\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\x76\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\x76\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\x76\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\x76\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\x76\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\x76\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\x76\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\x76\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\x76\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\x76\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\x76\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\x76\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\x76\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\x76\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\x76\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\x76\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\x76\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\x76\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\x76\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\x76\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\x76\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\x76\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\x76\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\x76\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\x76\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\x76\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\x76\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\x76\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\x76\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\x76\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\x76\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\x76\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\x76\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\x76\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\x76\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\x76\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\x76\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\x76\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\x76\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\x76\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\x76\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\x76\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\x76\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\x76\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\x76\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\x76\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\x77\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\x77\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\x77\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\x77\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\x77\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\x77\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\x77\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\x77\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\x77\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\x77\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\x77\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\x77\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\x77\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\x77\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\x77\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\x77\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\x77\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\x77\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\x77\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\x77\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\x77\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\x77\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\x77\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\x77\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\x77\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\x77\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\x77\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\x77\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\x77\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\x77\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\x77\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\x77\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\x77\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\x77\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\x77\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\x77\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\x77\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\x77\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\x77\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\x77\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\x77\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\x77\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\x77\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\x77\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xF0\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\x77\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\x77\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\x77\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\x77\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\x77\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\x77\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\x77\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\x77\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\x77\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\x77\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\x77\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\x77\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\x77\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\x77\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\x77\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\x77\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\x77\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\x77\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\x77\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\x77\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\x77\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\x77\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\x77\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\x77\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\x77\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\x77\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\x77\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\x77\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\x77\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\x77\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\x77\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\x77\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\x77\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\x77\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\x77\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\x77\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\x77\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\x77\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\x77\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\x77\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\x77\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\x77\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\x77\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\x77\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\x77\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\x77\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\x77\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\x77\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\x78\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\x78\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\x78\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\x78\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\x78\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\x78\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\x78\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\x78\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\x78\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\x78\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\x78\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\x78\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\x78\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\x78\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\x78\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\x78\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\x78\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\x78\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\x78\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\x78\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\x78\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\x78\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\x78\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\x78\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\x78\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\x78\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\x78\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\x78\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\x78\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\x78\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\x78\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\x78\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\x78\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\x78\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\x78\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\x78\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\x78\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\x78\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\x78\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\x78\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\x78\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\x78\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\x78\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\x78\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\x78\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\x78\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\x78\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\x78\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\x78\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\x78\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\x78\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\x78\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\x78\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\x78\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\x78\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\x78\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\x78\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\x78\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\x78\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\x78\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\x78\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\x78\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\x78\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\x78\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\x78\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\x78\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\x78\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\x78\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\x78\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\x78\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\x78\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\x78\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\x78\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\x78\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\x78\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\x78\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\x78\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\x78\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\x78\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\x78\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\x78\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\x78\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\x78\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\x78\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\x78\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\x78\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\x78\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\x78\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\x78\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\x78\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\x78\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\x78\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\x78\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\x78\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\xF6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xD2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],
        ["\xD4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],
        ["\x79\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],
        ["\x84\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],
        ["\x94\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],
        ["\x9A\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xA3\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x5F"],
        ["\xA7\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xA6\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\x9F\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x21"],
        ["\x82\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3B"],
        ["\x8E\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x2D"],
        ["\x90\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],
        ["\xA7\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\x8E\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x3F"],
        ["\x8A\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],
        ["\x82\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x29"],
        ["\x82\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x48"],
        ["\x82\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x52"],
        ["\x82\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x54"],
        ["\x82\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x63"],
        ["\x82\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x6E"],
        ["\x82\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x27"],
        ["\x82\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x23"],
        ["\x8A\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x2C"],
        ["\x82\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x29"],
        ["\x82\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3E"],
        ["\x83\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x5F"],
        ["\x83\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x58"],
        ["\x83\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x48"],
        ["\x83\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x57"],
        ["\x83\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x63"],
        ["\x83\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x74"],
        ["\x83\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x61"],
        ["\x83\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x23"],
        ["\x83\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x3B"],
        ["\x83\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x66"],
        ["\x83\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x6D"],
        ["\x83\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x75"],
        ["\x84\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x7C"],
        ["\x84\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x35"],
        ["\x84\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x58"],
        ["\x84\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x5B"],
        ["\x84\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x65"],
        ["\x84\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x6E"],
        ["\x84\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x7B"],
        ["\x85\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x40"],
        ["\x85\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x47"],
        ["\x85\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x50"],
        ["\x85\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x5E"],
        ["\x85\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x2A"],
        ["\x85\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x2F"],
        ["\x85\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x44"],
        ["\x85\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x68"],
        ["\x86\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x42"],
        ["\x86\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x64"],
        ["\x86\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x68"],
        ["\x86\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x67"],
        ["\x87\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x4E"],
        ["\x87\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x61"],
        ["\x87\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x75"],
        ["\x87\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x77"],
        ["\x87\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x78"],
        ["\x87\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x7C"],
        ["\x87\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x2F"],
        ["\x87\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x37"],
        ["\x88\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x3E"],
        ["\x88\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x5B"],
        ["\x88\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x2A"],
        ["\x88\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x61"],
        ["\x88\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x6B"],
        ["\x88\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x33"],
        ["\x88\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x38"],
        ["\x89\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x4A"],
        ["\x89\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x50"],
        ["\x89\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x5E"],
        ["\x89\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x74"],
        ["\x89\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x75"],
        ["\x89\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x79"],
        ["\x8A\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x64"],
        ["\x8A\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x6D"],
        ["\x8A\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x7E"],
        ["\x8A\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x42"],
        ["\x8C\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x67"],
        ["\x85\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x70"],
        ["\x8C\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x30"],
        ["\x8C\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x2C"],
        ["\x8C\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x33"],
        ["\x8C\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x3D"],
        ["\x8C\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x4D"],
        ["\x8C\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x49"],
        ["\x86\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x64"],
        ["\x8C\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x28"],
        ["\x8D\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x49"],
        ["\x8D\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x44"],
        ["\x8D\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x64"],
        ["\x8D\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x74"],
        ["\x8D\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x26"],
        ["\x8E\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x75"],
        ["\x8E\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],
        ["\x8E\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x78"],
        ["\x8E\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x2B"],
        ["\x8E\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x21"],
        ["\x8E\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x25"],
        ["\x8E\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x38"],
        ["\x8E\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x3A"],
        ["\x8E\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x44"],
        ["\x8E\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x52"],
        ["\x96\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x57"],
        ["\x8F\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],
        ["\x8F\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x5E"],
        ["\x8E\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x6D"],
        ["\x8F\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x70"],
        ["\x8F\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x21"],
        ["\x8F\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x35"],
        ["\x8F\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x49"],
        ["\x8F\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x39"],
        ["\x8F\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x58"],
        ["\x90\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],
        ["\x90\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x4C"],
        ["\x97\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],
        ["\x90\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],
        ["\x90\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x7D"],
        ["\x90\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x27"],
        ["\x90\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x35"],
        ["\x90\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x36"],
        ["\x91\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x55"],
        ["\x91\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x38"],
        ["\x91\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x57"],
        ["\x91\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],
        ["\x91\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x6A"],
        ["\x91\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],
        ["\x91\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x21"],
        ["\x92\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x2B"],
        ["\x92\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x47"],
        ["\x92\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x43"],
        ["\x92\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x4B"],
        ["\x92\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x4F"],
        ["\x92\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],
        ["\x92\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],
        ["\x92\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x6E"],
        ["\x92\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],
        ["\x92\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],
        ["\x92\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x70"],
        ["\x93\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x31"],
        ["\x93\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],
        ["\x93\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x78"],
        ["\x93\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x26"],
        ["\x93\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x2B"],
        ["\x93\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x2D"],
        ["\x93\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],
        ["\x93\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x53"],
        ["\x94\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x69"],
        ["\x94\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],
        ["\x94\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x7C"],
        ["\x94\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x74"],
        ["\x94\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x75"],
        ["\x94\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x33"],
        ["\x94\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x3D"],
        ["\x94\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x6F"],
        ["\x94\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x71"],
        ["\x94\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x2E"],
        ["\x95\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x4A"],
        ["\x95\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x66"],
        ["\x95\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x6A"],
        ["\x95\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x70"],
        ["\x95\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x74"],
        ["\x95\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x6E"],
        ["\x95\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x25"],
        ["\x95\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x79"],
        ["\x95\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2B"],
        ["\x95\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2E"],
        ["\x95\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2D"],
        ["\x95\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x32"],
        ["\x95\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x42"],
        ["\x95\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x50"],
        ["\x95\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x59"],
        ["\x96\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x3B"],
        ["\x96\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x3B"],
        ["\x96\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x3A"],
        ["\x96\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x43"],
        ["\x96\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x72"],
        ["\x84\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x5D"],
        ["\x97\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x55"],
        ["\x97\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x62"],
        ["\x97\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x69"],
        ["\x97\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x6D"],
        ["\x98\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x65"],
        ["\x98\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x69"],
        ["\x98\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x68"],
        ["\x98\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x6C"],
        ["\x99\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x3B"],
        ["\x9A\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x61"],
        ["\x9A\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x68"],
        ["\x9A\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x27"],
        ["\x9A\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x54"],
        ["\x90\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x72"],
        ["\x9A\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x2E"],
        ["\x9E\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],
        ["\x9E\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x22"],
        ["\x9F\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x37"],
        ["\x9E\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x41"],
        ["\x9F\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x51"],
        ["\x9F\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x74"],
        ["\x9F\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x46"],
        ["\x9F\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x48"],
        ["\x9F\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x51"],
        ["\xA3\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x53"],
        ["\xA3\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x48"],
        ["\xA3\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x54"],
        ["\xA3\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x6A"],
        ["\xA3\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x7A"],
        ["\xA3\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x24"],
        ["\xA3\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x30"],
        ["\xA3\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x35"],
        ["\xA3\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x4B"],
        ["\xA4\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x39"],
        ["\xA4\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x43"],
        ["\xA4\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xA5\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xA5\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xA6\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x28"],
        ["\xA6\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x26"],
        ["\xA6\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x29"],
        ["\xA6\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x2F"],
        ["\xA6\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x30"],
        ["\xA6\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x2A"],
        ["\xA6\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x2B"],
        ["\xA6\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x3C"],
        ["\xA6\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xA6\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x3F"],
        ["\xA6\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xA6\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xA6\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xA6\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xA6\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xA6\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xA6\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xA6\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xA6\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x26"],
        ["\xA6\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xA6\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xA6\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xA6\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xA6\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xA7\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x3E"],
        ["\xA7\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xA6\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xA6\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x3F"],
        ["\xA7\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xA7\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xA7\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xA7\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xA7\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xA7\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xA7\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xA7\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xA7\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xA7\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x33"],
        ["\xA7\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x3F"],
        ["\xA7\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xA7\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xA7\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xA7\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xA7\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xA8\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xA8\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xA8\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x2C"],
        ["\xA8\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x2E"],
        ["\xA8\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x31"],
        ["\xA8\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x32"],
        ["\xA9\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x31"],
        ["\xA9\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x36"],
        ["\xA9\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xA9\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xA9\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xA9\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xA9\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xA9\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xAA\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xAA\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x25"],
        ["\xA8\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x7B"],
        ["\xAA\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x7A"],
        ["\xAA\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x56"],
        ["\x45\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x21"],
        ["\x45\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x24"],
        ["\x45\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x2E"],
        ["\x45\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x31"],
        ["\x45\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x34"],
        ["\x45\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x3F"],
        ["\x45\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x42"],
        ["\x45\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x41"],
        ["\x45\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x50"],
        ["\x45\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x51"],
        ["\x45\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x54"],
        ["\x45\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x53"],
        ["\x45\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x62"],
        ["\x45\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x65"],
        ["\x45\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x64"],
        ["\x45\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAA\x72"],
        ["\x45\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x22"],
        ["\x45\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x21"],
        ["\x45\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x24"],
        ["\x45\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x23"],
        ["\x45\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x2E"],
        ["\x45\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x32"],
        ["\x45\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x31"],
        ["\x45\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x34"],
        ["\x45\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x33"],
        ["\x45\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x3F"],
        ["\x45\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x42"],
        ["\x45\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x50"],
        ["\x45\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x51"],
        ["\x45\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x54"],
        ["\x45\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x53"],
        ["\x45\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x63"],
        ["\x45\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x62"],
        ["\x45\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x65"],
        ["\x45\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x64"],
        ["\x45\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xAB\x73"],
        ["\x45\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA9\x4D"],
        ["\x45\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA9\x2D"],
        ["\x82\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x2D"],
        ["\x82\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x3D"],
        ["\x82\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x4F"],
        ["\x82\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x51"],
        ["\x82\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x56"],
        ["\x82\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x68"],
        ["\x82\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x72"],
        ["\x82\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x7B"],
        ["\x82\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x2A"],
        ["\x83\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x4F"],
        ["\x82\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x53"],
        ["\x83\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x59"],
        ["\x83\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x5A"],
        ["\x83\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x36"],
        ["\x83\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x51"],
        ["\x83\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x38"],
        ["\x83\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x41"],
        ["\x83\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x4A"],
        ["\x83\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x49"],
        ["\x83\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x58"],
        ["\x83\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x69"],
        ["\x84\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x28"],
        ["\x84\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x2B"],
        ["\x84\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x30"],
        ["\x84\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x3F"],
        ["\x84\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x41"],
        ["\x84\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x68"],
        ["\x85\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x3B"],
        ["\x85\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x3C"],
        ["\x85\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x4A"],
        ["\x85\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x72"],
        ["\x85\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x7E"],
        ["\x85\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x29"],
        ["\x85\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x2C"],
        ["\x85\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x39"],
        ["\x85\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x4C"],
        ["\x85\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x5B"],
        ["\x85\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x73"],
        ["\x85\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x7C"],
        ["\x86\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x2B"],
        ["\x86\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x2E"],
        ["\x86\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x3A"],
        ["\x86\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x43"],
        ["\x86\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x4D"],
        ["\x86\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x50"],
        ["\x86\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x52"],
        ["\x86\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x5D"],
        ["\x86\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x64"],
        ["\x86\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x26"],
        ["\x86\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x36"],
        ["\x86\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x37"],
        ["\x86\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x38"],
        ["\x86\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x6E"],
        ["\x86\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x74"],
        ["\x92\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x79"],
        ["\x86\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x7D"],
        ["\xC5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x34"],
        ["\x86\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x35"],
        ["\x86\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x39"],
        ["\x87\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x3F"],
        ["\x87\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x4C"],
        ["\x87\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x54"],
        ["\x87\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x57"],
        ["\x87\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x59"],
        ["\x87\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x5D"],
        ["\x87\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x62"],
        ["\x87\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x7E"],
        ["\x87\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x28"],
        ["\x87\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x2B"],
        ["\x87\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x3A"],
        ["\x87\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x3F"],
        ["\x87\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x40"],
        ["\x87\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x52"],
        ["\x87\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x54"],
        ["\x87\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x66"],
        ["\x87\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x67"],
        ["\x87\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x6A"],
        ["\x87\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x71"],
        ["\x88\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x21"],
        ["\x88\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x33"],
        ["\x88\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x44"],
        ["\x88\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x4E"],
        ["\x88\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x25"],
        ["\x88\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x2C"],
        ["\x88\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x2F"],
        ["\x88\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x34"],
        ["\x89\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x3B"],
        ["\x89\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x41"],
        ["\x89\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x6F"],
        ["\x89\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x70"],
        ["\xE6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBB"],
        ["\x89\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x2A"],
        ["\x89\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x37"],
        ["\x89\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x3A"],
        ["\x8A\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x4E"],
        ["\x8A\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x52"],
        ["\x8A\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x5E"],
        ["\x8A\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x6E"],
        ["\x8A\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x70"],
        ["\x8A\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x72"],
        ["\x8A\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x7D"],
        ["\x8A\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x27"],
        ["\x8A\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x29"],
        ["\x8A\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x2D"],
        ["\xA5\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x30"],
        ["\x8A\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x34"],
        ["\x8A\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x3B"],
        ["\x8A\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x43"],
        ["\x8C\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x46"],
        ["\x8C\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x53"],
        ["\x8C\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x55"],
        ["\x8C\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x5C"],
        ["\x8C\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x5F"],
        ["\x8C\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x76"],
        ["\x8C\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x77"],
        ["\x8C\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x44"],
        ["\x8C\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x48"],
        ["\x8C\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x60"],
        ["\x8C\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x6F"],
        ["\x8C\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x2C"],
        ["\x8D\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x34"],
        ["\x8D\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x3C"],
        ["\x8D\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x3D"],
        ["\x8D\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x51"],
        ["\x8D\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x54"],
        ["\x8D\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x59"],
        ["\x8A\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x5D"],
        ["\x8D\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x63"],
        ["\x8D\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x69"],
        ["\x8D\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x6D"],
        ["\x8D\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x78"],
        ["\x8D\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x3F"],
        ["\x8D\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x7D"],
        ["\x8D\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x7E"],
        ["\x8D\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x23"],
        ["\x8D\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x27"],
        ["\x8D\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x44"],
        ["\x8D\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x52"],
        ["\x8E\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x23"],
        ["\x8E\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x29"],
        ["\x8E\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x2C"],
        ["\x8E\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x35"],
        ["\x8E\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x3E"],
        ["\x8E\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x47"],
        ["\x8E\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x48"],
        ["\x8E\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],
        ["\x8F\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],
        ["\x8F\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],
        ["\x8F\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x69"],
        ["\x8F\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x71"],
        ["\x8F\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],
        ["\x8F\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],
        ["\x8F\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x26"],
        ["\x8F\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x2C"],
        ["\x8F\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x2E"],
        ["\x8F\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x30"],
        ["\x8F\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x38"],
        ["\x8F\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x40"],
        ["\x8F\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x4C"],
        ["\x8F\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x54"],
        ["\x8F\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],
        ["\x90\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x21"],
        ["\x90\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x29"],
        ["\x90\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x2D"],
        ["\x90\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x2E"],
        ["\x90\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x2F"],
        ["\x90\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x33"],
        ["\x90\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x37"],
        ["\x90\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x3F"],
        ["\x90\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x42"],
        ["\x90\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x48"],
        ["\x90\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x55"],
        ["\x90\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x75"],
        ["\x90\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x26"],
        ["\x90\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x2B"],
        ["\x90\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x30"],
        ["\x90\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x3B"],
        ["\x91\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x56"],
        ["\x91\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x66"],
        ["\x91\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],
        ["\x91\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],
        ["\x91\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],
        ["\x91\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x22"],
        ["\x91\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x2D"],
        ["\x91\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x49"],
        ["\x91\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x52"],
        ["\x91\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x5E"],
        ["\x91\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],
        ["\x91\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],
        ["\x91\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],
        ["\x91\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x7D"],
        ["\x91\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x23"],
        ["\x91\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x26"],
        ["\x91\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x28"],
        ["\x92\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x2E"],
        ["\x92\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x37"],
        ["\x92\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x3A"],
        ["\x92\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x41"],
        ["\x92\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x46"],
        ["\x92\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x4A"],
        ["\x92\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x54"],
        ["\x92\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x55"],
        ["\x92\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x5A"],
        ["\x92\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x71"],
        ["\x92\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],
        ["\x93\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x2E"],
        ["\x93\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x35"],
        ["\x93\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x48"],
        ["\x93\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x4C"],
        ["\x93\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x4F"],
        ["\x93\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x59"],
        ["\x93\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x5C"],
        ["\x93\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x5E"],
        ["\x93\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x62"],
        ["\x93\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x67"],
        ["\x93\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x68"],
        ["\x93\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],
        ["\x93\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x73"],
        ["\x93\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x27"],
        ["\x93\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x25"],
        ["\x93\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x3F"],
        ["\x93\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x42"],
        ["\x8E\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x52"],
        ["\x93\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x57"],
        ["\x94\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],
        ["\x94\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],
        ["\x94\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],
        ["\x94\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x6A"],
        ["\x94\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],
        ["\x94\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x7E"],
        ["\x94\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x24"],
        ["\x94\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x27"],
        ["\x94\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x34"],
        ["\x94\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x3E"],
        ["\x94\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x56"],
        ["\x94\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x6B"],
        ["\x94\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x7E"],
        ["\x94\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x30"],
        ["\x95\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x4C"],
        ["\x95\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x55"],
        ["\x95\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x6D"],
        ["\x95\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x71"],
        ["\x95\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x77"],
        ["\x95\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x28"],
        ["\x95\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x29"],
        ["\x95\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2C"],
        ["\x95\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2F"],
        ["\x95\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x33"],
        ["\x95\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x3A"],
        ["\x95\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x3C"],
        ["\x95\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x40"],
        ["\x95\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x4E"],
        ["\x95\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x4F"],
        ["\x95\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x58"],
        ["\x96\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x52"],
        ["\x96\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x5D"],
        ["\x95\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x5E"],
        ["\x96\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x69"],
        ["\x96\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x6A"],
        ["\x96\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x6B"],
        ["\x96\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x70"],
        ["\x96\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x3D"],
        ["\x96\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x46"],
        ["\x96\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x5C"],
        ["\x96\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x63"],
        ["\x96\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x6F"],
        ["\x96\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x70"],
        ["\x96\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x79"],
        ["\x96\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x2F"],
        ["\x96\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x30"],
        ["\x96\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x33"],
        ["\x96\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x46"],
        ["\x96\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x4D"],
        ["\x96\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x4E"],
        ["\x96\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x56"],
        ["\x96\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x62"],
        ["\x96\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x6C"],
        ["\x96\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x74"],
        ["\x96\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x7A"],
        ["\x96\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x7C"],
        ["\x97\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x36"],
        ["\x97\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x58"],
        ["\x97\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x5D"],
        ["\x97\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x6A"],
        ["\x97\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x6C"],
        ["\x97\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x7A"],
        ["\x97\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x36"],
        ["\x97\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x38"],
        ["\x97\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x48"],
        ["\x97\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x49"],
        ["\x97\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x58"],
        ["\x98\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x72"],
        ["\x98\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x77"],
        ["\x89\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x78"],
        ["\x99\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x7A"],
        ["\x98\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x25"],
        ["\x98\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x2B"],
        ["\x98\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x3D"],
        ["\x98\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x48"],
        ["\x96\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x54"],
        ["\x98\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x5C"],
        ["\x98\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x67"],
        ["\x98\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],
        ["\x99\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x7B"],
        ["\x99\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x27"],
        ["\x99\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x2A"],
        ["\x99\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x2F"],
        ["\x99\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x30"],
        ["\x99\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x4E"],
        ["\x99\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x4F"],
        ["\x99\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x6D"],
        ["\x96\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x68"],
        ["\x99\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],
        ["\x99\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x25"],
        ["\x99\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x29"],
        ["\x99\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x2F"],
        ["\x99\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x31"],
        ["\x99\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x44"],
        ["\x99\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x46"],
        ["\x99\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x4D"],
        ["\x99\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x52"],
        ["\x99\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x54"],
        ["\x99\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x56"],
        ["\x9A\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],
        ["\x9A\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],
        ["\x9A\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x64"],
        ["\x9A\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x78"],
        ["\x9A\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x22"],
        ["\x9A\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x29"],
        ["\x9A\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x3F"],
        ["\x9A\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x41"],
        ["\x9A\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x42"],
        ["\x9A\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x51"],
        ["\x9A\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x2A"],
        ["\x9A\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x2C"],
        ["\x9A\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x35"],
        ["\x9A\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x39"],
        ["\x9A\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x3C"],
        ["\x9A\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x40"],
        ["\x9D\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x44"],
        ["\x9D\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x50"],
        ["\x9D\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x57"],
        ["\x9D\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x7C"],
        ["\x9D\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x2C"],
        ["\x9D\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x39"],
        ["\xAA\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x42"],
        ["\x9D\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x2B"],
        ["\x9D\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x36"],
        ["\x9E\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x43"],
        ["\x9E\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x49"],
        ["\x9E\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],
        ["\x9E\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x7A"],
        ["\x9E\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x31"],
        ["\x9E\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x35"],
        ["\x9E\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x36"],
        ["\x9E\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x40"],
        ["\x9F\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x72"],
        ["\x9F\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x5E"],
        ["\xA2\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x73"],
        ["\xA2\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x29"],
        ["\xA2\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x27"],
        ["\xA2\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x30"],
        ["\xA2\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x32"],
        ["\xA2\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x3C"],
        ["\xA2\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x46"],
        ["\xA2\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x6F"],
        ["\xA2\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x70"],
        ["\xA2\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x3D"],
        ["\xA2\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x58"],
        ["\xA2\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x39"],
        ["\xA2\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x40"],
        ["\xA2\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x45"],
        ["\xA2\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x49"],
        ["\xA3\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x5E"],
        ["\xA3\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x62"],
        ["\xA3\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x64"],
        ["\xA3\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x27"],
        ["\xA3\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x39"],
        ["\xA3\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x4A"],
        ["\xA3\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x4D"],
        ["\xA3\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x5A"],
        ["\xA3\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x5D"],
        ["\xA3\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x63"],
        ["\xA3\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x64"],
        ["\xA3\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x67"],
        ["\x86\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x48"],
        ["\xA3\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x4C"],
        ["\xA3\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x4D"],
        ["\xA4\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x68"],
        ["\xA4\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x35"],
        ["\xA4\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x3E"],
        ["\xA4\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x64"],
        ["\xA4\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x65"],
        ["\xA4\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x68"],
        ["\xA4\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x7C"],
        ["\xA4\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xA4\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xA4\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xA4\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xA4\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x27"],
        ["\x84\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x32"],
        ["\xA4\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x33"],
        ["\xA4\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xA5\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xA5\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xA5\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xA5\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xA5\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xA5\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xA5\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x22"],
        ["\xA5\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x23"],
        ["\xA5\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x2A"],
        ["\xA5\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x30"],
        ["\xA5\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x32"],
        ["\xA5\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x3D"],
        ["\xA5\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xA5\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xA5\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xA5\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xA6\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xA4\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xA6\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x36"],
        ["\xA6\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x33"],
        ["\xA6\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x3D"],
        ["\xA6\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xA6\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xA6\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xA7\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xA7\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xA7\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xA7\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x3A"],
        ["\xA7\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xA7\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xA7\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xA7\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xA7\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xA7\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xA7\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xA7\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x26"],
        ["\xA2\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x2C"],
        ["\xA8\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x32"],
        ["\xA8\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x37"],
        ["\xA8\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x38"],
        ["\xA8\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\x86\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xA8\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xAA\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xA8\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xA8\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x30"],
        ["\xA3\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x35"],
        ["\xA8\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x3B"],
        ["\xAA\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xA8\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xA8\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xA8\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xA8\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xA8\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x21"],
        ["\xA8\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x2E"],
        ["\xA8\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x2F"],
        ["\xA9\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x32"],
        ["\xC5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x33"],
        ["\xA9\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x39"],
        ["\xA9\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xA9\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xA9\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x37"],
        ["\xA9\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x38"],
        ["\xA9\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xA9\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xA9\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xA9\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xA9\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x23"],
        ["\xA9\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xA9\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xA9\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xA9\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xA9\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xAA\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xAA\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\xAA\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x31"],
        ["\xAA\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x45"],
        ["\xAA\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x4D"],
        ["\xAA\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x57"],
        ["\xAA\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x63"],
        ["\xAA\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x64"],
        ["\xAA\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x6F"],
        ["\xAA\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x70"],
        ["\xAA\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x21"],
        ["\xAA\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x2C"],
        ["\xAA\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x68"],
        ["\xAA\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x6A"],
        ["\xF9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x6F"],
        ["\xAA\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x27"],
        ["\xAA\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x3A"],
        ["\x8A\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x59"],
        ["\xAA\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x5C"],
        ["\x86\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x61"],
        ["\x82\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x21"],
        ["\x82\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x2A"],
        ["\x82\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x2B"],
        ["\x82\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x42"],
        ["\x82\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x44"],
        ["\x82\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x4C"],
        ["\x82\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x4E"],
        ["\x82\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x65"],
        ["\x82\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x6D"],
        ["\x82\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x77"],
        ["\x82\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x2F"],
        ["\x82\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x35"],
        ["\x82\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x38"],
        ["\x82\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3C"],
        ["\x82\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3F"],
        ["\x83\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x45"],
        ["\x83\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x49"],
        ["\x83\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x51"],
        ["\x83\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x55"],
        ["\x83\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x6A"],
        ["\x83\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x6F"],
        ["\x83\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x70"],
        ["\x83\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x72"],
        ["\x83\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x34"],
        ["\x83\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x43"],
        ["\x88\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x6F"],
        ["\x88\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x22"],
        ["\x88\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x37"],
        ["\x89\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x39"],
        ["\x89\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x43"],
        ["\x89\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x46"],
        ["\x89\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x5A"],
        ["\x89\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x66"],
        ["\x89\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x68"],
        ["\x89\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x6A"],
        ["\x89\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\x7D"],
        ["\x89\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x24"],
        ["\x89\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x27"],
        ["\x89\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x29"],
        ["\x89\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x2D"],
        ["\x85\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x77"],
        ["\x84\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\x7B"],
        ["\x84\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x2E"],
        ["\x84\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x31"],
        ["\x84\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x36"],
        ["\x84\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x6B"],
        ["\x84\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x7D"],
        ["\x9A\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\x7E"],
        ["\x84\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x36"],
        ["\x85\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x3E"],
        ["\x85\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x5C"],
        ["\x85\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x5D"],
        ["\x85\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\x77"],
        ["\x85\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x38"],
        ["\x85\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x46"],
        ["\x85\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x49"],
        ["\x85\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x57"],
        ["\x85\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x59"],
        ["\x85\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x61"],
        ["\x85\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x62"],
        ["\x85\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\x6C"],
        ["\x85\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x27"],
        ["\x86\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x30"],
        ["\x86\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x3C"],
        ["\x86\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x3D"],
        ["\x86\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x65"],
        ["\x86\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\x71"],
        ["\x86\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x3E"],
        ["\x86\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x51"],
        ["\x86\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x5A"],
        ["\x86\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x6D"],
        ["\x86\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\x76"],
        ["\x86\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x24"],
        ["\x86\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x26"],
        ["\x86\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x2B"],
        ["\x87\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x43"],
        ["\x86\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x44"],
        ["\x87\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x4D"],
        ["\x87\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x60"],
        ["\x87\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\x6A"],
        ["\x87\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x23"],
        ["\x87\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x2E"],
        ["\x87\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x3C"],
        ["\x87\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x41"],
        ["\x87\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x44"],
        ["\x87\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x46"],
        ["\x87\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x61"],
        ["\x87\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x64"],
        ["\x87\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x70"],
        ["\x87\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x72"],
        ["\x88\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\x7C"],
        ["\x88\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x2B"],
        ["\x88\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x30"],
        ["\x88\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x32"],
        ["\x88\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x3C"],
        ["\x88\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x46"],
        ["\x88\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\x47"],
        ["\x8A\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x5F"],
        ["\x82\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x60"],
        ["\x8A\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x62"],
        ["\x8A\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x38"],
        ["\x8A\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x3F"],
        ["\x8A\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x41"],
        ["\x8A\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x44"],
        ["\x8A\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x4A"],
        ["\x8A\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x4B"],
        ["\x8C\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x56"],
        ["\x84\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x6C"],
        ["\x8C\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x7C"],
        ["\x8C\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\x7D"],
        ["\x8C\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x3E"],
        ["\x8C\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x3F"],
        ["\x8C\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x45"],
        ["\x8C\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x59"],
        ["\x8C\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x62"],
        ["\x8C\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x63"],
        ["\x8C\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x6A"],
        ["\x8C\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x6C"],
        ["\x8C\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x75"],
        ["\x8C\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\x79"],
        ["\x8C\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x2F"],
        ["\x8D\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x37"],
        ["\x8D\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x39"],
        ["\x8D\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x53"],
        ["\x8F\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x5A"],
        ["\x8A\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x67"],
        ["\x8D\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x6E"],
        ["\x8D\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\x72"],
        ["\x8D\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x26"],
        ["\x8A\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x3D"],
        ["\x8D\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x47"],
        ["\x8D\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x51"],
        ["\x8D\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\x68"],
        ["\x8D\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x2A"],
        ["\x8D\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x36"],
        ["\x8D\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x3C"],
        ["\x8D\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x56"],
        ["\x8E\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x64"],
        ["\x8E\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x65"],
        ["\x8E\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x6F"],
        ["\x8E\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],
        ["\x8E\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],
        ["\x8E\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],
        ["\x8E\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x22"],
        ["\x8E\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x32"],
        ["\x8E\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x36"],
        ["\x8E\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x3B"],
        ["\x8E\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x40"],
        ["\x8E\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x41"],
        ["\x8E\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x51"],
        ["\x8E\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],
        ["\x8F\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],
        ["\x8F\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],
        ["\x8F\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x7B"],
        ["\x8F\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x7E"],
        ["\x8F\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x25"],
        ["\x8F\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x41"],
        ["\x8F\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x48"],
        ["\x8F\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x56"],
        ["\x84\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],
        ["\x8F\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],
        ["\x90\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x71"],
        ["\x90\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],
        ["\x90\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x24"],
        ["\x90\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x25"],
        ["\x90\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x2C"],
        ["\x90\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x41"],
        ["\x90\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x58"],
        ["\x89\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],
        ["\x90\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],
        ["\x90\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],
        ["\x90\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],
        ["\x90\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x76"],
        ["\x90\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],
        ["\x90\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x31"],
        ["\x90\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x3D"],
        ["\x90\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x41"],
        ["\x91\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],
        ["\x91\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],
        ["\x91\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],
        ["\x91\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x63"],
        ["\x91\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],
        ["\x91\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],
        ["\x91\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],
        ["\x91\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],
        ["\xA6\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x36"],
        ["\x91\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x3D"],
        ["\x8D\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x3E"],
        ["\xA8\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x3F"],
        ["\x91\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x53"],
        ["\x91\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],
        ["\x91\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x6C"],
        ["\x91\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x6D"],
        ["\x91\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x6F"],
        ["\x91\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\x7E"],
        ["\x91\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x25"],
        ["\x92\x42",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x27"],
        ["\x92\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x2D"],
        ["\x92\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x34"],
        ["\x92\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x3B"],
        ["\x92\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x44"],
        ["\x92\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x56"],
        ["\x92\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x58"],
        ["\x92\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],
        ["\x92\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x61"],
        ["\x92\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x6D"],
        ["\x92\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],
        ["\x92\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],
        ["\x92\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\x7B"],
        ["\x92\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x22"],
        ["\x92\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x34"],
        ["\x93\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x3E"],
        ["\x93\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x52"],
        ["\x93\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x61"],
        ["\x93\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],
        ["\x93\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x6D"],
        ["\x93\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\x76"],
        ["\x93\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x21"],
        ["\x93\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x36"],
        ["\x93\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x44"],
        ["\x93\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x45"],
        ["\x98\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x47"],
        ["\x93\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x4D"],
        ["\x83\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x4F"],
        ["\x94\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x5A"],
        ["\x94\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x5F"],
        ["\x94\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x66"],
        ["\x94\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],
        ["\x94\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],
        ["\x8E\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\x76"],
        ["\x94\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x23"],
        ["\x94\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x2A"],
        ["\x9A\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x4E"],
        ["\x94\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x5B"],
        ["\x94\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x62"],
        ["\x94\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x65"],
        ["\x94\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x6D"],
        ["\x94\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x6E"],
        ["\x94\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\x75"],
        ["\x94\xDF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x2B"],
        ["\xA2\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x31"],
        ["\x94\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x32"],
        ["\x94\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x37"],
        ["\x95\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x45"],
        ["\x95\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x4E"],
        ["\x95\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x50"],
        ["\x95\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x57"],
        ["\x95\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x58"],
        ["\x95\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x59"],
        ["\x95\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x64"],
        ["\x95\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x68"],
        ["\x95\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x6B"],
        ["\x95\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x7B"],
        ["\x95\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\x7C"],
        ["\x95\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x23"],
        ["\x95\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x2A"],
        ["\x95\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x36"],
        ["\x95\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x3F"],
        ["\x95\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x49"],
        ["\x95\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x56"],
        ["\x95\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x61"],
        ["\x96\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\x67"],
        ["\x96\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x30"],
        ["\x96\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x35"],
        ["\x96\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x3C"],
        ["\x96\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x42"],
        ["\x96\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x43"],
        ["\x96\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x50"],
        ["\x96\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x62"],
        ["\x96\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x6D"],
        ["\x96\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x76"],
        ["\x96\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\x7B"],
        ["\x96\xB2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x44"],
        ["\x96\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x23"],
        ["\x96\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x26"],
        ["\x96\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x32"],
        ["\x96\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x34"],
        ["\x97\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x42"],
        ["\x97\x47",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x45"],
        ["\x82\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x46"],
        ["\x97\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x4B"],
        ["\x97\x53",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x4D"],
        ["\x97\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x4F"],
        ["\x97\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x77"],
        ["\x97\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x75"],
        ["\x97\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x25"],
        ["\x97\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x30"],
        ["\x97\x9F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x31"],
        ["\xA7\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x39"],
        ["\x97\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x3A"],
        ["\x97\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x4B"],
        ["\x97\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x57"],
        ["\x97\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x59"],
        ["\x97\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x5C"],
        ["\x98\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x67"],
        ["\x98\x83",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x74"],
        ["\x98\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x7B"],
        ["\x98\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x2E"],
        ["\x98\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x30"],
        ["\x98\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x32"],
        ["\x98\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x33"],
        ["\x98\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x3C"],
        ["\x98\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x43"],
        ["\x98\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x49"],
        ["\x98\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x4D"],
        ["\x98\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],
        ["\x98\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x63"],
        ["\x99\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x23"],
        ["\x99\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x7C"],
        ["\x99\x44",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x21"],
        ["\x99\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x2B"],
        ["\x99\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x2C"],
        ["\x99\x56",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x2D"],
        ["\x99\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x38"],
        ["\x99\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x3A"],
        ["\x99\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x46"],
        ["\x99\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x4C"],
        ["\x99\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],
        ["\x96\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x62"],
        ["\x99\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],
        ["\x99\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x26"],
        ["\x99\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x35"],
        ["\x99\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x3C"],
        ["\xA9\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x47"],
        ["\x99\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x4B"],
        ["\x99\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x4E"],
        ["\x9A\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],
        ["\x9A\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],
        ["\x9A\x51",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],
        ["\x9A\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x77"],
        ["\x9A\x55",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],
        ["\x9A\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x31"],
        ["\x9A\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x3A"],
        ["\x9A\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x45"],
        ["\x9A\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x46"],
        ["\x9A\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x47"],
        ["\x9A\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],
        ["\x9A\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x61"],
        ["\x9A\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x65"],
        ["\x9A\xBE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],
        ["\x9A\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],
        ["\x9A\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x74"],
        ["\x9A\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],
        ["\x9A\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x7A"],
        ["\x9A\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x32"],
        ["\x9A\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x3A"],
        ["\x9A\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x3E"],
        ["\x9D\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x42"],
        ["\x9D\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],
        ["\x9D\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x56"],
        ["\x9D\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x5A"],
        ["\x9D\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x69"],
        ["\x9D\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\x7B"],
        ["\x9D\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x2A"],
        ["\x9D\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],
        ["\x8F\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x63"],
        ["\x9D\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x75"],
        ["\x9D\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x76"],
        ["\x9D\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x79"],
        ["\x9D\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],
        ["\x9E\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],
        ["\x9E\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x27"],
        ["\x9E\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x49"],
        ["\x9F\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x52"],
        ["\x9F\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x54"],
        ["\x9F\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x5A"],
        ["\x9F\x9A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\x6E"],
        ["\x9F\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x25"],
        ["\x9F\xCB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x4F"],
        ["\xA2\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x3B"],
        ["\xA2\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x4A"],
        ["\xA2\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x4B"],
        ["\xA2\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x57"],
        ["\xA2\xAF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\x7A"],
        ["\xA2\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x2F"],
        ["\xA2\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x48"],
        ["\xA2\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x68"],
        ["\xA2\xB5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x6D"],
        ["\xA2\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x79"],
        ["\xA2\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\x7D"],
        ["\xA5\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x31"],
        ["\xA2\xCE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x33"],
        ["\xA2\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x44"],
        ["\xA3\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x4D"],
        ["\xA3\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x52"],
        ["\x9A\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x24"],
        ["\xA3\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x2E"],
        ["\xA3\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x47"],
        ["\xA3\xAD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x59"],
        ["\xA3\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x5C"],
        ["\xA3\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\x61"],
        ["\xA3\xB6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x2E"],
        ["\xA3\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x36"],
        ["\xA3\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x45"],
        ["\xA4\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x63"],
        ["\xA4\x45",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x66"],
        ["\xA4\x46",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x67"],
        ["\x9D\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\x6D"],
        ["\xA4\x85",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x31"],
        ["\xA4\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x33"],
        ["\xA4\x99",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\x4C"],
        ["\xA4\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x3C"],
        ["\xA5\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xA6\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xA6\xCD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xA8\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x25"],
        ["\x86\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xA8\x88",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xA8\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xA8\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\x93\x58",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xA9\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xA9\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xA9\xB7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x2A"],
        ["\xA9\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xA9\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xAA\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xAA\x54",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\xAA\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xAA\x81",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x22"],
        ["\xAA\x84",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x35"],
        ["\xAA\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x36"],
        ["\xAA\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x37"],
        ["\xAA\x8D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x4E"],
        ["\xAA\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x53"],
        ["\xAA\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x54"],
        ["\xAA\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x5D"],
        ["\xAA\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x61"],
        ["\xAA\xA4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x76"],
        ["\xAA\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\x7D"],
        ["\xAA\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x27"],
        ["\xAA\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x2F"],
        ["\xA8\x9E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x34"],
        ["\xAA\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x38"],
        ["\xAA\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\x57"],
        ["\xAA\xDD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x2D"],
        ["\xAA\xDE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x39"],
        ["\xAA\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\x3F"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
